/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.net.EthernetInterfaceImpl;
import org.eclipse.kura.core.net.NetInterfaceAddressImpl;
import org.eclipse.kura.emulator.Emulator;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.net.NetworkState;
import org.eclipse.kura.net.modem.ModemDevice;
import org.eclipse.kura.net.wifi.WifiAccessPoint;
import org.eclipse.kura.usb.UsbNetDevice;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmulatedNetworkServiceImpl
implements NetworkService {
    private static final Logger logger = LoggerFactory.getLogger(EmulatedNetworkServiceImpl.class);
    private Emulator emulator;
    private ComponentContext ctx;

    public void setEmulator(Emulator emulator) {
        this.emulator = emulator;
    }

    public void unsetEmulator(Emulator emulator) {
        this.emulator = null;
    }

    protected void activate(ComponentContext componentContext) {
        this.ctx = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.ctx = null;
    }

    public NetworkState getState() {
        InetAddress jnAddress = this.getFirstActiveInetAddress();
        if (jnAddress == null) {
            return NetworkState.DISCONNECTED;
        }
        if (jnAddress.isLoopbackAddress() || jnAddress.isLinkLocalAddress()) {
            return NetworkState.CONNECTED_LOCAL;
        }
        if (jnAddress.isSiteLocalAddress()) {
            return NetworkState.CONNECTED_SITE;
        }
        return NetworkState.CONNECTED_GLOBAL;
    }

    public NetInterfaceState getState(String interfaceName) {
        return NetInterfaceState.UNKNOWN;
    }

    public List<String> getAllNetworkInterfaceNames() throws KuraException {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        NetworkInterface jnInterface = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                jnInterface = interfaces.nextElement();
                interfaceNames.add(jnInterface.getName());
            }
        }
        catch (SocketException e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
        return interfaceNames;
    }

    public List<NetInterface<? extends NetInterfaceAddress>> getNetworkInterfaces() throws KuraException {
        IPAddress netAddress = null;
        NetInterfaceAddressImpl addressImpl = null;
        ArrayList<NetInterfaceAddressImpl> addresses = null;
        ArrayList<NetInterface<? extends NetInterfaceAddress>> interfaces = new ArrayList<NetInterface<? extends NetInterfaceAddress>>();
        EthernetInterfaceImpl ethInterface = null;
        NetworkInterface jnInterface = null;
        List<InterfaceAddress> jnInterfaceAddresses = null;
        Enumeration<NetworkInterface> jnInterfaces = null;
        try {
            jnInterfaces = NetworkInterface.getNetworkInterfaces();
            while (jnInterfaces.hasMoreElements()) {
                jnInterface = jnInterfaces.nextElement();
                ethInterface = new EthernetInterfaceImpl(jnInterface.getName());
                ethInterface.setVirtual(jnInterface.isVirtual());
                ethInterface.setState(NetInterfaceState.ACTIVATED);
                ethInterface.setAutoConnect(true);
                byte[] hwAddr = null;
                boolean isUp = false;
                boolean isLoop = false;
                int mtu = 0;
                boolean isP2p = false;
                boolean multi = false;
                try {
                    hwAddr = jnInterface.getHardwareAddress();
                    isUp = jnInterface.isUp();
                    isLoop = jnInterface.isLoopback();
                    mtu = jnInterface.getMTU();
                    isP2p = jnInterface.isPointToPoint();
                    multi = jnInterface.supportsMulticast();
                }
                catch (Exception e) {
                    logger.warn("Exception while getting information for interface " + jnInterface.getName() + ": " + e.getMessage());
                }
                ethInterface.setHardwareAddress(hwAddr);
                ethInterface.setLinkUp(isUp);
                ethInterface.setLoopback(isLoop);
                ethInterface.setMTU(mtu);
                ethInterface.setPointToPoint(isP2p);
                ethInterface.setSupportsMulticast(multi);
                ethInterface.setUp(isUp);
                addresses = new ArrayList<NetInterfaceAddressImpl>();
                jnInterfaceAddresses = jnInterface.getInterfaceAddresses();
                for (InterfaceAddress jnInterfaceAddress : jnInterfaceAddresses) {
                    netAddress = IPAddress.getByAddress((byte[])jnInterfaceAddress.getAddress().getAddress());
                    addressImpl = new NetInterfaceAddressImpl();
                    addressImpl.setAddress(netAddress);
                    if (jnInterfaceAddress.getBroadcast() != null) {
                        addressImpl.setBroadcast(IPAddress.getByAddress((byte[])jnInterfaceAddress.getBroadcast().getAddress()));
                    }
                    addressImpl.setNetworkPrefixLength(jnInterfaceAddress.getNetworkPrefixLength());
                    addresses.add(addressImpl);
                }
                ethInterface.setNetInterfaceAddresses(addresses);
                interfaces.add((NetInterface<? extends NetInterfaceAddress>)ethInterface);
            }
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
        return interfaces;
    }

    public List<WifiAccessPoint> getAllWifiAccessPoints() {
        return Collections.emptyList();
    }

    public List<WifiAccessPoint> getWifiAccessPoints(String wifiInterfaceName) {
        return Collections.emptyList();
    }

    public List<NetInterface<? extends NetInterfaceAddress>> getActiveNetworkInterfaces() throws KuraException {
        IPAddress netAddress = null;
        NetInterfaceAddressImpl addressImpl = null;
        ArrayList<NetInterfaceAddressImpl> addresses = null;
        ArrayList<NetInterface<? extends NetInterfaceAddress>> interfaces = new ArrayList<NetInterface<? extends NetInterfaceAddress>>();
        EthernetInterfaceImpl ethInterface = null;
        NetworkInterface jnInterface = null;
        List<InterfaceAddress> jnInterfaceAddresses = null;
        Enumeration<NetworkInterface> jnInterfaces = null;
        try {
            jnInterfaces = NetworkInterface.getNetworkInterfaces();
            while (jnInterfaces.hasMoreElements()) {
                try {
                    jnInterface = jnInterfaces.nextElement();
                    if (!jnInterface.isUp() || jnInterface.isVirtual() || jnInterface.isLoopback() || jnInterface.isPointToPoint() || jnInterface.getHardwareAddress() == null || jnInterface.getInterfaceAddresses().isEmpty()) continue;
                    ethInterface = new EthernetInterfaceImpl(jnInterface.getName());
                    ethInterface.setVirtual(jnInterface.isVirtual());
                    ethInterface.setState(NetInterfaceState.ACTIVATED);
                    ethInterface.setAutoConnect(true);
                    byte[] hwAddr = null;
                    boolean isUp = false;
                    boolean isLoop = false;
                    int mtu = 0;
                    boolean isP2p = false;
                    boolean multi = false;
                    try {
                        hwAddr = jnInterface.getHardwareAddress();
                        isUp = jnInterface.isUp();
                        isLoop = jnInterface.isLoopback();
                        mtu = jnInterface.getMTU();
                        isP2p = jnInterface.isPointToPoint();
                        multi = jnInterface.supportsMulticast();
                    }
                    catch (Exception e) {
                        logger.warn("Exception while getting information for interface " + jnInterface.getName(), (Throwable)e);
                    }
                    ethInterface.setHardwareAddress(hwAddr);
                    ethInterface.setLinkUp(isUp);
                    ethInterface.setLoopback(isLoop);
                    ethInterface.setMTU(mtu);
                    ethInterface.setPointToPoint(isP2p);
                    ethInterface.setSupportsMulticast(multi);
                    ethInterface.setUp(isUp);
                    addresses = new ArrayList<NetInterfaceAddressImpl>();
                    jnInterfaceAddresses = jnInterface.getInterfaceAddresses();
                    for (InterfaceAddress jnInterfaceAddress : jnInterfaceAddresses) {
                        netAddress = IPAddress.getByAddress((byte[])jnInterfaceAddress.getAddress().getAddress());
                        addressImpl = new NetInterfaceAddressImpl();
                        addressImpl.setAddress(netAddress);
                        if (jnInterfaceAddress.getBroadcast() != null) {
                            addressImpl.setBroadcast(IPAddress.getByAddress((byte[])jnInterfaceAddress.getBroadcast().getAddress()));
                        }
                        addressImpl.setNetworkPrefixLength(jnInterfaceAddress.getNetworkPrefixLength());
                        addresses.add(addressImpl);
                    }
                    ethInterface.setNetInterfaceAddresses(addresses);
                    interfaces.add((NetInterface<? extends NetInterfaceAddress>)ethInterface);
                }
                catch (SocketException se) {
                    logger.warn("Exception while getting information for interface " + jnInterface.getName(), (Throwable)se);
                }
            }
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
        return interfaces;
    }

    private InetAddress getFirstActiveInetAddress() {
        InetAddress jnAddress = null;
        NetworkInterface jnInterface = null;
        try {
            Enumeration<NetworkInterface> interfaces = null;
            interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                InetAddress address;
                Enumeration<InetAddress> addresses;
                jnInterface = interfaces.nextElement();
                if (jnInterface.isUp() && !jnInterface.isLoopback() && !jnInterface.isVirtual()) {
                    addresses = null;
                    addresses = jnInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        address = addresses.nextElement();
                        if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                        jnAddress = address;
                        break;
                    }
                }
                if (jnAddress == null) {
                    interfaces = NetworkInterface.getNetworkInterfaces();
                    block4: while (interfaces.hasMoreElements()) {
                        jnInterface = interfaces.nextElement();
                        if (!jnInterface.isUp() || jnInterface.isVirtual()) continue;
                        addresses = null;
                        addresses = jnInterface.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            address = addresses.nextElement();
                            if (!(address instanceof Inet4Address)) continue;
                            jnAddress = address;
                            continue block4;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (SocketException e) {
            logger.error("Error getting IP address", (Throwable)e);
        }
        return jnAddress;
    }

    public String getModemUsbPort(String interfaceName) {
        return null;
    }

    public String getModemPppPort(ModemDevice modemDevice) throws KuraException {
        return null;
    }

    public String getModemPppInterfaceName(String usbPath) {
        return null;
    }

    public Optional<ModemDevice> getModemDevice(String usbPath) {
        return Optional.empty();
    }

    public Optional<UsbNetDevice> getUsbNetDevice(String interfaceName) {
        return Optional.empty();
    }
}

