/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.query;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.query.WireRecordQueryComponentOptions;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.eclipse.kura.wire.store.provider.QueryableWireRecordStoreProvider;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class WireRecordQueryComponent
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(WireRecordQueryComponent.class);
    private State state = new Unsatisfied();
    private WireSupport wireSupport;
    private WireHelperService wireHelperService;

    public void bindQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider store) {
        this.updateState(s -> s.setQueryableWireRecordStoreProvider(store));
    }

    public synchronized void unbindQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider store) {
        this.updateState(s -> s.unsetQueryableWireRecordStoreProvider(store));
    }

    public void bindWireHelperService(WireHelperService wireHelperService) {
        this.wireHelperService = wireHelperService;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Wire Record Query component...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.updateState(s -> s.setOptions(new WireRecordQueryComponentOptions(properties)));
        logger.debug("Activating Wire Record Query component...done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Wire Record Query component... {}", properties);
        this.updateState(s -> s.setOptions(new WireRecordQueryComponentOptions(properties)));
        logger.debug("Updating Wire Record Query component... Done");
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        Optional<List<WireRecord>> records;
        try {
            records = this.state.getRecords();
        }
        catch (Exception e) {
            logger.warn("failed to perform query", (Throwable)e);
            return;
        }
        if (records.isPresent()) {
            this.wireSupport.emit(records.get());
        }
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private synchronized void updateState(UnaryOperator<State> transitionFunction) {
        this.state = (State)transitionFunction.apply(this.state);
    }

    private static class CachedRecords {
        private final List<WireRecord> records;
        private final long timestamp;

        public CachedRecords(List<WireRecord> records) {
            this.records = records;
            this.timestamp = System.nanoTime();
        }

        public boolean isFresh(WireRecordQueryComponentOptions options) {
            return System.nanoTime() - this.timestamp < TimeUnit.SECONDS.toNanos(options.getCacheExpirationInterval());
        }
    }

    private static class Satisfied
    implements State {
        private final WireRecordQueryComponentOptions options;
        private final QueryableWireRecordStoreProvider provider;
        private Optional<CachedRecords> cachedRecords = Optional.empty();

        public Satisfied(WireRecordQueryComponentOptions options, QueryableWireRecordStoreProvider provider) {
            this.options = options;
            this.provider = provider;
        }

        @Override
        public State setOptions(WireRecordQueryComponentOptions options) {
            if (options.equals(this.options)) {
                return this;
            }
            return new Satisfied(options, this.provider);
        }

        @Override
        public State setQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider wireRecordStoreProvider) {
            return new Satisfied(this.options, wireRecordStoreProvider);
        }

        @Override
        public State unsetQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider wireRecordStoreProvider) {
            if (this.provider == wireRecordStoreProvider) {
                return new Unsatisfied().setOptions(this.options);
            }
            return this;
        }

        @Override
        public synchronized Optional<List<WireRecord>> getRecords() throws KuraStoreException {
            List result;
            if (this.cachedRecords.isPresent() && this.cachedRecords.get().isFresh(this.options)) {
                result = this.cachedRecords.get().records;
            } else {
                result = this.provider.performQuery(this.options.getQuery());
                if (this.options.getCacheExpirationInterval() > 0) {
                    this.cachedRecords = Optional.of(new CachedRecords(result));
                }
            }
            if (!result.isEmpty() || this.options.isEmitOnEmptyResult()) {
                return Optional.of(result);
            }
            return Optional.empty();
        }
    }

    private static interface State {
        public State setOptions(WireRecordQueryComponentOptions var1);

        public State setQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider var1);

        public State unsetQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider var1);

        public Optional<List<WireRecord>> getRecords() throws KuraStoreException;
    }

    private static class Unsatisfied
    implements State {
        private Optional<WireRecordQueryComponentOptions> options = Optional.empty();
        private Optional<QueryableWireRecordStoreProvider> provider = Optional.empty();

        private Unsatisfied() {
        }

        @Override
        public State setOptions(WireRecordQueryComponentOptions options) {
            this.options = Optional.of(options);
            return this.checkSatisfied();
        }

        @Override
        public State setQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider queryableWireRecordStore) {
            this.provider = Optional.of(queryableWireRecordStore);
            return this.checkSatisfied();
        }

        @Override
        public State unsetQueryableWireRecordStoreProvider(QueryableWireRecordStoreProvider queryableWireRecordStore) {
            if (this.provider.equals(Optional.of(queryableWireRecordStore))) {
                this.provider = Optional.empty();
            }
            return this.checkSatisfied();
        }

        private State checkSatisfied() {
            if (this.options.isPresent() && this.provider.isPresent()) {
                return new Satisfied(this.options.get(), this.provider.get());
            }
            return this;
        }

        @Override
        public Optional<List<WireRecord>> getRecords() throws KuraStoreException {
            throw new KuraStoreException((Object)"Component dependencies are not satisfied");
        }
    }
}

