/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.db.BaseDbService;
import org.eclipse.kura.db.H2DbService;

public final class DbServiceHelper {
    private static final Logger logger = LogManager.getLogger(DbServiceHelper.class);
    private final BaseDbService dbService;

    private DbServiceHelper(BaseDbService dbService) {
        Objects.requireNonNull(dbService, "DB Service cannot be null");
        this.dbService = dbService;
    }

    public static DbServiceHelper of(BaseDbService dbService) {
        return new DbServiceHelper(dbService);
    }

    public synchronized void execute(Connection c, String sql, Integer ... params) throws SQLException {
        Objects.requireNonNull(sql, "SQL query cannot be null");
        logger.debug("Executing SQL query... {}", (Object)sql);
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement stmt = c.prepareStatement(sql);){
            int i = 0;
            while (i < params.length) {
                stmt.setInt(1 + i, params[i]);
                ++i;
            }
            stmt.execute();
            c.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        logger.debug("Executing SQL query... Done");
    }

    public Connection getConnection() throws SQLException {
        return this.dbService.getConnection();
    }

    public <T> T withConnection(H2DbService.ConnectionCallable<T> callable) throws SQLException {
        if (this.dbService instanceof H2DbService) {
            return (T)((H2DbService)this.dbService).withConnection(callable);
        }
        throw new UnsupportedOperationException("This operation is not supported by the current DB Service implementation");
    }

    public String sanitizeSqlTableAndColumnName(String string) {
        Objects.requireNonNull(string, "Provided string cannot be null");
        logger.debug("Sanitizing the provided string... {}", (Object)string);
        String sanitizedName = string.replaceAll("\"", "\"\"");
        return "\"" + sanitizedName + "\"";
    }
}

