/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.bluetooth.le.beacon.AdvertisingReportRecord;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.Signal;
import org.eclipse.kura.internal.ble.util.BTSnoopListener;
import org.eclipse.kura.internal.ble.util.BluetoothProcess;
import org.eclipse.kura.internal.ble.util.BluetoothProcessListener;

public class BluetoothLeUtil {
    private static final Logger logger = LogManager.getLogger(BluetoothLeUtil.class);
    private static final ExecutorService processExecutor = Executors.newSingleThreadExecutor();
    public static final String HCITOOL = "hcitool";
    public static final String COMMAND_ERROR = "Error executing command: {}";
    public static final String COMMAND_EXEC = "Command executed : {}";

    private BluetoothLeUtil() {
    }

    public static BluetoothProcess btdumpCmd(String name, CommandExecutorService executorService, BTSnoopListener listener) throws IOException {
        String[] command = new String[]{"btmon", "-i", name, "-w", "/dev/fd/3"};
        return BluetoothLeUtil.execSnoop(command, executorService, listener);
    }

    public static BluetoothProcess hcitoolCmd(String name, String cmd, CommandExecutorService executorService, BluetoothProcessListener listener) throws IOException {
        String[] command = new String[]{HCITOOL, "-i", name, cmd};
        return BluetoothLeUtil.exec(command, executorService, listener);
    }

    public static BluetoothProcess hcitoolCmd(String name, String[] cmd, CommandExecutorService executorService, BluetoothProcessListener listener) throws IOException {
        String[] command = new String[3 + cmd.length];
        command[0] = HCITOOL;
        command[1] = "-i";
        command[2] = name;
        int i = 0;
        while (i < cmd.length) {
            command[i + 3] = cmd[i];
            ++i;
        }
        return BluetoothLeUtil.exec(command, executorService, listener);
    }

    private static BluetoothProcess exec(String[] cmdArray, CommandExecutorService executorService, BluetoothProcessListener listener) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = processExecutor.submit(() -> {
            Thread.currentThread().setName("BluetoothProcessExecutor");
            BluetoothProcess bluetoothProcess = new BluetoothProcess(executorService);
            bluetoothProcess.exec(cmdArray, listener);
            return bluetoothProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static BluetoothProcess execSnoop(String[] cmdArray, CommandExecutorService executorService, BTSnoopListener listener) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = processExecutor.submit(() -> {
            Thread.currentThread().setName("BTSnoopProcessExecutor");
            BluetoothProcess bluetoothProcess = new BluetoothProcess(executorService);
            bluetoothProcess.execSnoop(cmdArray, listener);
            return bluetoothProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    public static List<AdvertisingReportRecord> parseLEAdvertisement(byte[] b) {
        ArrayList<AdvertisingReportRecord> reportRecords = new ArrayList<AdvertisingReportRecord>();
        if (b[0] != 62) {
            return reportRecords;
        }
        if (b[2] != 2 && b[2] != 13) {
            return reportRecords;
        }
        boolean extendedAdvertisingReport = false;
        if (b[2] == 13) {
            extendedAdvertisingReport = true;
        }
        int reportRecordsNumber = b[3];
        int ptr = 4;
        int nr = 0;
        while (nr < reportRecordsNumber) {
            byte arrDataLength;
            AdvertisingReportRecord arr = new AdvertisingReportRecord();
            arr.setExtendedReport(extendedAdvertisingReport);
            if (extendedAdvertisingReport) {
                arr.setEventType(b[ptr++] & 0xFF | (b[ptr++] & 0xFF) << 8);
            } else {
                arr.setEventType((int)b[ptr++]);
            }
            arr.setAddressType((int)b[ptr++]);
            String address = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
            arr.setAddress(address);
            ptr += 6;
            if (extendedAdvertisingReport) {
                arr.setPrimaryPhy((int)b[ptr++]);
                arr.setSecondaryPhy((int)b[ptr++]);
                arr.setSid((int)b[ptr++]);
                arr.setTxPower((int)b[ptr++]);
                arr.setRssi((int)b[ptr++]);
                arr.setPeriodicAdvertisingInterval(b[ptr++] & 0xFF | (b[ptr++] & 0xFF) << 8);
                arr.setDirectAddressType((int)b[ptr++]);
                String directAddress = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
                arr.setDirectAddress(directAddress);
                ptr += 6;
            }
            if ((arrDataLength = b[ptr++]) > 0) {
                arr.setLength((int)arrDataLength);
            }
            byte[] arrData = new byte[arrDataLength];
            System.arraycopy(b, ptr, arrData, 0, arrDataLength);
            arr.setReportData(arrData);
            if (!extendedAdvertisingReport) {
                arr.setRssi((int)b[ptr + arrDataLength]);
            }
            reportRecords.add(arr);
            ptr += arrDataLength;
            ++nr;
        }
        return reportRecords;
    }

    public static boolean stopHcitool(String interfaceName, CommandExecutorService executorService, String ... params) {
        ArrayList<String> killCommand = new ArrayList<String>();
        killCommand.add(HCITOOL);
        killCommand.add("-i");
        killCommand.add(interfaceName);
        Arrays.asList(params).stream().forEach(s -> {
            boolean bl = killCommand.add((String)s);
        });
        return executorService.kill(killCommand.toArray(new String[0]), (Signal)LinuxSignal.SIGINT);
    }

    public static boolean stopBtdump(String interfaceName, CommandExecutorService executorService) {
        String[] command = new String[]{"btmon", "-i", interfaceName, "-w", "/dev/fd/3"};
        return executorService.kill(command, (Signal)LinuxSignal.SIGTERM);
    }
}

