/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.triton.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.util.io.Streams;
import org.eclipse.kura.KuraIOException;
import org.eclipse.kura.util.zip.UnZip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TritonServerEncryptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(TritonServerEncryptionUtils.class);

    private TritonServerEncryptionUtils() {
    }

    protected static String getEncryptedModelPath(String modelName, String folderPath) throws KuraIOException {
        if (!Files.isDirectory(Paths.get(folderPath, new String[0]), new LinkOption[0])) {
            throw new KuraIOException((Object)("Model repository folder " + folderPath + " does not exist/is not a folder"));
        }
        File dir = new File(folderPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(String.valueOf(modelName) + ".*");
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files.length != 1) {
            throw new KuraIOException((Object)"No good match found in folder path");
        }
        return files[0].toString();
    }

    protected static String createDecryptionFolder(String prefix) throws IOException {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
        Path tempFolderPath = Files.createTempDirectory(prefix, PosixFilePermissions.asFileAttribute(permissions));
        logger.debug("Created temporary directory at path {}", (Object)tempFolderPath);
        return tempFolderPath.toString();
    }

    protected static void decryptModel(String password, String inputFilePath, String outputFilePath) throws IOException, KuraIOException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (!Files.isRegularFile(Paths.get(inputFilePath, new String[0]), new LinkOption[0])) {
            throw new IOException("Input file " + inputFilePath + " does not exist/is not a file");
        }
        if (Files.exists(Paths.get(outputFilePath, new String[0]), new LinkOption[0])) {
            throw new IOException("Output file " + outputFilePath + " already exists");
        }
        try {
            TritonServerEncryptionUtils.decryptFile(password, inputFilePath, outputFilePath);
        }
        catch (PGPException e) {
            throw new KuraIOException((Throwable)e, (Object)"File decryption failed.");
        }
    }

    protected static void unzipModel(String inputFilePath, String outputFolder) throws IOException {
        if (!Files.isRegularFile(Paths.get(inputFilePath, new String[0]), new LinkOption[0])) {
            throw new IOException("Input file " + inputFilePath + " does not exist/is not a file");
        }
        if (!UnZip.isZipCompressed((String)inputFilePath)) {
            throw new IOException("ZIP magic number check failed. Wrong file format");
        }
        if (!Files.isDirectory(Paths.get(outputFolder, new String[0]), new LinkOption[0])) {
            throw new IOException("Output folder " + outputFolder + " does not exist/is not a folder");
        }
        UnZip.unZipFile((String)inputFilePath, (String)outputFolder);
    }

    protected static void cleanRepository(String modelRootPath) {
        if (!Files.isDirectory(Paths.get(modelRootPath, new String[0]), new LinkOption[0])) {
            logger.warn("Model root folder {} does not exist", (Object)modelRootPath);
            return;
        }
        try {
            FileUtils.cleanDirectory((File)new File(modelRootPath));
        }
        catch (IOException e) {
            logger.warn("Cannot clean directory at path {}", (Object)modelRootPath, (Object)e);
        }
    }

    private static void decryptFile(String password, String inputFilePath, String outputFilePath) throws IOException, PGPException {
        InputStream inStream = new BufferedInputStream(new FileInputStream(inputFilePath));
        JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(inStream = PGPUtil.getDecoderStream((InputStream)inStream));
        Object currentObj = pgpFactory.nextObject();
        PGPEncryptedDataList enc = currentObj instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)currentObj : (PGPEncryptedDataList)pgpFactory.nextObject();
        if (enc == null) {
            inStream.close();
            throw new IOException("PGP PBE File format read failed");
        }
        PGPPBEEncryptedData pbe = (PGPPBEEncryptedData)enc.get(0);
        InputStream clear = pbe.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(password.toCharArray()));
        pgpFactory = new JcaPGPObjectFactory(clear);
        currentObj = pgpFactory.nextObject();
        if (currentObj instanceof PGPCompressedData) {
            PGPCompressedData compressedData = (PGPCompressedData)currentObj;
            pgpFactory = new JcaPGPObjectFactory(compressedData.getDataStream());
            currentObj = pgpFactory.nextObject();
        }
        PGPLiteralData literalData = (PGPLiteralData)currentObj;
        InputStream decryptedStream = literalData.getInputStream();
        FileOutputStream outStream = new FileOutputStream(outputFilePath);
        Streams.pipeAll((InputStream)decryptedStream, (OutputStream)outStream);
        ((OutputStream)outStream).close();
        inStream.close();
        if (pbe.isIntegrityProtected()) {
            if (!pbe.verify()) {
                logger.error("File failed integrity check");
            } else {
                logger.info("File integrity check passed");
            }
        } else {
            logger.info("No file integrity check");
        }
    }
}

