/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.WriterReaderPhaser;

public class DoubleRecorder {
    private static AtomicLong instanceIdSequencer = new AtomicLong(1L);
    private final long instanceId = instanceIdSequencer.getAndIncrement();
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile InternalConcurrentDoubleHistogram activeHistogram;
    private InternalConcurrentDoubleHistogram inactiveHistogram;

    public DoubleRecorder(int numberOfSignificantValueDigits) {
        this.activeHistogram = new InternalConcurrentDoubleHistogram(this.instanceId, numberOfSignificantValueDigits);
        this.inactiveHistogram = new InternalConcurrentDoubleHistogram(this.instanceId, numberOfSignificantValueDigits);
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    public DoubleRecorder(long highestToLowestValueRatio, int numberOfSignificantValueDigits) {
        this.activeHistogram = new InternalConcurrentDoubleHistogram(this.instanceId, highestToLowestValueRatio, numberOfSignificantValueDigits);
        this.inactiveHistogram = new InternalConcurrentDoubleHistogram(this.instanceId, highestToLowestValueRatio, numberOfSignificantValueDigits);
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValue(double value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValueWithExpectedInterval(double value, double expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public synchronized DoubleHistogram getIntervalHistogram() {
        return this.getIntervalHistogram(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DoubleHistogram getIntervalHistogram(DoubleHistogram histogramToRecycle) {
        if (histogramToRecycle == null) {
            histogramToRecycle = new InternalConcurrentDoubleHistogram(this.inactiveHistogram);
        }
        this.validateFitAsReplacementHistogram(histogramToRecycle);
        try {
            this.recordingPhaser.readerLock();
            this.inactiveHistogram = (InternalConcurrentDoubleHistogram)histogramToRecycle;
            this.performIntervalSample();
            InternalConcurrentDoubleHistogram internalConcurrentDoubleHistogram = this.inactiveHistogram;
            return internalConcurrentDoubleHistogram;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public synchronized void getIntervalHistogramInto(DoubleHistogram targetHistogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(targetHistogram);
    }

    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        this.inactiveHistogram.reset();
        try {
            this.recordingPhaser.readerLock();
            InternalConcurrentDoubleHistogram tempHistogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = tempHistogram;
            long now = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(now);
            this.inactiveHistogram.setEndTimeStamp(now);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    void validateFitAsReplacementHistogram(DoubleHistogram replacementHistogram) {
        boolean bad = true;
        if (replacementHistogram instanceof InternalConcurrentDoubleHistogram && ((InternalConcurrentDoubleHistogram)replacementHistogram).containingInstanceId == this.activeHistogram.containingInstanceId) {
            bad = false;
        }
        if (bad) {
            throw new IllegalArgumentException("replacement histogram must have been obtained via a previousgetIntervalHistogram() call from this " + this.getClass().getName() + " instance");
        }
    }

    private class InternalConcurrentDoubleHistogram
    extends ConcurrentDoubleHistogram {
        private final long containingInstanceId;

        private InternalConcurrentDoubleHistogram(long id, int numberOfSignificantValueDigits) {
            super(numberOfSignificantValueDigits);
            this.containingInstanceId = id;
        }

        private InternalConcurrentDoubleHistogram(long id, long highestToLowestValueRatio, int numberOfSignificantValueDigits) {
            super(highestToLowestValueRatio, numberOfSignificantValueDigits);
            this.containingInstanceId = id;
        }

        private InternalConcurrentDoubleHistogram(InternalConcurrentDoubleHistogram source) {
            super(source);
            this.containingInstanceId = source.containingInstanceId;
        }
    }
}

