/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.triton.server;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.ai.triton.server.TritonServerServiceOptions;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.Signal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TritonServerLocalManager {
    private static final Logger logger = LoggerFactory.getLogger(TritonServerLocalManager.class);
    private static final int MONITOR_PERIOD = 30;
    private static final String[] TRITONSERVER = new String[]{"tritonserver"};
    private final CommandExecutorService commandExecutorService;
    private final TritonServerServiceOptions options;
    private Command serverCommand;
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> scheduledFuture;

    protected TritonServerLocalManager(TritonServerServiceOptions options, CommandExecutorService commandExecutorService) {
        this.options = options;
        this.commandExecutorService = commandExecutorService;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    protected void start() {
        this.startLocalServerMonitor();
    }

    protected void stop() {
        this.stopLocalServerMonitor();
        this.stopScheduledExecutor();
    }

    private void startLocalServerMonitor() {
        if (this.options.isLocalEnabled()) {
            this.serverCommand = this.createServerCommand();
            this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                Thread.currentThread().setName(this.getClass().getSimpleName());
                if (!this.isLocalServerRunning()) {
                    this.startLocalServer();
                }
            }, 0L, 30L, TimeUnit.SECONDS);
        }
    }

    private void startLocalServer() {
        this.commandExecutorService.execute(this.serverCommand, status -> {
            if (status.getExitStatus().isSuccessful()) {
                logger.info("Nvidia Triton Server started");
            } else {
                logger.info("Nvidia Triton Server not started. Exit value: {}", (Object)status.getExitStatus().getExitCode());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("execute command {} :: exited with code - {}", (Object)this.serverCommand, (Object)status.getExitStatus().getExitCode());
                logger.debug("execute stderr {}", (Object)new String(((ByteArrayOutputStream)this.serverCommand.getErrorStream()).toByteArray(), StandardCharsets.UTF_8));
                logger.debug("execute stdout {}", (Object)new String(((ByteArrayOutputStream)this.serverCommand.getOutputStream()).toByteArray(), StandardCharsets.UTF_8));
            }
        });
    }

    private void stopLocalServerMonitor() {
        this.stopMonitor();
        this.stopLocalServer();
    }

    private void stopMonitor() {
        if (Objects.nonNull(this.scheduledFuture)) {
            this.scheduledFuture.cancel(true);
            while (!this.scheduledFuture.isDone()) {
                TritonServerLocalManager.sleepFor(500L);
            }
        }
    }

    private synchronized void stopLocalServer() {
        this.commandExecutorService.kill(TRITONSERVER, (Signal)LinuxSignal.SIGINT);
    }

    private void stopScheduledExecutor() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            while (!this.scheduledExecutorService.isTerminated()) {
                TritonServerLocalManager.sleepFor(500L);
            }
            this.scheduledExecutorService = null;
        }
    }

    private boolean isLocalServerRunning() {
        boolean isRunning = false;
        if (this.commandExecutorService.isRunning(TRITONSERVER)) {
            isRunning = true;
        }
        return isRunning;
    }

    protected static void sleepFor(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private Command createServerCommand() {
        ArrayList<String> commandString = new ArrayList<String>();
        commandString.add("tritonserver");
        commandString.add("--model-repository=" + this.options.getModelRepositoryPath());
        commandString.add("--backend-directory=" + this.options.getBackendsPath());
        if (!this.options.getBackendsConfigs().isEmpty()) {
            this.options.getBackendsConfigs().forEach(config -> {
                boolean bl = commandString.add("--backend-config=" + config);
            });
        }
        commandString.add("--http-port=" + this.options.getHttpPort());
        commandString.add("--grpc-port=" + this.options.getGrpcPort());
        commandString.add("--metrics-port=" + this.options.getMetricsPort());
        commandString.add("--model-control-mode=explicit");
        if (!this.options.getModels().isEmpty()) {
            this.options.getModels().forEach(model -> {
                boolean bl = commandString.add("--load-model=" + model);
            });
        }
        commandString.add("2>&1");
        commandString.add("|");
        commandString.add("systemd-cat");
        commandString.add("-t tritonserver");
        commandString.add("-p info");
        Command command = new Command(commandString.toArray(new String[0]));
        command.setTimeout(-1);
        command.setExecuteInAShell(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        command.setErrorStream((OutputStream)err);
        command.setOutputStream((OutputStream)out);
        logger.debug("Triton command: {}", commandString);
        return command;
    }
}

