/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.XmlConfigPropertiesAdapted;
import org.eclipse.kura.core.configuration.XmlConfigPropertiesAdapter;
import org.eclipse.kura.core.configuration.XmlConfigPropertyAdapted;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaMetadataMapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlJavaComponentConfigurationsMapper
implements XmlJavaDataMapper {
    private static final String CONFIGURATIONS = "configurations";
    private static final String PROPERTIES = "properties";
    private static final String CONFIGURATION_PID = "pid";
    private static final String CONFIGURATIONS_CONFIGURATION = "configuration";
    private static final String CONFIGURATIONS_CONFIGURATION_PROPERTY = "property";
    private static final String CONFIGURATIONS_CONFIGURATION_PROPERTY_NAME = "name";
    private static final String CONFIGURATIONS_CONFIGURATION_PROPERTY_ARRAY = "array";
    private static final String CONFIGURATIONS_CONFIGURATION_PROPERTY_ENCRYPTED = "encrypted";
    private static final String CONFIGURATIONS_CONFIGURATION_PROPERTY_TYPE = "type";
    private static final String CONFIGURATIONS_CONFIGURATION_PROPERTY_VALUE = "value";
    private Document marshallDoc = null;

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        this.marshallDoc = doc;
        Element configurations = doc.createElement("esf:configurations");
        configurations.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:esf", "http://eurotech.com/esf/2.0");
        configurations.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ocd", "http://www.osgi.org/xmlns/metatype/v1.2.0");
        doc.appendChild(configurations);
        XmlComponentConfigurations xmlCompConfig = (XmlComponentConfigurations)object;
        List configs = xmlCompConfig.getConfigurations();
        if (configs != null) {
            for (ComponentConfiguration config : configs) {
                Element configuration = this.marshallConfiguration(config);
                configurations.appendChild(configuration);
            }
        }
        return configurations;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        XmlComponentConfigurations xcc = new XmlComponentConfigurations();
        NodeList configurationList = doc.getElementsByTagName("esf:configuration");
        ArrayList<ComponentConfiguration> compConfList = new ArrayList<ComponentConfiguration>();
        int configIndex = 0;
        while (configIndex < configurationList.getLength()) {
            Element configuration = (Element)configurationList.item(configIndex);
            ComponentConfiguration cci = this.parseConfiguration(configuration);
            compConfList.add(cci);
            ++configIndex;
        }
        xcc.setConfigurations(compConfList);
        return (T)xcc;
    }

    private Element marshallConfiguration(ComponentConfiguration config) throws Exception {
        String configPid = config.getPid();
        Map configProperty = config.getConfigurationProperties();
        OCD configOCD = config.getDefinition();
        Element configurationElement = this.marshallDoc.createElement("esf:configuration");
        Attr propertiesAttribute = this.marshallDoc.createAttribute(CONFIGURATION_PID);
        propertiesAttribute.setNodeValue(configPid);
        configurationElement.setAttributeNode(propertiesAttribute);
        if (configOCD != null) {
            Element ocd = new XmlJavaMetadataMapper().marshal(this.marshallDoc, configOCD);
            configurationElement.appendChild(ocd);
        }
        if (configProperty != null) {
            Element properties = this.marshallDoc.createElement("esf:properties");
            this.marshallProperties(configProperty, properties);
            configurationElement.appendChild(properties);
        }
        return configurationElement;
    }

    private void marshallProperties(Map<String, Object> propertyMap, Element properties) throws Exception {
        XmlConfigPropertyAdapted[] propArray;
        XmlConfigPropertiesAdapter xmlPropAdapter = new XmlConfigPropertiesAdapter();
        XmlConfigPropertiesAdapted configPropAdapted = xmlPropAdapter.marshal(propertyMap);
        XmlConfigPropertyAdapted[] xmlConfigPropertyAdaptedArray = propArray = configPropAdapted.getProperties();
        int n = propArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlConfigPropertyAdapted propertyObj = xmlConfigPropertyAdaptedArray[n2];
            Element property = this.marshallProperty(propertyObj);
            if (property != null) {
                properties.appendChild(property);
            }
            ++n2;
        }
    }

    private Element marshallProperty(XmlConfigPropertyAdapted propertyObj) {
        String name = propertyObj.getName();
        Boolean array = propertyObj.getArray();
        Boolean encrypted = propertyObj.isEncrypted();
        XmlConfigPropertyAdapted.ConfigPropertyType cpt = propertyObj.getType();
        String[] values = propertyObj.getValues();
        if (values != null) {
            Element property = this.marshallDoc.createElement("esf:property");
            Attr attName = this.marshallDoc.createAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_NAME);
            attName.setNodeValue(name);
            property.setAttributeNode(attName);
            Attr attArray = this.marshallDoc.createAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_ARRAY);
            attArray.setNodeValue(array.toString());
            property.setAttributeNode(attArray);
            Attr attEncrypted = this.marshallDoc.createAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_ENCRYPTED);
            attEncrypted.setNodeValue(encrypted.toString());
            property.setAttributeNode(attEncrypted);
            Attr attType = this.marshallDoc.createAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_TYPE);
            attType.setNodeValue(this.getStringValue(cpt));
            property.setAttributeNode(attType);
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                Element valueElem = this.marshallDoc.createElement("esf:value");
                valueElem.setTextContent(value);
                property.appendChild(valueElem);
                ++n2;
            }
            return property;
        }
        return null;
    }

    private String getStringValue(XmlConfigPropertyAdapted.ConfigPropertyType type) {
        if (type == null) {
            return "String";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.STRING_TYPE)) {
            return "String";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.LONG_TYPE)) {
            return "Long";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.DOUBLE_TYPE)) {
            return "Double";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.FLOAT_TYPE)) {
            return "Float";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.INTEGER_TYPE)) {
            return "Integer";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.BYTE_TYPE)) {
            return "Byte";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.CHAR_TYPE)) {
            return "Char";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.BOOLEAN_TYPE)) {
            return "Boolean";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.SHORT_TYPE)) {
            return "Short";
        }
        if (type.equals((Object)XmlConfigPropertyAdapted.ConfigPropertyType.PASSWORD_TYPE)) {
            return "Password";
        }
        return "String";
    }

    private ComponentConfiguration parseConfiguration(Element configuration) throws Exception {
        XmlConfigPropertiesAdapter xmlPropAdapter = new XmlConfigPropertiesAdapter();
        NodeList propertiesList = configuration.getChildNodes();
        Element[] propertiesArray = this.getElementNodes(propertiesList);
        XmlConfigPropertiesAdapted xmlPropertiesAdapted = new XmlConfigPropertiesAdapted();
        Element[] elementArray = propertiesArray;
        int n = propertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = elementArray[n2];
            NodeList propertyList = element.getChildNodes();
            Element[] propertyArray = this.getElementNodes(propertyList);
            XmlConfigPropertyAdapted[] xmlConfigProperties = new XmlConfigPropertyAdapted[propertyArray.length];
            int propertyIndex = 0;
            while (propertyIndex < propertyArray.length) {
                XmlConfigPropertyAdapted xmlProperty;
                xmlConfigProperties[propertyIndex] = xmlProperty = this.parseProperty(propertyArray[propertyIndex]);
                ++propertyIndex;
            }
            xmlPropertiesAdapted.setProperties(xmlConfigProperties);
            ++n2;
        }
        Map propertiesMap = xmlPropAdapter.unmarshal(xmlPropertiesAdapted);
        String pid = configuration.getAttribute(CONFIGURATION_PID);
        return new ComponentConfigurationImpl(pid, null, propertiesMap);
    }

    private XmlConfigPropertyAdapted parseProperty(Element property) {
        NodeList valuesList = property.getChildNodes();
        Element[] valuesArray = this.getElementNodes(valuesList);
        String[] values = new String[valuesArray.length];
        int valIndex = 0;
        while (valIndex < valuesArray.length) {
            values[valIndex] = valuesArray[valIndex].getTextContent();
            ++valIndex;
        }
        String name = property.getAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_NAME);
        String type = property.getAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_TYPE);
        String array = property.getAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_ARRAY);
        String encrypted = property.getAttribute(CONFIGURATIONS_CONFIGURATION_PROPERTY_ENCRYPTED);
        XmlConfigPropertyAdapted.ConfigPropertyType cct = this.getType(type);
        XmlConfigPropertyAdapted xmlProperty = new XmlConfigPropertyAdapted(name, cct, values);
        xmlProperty.setArray(Boolean.parseBoolean(array));
        xmlProperty.setEncrypted(Boolean.parseBoolean(encrypted));
        return xmlProperty;
    }

    private Element[] getElementNodes(NodeList propertiesList) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        int propIndex = 0;
        while (propIndex < propertiesList.getLength()) {
            Node currentNode = propertiesList.item(propIndex);
            if (currentNode.getNodeType() == 1) {
                Element el = (Element)currentNode;
                elementList.add(el);
            }
            ++propIndex;
        }
        return elementList.toArray(new Element[0]);
    }

    private XmlConfigPropertyAdapted.ConfigPropertyType getType(String type) {
        if (type.equals("String")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.STRING_TYPE;
        }
        if (type.equals("Long")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.LONG_TYPE;
        }
        if (type.equals("Double")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.DOUBLE_TYPE;
        }
        if (type.equals("Float")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.FLOAT_TYPE;
        }
        if (type.equals("Integer")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.INTEGER_TYPE;
        }
        if (type.equals("Byte")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.BYTE_TYPE;
        }
        if (type.equals("Char")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.CHAR_TYPE;
        }
        if (type.equals("Boolean")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.BOOLEAN_TYPE;
        }
        if (type.equals("Short")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.SHORT_TYPE;
        }
        if (type.equals("Password")) {
            return XmlConfigPropertyAdapted.ConfigPropertyType.PASSWORD_TYPE;
        }
        return null;
    }
}

