/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.channel.ChannelFlag;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelStatus;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtChannelOperationResult;
import org.eclipse.kura.web.shared.model.GwtChannelRecord;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtAssetService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class GwtAssetServiceImpl
extends OsgiRemoteServiceServlet
implements GwtAssetService {
    private static final long serialVersionUID = 8627173534436639487L;
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();

    @Override
    public GwtChannelOperationResult readAllChannels(GwtXSRFToken xsrfToken, String assetPid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            ArrayList<GwtChannelRecord> result = new ArrayList<GwtChannelRecord>();
            this.withAsset(assetPid, asset -> {
                List assetData = asset.readAllChannels();
                for (ChannelRecord channelRecord : assetData) {
                    result.add(GwtAssetServiceImpl.toGwt(channelRecord));
                }
            });
            return new GwtChannelOperationResult(result);
        }
        catch (Exception e) {
            return this.getFailureResult(e);
        }
    }

    @Override
    public GwtChannelOperationResult write(GwtXSRFToken xsrfToken, String assetPid, List<GwtChannelRecord> gwtChannelRecords) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            HashMap<String, GwtChannelRecord> groupedRecords = new HashMap<String, GwtChannelRecord>(gwtChannelRecords.size());
            for (GwtChannelRecord record : gwtChannelRecords) {
                record.setUnescaped(true);
                groupedRecords.put(record.getName(), record);
            }
            ArrayList<ChannelRecord> channelRecords = new ArrayList<ChannelRecord>();
            for (GwtChannelRecord gwtChannelData : gwtChannelRecords) {
                String channelName = gwtChannelData.getName();
                String typedValue = gwtChannelData.getValueType();
                String value = gwtChannelData.getValue();
                try {
                    channelRecords.add(ChannelRecord.createWriteRecord((String)channelName, GwtAssetServiceImpl.parseTypedValue(value, typedValue)));
                }
                catch (Exception e) {
                    gwtChannelData.setValue(null);
                    gwtChannelData.setExceptionMessage(e.getMessage());
                    gwtChannelData.setExceptionStackTrace(e.getStackTrace());
                }
            }
            this.withAsset(assetPid, asset -> asset.write(channelRecords));
            for (ChannelRecord record : channelRecords) {
                GwtChannelRecord gwtChannelRecord = (GwtChannelRecord)groupedRecords.get(record.getChannelName());
                ChannelStatus status = record.getChannelStatus();
                if (status.getChannelFlag() != ChannelFlag.FAILURE) continue;
                GwtAssetServiceImpl.fillErrorData(status, gwtChannelRecord);
            }
            return new GwtChannelOperationResult(gwtChannelRecords);
        }
        catch (Exception e) {
            return this.getFailureResult(e);
        }
    }

    private GwtChannelOperationResult getFailureResult(Throwable e) {
        Throwable rootCause = e.getCause();
        if (rootCause != null) {
            return new GwtChannelOperationResult(rootCause);
        }
        return new GwtChannelOperationResult(e);
    }

    private void withAsset(String kuraServicePid, ServiceLocator.ServiceConsumer<Asset> consumer) throws Exception {
        String filter;
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        Collection refs = ctx.getServiceReferences(Asset.class, filter = String.format("(%s=%s)", "kura.service.pid", kuraServicePid));
        if (refs == null || refs.isEmpty()) {
            return;
        }
        ServiceReference assetRef = (ServiceReference)refs.iterator().next();
        try {
            consumer.consume((Asset)ctx.getService(assetRef));
        }
        finally {
            ctx.ungetService(assetRef);
        }
    }

    private static GwtChannelRecord toGwt(ChannelRecord channelRecord) {
        GwtChannelRecord channelData = new GwtChannelRecord();
        channelData.setName(channelRecord.getChannelName());
        channelData.setValueType(channelRecord.getValueType().toString());
        ChannelStatus status = channelRecord.getChannelStatus();
        if (ChannelFlag.SUCCESS.equals((Object)status.getChannelFlag())) {
            channelData.setValue(GwtAssetServiceImpl.typedValueToString(channelRecord.getValue()));
        } else {
            GwtAssetServiceImpl.fillErrorData(status, channelData);
        }
        return channelData;
    }

    private static void fillErrorData(ChannelStatus status, GwtChannelRecord record) {
        record.setValue(null);
        Exception exception = status.getException();
        String userMessage = status.getExceptionMessage();
        String exceptionMessage = exception != null ? exception.getMessage() : null;
        StringBuilder exceptionMessageBuilder = new StringBuilder();
        if (userMessage != null) {
            exceptionMessageBuilder.append(userMessage);
        }
        if (exceptionMessage != null && !exceptionMessage.equals(userMessage)) {
            if (userMessage != null) {
                exceptionMessageBuilder.append(" - ");
            }
            exceptionMessageBuilder.append(exceptionMessage);
        }
        record.setExceptionMessage(exceptionMessageBuilder.toString());
        if (exception != null) {
            record.setExceptionStackTrace(exception.getStackTrace());
        }
    }

    private static TypedValue<?> parseTypedValue(String userValue, String userType) {
        DataType dataType = DataType.getDataType((String)userType);
        if (DataType.INTEGER == dataType) {
            return TypedValues.newIntegerValue((int)Integer.parseInt(userValue));
        }
        if (DataType.BOOLEAN == dataType) {
            return TypedValues.newBooleanValue((boolean)Boolean.parseBoolean(userValue));
        }
        if (DataType.FLOAT == dataType) {
            return TypedValues.newFloatValue((float)Float.parseFloat(userValue));
        }
        if (DataType.DOUBLE == dataType) {
            return TypedValues.newDoubleValue((double)Double.parseDouble(userValue));
        }
        if (DataType.LONG == dataType) {
            return TypedValues.newLongValue((long)Long.parseLong(userValue));
        }
        if (DataType.STRING == dataType) {
            return TypedValues.newStringValue((String)userValue);
        }
        if (DataType.BYTE_ARRAY == dataType) {
            return TypedValues.newByteArrayValue((byte[])BASE64_DECODER.decode(userValue));
        }
        throw new IllegalArgumentException();
    }

    private static String typedValueToString(TypedValue<?> typedValue) {
        if (typedValue.getType() == DataType.BYTE_ARRAY) {
            return BASE64_ENCODER.encodeToString((byte[])typedValue.getValue());
        }
        return typedValue.getValue().toString();
    }
}

