/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.fifo;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class Fifo
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final String DISCARD_ENVELOPES_PROP_NAME = "discard.envelopes";
    private static final String QUEUE_CAPACITY_PROP_NAME = "queue.capacity";
    private static final Logger logger = LogManager.getLogger(Fifo.class);
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private FifoEmitterThread emitterThread;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    public void activate(Map<String, Object> properties, ComponentContext componentContext) {
        logger.info("Activating Fifo...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.updated(properties);
        logger.info("Activating Fifo... Done");
    }

    public void deactivate() {
        logger.info("Dectivating Fifo...");
        this.stopEmitterThread();
        logger.info("Dectivating Fifo... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.info("Updating Fifo...");
        String threadName = String.valueOf((String)properties.getOrDefault("kura.service.pid", "Fifo")) + "-EmitterThread";
        int queueCapacity = (Integer)properties.getOrDefault(QUEUE_CAPACITY_PROP_NAME, 50);
        boolean discardEnvelopes = (Boolean)properties.getOrDefault(DISCARD_ENVELOPES_PROP_NAME, false);
        this.restartEmitterThread(threadName, queueCapacity, discardEnvelopes);
        logger.info("Updating Fifo... Done");
    }

    private synchronized void stopEmitterThread() {
        if (this.emitterThread != null) {
            this.emitterThread.shutdown();
            this.emitterThread = null;
        }
    }

    private synchronized void restartEmitterThread(String threadName, int queueCapacity, boolean discardEnvelopes) {
        this.stopEmitterThread();
        logger.debug("Creating new emitter thread: {}, queue capacity: {}, discard envelopes: {}", (Object)threadName, (Object)queueCapacity, (Object)discardEnvelopes);
        this.emitterThread = new FifoEmitterThread(threadName, queueCapacity, discardEnvelopes);
        this.emitterThread.start();
    }

    public void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        if (this.emitterThread != null) {
            this.emitterThread.submit(wireEnvelope);
        }
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    private class FifoEmitterThread
    extends Thread {
        private Lock lock = new ReentrantLock();
        private Condition producer = this.lock.newCondition();
        private Condition consumer = this.lock.newCondition();
        private boolean run = true;
        private ArrayList<WireEnvelope> queue = new ArrayList();
        private int queueCapacity;
        private Consumer<WireEnvelope> submitter;

        public FifoEmitterThread(String threadName, int queueCapacity, boolean discardEnvelopes) {
            this.queueCapacity = queueCapacity;
            this.setName(threadName);
            this.submitter = discardEnvelopes ? this.getEnvelopeDiscardingSubmitter() : this.getEmitterBlockingSubmitter();
        }

        private Consumer<WireEnvelope> getEnvelopeDiscardingSubmitter() {
            return envelope -> {
                try {
                    this.lock.lock();
                    if (!this.run || this.queue.size() >= this.queueCapacity) {
                        logger.debug("envelope discarded");
                        return;
                    }
                    this.queue.add((WireEnvelope)envelope);
                    this.producer.signal();
                    logger.debug("envelope submitted");
                }
                finally {
                    this.lock.unlock();
                }
            };
        }

        private Consumer<WireEnvelope> getEmitterBlockingSubmitter() {
            return envelope -> {
                try {
                    this.lock.lock();
                    while (this.run && this.queue.size() >= this.queueCapacity) {
                        this.consumer.await();
                    }
                    if (!this.run) {
                        return;
                    }
                    try {
                        this.queue.add((WireEnvelope)envelope);
                        this.producer.signal();
                        logger.debug("envelope submitted");
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("Interrupted while adding new envelope to queue", (Throwable)e);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            };
        }

        public void shutdown() {
            try {
                this.lock.lock();
                this.run = false;
                this.producer.signalAll();
                this.consumer.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void submit(WireEnvelope envelope) {
            this.submitter.accept(envelope);
        }

        @Override
        public void run() {
            while (this.run) {
                try {
                    WireEnvelope next = null;
                    try {
                        this.lock.lock();
                        while (this.run && this.queue.isEmpty()) {
                            this.producer.await();
                        }
                        if (!this.run) break;
                        next = this.queue.remove(0);
                        this.consumer.signal();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    Fifo.this.wireSupport.emit(next.getRecords());
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while dispatching envelope", (Throwable)e);
                }
            }
            logger.debug("exiting");
        }
    }
}

