/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth;

import org.eclipse.kura.bluetooth.BluetoothConnector;
import org.eclipse.kura.bluetooth.BluetoothDevice;
import org.eclipse.kura.bluetooth.BluetoothGatt;
import org.eclipse.kura.linux.bluetooth.BluetoothServiceImpl;
import org.eclipse.kura.linux.bluetooth.le.BluetoothGattImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BluetoothDeviceImpl
implements BluetoothDevice {
    public static final int DEVICE_TYPE_DUAL = 3;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    private final String m_name;
    private final String m_address;

    public BluetoothDeviceImpl(String address, String name) {
        this.m_address = address;
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAdress() {
        return this.m_address;
    }

    public int getType() {
        return 0;
    }

    public BluetoothConnector getBluetoothConnector() {
        ServiceReference sr;
        BluetoothConnector bluetoothConnector = null;
        BundleContext bundleContext = BluetoothServiceImpl.getBundleContext();
        if (bundleContext != null && (sr = bundleContext.getServiceReference(BluetoothConnector.class)) != null) {
            bluetoothConnector = (BluetoothConnector)bundleContext.getService(sr);
        }
        return bluetoothConnector;
    }

    public BluetoothGatt getBluetoothGatt() {
        return new BluetoothGattImpl(this.m_address);
    }
}

