/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.wifi;

public enum WifiSecurity {
    NONE(0),
    PAIR_WEP40(1),
    PAIR_WEP104(2),
    PAIR_TKIP(4),
    PAIR_CCMP(8),
    GROUP_WEP40(16),
    GROUP_WEP104(32),
    GROUP_TKIP(64),
    GROUP_CCMP(128),
    KEY_MGMT_PSK(256),
    KEY_MGMT_802_1X(512),
    SECURITY_NONE(1024),
    SECURITY_WEP(2048),
    SECURITY_WPA(4096),
    SECURITY_WPA2(8192),
    SECURITY_WPA_WPA2(16384);

    private int m_code;

    private WifiSecurity(int code) {
        this.m_code = code;
    }

    public static WifiSecurity parseCode(int code) {
        WifiSecurity[] wifiSecurityArray = WifiSecurity.values();
        int n = wifiSecurityArray.length;
        int n2 = 0;
        while (n2 < n) {
            WifiSecurity mode = wifiSecurityArray[n2];
            if (mode.m_code == code) {
                return mode;
            }
            ++n2;
        }
        return null;
    }

    public static int getCode(WifiSecurity security) {
        WifiSecurity[] wifiSecurityArray = WifiSecurity.values();
        int n = wifiSecurityArray.length;
        int n2 = 0;
        while (n2 < n) {
            WifiSecurity mode = wifiSecurityArray[n2];
            if (mode == security) {
                return mode.m_code;
            }
            ++n2;
        }
        return -1;
    }
}

