/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.concurrent.Callable;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollbackCallable
implements Callable<Void> {
    private static Logger logger = LoggerFactory.getLogger(RollbackCallable.class);
    private final Long snapshotId;
    private final ConfigurationService configurationService;

    public RollbackCallable(Long snapshotId, ConfigurationService configurationService) {
        this.snapshotId = snapshotId;
        this.configurationService = configurationService;
    }

    @Override
    public Void call() throws Exception {
        Thread.currentThread().setName(this.getClass().getSimpleName());
        try {
            if (this.snapshotId == null) {
                this.configurationService.rollback();
            } else {
                this.configurationService.rollback(this.snapshotId.longValue());
            }
        }
        catch (KuraException e) {
            logger.error("Error rolling back to snapshot: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_ROLLBACK, (Throwable)e, new Object[0]);
        }
        return null;
    }
}

