/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.eclipse.kura.web.client.messages.Messages;

public class DateUtils {
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);

    public static String formatDateTime(Date d) {
        Date dNow = new Date();
        DateTimeFormat dtf1 = DateTimeFormat.getFormat((String)"yyyy.MM.dd 00:00:00.000 ZZZZ");
        DateTimeFormat dtf2 = DateTimeFormat.getFormat((String)"yyyy.MM.dd HH:mm:ss.SSS ZZZZ");
        String today = dtf1.format(dNow);
        Date dToday = dtf2.parse(today);
        String date = null;
        dNow.getTime();
        d.getTime();
        double dDayDiff = (double)(d.getTime() - dToday.getTime()) / 8.64E7;
        if (dDayDiff >= 2.0) {
            DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM);
            date = dtf.format(d);
        } else if (dDayDiff >= 1.0) {
            DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM);
            date = MSGS.tomorrow(dtf.format(d));
        } else if (dDayDiff >= 0.0) {
            DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM);
            date = MSGS.today(dtf.format(d));
        } else if (dDayDiff >= -1.0) {
            DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM);
            date = MSGS.yesterday(dtf.format(d));
        } else {
            DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM);
            date = dtf.format(d);
        }
        return date;
    }

    public static int getYear(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
    }

    public static int getMonth(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date)) - 1;
    }

    public static int getDayOfMonth(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date));
    }

    public static int getHour(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"HH").format(date));
    }

    public static int getMinute(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"mm").format(date));
    }

    public static int getSecond(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"ss").format(date));
    }

    public static int getMillisecond(Date date) {
        return Integer.parseInt(DateTimeFormat.getFormat((String)"SSS").format(date));
    }

    public static Date setYear(Date date, int year) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtils.pad(Integer.toString(year), 4));
        sb.append(dateString.substring(5));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setMonth(Date date, int month) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 5));
        sb.append(DateUtils.pad(Integer.toString(month + 1), 2));
        sb.append(dateString.substring(7));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setDayOfMonth(Date date, int dayOfMonth) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 8));
        sb.append(DateUtils.pad(Integer.toString(dayOfMonth), 2));
        sb.append(dateString.substring(10));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setToLastDayOfMonth(Date date) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 8));
        switch (DateUtils.getMonth(date)) {
            case 0: {
                sb.append("31");
                break;
            }
            case 1: {
                if (DateUtils.isLeapYear(DateUtils.getYear(date))) {
                    sb.append("29");
                    break;
                }
                sb.append("28");
                break;
            }
            case 2: {
                sb.append("31");
                break;
            }
            case 3: {
                sb.append("30");
                break;
            }
            case 4: {
                sb.append("31");
                break;
            }
            case 5: {
                sb.append("30");
                break;
            }
            case 6: {
                sb.append("31");
                break;
            }
            case 7: {
                sb.append("31");
                break;
            }
            case 8: {
                sb.append("30");
                break;
            }
            case 9: {
                sb.append("31");
                break;
            }
            case 10: {
                sb.append("30");
                break;
            }
            case 11: {
                sb.append("31");
                break;
            }
        }
        sb.append(dateString.substring(10));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setHour(Date date, int hour) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 11));
        sb.append(DateUtils.pad(Integer.toString(hour), 2));
        sb.append(dateString.substring(13));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setMinute(Date date, int minute) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 14));
        sb.append(DateUtils.pad(Integer.toString(minute), 2));
        sb.append(dateString.substring(16));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setSecond(Date date, int second) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 17));
        sb.append(DateUtils.pad(Integer.toString(second), 2));
        sb.append(dateString.substring(19));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    public static Date setMillisecond(Date date, int millisecond) {
        String dateString = DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").format(date);
        StringBuilder sb = new StringBuilder();
        sb.append(dateString.substring(0, 20));
        sb.append(DateUtils.pad(Integer.toString(millisecond), 3));
        return DateTimeFormat.getFormat((String)"yyyy.MM.dd.HH.mm.ss.SSS").parse(sb.toString());
    }

    private static String pad(String data, int size) {
        if (data.length() < size) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < size - data.length()) {
                sb.append("0");
                ++i;
            }
            sb.append(data);
            return sb.toString();
        }
        return data;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0;
    }
}

