/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.cloudconnection;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudConnectionsUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.PidTextBox;
import org.eclipse.kura.web.client.util.request.RequestContext;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.model.GwtCloudComponentFactories;
import org.eclipse.kura.web.shared.model.GwtCloudConnectionEntry;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtCloudPubSubEntry;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionService;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.eclipse.kura.web.shared.service.GwtStatusService;
import org.eclipse.kura.web.shared.service.GwtStatusServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.Well;
import org.gwtbootstrap3.client.ui.form.validator.RegExValidator;
import org.gwtbootstrap3.client.ui.form.validator.Validator;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Span;

public class CloudInstancesUi
extends Composite {
    private static final int REFRESH_DELAY_MS = 2000;
    private static CloudConnectionsUiUiBinder uiBinder = (CloudConnectionsUiUiBinder)GWT.create(CloudConnectionsUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final SingleSelectionModel<GwtCloudEntry> selectionModel = new SingleSelectionModel();
    private final ListDataProvider<GwtCloudEntry> cloudServicesDataProvider = new ListDataProvider();
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtCloudConnectionServiceAsync gwtCloudConnection = (GwtCloudConnectionServiceAsync)GWT.create(GwtCloudConnectionService.class);
    private final GwtStatusServiceAsync gwtStatusService = (GwtStatusServiceAsync)GWT.create(GwtStatusService.class);
    private final CloudConnectionsUi cloudServicesUi;
    private static final Comparator<GwtCloudEntry> CLOUD_ENTRY_COMPARATOR = (o1, o2) -> o1.getPid().compareTo(o2.getPid());
    @UiField
    Well connectionsWell;
    @UiField
    Button connectionRefresh;
    @UiField
    Button newConnection;
    @UiField
    Button newPubSub;
    @UiField
    Button deleteConnection;
    @UiField
    Button statusConnectDisconnect;
    @UiField
    Button btnCreateComp;
    @UiField
    Button btnCancel;
    @UiField
    Modal newConnectionModal;
    @UiField
    ListBox cloudFactoriesPids;
    @UiField
    PidTextBox cloudConnectionPid;
    @UiField
    Icon cloudConnectionPidSpinner;
    @UiField
    Modal newPubSubModal;
    @UiField
    ListBox pubSubFactoriesPids;
    @UiField
    PidTextBox pubSubPid;
    @UiField
    Icon pubSubPidSpinner;
    @UiField
    Button btnPubSubCreateComp;
    @UiField
    Button btnPubSubCancel;
    @UiField
    AlertDialog alertDialog;
    List<String> cloudConnectionFactoryPids;
    Map<String, List<GwtCloudEntry>> pubSubFactoryEntries;
    @UiField
    CellTable<GwtCloudEntry> connectionsGrid = new CellTable();
    private GwtCloudComponentFactories cloudComponentFactories;

    public CloudInstancesUi(CloudConnectionsUi cloudServicesUi) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.cloudServicesUi = cloudServicesUi;
        this.connectionsGrid.setSelectionModel(this.selectionModel);
        this.btnCreateComp.addClickHandler(event -> this.createCloudConnectionServiceFactory());
        this.btnPubSubCreateComp.addClickHandler(event -> this.createPubSub());
        this.selectionModel.addSelectionChangeHandler(event -> {
            GwtCloudEntry selected = this.getSelectedObject();
            boolean isEndpoint = false;
            boolean isConnection = false;
            if (selected instanceof GwtCloudConnectionEntry) {
                GwtCloudConnectionEntry cloudConnection = (GwtCloudConnectionEntry)selected;
                isEndpoint = true;
                isConnection = cloudConnection.getConnectionType() == GwtCloudConnectionEntry.GwtCloudConnectionType.CONNECTION;
            }
            this.newPubSub.setEnabled(isEndpoint);
            this.statusConnectDisconnect.setEnabled(isConnection);
            this.cloudServicesUi.onSelectionChange();
        });
        this.cloudFactoriesPids.addChangeHandler(event -> {
            String factoryPid = this.cloudFactoriesPids.getSelectedValue();
            this.getSuggestedCloudConnectionPid(factoryPid);
        });
        this.pubSubFactoriesPids.addChangeHandler(event -> {
            String factoryPid = this.pubSubFactoriesPids.getSelectedValue();
            this.getSuggestedCloudPubSubPid(factoryPid);
        });
        this.initConnectionButtons();
        this.initConnectionsTable();
    }

    public void setData(List<GwtCloudEntry> data) {
        ArrayList<GwtCloudEntry> cloudConnections = new ArrayList<GwtCloudEntry>();
        HashMap groupedPubSub = new HashMap();
        for (GwtCloudEntry entry : data) {
            if (entry instanceof GwtCloudConnectionEntry) {
                cloudConnections.add(entry);
                groupedPubSub.put(entry.getPid(), new ArrayList());
                continue;
            }
            GwtCloudPubSubEntry pubSub = (GwtCloudPubSubEntry)entry;
            List entries = (List)groupedPubSub.get(pubSub.getCloudConnectionPid());
            if (entries == null) continue;
            entries.add(pubSub);
        }
        cloudConnections.sort(CLOUD_ENTRY_COMPARATOR);
        List providerList = this.cloudServicesDataProvider.getList();
        providerList.clear();
        for (GwtCloudEntry entry : cloudConnections) {
            providerList.add(entry);
            List pubSubs = (List)groupedPubSub.get(entry.getPid());
            if (pubSubs == null) continue;
            pubSubs.sort(CLOUD_ENTRY_COMPARATOR);
            providerList.addAll(pubSubs);
        }
        this.refresh();
    }

    public void setFactoryInfo(GwtCloudComponentFactories factories) {
        this.cloudComponentFactories = factories;
        this.cloudConnectionFactoryPids = factories.getCloudConnectionFactoryPids();
        this.pubSubFactoryEntries = new HashMap<String, List<GwtCloudEntry>>();
        for (GwtCloudEntry pubSubEntry : factories.getPubSubFactories()) {
            String factoryPid = pubSubEntry.getFactoryPid();
            this.pubSubFactoryEntries.computeIfAbsent(factoryPid, p -> new ArrayList()).add(pubSubEntry);
        }
    }

    public boolean setStatus(String pid, GwtCloudConnectionEntry.GwtCloudConnectionState state) {
        List entries = this.cloudServicesDataProvider.getList();
        for (GwtCloudEntry entry : entries) {
            if (!pid.equals(entry.getPid()) || !(entry instanceof GwtCloudConnectionEntry)) continue;
            GwtCloudConnectionEntry connEntry = (GwtCloudConnectionEntry)entry;
            connEntry.setState(state);
            this.connectionsGrid.redraw();
            return true;
        }
        return false;
    }

    public int getTableSize() {
        return this.cloudServicesDataProvider.getList().size();
    }

    public void setVisibility(boolean isVisible) {
        this.connectionsGrid.setVisible(isVisible);
    }

    public GwtCloudEntry getSelectedObject() {
        return (GwtCloudEntry)this.selectionModel.getSelectedObject();
    }

    public GwtCloudEntry getObjectAfterSelection() {
        List entries = this.cloudServicesDataProvider.getList();
        int index = entries.indexOf(this.getSelectedObject());
        if (index == -1) {
            return null;
        }
        int nextIndex = index + 1;
        if (nextIndex >= entries.size()) {
            return null;
        }
        return (GwtCloudEntry)entries.get(nextIndex);
    }

    public void setSelected(GwtCloudEntry cloudEntry) {
        this.selectionModel.setSelected((Object)cloudEntry, true);
    }

    private void initConnectionButtons() {
        this.connectionRefresh.addClickHandler(event -> this.cloudServicesUi.refresh());
        this.newConnection.addClickHandler(event -> this.showNewConnectionModal());
        this.newPubSub.addClickHandler(event -> {
            GwtCloudEntry entry = this.getSelectedObject();
            if (!(entry instanceof GwtCloudConnectionEntry)) {
                return;
            }
            this.showNewPubSubModal(((GwtCloudConnectionEntry)entry).getCloudConnectionFactoryPid());
        });
        this.deleteConnection.addClickHandler(event -> {
            if (this.getSelectedObject() instanceof GwtCloudConnectionEntry && this.getObjectAfterSelection() instanceof GwtCloudPubSubEntry) {
                this.alertDialog.show(MSGS.cannotDeleteConnection(), AlertDialog.Severity.ALERT, null);
                return;
            }
            if (this.getTableSize() > 0) {
                this.showDeleteModal();
            }
        });
        this.statusConnectDisconnect.addClickHandler(event -> {
            GwtCloudEntry selection = (GwtCloudEntry)this.selectionModel.getSelectedObject();
            String selectedCloudServicePid = selection.getPid();
            this.connectDisconnectDataService(selectedCloudServicePid);
        });
    }

    private void initConnectionsTable() {
        TextColumn col = new TextColumn<GwtCloudEntry>(){

            public String getValue(GwtCloudEntry object) {
                String pid = object.getPid();
                if (object instanceof GwtCloudPubSubEntry) {
                    return " -> " + pid;
                }
                return pid;
            }

            public void render(Cell.Context context, GwtCloudEntry object, SafeHtmlBuilder sb) {
                String pid = object.getPid();
                if (object instanceof GwtCloudPubSubEntry) {
                    String iconStyle = ((GwtCloudPubSubEntry)object).getType() == GwtCloudPubSubEntry.Type.PUBLISHER ? "fa-arrow-up" : "fa-arrow-down";
                    sb.append((SafeHtml & Serializable)() -> "&ensp;<i class=\"fa assets-status-icon " + iconStyle + "\"></i>" + pid);
                } else {
                    sb.append((SafeHtml & Serializable)() -> "<i class=\"fa assets-status-icon fa-cloud\"></i>" + pid);
                }
            }
        };
        col.setCellStyleNames("status-table-row");
        this.connectionsGrid.addColumn((Column)col, MSGS.connectionCloudConnectionPidHeader());
        col = new TextColumn<GwtCloudEntry>(){

            public String getValue(GwtCloudEntry object) {
                if (object instanceof GwtCloudConnectionEntry) {
                    return "Cloud connection";
                }
                return ((GwtCloudPubSubEntry)object).getType() == GwtCloudPubSubEntry.Type.PUBLISHER ? "Publisher" : "Subscriber";
            }
        };
        col.setCellStyleNames("status-table-row");
        this.connectionsGrid.addColumn((Column)col, MSGS.typeLabel());
        col = new TextColumn<GwtCloudEntry>(){

            public String getValue(GwtCloudEntry object) {
                if (!(object instanceof GwtCloudConnectionEntry)) {
                    return "";
                }
                GwtCloudConnectionEntry entry = (GwtCloudConnectionEntry)object;
                switch (entry.getState()) {
                    case UNREGISTERED: {
                        return MSGS.unregistered();
                    }
                    case CONNECTED: {
                        return MSGS.connected();
                    }
                    case DISCONNECTED: {
                        return MSGS.disconnected();
                    }
                }
                return entry.getState().toString();
            }

            public String getCellStyleNames(Cell.Context context, GwtCloudEntry object) {
                if (!(object instanceof GwtCloudConnectionEntry)) {
                    return "status-table-row";
                }
                GwtCloudConnectionEntry entry = (GwtCloudConnectionEntry)object;
                switch (entry.getState()) {
                    case CONNECTED: {
                        return "status-table-row text-success";
                    }
                    case DISCONNECTED: {
                        return "status-table-row text-danger";
                    }
                }
                return "status-table-row";
            }
        };
        this.connectionsGrid.addColumn((Column)col, MSGS.netIPv4Status());
        col = new TextColumn<GwtCloudEntry>(){

            public String getValue(GwtCloudEntry object) {
                if (object instanceof GwtCloudConnectionEntry) {
                    return ((GwtCloudConnectionEntry)object).getCloudConnectionFactoryPid();
                }
                return object.getFactoryPid();
            }
        };
        col.setCellStyleNames("status-table-row");
        this.connectionsGrid.addColumn((Column)col, MSGS.connectionCloudConnectionFactoryPidHeader());
        this.cloudServicesDataProvider.addDataDisplay(this.connectionsGrid);
    }

    private void createPubSub() {
        String kuraServicePid = this.pubSubPid.getPid();
        if (kuraServicePid == null) {
            return;
        }
        this.newPubSubModal.hide();
        GwtCloudEntry entry = this.getSelectedObject();
        if (!(entry instanceof GwtCloudConnectionEntry)) {
            return;
        }
        String cloudConnectionPid = entry.getPid();
        String factoryPid = this.pubSubFactoriesPids.getSelectedValue();
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtCloudConnection.createPubSubInstance((GwtXSRFToken)token, kuraServicePid, factoryPid, cloudConnectionPid, context.callback(v -> context.defer(2000, this.cloudServicesUi::refresh))))));
    }

    private void deletePubSub(String pid) {
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtCloudConnection.deletePubSubInstance((GwtXSRFToken)token, pid, context.callback(v -> context.defer(2000, this.cloudServicesUi::refresh))))));
    }

    private void createCloudConnectionServiceFactory() {
        String factoryPid = this.cloudFactoriesPids.getSelectedValue();
        String newCloudServicePid = this.cloudConnectionPid.getPid();
        if (newCloudServicePid == null) {
            return;
        }
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtCloudConnection.createCloudServiceFromFactory((GwtXSRFToken)token, factoryPid, newCloudServicePid, context.callback(new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                FailureHandler.handle(caught, CloudInstancesUi.this.gwtCloudConnection.getClass().getSimpleName());
                CloudInstancesUi.this.newConnectionModal.hide();
            }

            public void onSuccess(Void result) {
                context.defer(2000, CloudInstancesUi.this.cloudServicesUi::refresh);
                CloudInstancesUi.this.newConnectionModal.hide();
            }
        })))));
    }

    private void refresh() {
        int size = this.cloudServicesDataProvider.getList().size();
        this.connectionsGrid.setVisibleRange(0, size);
        this.cloudServicesDataProvider.flush();
        if (size > 0) {
            GwtCloudEntry firstEntry = (GwtCloudEntry)this.cloudServicesDataProvider.getList().get(0);
            this.selectionModel.setSelected((Object)firstEntry, true);
        }
        this.connectionsGrid.redraw();
    }

    private void showNewPubSubModal(String connectionFactoryPid) {
        this.pubSubFactoriesPids.clear();
        this.pubSubPid.clear();
        List<GwtCloudEntry> entries = this.pubSubFactoryEntries.get(connectionFactoryPid);
        if (entries == null || entries.isEmpty()) {
            this.alertDialog.show(MSGS.noPubSubFactoriesFound(), AlertDialog.Severity.ALERT, null);
            return;
        }
        for (GwtCloudEntry entry : entries) {
            this.pubSubFactoriesPids.addItem(entry.getPid());
        }
        String selectedPubSubPid = this.pubSubFactoriesPids.getSelectedValue();
        this.getSuggestedCloudPubSubPid(selectedPubSubPid);
        this.newPubSubModal.show();
    }

    private void showNewConnectionModal() {
        this.cloudConnectionPid.clear();
        this.cloudFactoriesPids.clear();
        for (String cloudConnectionFactoryPid : this.cloudConnectionFactoryPids) {
            this.cloudFactoriesPids.addItem(cloudConnectionFactoryPid);
        }
        String selectedFactoryPid = this.cloudFactoriesPids.getSelectedValue();
        this.getSuggestedCloudConnectionPid(selectedFactoryPid);
        this.newConnectionModal.show();
    }

    private void connectDisconnectDataService(String connectionId) {
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtStatusService.isConnected((GwtXSRFToken)token, connectionId, context.callback(isConnected -> {
            if (isConnected.booleanValue()) {
                this.disconnectDataService(connectionId);
            } else {
                this.connectDataService(connectionId);
            }
        })))));
    }

    private void connectDataService(String connectionId) {
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtStatusService.connectDataService((GwtXSRFToken)token, connectionId, (AsyncCallback<Void>)context.callback()))));
    }

    private void disconnectDataService(String connectionId) {
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtStatusService.disconnectDataService((GwtXSRFToken)token, connectionId, (AsyncCallback<Void>)context.callback()))));
    }

    private void deleteConnection(String factoryPid, String cloudServicePid) {
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtCloudConnection.deleteCloudServiceFromFactory((GwtXSRFToken)token, factoryPid, cloudServicePid, context.callback(result -> context.defer(2000, this.cloudServicesUi::refresh))))));
    }

    private void showDeleteModal() {
        Modal modal = new Modal();
        ModalHeader header = new ModalHeader();
        header.setTitle(MSGS.warning());
        modal.add((Widget)header);
        ModalBody body = new ModalBody();
        body.add((Widget)new Span(MSGS.cloudServiceDeleteConfirmation()));
        modal.add((Widget)body);
        ModalFooter footer = new ModalFooter();
        Button yes = new Button(MSGS.yesButton(), event -> {
            GwtCloudEntry selection = (GwtCloudEntry)this.selectionModel.getSelectedObject();
            if (selection instanceof GwtCloudConnectionEntry) {
                GwtCloudConnectionEntry entry = (GwtCloudConnectionEntry)selection;
                String selectedFactoryPid = entry.getCloudConnectionFactoryPid();
                String selectedCloudServicePid = entry.getPid();
                this.deleteConnection(selectedFactoryPid, selectedCloudServicePid);
            } else {
                this.deletePubSub(selection.getPid());
            }
            modal.hide();
        });
        Button no = new Button(MSGS.noButton(), event -> modal.hide());
        footer.add((Widget)no);
        footer.add((Widget)yes);
        modal.add((Widget)footer);
        modal.show();
        no.setFocus(true);
    }

    private void getSuggestedCloudConnectionPid(String factoryPid) {
        RequestQueue.submit(context -> {
            this.cloudConnectionPid.clear();
            this.cloudConnectionPid.setEnabled(false);
            this.cloudConnectionPidSpinner.setVisible(true);
            this.gwtCloudConnection.findSuggestedCloudServicePid(factoryPid, context.callback(result -> this.getCloudConnectionPidRegex(context, factoryPid, (String)result)));
        }, false);
    }

    private void getCloudConnectionPidRegex(RequestContext context, String factoryPid, String example) {
        this.gwtCloudConnection.findCloudServicePidRegex(factoryPid, context.callback(result -> {
            PidTextBox pidTextBox = this.cloudConnectionPid;
            pidTextBox.reset();
            String placeholder = null;
            String validationMessage = null;
            if (example != null) {
                placeholder = MSGS.exampleGiven(example);
                validationMessage = MSGS.mustBeLike(example);
            }
            if (result != null) {
                pidTextBox.setValidators(new Validator[]{new RegExValidator(result, validationMessage)});
            } else {
                pidTextBox.setValidators(new Validator[0]);
            }
            pidTextBox.setPlaceholder(placeholder);
            pidTextBox.setEnabled(true);
            this.cloudConnectionPidSpinner.setVisible(false);
        }));
    }

    private void getSuggestedCloudPubSubPid(String pubSubPid) {
        this.pubSubPid.clear();
        this.pubSubPid.setEnabled(false);
        this.pubSubPid.setVisible(true);
        List<GwtCloudEntry> providerList = this.cloudComponentFactories.getPubSubFactories();
        for (GwtCloudEntry entry : providerList) {
            if (!pubSubPid.equals(entry.getPid())) continue;
            String example = entry.getDefaultFactoryPid();
            String regex = entry.getDefaultFactoryPidRegex();
            String placeholder = null;
            String validationMessage = null;
            if (example != null) {
                placeholder = MSGS.exampleGiven(example);
                validationMessage = MSGS.mustBeLike(example);
            }
            PidTextBox pidTextBox = this.pubSubPid;
            pidTextBox.reset();
            if (regex != null) {
                pidTextBox.setValidators(new Validator[]{new RegExValidator(regex, validationMessage)});
            } else {
                pidTextBox.setValidators(new Validator[0]);
            }
            pidTextBox.setPlaceholder(placeholder);
            pidTextBox.setEnabled(true);
            this.pubSubPidSpinner.setVisible(false);
        }
    }

    static interface CloudConnectionsUiUiBinder
    extends UiBinder<Widget, CloudInstancesUi> {
    }
}

