/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Level;
import org.eclipse.kura.web.client.ui.AbstractServicesUi;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.NavPills;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;

public class ServicesUi
extends AbstractServicesUi {
    private static final ServicesUiUiBinder uiBinder = (ServicesUiUiBinder)GWT.create(ServicesUiUiBinder.class);
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private boolean dirty;
    private boolean initialized;
    private GwtConfigComponent originalConfig;
    NavPills menu;
    PanelBody content;
    AnchorListItem service;
    TextBox validated;
    FormGroup validatedGroup;
    EntryClassUi entryClass;
    Modal modal;
    @UiField
    Button apply;
    @UiField
    Button reset;
    @UiField
    Button delete;
    @UiField
    FieldSet fields;
    @UiField
    Form form;
    @UiField
    Button deleteButton;
    @UiField
    Button cancelButton;
    @UiField
    Modal incompleteFieldsModal;
    @UiField
    Alert incompleteFields;
    @UiField
    Text incompleteFieldsText;
    @UiField
    Modal deleteModal;
    @UiField
    ModalHeader deleteModalHeader;
    @UiField
    ModalBody deleteModalBody;

    public ServicesUi(GwtConfigComponent addedItem, EntryClassUi entryClassUi) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initialized = false;
        this.entryClass = entryClassUi;
        this.originalConfig = addedItem;
        this.restoreConfiguration(this.originalConfig);
        this.fields.clear();
        this.apply.setText(MSGS.apply());
        this.apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServicesUi.this.apply();
            }
        });
        this.reset.setText(MSGS.reset());
        this.reset.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServicesUi.this.reset();
            }
        });
        this.delete.setText(MSGS.delete());
        this.delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServicesUi.this.deleteModal.show();
            }
        });
        this.deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServicesUi.this.delete();
            }
        });
        this.deleteButton.setText(MSGS.delete());
        this.cancelButton.setText(MSGS.cancelButton());
        this.deleteModalBody.add((Widget)new Span(MSGS.deleteWarning()));
        this.deleteModalHeader.setTitle(MSGS.confirm());
        this.renderForm();
        this.initInvalidDataModal();
        this.setDirty(false);
        this.apply.setEnabled(false);
        this.reset.setEnabled(false);
        this.delete.setEnabled(this.configurableComponent.isFactoryComponent());
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
        if (this.dirty && this.initialized) {
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void reset() {
        if (this.isDirty()) {
            this.modal = new Modal();
            ModalHeader header = new ModalHeader();
            header.setTitle(MSGS.confirm());
            this.modal.add((Widget)header);
            ModalBody body = new ModalBody();
            body.add((Widget)new Span(MSGS.deviceConfigDirty()));
            this.modal.add((Widget)body);
            ModalFooter footer = new ModalFooter();
            ButtonGroup group = new ButtonGroup();
            Button no = new Button();
            no.setText(MSGS.noButton());
            no.addStyleName("fa fa-times");
            no.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ServicesUi.this.modal.hide();
                }
            });
            group.add((Widget)no);
            Button yes = new Button();
            yes.setText(MSGS.yesButton());
            yes.addStyleName("fa fa-check");
            yes.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ServicesUi.this.modal.hide();
                    ServicesUi.this.restoreConfiguration(ServicesUi.this.originalConfig);
                    ServicesUi.this.renderForm();
                    ServicesUi.this.apply.setEnabled(false);
                    ServicesUi.this.reset.setEnabled(false);
                    ServicesUi.this.setDirty(false);
                    ServicesUi.this.entryClass.fetchAvailableServices(null);
                }
            });
            group.add((Widget)yes);
            footer.add((Widget)group);
            this.modal.add((Widget)footer);
            this.modal.show();
            no.setFocus(true);
        }
    }

    public void delete() {
        if (this.configurableComponent.isFactoryComponent()) {
            EntryClassUi.showWaitModal();
            this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                public void onFailure(Throwable ex) {
                    EntryClassUi.hideWaitModal();
                    FailureHandler.handle(ex);
                }

                public void onSuccess(GwtXSRFToken token) {
                    ServicesUi.this.gwtComponentService.deleteFactoryConfiguration(token, ServicesUi.this.configurableComponent.getComponentId(), true, new AsyncCallback<Void>(){

                        public void onFailure(Throwable caught) {
                            EntryClassUi.hideWaitModal();
                            errorLogger.log(Level.SEVERE, caught.getLocalizedMessage());
                        }

                        public void onSuccess(Void result) {
                            Window.Location.reload();
                        }
                    });
                }
            });
        }
    }

    @Override
    public void renderForm() {
        this.fields.clear();
        for (GwtConfigParameter param : this.configurableComponent.getParameters()) {
            if (param.getCardinality() == 0 || param.getCardinality() == 1 || param.getCardinality() == -1) {
                FormGroup formGroup = new FormGroup();
                this.renderConfigParameter(param, true, formGroup);
                continue;
            }
            this.renderMultiFieldConfigParameter(param);
        }
        this.initialized = true;
    }

    @Override
    protected void renderTextField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderTextField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderPasswordField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderPasswordField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderBooleanField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderBooleanField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderChoiceField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderChoiceField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    private void apply() {
        if (this.isValid()) {
            if (this.isDirty()) {
                this.modal = new Modal();
                ModalHeader header = new ModalHeader();
                header.setTitle(MSGS.confirm());
                this.modal.add((Widget)header);
                ModalBody body = new ModalBody();
                body.add((Widget)new Span(MSGS.deviceConfigConfirmation(this.configurableComponent.getComponentName())));
                this.modal.add((Widget)body);
                ModalFooter footer = new ModalFooter();
                ButtonGroup group = new ButtonGroup();
                Button no = new Button();
                no.setText(MSGS.noButton());
                no.addStyleName("fa fa-times");
                no.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ServicesUi.this.modal.hide();
                    }
                });
                group.add((Widget)no);
                Button yes = new Button();
                yes.setText(MSGS.yesButton());
                yes.addStyleName("fa fa-check");
                yes.addClickHandler(event -> {
                    try {
                        this.getUpdatedConfiguration();
                    }
                    catch (Exception ex) {
                        FailureHandler.handle(ex);
                        return;
                    }
                    RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtComponentService.updateComponentConfiguration((GwtXSRFToken)token, this.configurableComponent, context.callback(new AsyncCallback<Void>(){

                        public void onFailure(Throwable caught) {
                            FailureHandler.handle(caught);
                            errorLogger.log(Level.SEVERE, caught.getLocalizedMessage() != null ? caught.getLocalizedMessage() : caught.getClass().getName(), caught);
                        }

                        public void onSuccess(Void result) {
                            ServicesUi.this.modal.hide();
                            logger.info(String.valueOf(MSGS.info()) + ": " + MSGS.deviceConfigApplied());
                            ServicesUi.this.apply.setEnabled(false);
                            ServicesUi.this.reset.setEnabled(false);
                            ServicesUi.this.setDirty(false);
                            ServicesUi.this.originalConfig = ServicesUi.this.configurableComponent;
                            context.defer(2000, () -> ServicesUi.this.entryClass.fetchAvailableServices(null));
                        }
                    })))));
                });
                group.add((Widget)yes);
                footer.add((Widget)group);
                this.modal.add((Widget)footer);
                this.modal.show();
                no.setFocus(true);
            }
        } else {
            errorLogger.log(Level.SEVERE, "Device configuration error!");
            this.incompleteFieldsModal.show();
        }
    }

    private GwtConfigComponent getUpdatedConfiguration() {
        for (Widget w : this.fields) {
            if (!(w instanceof FormGroup)) continue;
            FormGroup fg = (FormGroup)w;
            this.fillUpdatedConfiguration(fg);
        }
        return this.configurableComponent;
    }

    private void initInvalidDataModal() {
        this.incompleteFieldsModal.setTitle(MSGS.warning());
        this.incompleteFieldsText.setText(MSGS.formWithErrorsOrIncomplete());
    }

    static interface ServicesUiUiBinder
    extends UiBinder<Widget, ServicesUi> {
    }
}

