/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.Network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.Network.NetworkTab;
import org.eclipse.kura.web.client.ui.Network.TabTcpIpUi;
import org.eclipse.kura.web.client.ui.Network.TabWirelessUi;
import org.eclipse.kura.web.client.util.HelpButton;
import org.eclipse.kura.web.client.util.MessageUtils;
import org.eclipse.kura.web.client.util.TextFieldValidator;
import org.eclipse.kura.web.shared.model.GwtNetIfType;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetRouterMode;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Span;

public class TabDhcpNatUi
extends Composite
implements NetworkTab {
    private static final String ROUTER_OFF_MESSAGE = MessageUtils.get(GwtNetRouterMode.netRouterOff.name());
    private static final String ROUTER_NAT_MESSAGE = MessageUtils.get(GwtNetRouterMode.netRouterNat.name());
    private static final String WIFI_DISABLED = GwtWifiWirelessMode.netWifiWirelessModeDisabled.name();
    private static final String WIFI_STATION_MODE = GwtWifiWirelessMode.netWifiWirelessModeStation.name();
    private static TabDhcpNatUiUiBinder uiBinder = (TabDhcpNatUiUiBinder)GWT.create(TabDhcpNatUiUiBinder.class);
    private static final String REGEX_IPV4 = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    GwtSession session;
    TabTcpIpUi tcpTab;
    TabWirelessUi wirelessTab;
    Boolean dirty;
    GwtNetInterfaceConfig selectedNetIfConfig;
    @UiField
    Form form;
    @UiField
    FormLabel labelRouter;
    @UiField
    FormLabel labelBegin;
    @UiField
    FormLabel labelEnd;
    @UiField
    FormLabel labelSubnet;
    @UiField
    FormLabel labelDefaultL;
    @UiField
    FormLabel labelMax;
    @UiField
    FormLabel labelPass;
    @UiField
    ListBox router;
    @UiField
    TextBox begin;
    @UiField
    TextBox end;
    @UiField
    TextBox subnet;
    @UiField
    TextBox defaultL;
    @UiField
    TextBox max;
    @UiField
    InlineRadio radio1;
    @UiField
    InlineRadio radio2;
    @UiField
    FormGroup groupRouter;
    @UiField
    FormGroup groupBegin;
    @UiField
    FormGroup groupEnd;
    @UiField
    FormGroup groupSubnet;
    @UiField
    FormGroup groupDefaultL;
    @UiField
    FormGroup groupMax;
    @UiField
    HelpBlock helpRouter;
    @UiField
    PanelHeader helpTitle;
    @UiField
    ScrollPanel helpText;
    @UiField
    HelpButton routerHelp;
    @UiField
    HelpButton beginHelp;
    @UiField
    HelpButton endHelp;
    @UiField
    HelpButton subnetHelp;
    @UiField
    HelpButton defaultLHelp;
    @UiField
    HelpButton maxHelp;
    @UiField
    HelpButton passHelp;

    public TabDhcpNatUi(GwtSession currentSession, TabTcpIpUi tcp, TabWirelessUi wireless) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.tcpTab = tcp;
        this.wirelessTab = wireless;
        this.session = currentSession;
        this.setDirty(false);
        this.initForm();
        this.initHelpButtons();
        this.tcpTab.status.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabDhcpNatUi.this.update();
            }
        });
        this.wirelessTab.wireless.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabDhcpNatUi.this.update();
            }
        });
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isValid() {
        return !this.groupRouter.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupBegin.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupEnd.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupSubnet.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupDefaultL.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupMax.getValidationState().equals((Object)ValidationState.ERROR);
    }

    @Override
    public void setNetInterface(GwtNetInterfaceConfig config) {
        this.setDirty(true);
        this.selectedNetIfConfig = config;
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resetValidations();
            if (this.selectedNetIfConfig == null) {
                this.reset();
            } else {
                this.update();
            }
        }
    }

    @Override
    public void getUpdatedNetInterface(GwtNetInterfaceConfig updatedNetIf) {
        if (this.session != null) {
            GwtNetRouterMode[] gwtNetRouterModeArray = GwtNetRouterMode.values();
            int n = gwtNetRouterModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GwtNetRouterMode mode = gwtNetRouterModeArray[n2];
                if (MessageUtils.get(mode.name()).equals(this.router.getSelectedItemText())) {
                    updatedNetIf.setRouterMode(mode.name());
                }
                ++n2;
            }
            updatedNetIf.setRouterDhcpBeginAddress(this.begin.getText());
            updatedNetIf.setRouterDhcpEndAddress(this.end.getText());
            updatedNetIf.setRouterDhcpSubnetMask(this.subnet.getText());
            if (this.defaultL.getText() != null && !"".equals(this.defaultL.getText().trim())) {
                updatedNetIf.setRouterDhcpDefaultLease(Integer.parseInt(this.defaultL.getText()));
            }
            if (this.max.getText() != null && !"".equals(this.max.getText().trim())) {
                updatedNetIf.setRouterDhcpMaxLease(Integer.parseInt(this.max.getText()));
            }
            updatedNetIf.setRouterDnsPass(this.radio1.getValue());
        }
    }

    private void update() {
        if (this.selectedNetIfConfig != null) {
            int i = 0;
            while (i < this.router.getItemCount()) {
                if (this.router.getItemText(i).equals(MessageUtils.get(this.selectedNetIfConfig.getRouterMode()))) {
                    this.router.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            this.begin.setText(this.selectedNetIfConfig.getRouterDhcpBeginAddress());
            this.end.setText(this.selectedNetIfConfig.getRouterDhcpEndAddress());
            this.subnet.setText(this.selectedNetIfConfig.getRouterDhcpSubnetMask());
            this.defaultL.setText(String.valueOf(this.selectedNetIfConfig.getRouterDhcpDefaultLease()));
            this.max.setText(String.valueOf(this.selectedNetIfConfig.getRouterDhcpMaxLease()));
            this.radio1.setValue(Boolean.valueOf(this.selectedNetIfConfig.getRouterDnsPass()));
            this.radio2.setValue(Boolean.valueOf(!this.selectedNetIfConfig.getRouterDnsPass()));
        }
        this.refreshForm();
    }

    private void refreshForm() {
        GwtWifiConfig wifiConfig = this.wirelessTab.activeConfig;
        String wifiMode = null;
        if (wifiConfig != null) {
            wifiMode = wifiConfig.getWirelessMode();
        }
        if (this.selectedNetIfConfig.getHwTypeEnum() == GwtNetIfType.WIFI && wifiMode != null && (wifiMode.equals(WIFI_STATION_MODE) || wifiMode.equals(WIFI_DISABLED))) {
            this.router.setEnabled(false);
            this.begin.setEnabled(false);
            this.end.setEnabled(false);
            this.subnet.setEnabled(false);
            this.defaultL.setEnabled(false);
            this.max.setEnabled(false);
            this.radio1.setEnabled(false);
            this.radio2.setEnabled(false);
        } else {
            this.router.setEnabled(true);
            this.begin.setEnabled(true);
            this.end.setEnabled(true);
            this.subnet.setEnabled(true);
            this.defaultL.setEnabled(true);
            this.max.setEnabled(true);
            this.radio1.setEnabled(true);
            this.radio2.setEnabled(true);
            String modeValue = this.router.getSelectedItemText();
            if (modeValue.equals(ROUTER_NAT_MESSAGE) || modeValue.equals(ROUTER_OFF_MESSAGE)) {
                this.router.setEnabled(true);
                this.begin.setEnabled(false);
                this.end.setEnabled(false);
                this.subnet.setEnabled(false);
                this.defaultL.setEnabled(false);
                this.max.setEnabled(false);
                this.radio1.setEnabled(false);
                this.radio2.setEnabled(false);
            } else {
                this.router.setEnabled(true);
                this.begin.setEnabled(true);
                this.end.setEnabled(true);
                this.subnet.setEnabled(true);
                this.defaultL.setEnabled(true);
                this.max.setEnabled(true);
                this.radio1.setEnabled(true);
                this.radio2.setEnabled(true);
            }
        }
    }

    private void reset() {
        this.router.setSelectedIndex(0);
        this.begin.setText("");
        this.end.setText("");
        this.subnet.setText("");
        this.defaultL.setText("");
        this.max.setText("");
        this.radio1.setValue(Boolean.valueOf(true));
        this.radio2.setValue(Boolean.valueOf(false));
        this.update();
    }

    private void resetValidations() {
        this.groupRouter.setValidationState(ValidationState.NONE);
        this.groupBegin.setValidationState(ValidationState.NONE);
        this.groupEnd.setValidationState(ValidationState.NONE);
        this.groupSubnet.setValidationState(ValidationState.NONE);
        this.groupDefaultL.setValidationState(ValidationState.NONE);
        this.groupMax.setValidationState(ValidationState.NONE);
        this.helpRouter.setText("");
    }

    private void initHelpButtons() {
        this.routerHelp.setHelpText(MSGS.netRouterToolTipMode());
        this.beginHelp.setHelpText(MSGS.netRouterToolTipDhcpBeginAddr());
        this.endHelp.setHelpText(MSGS.netRouterToolTipDhcpEndAddr());
        this.subnetHelp.setHelpText(MSGS.netRouterToolTipDhcpSubnet());
        this.defaultLHelp.setHelpText(MSGS.netRouterToolTipDhcpDefaultLeaseTime());
        this.maxHelp.setHelpText(MSGS.netRouterToolTipDhcpMaxLeaseTime());
        this.passHelp.setHelpText(MSGS.netRouterToolTipPassDns());
    }

    private void initForm() {
        this.labelRouter.setText(MSGS.netRouterMode());
        int i = 0;
        GwtNetRouterMode[] gwtNetRouterModeArray = GwtNetRouterMode.values();
        int n = gwtNetRouterModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GwtNetRouterMode mode = gwtNetRouterModeArray[n2];
            this.router.addItem(MessageUtils.get(mode.name()));
            if (this.tcpTab.isDhcp() && mode.equals((Object)GwtNetRouterMode.netRouterOff)) {
                this.router.setSelectedIndex(i);
            }
            ++i;
            ++n2;
        }
        this.router.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipMode()));
                }
            }
        });
        this.router.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.router.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabDhcpNatUi.this.setDirty(true);
                ListBox box = (ListBox)event.getSource();
                if (TabDhcpNatUi.this.tcpTab.isDhcp() && !box.getSelectedItemText().equals(ROUTER_OFF_MESSAGE)) {
                    TabDhcpNatUi.this.groupRouter.setValidationState(ValidationState.ERROR);
                    TabDhcpNatUi.this.helpRouter.setText(MSGS.netRouterConfiguredForDhcpError());
                    TabDhcpNatUi.this.helpRouter.setColor("red");
                } else {
                    TabDhcpNatUi.this.groupRouter.setValidationState(ValidationState.NONE);
                    TabDhcpNatUi.this.helpRouter.setText("");
                }
                TabDhcpNatUi.this.refreshForm();
            }
        });
        this.labelBegin.setText(MSGS.netRouterDhcpBeginningAddress());
        this.begin.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipDhcpBeginAddr()));
                }
            }
        });
        this.begin.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.begin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TabDhcpNatUi.this.setDirty(true);
                if (!TabDhcpNatUi.this.begin.getText().matches(TabDhcpNatUi.REGEX_IPV4)) {
                    TabDhcpNatUi.this.groupBegin.setValidationState(ValidationState.ERROR);
                } else {
                    TabDhcpNatUi.this.groupBegin.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelEnd.setText(MSGS.netRouterDhcpEndingAddress());
        this.end.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipDhcpEndAddr()));
                }
            }
        });
        this.end.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.end.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TabDhcpNatUi.this.setDirty(true);
                if (!TabDhcpNatUi.this.end.getText().matches(TabDhcpNatUi.REGEX_IPV4)) {
                    TabDhcpNatUi.this.groupEnd.setValidationState(ValidationState.ERROR);
                } else {
                    TabDhcpNatUi.this.groupEnd.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelSubnet.setText(MSGS.netRouterDhcpSubnetMask());
        this.subnet.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipDhcpSubnet()));
                }
            }
        });
        this.subnet.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.subnet.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TabDhcpNatUi.this.setDirty(true);
                if (!TabDhcpNatUi.this.subnet.getText().matches(TabDhcpNatUi.REGEX_IPV4)) {
                    TabDhcpNatUi.this.groupSubnet.setValidationState(ValidationState.ERROR);
                } else {
                    TabDhcpNatUi.this.groupSubnet.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelDefaultL.setText(MSGS.netRouterDhcpDefaultLease());
        this.defaultL.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipDhcpDefaultLeaseTime()));
                }
            }
        });
        this.defaultL.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.defaultL.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TabDhcpNatUi.this.setDirty(true);
                if (!TabDhcpNatUi.this.defaultL.getText().trim().matches(TextFieldValidator.FieldType.NUMERIC.getRegex())) {
                    TabDhcpNatUi.this.groupDefaultL.setValidationState(ValidationState.ERROR);
                } else {
                    TabDhcpNatUi.this.groupDefaultL.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelMax.setText(MSGS.netRouterDhcpMaxLease());
        this.max.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipDhcpMaxLeaseTime()));
                }
            }
        });
        this.max.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.max.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TabDhcpNatUi.this.setDirty(true);
                if (!TabDhcpNatUi.this.max.getText().trim().matches(TextFieldValidator.FieldType.NUMERIC.getRegex())) {
                    TabDhcpNatUi.this.groupMax.setValidationState(ValidationState.ERROR);
                } else {
                    TabDhcpNatUi.this.groupMax.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelPass.setText(MSGS.netRouterPassDns());
        this.radio1.setText(MSGS.trueLabel());
        this.radio2.setText(MSGS.falseLabel());
        this.radio1.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipPassDns()));
                }
            }
        });
        this.radio1.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.radio2.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabDhcpNatUi.this.router.isEnabled()) {
                    TabDhcpNatUi.this.helpText.clear();
                    TabDhcpNatUi.this.helpText.add((Widget)new Span(MSGS.netRouterToolTipPassDns()));
                }
            }
        });
        this.radio2.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabDhcpNatUi.this.resetHelp();
            }
        });
        this.radio1.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                TabDhcpNatUi.this.setDirty(true);
            }
        });
        this.radio2.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                TabDhcpNatUi.this.setDirty(true);
            }
        });
        this.helpTitle.setText(MSGS.netHelpTitle());
    }

    private void resetHelp() {
        this.helpText.clear();
        this.helpText.add((Widget)new Span(MSGS.netHelpDefaultHint()));
    }

    static interface TabDhcpNatUiUiBinder
    extends UiBinder<Widget, TabDhcpNatUi> {
    }
}

