/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.cloud.CloudConnectionEstablishedEvent;
import org.eclipse.kura.cloud.CloudConnectionLostEvent;
import org.eclipse.kura.cloud.CloudPayloadEncoding;
import org.eclipse.kura.cloud.CloudPayloadProtoBufDecoder;
import org.eclipse.kura.cloud.CloudPayloadProtoBufEncoder;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.cloudconnection.subscriber.listener.CloudSubscriberListener;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.data.DataServiceImpl;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.listener.DataServiceListener;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudConnectionManagerOptions;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadEncoder;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadGZipEncoder;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadJsonDecoder;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadJsonEncoder;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadProtoBufDecoderImpl;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadProtoBufEncoderImpl;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPublisherDeliveryListener;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.ControlTopic;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.LifeCyclePayloadBuilder;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.MessageHandlerCallable;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.MessageConstants;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.MessageType;
import org.eclipse.kura.message.KuraApplicationTopic;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.net.modem.ModemReadyEvent;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConnectionManagerImpl
implements DataServiceListener,
ConfigurableComponent,
EventHandler,
CloudPayloadProtoBufEncoder,
CloudPayloadProtoBufDecoder,
RequestHandlerRegistry,
CloudConnectionManager,
CloudEndpoint {
    private static final String ERROR = "ERROR";
    private static final Logger logger = LoggerFactory.getLogger(CloudConnectionManagerImpl.class);
    private static final String CONNECTION_EVENT_PID_PROPERTY_KEY = "cloud.service.pid";
    private static final int NUM_CONCURRENT_CALLBACKS = 2;
    private static ExecutorService callbackExecutor = Executors.newFixedThreadPool(2);
    private ComponentContext ctx;
    private CloudConnectionManagerOptions options;
    private DataService dataService;
    private SystemService systemService;
    private SystemAdminService systemAdminService;
    private NetworkService networkService;
    private PositionService positionService;
    private EventAdmin eventAdmin;
    private CertificatesService certificatesService;
    String imei;
    String iccid;
    String imsi;
    String rssi;
    private boolean birthPublished;
    private final AtomicInteger messageId = new AtomicInteger();
    private ServiceRegistration<?> cloudServiceRegistration;
    private final Map<String, RequestHandler> registeredRequestHandlers;
    private final Set<CloudConnectionListener> registeredCloudConnectionListeners = new CopyOnWriteArraySet<CloudConnectionListener>();
    private final Set<CloudPublisherDeliveryListener> registeredCloudPublisherDeliveryListeners;
    private final Set<CloudDeliveryListener> registeredCloudDeliveryListeners;

    public CloudConnectionManagerImpl() {
        this.registeredRequestHandlers = new HashMap<String, RequestHandler>();
        this.registeredCloudPublisherDeliveryListeners = new CopyOnWriteArraySet<CloudPublisherDeliveryListener>();
        this.registeredCloudDeliveryListeners = new CopyOnWriteArraySet<CloudDeliveryListener>();
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void unsetDataService(DataService dataService) {
        this.dataService = null;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public void setSystemAdminService(SystemAdminService systemAdminService) {
        this.systemAdminService = systemAdminService;
    }

    public void unsetSystemAdminService(SystemAdminService systemAdminService) {
        this.systemAdminService = null;
    }

    public SystemAdminService getSystemAdminService() {
        return this.systemAdminService;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    public SystemService getSystemService() {
        return this.systemService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.networkService = null;
    }

    public NetworkService getNetworkService() {
        return this.networkService;
    }

    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    public void unsetPositionService(PositionService positionService) {
        this.positionService = null;
    }

    public PositionService getPositionService() {
        return this.positionService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("activate {}...", properties.get("kura.service.pid"));
        this.ctx = componentContext;
        this.options = new CloudConnectionManagerOptions(properties, this.systemService);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        String[] eventTopics = new String[]{"org/eclipse/kura/position/locked", "org/eclipse/kura/net/modem/READY"};
        ((Dictionary)props).put("event.topics", eventTopics);
        this.cloudServiceRegistration = this.ctx.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, props);
        this.dataService.addDataServiceListener((DataServiceListener)this);
        if (this.isConnected()) {
            logger.warn("DataService is already connected. Publish BIRTH certificate");
            try {
                this.setupCloudConnection();
            }
            catch (KuraException e) {
                logger.warn("Cannot setup cloud service connection", (Throwable)e);
            }
        }
    }

    public void updated(Map<String, Object> properties) {
        logger.info("updated {}...: {}", properties.get("kura.service.pid"), properties);
        this.options = new CloudConnectionManagerOptions(properties, this.systemService);
        if (this.isConnected()) {
            try {
                this.setupCloudConnection();
            }
            catch (KuraException kuraException) {
                logger.warn("Cannot setup cloud service connection");
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("deactivate {}...", componentContext.getProperties().get("kura.service.pid"));
        if (this.isConnected()) {
            try {
                this.publishDisconnectCertificate();
            }
            catch (KuraException kuraException) {
                logger.warn("Cannot publish disconnect certificate");
            }
        }
        this.dataService.removeDataServiceListener((DataServiceListener)this);
        this.dataService = null;
        this.systemService = null;
        this.systemAdminService = null;
        this.networkService = null;
        this.positionService = null;
        this.eventAdmin = null;
        this.cloudServiceRegistration.unregister();
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/kura/position/locked".contains(event.getTopic())) {
            logger.info("Handling PositionLockedEvent");
            if (this.dataService.isConnected() && this.options.getRepubBirthCertOnGpsLock()) {
                try {
                    this.publishBirthCertificate();
                }
                catch (KuraException e) {
                    logger.warn("Cannot publish birth certificate", (Throwable)e);
                }
            }
        } else if ("org/eclipse/kura/net/modem/READY".contains(event.getTopic())) {
            logger.info("Handling ModemReadyEvent");
            ModemReadyEvent modemReadyEvent = (ModemReadyEvent)event;
            this.imei = (String)modemReadyEvent.getProperty("IMEI");
            this.imsi = (String)modemReadyEvent.getProperty("IMSI");
            this.iccid = (String)modemReadyEvent.getProperty("ICCID");
            this.rssi = (String)modemReadyEvent.getProperty("RSSI");
            logger.trace("handleEvent() :: IMEI={}", (Object)this.imei);
            logger.trace("handleEvent() :: IMSI={}", (Object)this.imsi);
            logger.trace("handleEvent() :: ICCID={}", (Object)this.iccid);
            logger.trace("handleEvent() :: RSSI={}", (Object)this.rssi);
            if (this.dataService.isConnected() && this.options.getRepubBirthCertOnModemDetection() && (this.imei != null && this.imei.length() != 0 && !ERROR.equals(this.imei) || this.imsi != null && this.imsi.length() != 0 && !ERROR.equals(this.imsi) || this.iccid != null && this.iccid.length() != 0 && !ERROR.equals(this.iccid))) {
                logger.debug("handleEvent() :: publishing BIRTH certificate ...");
                try {
                    this.publishBirthCertificate();
                }
                catch (KuraException e) {
                    logger.warn("Cannot publish birth certificate", (Throwable)e);
                }
            }
        }
    }

    public boolean isConnected() {
        return this.dataService != null && this.dataService.isConnected();
    }

    public CloudConnectionManagerOptions getCloudConnectionManagerOptions() {
        return this.options;
    }

    public byte[] encodePayload(KuraPayload payload) throws KuraException {
        byte[] bytes;
        CloudPayloadEncoding preferencesEncoding = this.options.getPayloadEncoding();
        if (preferencesEncoding == CloudPayloadEncoding.KURA_PROTOBUF) {
            bytes = this.encodeProtobufPayload(payload);
        } else if (preferencesEncoding == CloudPayloadEncoding.SIMPLE_JSON) {
            bytes = this.encodeJsonPayload(payload);
        } else {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR);
        }
        return bytes;
    }

    public void onConnectionEstablished() {
        try {
            this.setupCloudConnection();
        }
        catch (KuraException kuraException) {
            logger.warn("Cannot setup cloud service connection");
        }
        this.postConnectionStateChangeEvent(true);
        this.registeredCloudConnectionListeners.forEach(CloudConnectionListener::onConnectionEstablished);
    }

    public void onDisconnecting() {
        try {
            this.publishDisconnectCertificate();
        }
        catch (KuraException kuraException) {
            logger.warn("Cannot publish disconnect certificate");
        }
        this.birthPublished = false;
    }

    public void onDisconnected() {
        this.postConnectionStateChangeEvent(false);
        this.registeredCloudConnectionListeners.forEach(CloudConnectionListener::onDisconnected);
    }

    public void onConnectionLost(Throwable cause) {
        this.postConnectionStateChangeEvent(false);
        this.registeredCloudConnectionListeners.forEach(CloudConnectionListener::onConnectionLost);
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        logger.info("Message arrived on topic: {}", (Object)topic);
        ControlTopic kuraTopic = new ControlTopic(topic, MessageType.CONTROL.getTopicPrefix());
        KuraPayload kuraPayload = null;
        if (this.options.getPayloadEncoding() == CloudPayloadEncoding.SIMPLE_JSON) {
            kuraPayload = this.createKuraPayloadFromJson(payload);
        } else if (this.options.getPayloadEncoding() == CloudPayloadEncoding.KURA_PROTOBUF) {
            kuraPayload = this.createKuraPayloadFromProtoBuf(topic, payload);
        }
        try {
            boolean validMessage = this.isValidMessage(kuraTopic, kuraPayload);
            if (validMessage) {
                this.dispatchControlMessage(kuraTopic, kuraPayload);
            } else {
                logger.warn("Message verification failed! Not valid signature or message not signed.");
            }
        }
        catch (Exception e) {
            logger.error("Error during CloudClientListener notification.", (Throwable)e);
        }
    }

    private void dispatchControlMessage(ControlTopic kuraTopic, KuraPayload kuraPayload) {
        String applicationId = kuraTopic.getApplicationId();
        kuraPayload.addMetric("request.id", (Object)kuraTopic.getReqId());
        RequestHandler cloudlet = this.registeredRequestHandlers.get(applicationId);
        if (cloudlet != null) {
            callbackExecutor.submit(new MessageHandlerCallable(cloudlet, kuraTopic.getApplicationTopic(), kuraPayload, this));
        }
    }

    private boolean isValidMessage(KuraApplicationTopic kuraAppTopic, KuraPayload kuraPayload) {
        ServiceReference sr;
        if (this.certificatesService == null && (sr = this.ctx.getBundleContext().getServiceReference(CertificatesService.class)) != null) {
            this.certificatesService = (CertificatesService)this.ctx.getBundleContext().getService(sr);
        }
        boolean validMessage = false;
        if (this.certificatesService == null || this.certificatesService.verifySignature(kuraAppTopic, kuraPayload)) {
            validMessage = true;
        }
        return validMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessagePublished(int messageId, String topic) {
        AtomicInteger atomicInteger = this.messageId;
        synchronized (atomicInteger) {
            if (this.messageId.get() != -1 && this.messageId.get() == messageId) {
                if (this.options.getLifeCycleMessageQos() == 0) {
                    this.messageId.set(-1);
                }
                this.messageId.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageConfirmed(int messageId, String topic) {
        AtomicInteger atomicInteger = this.messageId;
        synchronized (atomicInteger) {
            if (this.messageId.get() != -1 && this.messageId.get() == messageId) {
                this.messageId.set(-1);
                this.messageId.notifyAll();
            }
        }
        this.registeredCloudPublisherDeliveryListeners.forEach(deliveryListener -> deliveryListener.onMessageConfirmed(String.valueOf(messageId), topic));
        this.registeredCloudDeliveryListeners.forEach(deliveryListener -> deliveryListener.onMessageConfirmed(String.valueOf(messageId)));
    }

    public byte[] getBytes(KuraPayload kuraPayload, boolean gzipped) throws KuraException {
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(kuraPayload);
        if (gzipped) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            byte[] bytes = encoder.getBytes();
            return bytes;
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public KuraPayload buildFromByteArray(byte[] payload) throws KuraException {
        CloudPayloadProtoBufDecoderImpl encoder = new CloudPayloadProtoBufDecoderImpl(payload);
        try {
            KuraPayload kuraPayload = encoder.buildFromByteArray();
            return kuraPayload;
        }
        catch (IOException | KuraInvalidMessageException e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, e, new Object[0]);
        }
    }

    private void setupCloudConnection() throws KuraException {
        boolean publishBirth = true;
        if (this.birthPublished && !this.options.getRepubBirthCertOnReconnect()) {
            publishBirth = false;
            logger.info("Birth certificate republish is disabled in configuration");
        }
        if (publishBirth) {
            this.publishBirthCertificate();
            this.birthPublished = true;
        }
        this.setupDeviceSubscriptions();
    }

    private void setupDeviceSubscriptions() throws KuraException {
        StringBuilder sbDeviceSubscription = new StringBuilder();
        sbDeviceSubscription.append(MessageType.CONTROL.getTopicPrefix()).append(this.options.getTopicSeparator()).append("+").append(this.options.getTopicSeparator()).append("+").append(this.options.getTopicSeparator()).append("req").append(this.options.getTopicSeparator()).append(this.options.getTopicWildCard());
        this.dataService.subscribe(sbDeviceSubscription.toString(), 0);
    }

    private void publishBirthCertificate() throws KuraException {
        if (this.options.isLifecycleCertsDisabled()) {
            return;
        }
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(MessageType.EVENT.getTopicPrefix()).append(this.options.getTopicSeparator()).append(this.options.getTopicSeparator()).append(this.options.getTopicSeparator()).append(this.options.getTopicBirthSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishDisconnectCertificate() throws KuraException {
        if (this.options.isLifecycleCertsDisabled()) {
            return;
        }
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(MessageType.EVENT.getTopicPrefix()).append(this.options.getTopicSeparator()).append(this.options.getTopicSeparator()).append(this.options.getTopicSeparator()).append(this.options.getTopicDisconnectSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createDisconnectPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private KuraPayload createBirthPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildBirthPayload();
    }

    private KuraPayload createDisconnectPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildDisconnectPayload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishLifeCycleMessage(String topic, KuraPayload payload) throws KuraException {
        AtomicInteger atomicInteger = this.messageId;
        synchronized (atomicInteger) {
            this.messageId.set(-1);
            byte[] encodedPayload = this.encodePayload(payload);
            int localMessageId = this.dataService.publish(topic, encodedPayload, this.options.getLifeCycleMessageQos(), this.options.getLifeCycleMessageRetain(), this.options.getLifeCycleMessagePriority());
            this.messageId.set(localMessageId);
            try {
                this.messageId.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.info("Interrupted while waiting for the message to be published", (Throwable)e);
            }
        }
    }

    private byte[] encodeProtobufPayload(KuraPayload payload) throws KuraException {
        byte[] bytes = new byte[]{};
        if (payload == null) {
            return bytes;
        }
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(payload);
        if (this.options.getEncodeGzip()) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            bytes = encoder.getBytes();
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
        return bytes;
    }

    private byte[] encodeJsonPayload(KuraPayload payload) {
        return CloudPayloadJsonEncoder.getBytes(payload);
    }

    private KuraPayload createKuraPayloadFromJson(byte[] payload) {
        return CloudPayloadJsonDecoder.buildFromByteArray(payload);
    }

    private KuraPayload createKuraPayloadFromProtoBuf(String topic, byte[] payload) {
        KuraPayload kuraPayload;
        try {
            kuraPayload = new CloudPayloadProtoBufDecoderImpl(payload).buildFromByteArray();
        }
        catch (Exception exception) {
            logger.debug("Received message on topic {} that could not be decoded. Wrapping it into an KuraPayload.", (Object)topic);
            kuraPayload = new KuraPayload();
            kuraPayload.setBody(payload);
        }
        return kuraPayload;
    }

    private void postConnectionStateChangeEvent(boolean isConnected) {
        Map<String, String> eventProperties = Collections.singletonMap(CONNECTION_EVENT_PID_PROPERTY_KEY, (String)this.ctx.getProperties().get("kura.service.pid"));
        CloudConnectionEstablishedEvent event = isConnected ? new CloudConnectionEstablishedEvent(eventProperties) : new CloudConnectionLostEvent(eventProperties);
        this.eventAdmin.postEvent((Event)event);
    }

    public void connect() throws KuraConnectException {
        if (this.dataService != null) {
            this.dataService.connect();
        }
    }

    public void disconnect() {
        if (this.dataService != null) {
            this.dataService.disconnect(10L);
        }
    }

    public Map<String, String> getInfo() {
        DataServiceImpl dataServiceImpl = (DataServiceImpl)this.dataService;
        return dataServiceImpl.getConnectionInfo();
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.registeredCloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.registeredCloudConnectionListeners.remove(cloudConnectionListener);
    }

    public void registerCloudPublisherDeliveryListener(CloudPublisherDeliveryListener cloudPublisherDeliveryListener) {
        this.registeredCloudPublisherDeliveryListeners.add(cloudPublisherDeliveryListener);
    }

    public void unregisterCloudPublisherDeliveryListener(CloudPublisherDeliveryListener cloudPublisherDeliveryListener) {
        this.registeredCloudPublisherDeliveryListeners.remove(cloudPublisherDeliveryListener);
    }

    public String publish(KuraMessage message) throws KuraException {
        Map messageProps = message.getProperties();
        String fullTopic = (String)messageProps.get(MessageConstants.FULL_TOPIC.name());
        int qos = (Integer)messageProps.get(MessageConstants.QOS.name());
        boolean retain = (Boolean)messageProps.get(MessageConstants.RETAIN.name());
        int priority = (Integer)messageProps.get(MessageConstants.PRIORITY.name());
        byte[] appPayload = this.encodePayload(message.getPayload());
        int id = this.dataService.publish(fullTopic, appPayload, qos, retain, priority);
        if (qos == 0) {
            return null;
        }
        return String.valueOf(id);
    }

    public void registerSubscriber(Map<String, Object> subscriptionProperties, CloudSubscriberListener subscriber) {
        throw new UnsupportedOperationException();
    }

    public void unregisterSubscriber(CloudSubscriberListener subscriberListener) {
        throw new UnsupportedOperationException();
    }

    public void registerRequestHandler(String id, RequestHandler requestHandler) throws KuraException {
        this.registeredRequestHandlers.put(id, requestHandler);
    }

    public void unregister(String id) throws KuraException {
        this.registeredRequestHandlers.remove(id);
    }

    public String getNotificationPublisherPid() {
        throw new UnsupportedOperationException();
    }

    public CloudNotificationPublisher getNotificationPublisher() {
        throw new UnsupportedOperationException();
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.registeredCloudDeliveryListeners.add(cloudDeliveryListener);
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.registeredCloudDeliveryListeners.remove(cloudDeliveryListener);
    }
}

