/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "armenskt";
        final String metaValue_bn = "bangla";
        final String metaValue_chr = "cherokee";
        final String metaValue_el = "grikskt";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraiskt";
        final String metaValue_jv = "javanskt";
        final String metaValue_ja = "japanskt";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreanskt";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "odia";
        final String metaValue_syr = "syriac";
        final String metaValue_ta = "tamilskt";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "tailendskt";
        final String metaValue_bo = "tibetskt";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "heimur" },
            { "002", "Afrika" },
            { "003", "Norðuramerika" },
            { "005", "Suðuramerika" },
            { "009", "Osiania" },
            { "011", "Vesturafrika" },
            { "013", "Miðamerika" },
            { "014", "Eysturafrika" },
            { "015", "Norðurafrika" },
            { "017", "Miðafrika" },
            { "018", "sunnari partur av Afrika" },
            { "019", "Amerika" },
            { "021", "Amerika norðanfyri Meksiko" },
            { "029", "Karibia" },
            { "030", "Eysturasia" },
            { "034", "Suðurasia" },
            { "035", "Útsynningsasia" },
            { "039", "Suðurevropa" },
            { "053", "Avstralasia" },
            { "054", "Melanesia" },
            { "057", "Mikronesi øki" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Miðasia" },
            { "145", "Vesturasia" },
            { "150", "Evropa" },
            { "151", "Eysturevropa" },
            { "154", "Norðurevropa" },
            { "155", "Vesturevropa" },
            { "202", "Afrika sunnanfyri Sahara" },
            { "419", "Latínamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Sameindu Emirríkini" },
            { "AF", "Afganistan" },
            { "AG", "Antigua & Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "Eysturríki" },
            { "AU", "Avstralia" },
            { "AW", "Aruba" },
            { "AX", "Áland" },
            { "AZ", "Aserbadjan" },
            { "BA", "Bosnia-Hersegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesj" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Niðurlonds Karibia" },
            { "BR", "Brasil" },
            { "BS", "Bahamaoyggjar" },
            { "BT", "Butan" },
            { "BV", "Bouvetoyggj" },
            { "BW", "Botsvana" },
            { "BY", "Hvítarussland" },
            { "BZ", "Belis" },
            { "CA", "Kanada" },
            { "CC", "Kokosoyggjar" },
            { "CD", "Kongo, Dem. Lýðveldið" },
            { "CF", "Miðafrikalýðveldið" },
            { "CG", "Kongo" },
            { "CH", "Sveis" },
            { "CI", "Fílabeinsstrondin" },
            { "CK", "Cooksoyggjar" },
            { "CL", "Kili" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolombia" },
            { "CP", "Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Grønhøvdaoyggjar" },
            { "CW", "Curaçao" },
            { "CX", "Jólaoyggjin" },
            { "CY", "Kýpros" },
            { "CZ", "Kekkia" },
            { "DE", "Týskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Danmark" },
            { "DM", "Dominika" },
            { "DO", "Dominikalýðveldið" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Estland" },
            { "EG", "Egyptaland" },
            { "EH", "Vestursahara" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Evropasamveldið" },
            { "EZ", "Evrasona" },
            { "FI", "Finnland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandsoyggjar" },
            { "FM", "Mikronesiasamveldið" },
            { "FO", "Føroyar" },
            { "FR", "Frakland" },
            { "GA", "Gabon" },
            { "GB", "Stórabretland" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Franska Gujana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grønland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorguinea" },
            { "GR", "Grikkaland" },
            { "GS", "Suðurgeorgia og Suðursandwichoyggjar" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Gujana" },
            { "HK", "Hong Kong SAR Kina" },
            { "HM", "Heard og McDonaldoyggjar" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanariuoyggjar" },
            { "ID", "Indonesia" },
            { "IE", "Írland" },
            { "IL", "Ísrael" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Stóra Bretlands Indiahavoyggjar" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Ísland" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenja" },
            { "KG", "Kirgisia" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komoroyggjar" },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "Norðurkorea" },
            { "KR", "Suðurkorea" },
            { "KW", "Kuvait" },
            { "KY", "Caymanoyggjar" },
            { "KZ", "Kasakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lusia" },
            { "LI", "Liktinstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Litava" },
            { "LU", "Luksemborg" },
            { "LV", "Lettland" },
            { "LY", "Libya" },
            { "MA", "Marokko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalloyggjar" },
            { "MK", "Norður Makedónia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Makao SAR Kina" },
            { "MP", "Norðaru Mariuoyggjar" },
            { "MQ", "Martinique" },
            { "MR", "Móritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Móritius" },
            { "MV", "Maldivoyggjar" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Nýkaledónia" },
            { "NE", "Niger" },
            { "NF", "Norfolksoyggj" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Niðurlond" },
            { "NO", "Noreg" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nýsæland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesia" },
            { "PG", "Papua Nýguinea" },
            { "PH", "Filipsoyggjar" },
            { "PK", "Pakistan" },
            { "PL", "Pólland" },
            { "PM", "Saint Pierre & Miquelon" },
            { "PN", "Pitcairnoyggjar" },
            { "PR", "Puerto Riko" },
            { "PS", "Palestinskt landøki" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "fjarskoti Osiania" },
            { "RE", "Réunion" },
            { "RO", "Rumenia" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudiarabia" },
            { "SB", "Salomonoyggjar" },
            { "SC", "Seyskelloyggjar" },
            { "SD", "Sudan" },
            { "SE", "Svøríki" },
            { "SG", "Singapor" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Suðursudan" },
            { "ST", "Sao Tome & Prinsipi" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Sýria" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- og Caicosoyggjar" },
            { "TD", "Kjad" },
            { "TF", "Fronsku sunnaru landaøki" },
            { "TG", "Togo" },
            { "TH", "Tailand" },
            { "TJ", "Tadsjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Eysturtimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesia" },
            { "TO", "Tonga" },
            { "TR", "Turkaland" },
            { "TT", "Trinidad & Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taivan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Sambandsríki Amerikas fjarskotnu oyggjar" },
            { "UN", "Sameindu Tjóðir" },
            { "US", "Sambandsríki Amerika" },
            { "UY", "Uruguai" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanbýur" },
            { "VC", "St. Vinsent & Grenadinoyggjar" },
            { "VE", "Venesuela" },
            { "VG", "Stóra Bretlands Jomfrúoyggjar" },
            { "VI", "Sambandsríki Amerikas Jomfrúoyggjar" },
            { "VN", "Vjetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis- og Futunaoyggjar" },
            { "WS", "Samoa" },
            { "XA", "óekta tónalag" },
            { "XB", "óektaður BIDI tekstur" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Suðurafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabvi" },
            { "ZZ", "ókent øki" },
            { "aa", "afar" },
            { "ab", "abkhasiskt" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhariskt" },
            { "an", "aragoniskt" },
            { "ar", "arabiskt" },
            { "as", "assamesiskt" },
            { "av", "avariskt" },
            { "ay", "aymara" },
            { "az", "aserbajdsjanskt" },
            { "ba", "bashkir" },
            { "be", "hvitarussiskt" },
            { "bg", "bulgarskt" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonskt" },
            { "bs", "bosniskt" },
            { "ca", "katalani" },
            { "ce", "tjetjenskt" },
            { "ch", "chamorro" },
            { "co", "korsikanskt" },
            { "cs", "kekkiskt" },
            { "cu", "kirkju sláviskt" },
            { "cv", "chuvash" },
            { "cy", "walisiskt" },
            { "da", "danskt" },
            { "de", "týskt" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "enskt" },
            { "eo", "esperanto" },
            { "es", "spanskt" },
            { "et", "estiskt" },
            { "eu", "baskiskt" },
            { "fa", "persiskt" },
            { "ff", "fulah" },
            { "fi", "finskt" },
            { "fj", "fijimál" },
            { "fo", "føroyskt" },
            { "fr", "franskt" },
            { "fy", "vestur frísiskt" },
            { "ga", "írskt" },
            { "gd", "skotskt gæliskt" },
            { "gl", "galisiskt" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "kroatiskt" },
            { "ht", "haitiskt creole" },
            { "hu", "ungarskt" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiskt" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "io", "ido" },
            { "is", "íslendskt" },
            { "it", "italskt" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", "georgiskt" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdiskt" },
            { "kv", "komi" },
            { "kw", "corniskt" },
            { "ky", "kyrgyz" },
            { "la", "latín" },
            { "lb", "luksemborgskt" },
            { "lg", "ganda" },
            { "li", "limburgiskt" },
            { "ln", "lingala" },
            { "lo", "laoskt" },
            { "lt", "litaviskt" },
            { "lu", "luba-katanga" },
            { "lv", "lettiskt" },
            { "mg", "malagassiskt" },
            { "mh", "marshallesiskt" },
            { "mi", "maori" },
            { "mk", "makedónskt" },
            { "ml", metaValue_ml },
            { "mn", "mongolskt" },
            { "mr", "marathi" },
            { "ms", "malaiiskt" },
            { "mt", "maltiskt" },
            { "my", "burmesiskt" },
            { "na", "nauru" },
            { "nb", "norskt bókmál" },
            { "nd", "norður ndebele" },
            { "ne", "nepalskt" },
            { "ng", "ndonga" },
            { "nl", "hálendskt" },
            { "nn", "nýnorskt" },
            { "no", "norskt" },
            { "nr", "suður ndebele" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitanskt" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetiskt" },
            { "pa", "punjabi" },
            { "pl", "pólskt" },
            { "ps", "pashto" },
            { "pt", "portugiskiskt" },
            { "qu", "quechua" },
            { "rm", "retoromanskt" },
            { "rn", "rundi" },
            { "ro", "rumenskt" },
            { "ru", "russiskt" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardiskt" },
            { "sd", "sindhi" },
            { "se", "norður sámiskt" },
            { "sg", "sango" },
            { "sh", "serbokroatiskt" },
            { "si", "singalesiskt" },
            { "sk", "slovakiskt" },
            { "sl", "slovenskt" },
            { "sm", "sámoiskt" },
            { "sn", "shona" },
            { "so", "somaliskt" },
            { "sq", "albanskt" },
            { "sr", "serbiskt" },
            { "ss", "swatiskt" },
            { "st", "sesotho" },
            { "su", "sundanesiskt" },
            { "sv", "svenskt" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tajik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turkmenskt" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganskt" },
            { "tr", "turkiskt" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitiskt" },
            { "ug", "uyghur" },
            { "uk", "ukrainskt" },
            { "ur", "urdu" },
            { "uz", "usbekiskt" },
            { "ve", "venda" },
            { "vi", "vjetnamesiskt" },
            { "vo", "volapykk" },
            { "wa", "walloon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddiskt" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "kinesiskt" },
            { "zu", "sulu" },
            { "ace", "achinese" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleut" },
            { "alt", "suður altai" },
            { "anp", "angika" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "asa", "asu" },
            { "ast", "asturianskt" },
            { "awa", "awadhi" },
            { "ban", "balinesiskt" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bgn", "vestur balochi" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "brx", "bodo" },
            { "bss", "bakossi" },
            { "bug", "buginesiskt" },
            { "byn", "blin" },
            { "ccp", "khakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "miðkurdiskt" },
            { "crs", "seselwa creole franskt" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "sarma" },
            { "doi", "dogri" },
            { "dsb", "lágt sorbian" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipiniskt" },
            { "fon", "fon" },
            { "fur", "friuliskt" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan kinesiskt" },
            { "gez", "geez" },
            { "gil", "kiribatiskt" },
            { "gor", "gorontalo" },
            { "gsw", "týskt (Sveis)" },
            { "guz", "gusii" },
            { "gwi", "gwich’in" },
            { "hak", "hakka kinesiskt" },
            { "haw", "hawaiianskt" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "ovara sorbian" },
            { "hsn", "xiang kinesiskt" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ilo", "iloko" },
            { "inh", "inguish" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "kabardinskt" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "grønhøvdaoyggjarskt" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "karelskt" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kølnskt" },
            { "kum", "kumyk" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lez", "lezghian" },
            { "lij", "liguriskt" },
            { "lkt", "lakota" },
            { "lmo", "lombard" },
            { "loz", "lozi" },
            { "lrc", "norður luri" },
            { "lua", "luba-lulua" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "maduresiskt" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "metaʼ" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manupuri" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "ymisk mál" },
            { "mus", "creek" },
            { "mwl", "mirandesiskt" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nan", "min nan kinesiskt" },
            { "nap", "napolitanskt" },
            { "naq", "nama" },
            { "nds", "lágt týskt" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niuean" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", "nʼko" },
            { "nso", "norður sotho" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauan" },
            { "pcm", "nigeriskt pidgin" },
            { "prg", "prusslanskt" },
            { "quc", "kʼicheʼ" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongiskt" },
            { "rof", "rombo" },
            { "rup", "aromenskt" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sisilanskt" },
            { "sco", "skotskt" },
            { "sdh", "suður kurdiskt" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "sma", "suður sámiskt" },
            { "smj", "lule sámiskt" },
            { "smn", "inari sami" },
            { "sms", "skolt sámiskt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "ssy", metaValue_ssy },
            { "suk", "sukuma" },
            { "swb", "komoriskt" },
            { "syr", metaValue_syr },
            { "szl", "silesiskt" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tlh", "klingonskt" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinian" },
            { "tzm", "miðatlasfjøll tamazight" },
            { "udm", "udmurt" },
            { "umb", "umbundu" },
            { "und", "ókent mál" },
            { "vec", "venetiskt" },
            { "vmw", "makhuwa" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "wbp", "warlpiri" },
            { "wuu", "wu kinesiskt" },
            { "xal", "kalmyk" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonesiskt" },
            { "zgh", "vanligt marokanskt tamazight" },
            { "zun", "zuni" },
            { "zxx", "einki málsligt innihald" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Ahom", "ahom" },
            { "Arab", "arabisk" },
            { "Aran", "nastaliq" },
            { "Armn", metaValue_hy },
            { "Avst", "avestanskt" },
            { "Bali", "baliskt" },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "blindaskrift" },
            { "Bugi", "buginskt" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "sameindir kanadiskir uppruna stavir" },
            { "Cari", "carian" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "chorasmian" },
            { "Copt", "koptiskt" },
            { "Cpmn", "cypro-minoan" },
            { "Cprt", "kýpriskt" },
            { "Cyrl", "kyrilliskt" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogra" },
            { "Dsrt", "deseret" },
            { "Egyp", "egyptiskar hieroglyffur" },
            { "Elba", "elbasan" },
            { "Elym", "elymaic" },
            { "Ethi", "etiopiskt" },
            { "Gara", "garay" },
            { "Geor", "georgianskt" },
            { "Glag", "glagolitic" },
            { "Gong", "gunjala gondi" },
            { "Gonm", "masaram gondi" },
            { "Goth", "gotiskt" },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Gukh", "gurung khema" },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "einkult" },
            { "Hant", "vanligt" },
            { "Hatr", "hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "anatoliskar hieroglyffur" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "japanskir stavir" },
            { "Hung", "gamalt ungarskt" },
            { "Ital", "gamalt italienskt" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", "kawi" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latn", "latínskt" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lisu", "fraser" },
            { "Mand", "mandaean" },
            { "Mend", metaValue_men },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", "mongolsk" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "myanmarskt" },
            { "Newa", "newa" },
            { "Nkoo", "n’ko" },
            { "Nshu", "nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Onao", "ol onal" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", "osage" },
            { "Osma", "osmanya" },
            { "Ougr", "gamalt uyghur" },
            { "Palm", "palmyrene" },
            { "Pauc", "pau cin hau" },
            { "Perm", "gamalt permic" },
            { "Phag", "phags-pa" },
            { "Rohg", "hanifi" },
            { "Runr", "rúnar" },
            { "Saur", "saurashtra" },
            { "Sidd", "siddham" },
            { "Sinh", "sinhala" },
            { "Sogd", "sogdian" },
            { "Sogo", "gamalt sogdian" },
            { "Soyo", "soyombo" },
            { "Sund", "sudanskt" },
            { "Sunu", "sunuwar" },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "nýtt tai lue" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Todr", "todhri" },
            { "Toto", "toto" },
            { "Tutg", "tulu-tigalari" },
            { "Ugar", "ugaritic" },
            { "Vaii", "vai" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Xsux", "sumero-akkadian cuneiform" },
            { "Yezi", "vezidi" },
            { "Yiii", "yi" },
            { "Zinh", "arva skrift" },
            { "Zmth", "støddfrøðilig teknskipan" },
            { "Zsye", "emoji" },
            { "Zsym", "tekin" },
            { "Zxxx", "óskriva" },
            { "Zyyy", "vanlig" },
            { "Zzzz", "ókend skrift" },
            { "de_CH", "høgt týskt (Sveis)" },
            { "fa_AF", "dari" },
            { "nl_BE", "flamskt" },
            { "pt_BR", "portugiskiskt (Brasilia)" },
            { "pt_PT", "portugiskiskt (Evropa)" },
            { "ro_MD", "moldaviskt" },
            { "sw_CD", "kongo svahili" },
            { "ar_001", "nútíðar vanligt arabiskt" },
            { "key.ca", "kalendari" },
            { "key.cf", "gjaldoyra format" },
            { "key.co", "raðskipan" },
            { "key.cu", "gjaldoyra" },
            { "key.hc", "klokkuskipan (12 ímóti 24)" },
            { "key.lb", "reglubrot stílur" },
            { "key.ms", "mátingareind" },
            { "key.nu", "tøl" },
            { "nds_NL", "lágt saksiskt" },
            { "%%BCIAV", "bciav" },
            { "%%BLASL", "blasl" },
            { "%%CORNU", "cornu" },
            { "%%FODOM", "fodom" },
            { "%%GALLO", "gallo" },
            { "%%GHERD", "gherd" },
            { "%%JAUER", "jauer" },
            { "%%NEDIS", "natisone málføri" },
            { "%%PEANO", "peano" },
            { "%%POSIX", "teldumál" },
            { "%%PUTER", "puter" },
            { "%%RUMGR", "rumgr" },
            { "%%SAAHO", metaValue_ssy },
            { "%%TAILO", "tailo" },
            { "zh_Hans", "einkult kinesiskt" },
            { "zh_Hant", "vanligt kinesiskt" },
            { "%%ANPEZO", "anpezo" },
            { "%%ASANTE", "asante" },
            { "%%AUVERN", "auvern" },
            { "%%BCIZBL", "bcizbl" },
            { "%%CISAUP", "cisaup" },
            { "%%CREISS", "creiss" },
            { "%%FASCIA", "fascia" },
            { "%%GASCON", "gascon" },
            { "%%GRITAL", "grital" },
            { "%%NDYUKA", "andyuka málføri" },
            { "%%NICARD", "nicard" },
            { "%%PAMAKA", "pamaka málføri" },
            { "%%PINYIN", "pinyin" },
            { "%%SIMPLE", "simple" },
            { "%%ULSTER", "ulster" },
            { "%%AKUAPEM", "akuapem" },
            { "%%ARKAIKA", "arkaika" },
            { "%%BAUDDHA", "bauddha" },
            { "%%FONNAPA", "fonnapa" },
            { "%%GRCLASS", "grclass" },
            { "%%GRMISTR", "grmstr" },
            { "%%ITIHASA", "itihasa" },
            { "%%LAUKIKA", "laukika" },
            { "%%LEMOSIN", "lemosin" },
            { "%%LTG1929", "ltg1929" },
            { "%%LTG2007", "ltg2007" },
            { "%%MONOTON", "monotonísk" },
            { "%%PAHAWH2", "pahawh2" },
            { "%%PAHAWH3", "pahawh3" },
            { "%%PAHAWH4", "pahawh4" },
            { "%%PEHOEJI", "pehoeji" },
            { "%%POLYTON", "polytonísk" },
            { "%%PROVENC", "provenc" },
            { "%%SURSILV", "sursilv" },
            { "%%SUTSILV", "sutsilv" },
            { "%%VAIDIKA", "vaidika" },
            { "%%BASICENG", "basiceng" },
            { "%%BISCAYAN", "biscayan" },
            { "%%BORNHOLM", "bornholm" },
            { "%%FONKIRSH", "fonkirsh" },
            { "%%FONXSAMP", "fonxsamp" },
            { "%%HOGNORSK", "hognorsk" },
            { "%%HSISTEMO", "hsistemo" },
            { "%%IVANCHOV", "ivanchov" },
            { "%%JYUTPING", "jyutping" },
            { "%%KOCIEWIE", "kociewie" },
            { "%%LENGADOC", "lengadoc" },
            { "%%LUNA1918", "luna1918" },
            { "%%NEWFOUND", "newfound" },
            { "%%PETR1708", "petr1708" },
            { "%%SPANGLIS", "spanglis" },
            { "%%SURMIRAN", "surmiran" },
            { "%%SYNNEJYL", "synnejyl" },
            { "%%TONGYONG", "tongyong" },
            { "%%TUNUMIIT", "tunumiit" },
            { "%%VALBADIA", "valbadia" },
            { "%%VALLADER", "vallader" },
            { "%%VECDRUKA", "vecdruka" },
            { "%%VIVARAUP", "vivaraup" },
            { "%%WADEGILE", "Wade-Giles" },
            { "%%XSISTEMO", "xsistemo" },
            { "type.ca.roc", "minguo kalendari" },
            { "type.co.eor", "röðina fyrir fjöltyngi evrópskum skjölum" },
            { "type.hc.h11", "12 tímar klokkuskipan (0–11)" },
            { "type.hc.h12", "12 tímar klokkuskipan (1–12)" },
            { "type.hc.h23", "24 tímar klokkuskipan (0–23)" },
            { "type.hc.h24", "24 tímar klokkuskipan (1–24)" },
            { "type.nu.ahom", "ahom tøl" },
            { "type.nu.arab", "arabisk tøl" },
            { "type.nu.armn", "armensk tøl" },
            { "type.nu.bali", "balisk tøl" },
            { "type.nu.beng", "bangla tøl" },
            { "type.nu.brah", "brahmi tøl" },
            { "type.nu.cakm", "chakma tøl" },
            { "type.nu.cham", "cham tøl" },
            { "type.nu.cyrl", "kyrilliskt tøl" },
            { "type.nu.deva", "devanagarik tøl" },
            { "type.nu.diak", "dives akuru tøl" },
            { "type.nu.ethi", "etiopisk tøl" },
            { "type.nu.gara", "garay tøl" },
            { "type.nu.geor", "gregoriansk tøl" },
            { "type.nu.gong", "gunjala gondi tøl" },
            { "type.nu.gonm", "masaram gondi tøl" },
            { "type.nu.grek", "grikskt tøl" },
            { "type.nu.gujr", "gujaratik tøl" },
            { "type.nu.guru", "gurmukhik tøl" },
            { "type.nu.hans", "einkul kinesisk tøl" },
            { "type.nu.hant", "vanlig kinesisk tøl" },
            { "type.nu.hebr", "hebraisk tøl" },
            { "type.nu.java", "javanskt tøl" },
            { "type.nu.jpan", "japanskt tøl" },
            { "type.nu.khmr", "khmer tøl" },
            { "type.nu.knda", "kannada tøl" },
            { "type.nu.laoo", "lao tøl" },
            { "type.nu.latn", "vesturlendsk tøl" },
            { "type.nu.mlym", "malayalam tøl" },
            { "type.nu.mtei", "meetei mayek tøl" },
            { "type.nu.mymr", "myanmarsk tøl" },
            { "type.nu.olck", "ol chiki tøl" },
            { "type.nu.orya", "odia tøl" },
            { "type.nu.taml", "vanlig tamilsk tøl" },
            { "type.nu.telu", "telugu tøl" },
            { "type.nu.thai", "tailendsk tøl" },
            { "type.nu.tibt", "tibetsk tøl" },
            { "type.nu.vaii", "vai tøl" },
            { "type.ca.dangi", "dangi kalendari" },
            { "type.co.ducet", "forsett Unicode raðskipan" },
            { "type.co.emoji", "myndtekin raðskipan" },
            { "type.lb.loose", "leysur reglubrot stílur" },
            { "type.nu.roman", "rómartøl" },
            { "type.ca.coptic", "koptiskur kalendari" },
            { "type.ca.hebrew", "hebraiskur kalendari" },
            { "type.co.search", "vanlig leiting" },
            { "type.co.zhuyin", "zhuyin raðskipan" },
            { "type.lb.normal", "vanligur reglubrot stílur" },
            { "type.lb.strict", "strangur reglubrot stílur" },
            { "type.ms.metric", "metralag" },
            { "type.ca.chinese", "kinesiskur kalendari" },
            { "type.ca.islamic", "islamiskur kalendari" },
            { "type.ca.iso8601", "ISO-8601 kalendari" },
            { "type.ca.persian", "persiskur kalendari" },
            { "type.cf.account", "gjaldoyras roknskaparførsla format" },
            { "type.nu.arabext", "víðkað arabisk tøl" },
            { "type.nu.armnlow", "armensk tøl (smáir bókstavir)" },
            { "type.nu.greklow", "grikskt tøl (smáir bókstavir)" },
            { "type.nu.hanidec", "kinesisk desimal tøl" },
            { "type.nu.hansfin", "einkul kinesisk fíggjarlig tøl" },
            { "type.nu.hantfin", "vanlig kinesisk fíggjarlig tøl" },
            { "type.nu.jpanfin", "japanskt fíggjarlig tøl" },
            { "type.nu.tamldec", "tamilsk tøl" },
            { "type.ca.buddhist", "buddistiskur kalendari" },
            { "type.ca.ethiopic", "etiopiskur kalendari" },
            { "type.ca.japanese", "japanskur kalendari" },
            { "type.cf.standard", "vanlig gjaldoyra format" },
            { "type.co.standard", "vanlig raðskipan" },
            { "type.ms.uksystem", "mátingareind (UK)" },
            { "type.ms.ussystem", "mátingareind (USA)" },
            { "type.nu.fullwide", "tøl í fullari longd" },
            { "type.nu.romanlow", "rómartøl (smáir bókstavir)" },
            { "type.ca.gregorian", "gregorianskur kalendari" },
            { "type.co.traditional", "siðbundin raðskipan" },
            { "type.ca.islamic-civil", "islamiskur kalendari (talvuskapaður, fólkaligt tíðarskeið)" },
            { "type.ca.islamic-umalqura", "islamiskur kalendari (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopiskur amete alem kalendari" },
        };
        return data;
    }
}
