/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh_Hant extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ff = "富拉文";
        final String metaValue_hy = "亞美尼亞文";
        final String metaValue_ban = "峇里文";
        final String metaValue_bax = "巴姆穆文";
        final String metaValue_bas = "巴薩文";
        final String metaValue_bn = "孟加拉文";
        final String metaValue_sa = "梵文";
        final String metaValue_bug = "布吉斯文";
        final String metaValue_ccp = "查克馬文";
        final String metaValue_chr = "柴羅基文";
        final String metaValue_cop = "科普特文";
        final String metaValue_ka = "喬治亞文";
        final String metaValue_gon = "岡德文";
        final String metaValue_gu = "古吉拉特文";
        final String metaValue_he = "希伯來文";
        final String metaValue_jv = "爪哇文";
        final String metaValue_ja = "日文";
        final String metaValue_km = "高棉文";
        final String metaValue_kn = "坎那達文";
        final String metaValue_ko = "韓文";
        final String metaValue_lo = "寮文";
        final String metaValue_hi = "印地文";
        final String metaValue_men = "門德文";
        final String metaValue_ml = "馬來亞拉姆文";
        final String metaValue_mr = "馬拉地文";
        final String metaValue_mn = "蒙古文";
        final String metaValue_mni = "曼尼普爾文";
        final String metaValue_my = "緬甸文";
        final String metaValue_sat = "桑塔利文";
        final String metaValue_or = "歐迪亞文";
        final String metaValue_osa = "歐塞奇文";
        final String metaValue_phn = "腓尼基文";
        final String metaValue_saz = "索拉什特拉文";
        final String metaValue_sd = "信德文";
        final String metaValue_sog = "粟特文";
        final String metaValue_su = "巽他文";
        final String metaValue_syr = "敘利亞文";
        final String metaValue_ta = "坦米爾文";
        final String metaValue_te = "泰盧固文";
        final String metaValue_th = "泰文";
        final String metaValue_bo = "藏文";
        final String metaValue_mai = "邁蒂利文";
        final String metaValue_uga = "烏加列文";
        final String metaValue_peo = "古波斯文";
        final String metaValue_ssy = "薩霍文";
        final String metaValue_Zsye = "表情符號";
        final String metaValue_key_nu = "數字";
        final String metaValue_type_nu_taml = "坦米爾數字";
        final Object[][] data = new Object[][] {
            { "001", "世界" },
            { "002", "非洲" },
            { "003", "北美洲" },
            { "005", "南美洲" },
            { "009", "大洋洲" },
            { "011", "西非" },
            { "013", "中美" },
            { "014", "東非" },
            { "015", "北非" },
            { "017", "中非" },
            { "018", "非洲南部" },
            { "019", "美洲" },
            { "021", "北美" },
            { "029", "加勒比海" },
            { "030", "東亞" },
            { "034", "南亞" },
            { "035", "東南亞" },
            { "039", "南歐" },
            { "053", "澳洲與紐西蘭" },
            { "054", "美拉尼西亞" },
            { "057", "密克羅尼西亞群島" },
            { "061", "玻里尼西亞" },
            { "142", "亞洲" },
            { "143", "中亞" },
            { "145", "西亞" },
            { "150", "歐洲" },
            { "151", "東歐" },
            { "154", "北歐" },
            { "155", "西歐" },
            { "202", "撒哈拉撒沙漠以南非洲" },
            { "419", "拉丁美洲" },
            { "AC", "阿森松島" },
            { "AD", "安道爾" },
            { "AE", "阿拉伯聯合大公國" },
            { "AF", "阿富汗" },
            { "AG", "安地卡及巴布達" },
            { "AI", "安奎拉" },
            { "AL", "阿爾巴尼亞" },
            { "AM", "亞美尼亞" },
            { "AO", "安哥拉" },
            { "AQ", "南極洲" },
            { "AR", "阿根廷" },
            { "AS", "美屬薩摩亞" },
            { "AT", "奧地利" },
            { "AU", "澳洲" },
            { "AW", "荷屬阿魯巴" },
            { "AX", "奧蘭群島" },
            { "AZ", "亞塞拜然" },
            { "BA", "波士尼亞與赫塞哥維納" },
            { "BB", "巴貝多" },
            { "BD", "孟加拉" },
            { "BE", "比利時" },
            { "BF", "布吉納法索" },
            { "BG", "保加利亞" },
            { "BH", "巴林" },
            { "BI", "蒲隆地" },
            { "BJ", "貝南" },
            { "BL", "聖巴瑟米" },
            { "BM", "百慕達" },
            { "BN", "汶萊" },
            { "BO", "玻利維亞" },
            { "BQ", "荷蘭加勒比區" },
            { "BR", "巴西" },
            { "BS", "巴哈馬" },
            { "BT", "不丹" },
            { "BV", "布威島" },
            { "BW", "波札那" },
            { "BY", "白俄羅斯" },
            { "BZ", "貝里斯" },
            { "CA", "加拿大" },
            { "CC", "科克斯（基靈）群島" },
            { "CD", "剛果（金夏沙）" },
            { "CF", "中非共和國" },
            { "CG", "剛果（布拉薩）" },
            { "CH", "瑞士" },
            { "CI", "象牙海岸" },
            { "CK", "庫克群島" },
            { "CL", "智利" },
            { "CM", "喀麥隆" },
            { "CN", "中國" },
            { "CO", "哥倫比亞" },
            { "CP", "克里派頓島" },
            { "CR", "哥斯大黎加" },
            { "CU", "古巴" },
            { "CV", "維德角" },
            { "CW", "庫拉索" },
            { "CX", "聖誕島" },
            { "CY", "賽普勒斯" },
            { "CZ", "捷克" },
            { "DE", "德國" },
            { "DG", "迪亞哥加西亞島" },
            { "DJ", "吉布地" },
            { "DK", "丹麥" },
            { "DM", "多米尼克" },
            { "DO", "多明尼加共和國" },
            { "DZ", "阿爾及利亞" },
            { "EA", "休達與梅利利亞" },
            { "EC", "厄瓜多" },
            { "EE", "愛沙尼亞" },
            { "EG", "埃及" },
            { "EH", "西撒哈拉" },
            { "ER", "厄利垂亞" },
            { "ES", "西班牙" },
            { "ET", "衣索比亞" },
            { "EU", "歐盟" },
            { "EZ", "歐元區" },
            { "FI", "芬蘭" },
            { "FJ", "斐濟" },
            { "FK", "福克蘭群島" },
            { "FM", "密克羅尼西亞" },
            { "FO", "法羅群島" },
            { "FR", "法國" },
            { "GA", "加彭" },
            { "GB", "英國" },
            { "GD", "格瑞那達" },
            { "GE", "喬治亞" },
            { "GF", "法屬圭亞那" },
            { "GG", "根息" },
            { "GH", "迦納" },
            { "GI", "直布羅陀" },
            { "GL", "格陵蘭" },
            { "GM", "甘比亞" },
            { "GN", "幾內亞" },
            { "GP", "瓜地洛普" },
            { "GQ", "赤道幾內亞" },
            { "GR", "希臘" },
            { "GS", "南喬治亞與南三明治群島" },
            { "GT", "瓜地馬拉" },
            { "GU", "關島" },
            { "GW", "幾內亞比索" },
            { "GY", "蓋亞那" },
            { "HK", "中國香港特別行政區" },
            { "HM", "赫德島及麥唐納群島" },
            { "HN", "宏都拉斯" },
            { "HR", "克羅埃西亞" },
            { "HT", "海地" },
            { "HU", "匈牙利" },
            { "IC", "加那利群島" },
            { "ID", "印尼" },
            { "IE", "愛爾蘭" },
            { "IL", "以色列" },
            { "IM", "曼島" },
            { "IN", "印度" },
            { "IO", "英屬印度洋領地" },
            { "IQ", "伊拉克" },
            { "IR", "伊朗" },
            { "IS", "冰島" },
            { "IT", "義大利" },
            { "JE", "澤西島" },
            { "JM", "牙買加" },
            { "JO", "約旦" },
            { "JP", "日本" },
            { "KE", "肯亞" },
            { "KG", "吉爾吉斯" },
            { "KH", "柬埔寨" },
            { "KI", "吉里巴斯" },
            { "KM", "葛摩" },
            { "KN", "聖克里斯多福及尼維斯" },
            { "KP", "北韓" },
            { "KR", "南韓" },
            { "KW", "科威特" },
            { "KY", "開曼群島" },
            { "KZ", "哈薩克" },
            { "LA", "寮國" },
            { "LB", "黎巴嫩" },
            { "LC", "聖露西亞" },
            { "LI", "列支敦斯登" },
            { "LK", "斯里蘭卡" },
            { "LR", "賴比瑞亞" },
            { "LS", "賴索托" },
            { "LT", "立陶宛" },
            { "LU", "盧森堡" },
            { "LV", "拉脫維亞" },
            { "LY", "利比亞" },
            { "MA", "摩洛哥" },
            { "MC", "摩納哥" },
            { "MD", "摩爾多瓦" },
            { "ME", "蒙特內哥羅" },
            { "MF", "法屬聖馬丁" },
            { "MG", "馬達加斯加" },
            { "MH", "馬紹爾群島" },
            { "MK", "北馬其頓" },
            { "ML", "馬利" },
            { "MM", "緬甸" },
            { "MN", "蒙古" },
            { "MO", "中國澳門特別行政區" },
            { "MP", "北馬利安納群島" },
            { "MQ", "馬丁尼克" },
            { "MR", "茅利塔尼亞" },
            { "MS", "蒙哲臘" },
            { "MT", "馬爾他" },
            { "MU", "模里西斯" },
            { "MV", "馬爾地夫" },
            { "MW", "馬拉威" },
            { "MX", "墨西哥" },
            { "MY", "馬來西亞" },
            { "MZ", "莫三比克" },
            { "NA", "納米比亞" },
            { "NC", "新喀里多尼亞" },
            { "NE", "尼日" },
            { "NF", "諾福克島" },
            { "NG", "奈及利亞" },
            { "NI", "尼加拉瓜" },
            { "NL", "荷蘭" },
            { "NO", "挪威" },
            { "NP", "尼泊爾" },
            { "NR", "諾魯" },
            { "NU", "紐埃島" },
            { "NZ", "紐西蘭" },
            { "OM", "阿曼" },
            { "PA", "巴拿馬" },
            { "PE", "秘魯" },
            { "PF", "法屬玻里尼西亞" },
            { "PG", "巴布亞紐幾內亞" },
            { "PH", "菲律賓" },
            { "PK", "巴基斯坦" },
            { "PL", "波蘭" },
            { "PM", "聖皮埃與密克隆群島" },
            { "PN", "皮特肯群島" },
            { "PR", "波多黎各" },
            { "PS", "巴勒斯坦自治區" },
            { "PT", "葡萄牙" },
            { "PW", "帛琉" },
            { "PY", "巴拉圭" },
            { "QA", "卡達" },
            { "QO", "大洋洲邊疆群島" },
            { "RE", "留尼旺" },
            { "RO", "羅馬尼亞" },
            { "RS", "塞爾維亞" },
            { "RU", "俄羅斯" },
            { "RW", "盧安達" },
            { "SA", "沙烏地阿拉伯" },
            { "SB", "索羅門群島" },
            { "SC", "塞席爾" },
            { "SD", "蘇丹" },
            { "SE", "瑞典" },
            { "SG", "新加坡" },
            { "SH", "聖赫勒拿島" },
            { "SI", "斯洛維尼亞" },
            { "SJ", "挪威屬斯瓦巴及尖棉" },
            { "SK", "斯洛伐克" },
            { "SL", "獅子山" },
            { "SM", "聖馬利諾" },
            { "SN", "塞內加爾" },
            { "SO", "索馬利亞" },
            { "SR", "蘇利南" },
            { "SS", "南蘇丹" },
            { "ST", "聖多美普林西比" },
            { "SV", "薩爾瓦多" },
            { "SX", "荷屬聖馬丁" },
            { "SY", "敘利亞" },
            { "SZ", "史瓦帝尼" },
            { "TA", "特里斯坦達庫尼亞群島" },
            { "TC", "土克斯及開科斯群島" },
            { "TD", "查德" },
            { "TF", "法屬南部屬地" },
            { "TG", "多哥" },
            { "TH", "泰國" },
            { "TJ", "塔吉克" },
            { "TK", "托克勞群島" },
            { "TL", "東帝汶" },
            { "TM", "土庫曼" },
            { "TN", "突尼西亞" },
            { "TO", "東加" },
            { "TR", "土耳其" },
            { "TT", "千里達及托巴哥" },
            { "TV", "吐瓦魯" },
            { "TW", "台灣" },
            { "TZ", "坦尚尼亞" },
            { "UA", "烏克蘭" },
            { "UG", "烏干達" },
            { "UM", "美國本土外小島嶼" },
            { "UN", "聯合國" },
            { "US", "美國" },
            { "UY", "烏拉圭" },
            { "UZ", "烏茲別克" },
            { "VA", "梵蒂岡" },
            { "VC", "聖文森及格瑞那丁" },
            { "VE", "委內瑞拉" },
            { "VG", "英屬維京群島" },
            { "VI", "美屬維京群島" },
            { "VN", "越南" },
            { "VU", "萬那杜" },
            { "WF", "瓦利斯群島和富圖那群島" },
            { "WS", "薩摩亞" },
            { "XA", "偽區域" },
            { "XB", "偽比迪" },
            { "XK", "科索沃" },
            { "YE", "葉門" },
            { "YT", "馬約特島" },
            { "ZA", "南非" },
            { "ZM", "尚比亞" },
            { "ZW", "辛巴威" },
            { "ZZ", "未知區域" },
            { "aa", "阿法文" },
            { "ab", "阿布哈茲文" },
            { "ae", "阿維斯塔文" },
            { "af", "南非荷蘭文" },
            { "ak", "阿坎文" },
            { "am", "阿姆哈拉文" },
            { "an", "阿拉貢文" },
            { "ar", "阿拉伯文" },
            { "as", "阿薩姆文" },
            { "av", "阿瓦爾文" },
            { "ay", "艾馬拉文" },
            { "az", "亞塞拜然文" },
            { "ba", "巴什喀爾文" },
            { "be", "白俄羅斯文" },
            { "bg", "保加利亞文" },
            { "bi", "比斯拉馬文" },
            { "bm", "班巴拉文" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "布列塔尼文" },
            { "bs", "波士尼亞文" },
            { "ca", "加泰蘭文" },
            { "ce", "車臣文" },
            { "ch", "查莫洛文" },
            { "co", "科西嘉文" },
            { "cr", "克里文" },
            { "cs", "捷克文" },
            { "cu", "宗教斯拉夫文" },
            { "cv", "楚瓦什文" },
            { "cy", "威爾斯文" },
            { "da", "丹麥文" },
            { "de", "德文" },
            { "dv", "迪維西文" },
            { "dz", "宗卡文" },
            { "ee", "埃維文" },
            { "el", "希臘文" },
            { "en", "英文" },
            { "eo", "世界文" },
            { "es", "西班牙文" },
            { "et", "愛沙尼亞文" },
            { "eu", "巴斯克文" },
            { "fa", "波斯文" },
            { "ff", metaValue_ff },
            { "fi", "芬蘭文" },
            { "fj", "斐濟文" },
            { "fo", "法羅文" },
            { "fr", "法文" },
            { "fy", "西弗里西亞文" },
            { "ga", "愛爾蘭文" },
            { "gd", "蘇格蘭蓋爾文" },
            { "gl", "加利西亞文" },
            { "gn", "瓜拉尼文" },
            { "gu", metaValue_gu },
            { "gv", "曼島文" },
            { "ha", "豪薩文" },
            { "he", metaValue_he },
            { "hi", metaValue_hi },
            { "ho", "西里莫圖土文" },
            { "hr", "克羅埃西亞文" },
            { "ht", "海地文" },
            { "hu", "匈牙利文" },
            { "hy", metaValue_hy },
            { "hz", "赫雷羅文" },
            { "ia", "國際文" },
            { "id", "印尼文" },
            { "ie", "國際文（E）" },
            { "ig", "伊布文" },
            { "ii", "四川彝文" },
            { "ik", "依奴皮維克文" },
            { "io", "伊多文" },
            { "is", "冰島文" },
            { "it", "義大利文" },
            { "iu", "因紐特文" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "剛果文" },
            { "ki", "吉庫尤文" },
            { "kj", "廣亞馬文" },
            { "kk", "哈薩克文" },
            { "kl", "格陵蘭文" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "卡努里文" },
            { "ks", "喀什米爾文" },
            { "ku", "庫德文" },
            { "kv", "科米文" },
            { "kw", "康瓦耳文" },
            { "ky", "吉爾吉斯文" },
            { "la", "拉丁文" },
            { "lb", "盧森堡文" },
            { "lg", "干達文" },
            { "li", "林堡文" },
            { "ln", "林加拉文" },
            { "lo", metaValue_lo },
            { "lt", "立陶宛文" },
            { "lu", "魯巴加丹加文" },
            { "lv", "拉脫維亞文" },
            { "mg", "馬達加斯加文" },
            { "mh", "馬紹爾文" },
            { "mi", "毛利文" },
            { "mk", "馬其頓文" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", metaValue_mr },
            { "ms", "馬來文" },
            { "mt", "馬爾他文" },
            { "my", metaValue_my },
            { "na", "諾魯文" },
            { "nb", "書面挪威文" },
            { "nd", "北地畢列文" },
            { "ne", "尼泊爾文" },
            { "ng", "恩東加文" },
            { "nl", "荷蘭文" },
            { "nn", "新挪威文" },
            { "no", "挪威文" },
            { "nr", "南地畢列文" },
            { "nv", "納瓦荷文" },
            { "ny", "尼揚賈文" },
            { "oc", "奧克西坦文" },
            { "oj", "奧杰布瓦文" },
            { "om", "奧羅莫文" },
            { "or", metaValue_or },
            { "os", "奧塞提文" },
            { "pa", "旁遮普文" },
            { "pi", "巴利文" },
            { "pl", "波蘭文" },
            { "ps", "普什圖文" },
            { "pt", "葡萄牙文" },
            { "qu", "蓋楚瓦文" },
            { "rm", "羅曼斯文" },
            { "rn", "隆迪文" },
            { "ro", "羅馬尼亞文" },
            { "ru", "俄文" },
            { "rw", "盧安達文" },
            { "sa", metaValue_sa },
            { "sc", "撒丁文" },
            { "sd", metaValue_sd },
            { "se", "北薩米文" },
            { "sg", "桑戈文" },
            { "sh", "塞爾維亞克羅埃西亞文" },
            { "si", "僧伽羅文" },
            { "sk", "斯洛伐克文" },
            { "sl", "斯洛維尼亞文" },
            { "sm", "薩摩亞文" },
            { "sn", "紹納文" },
            { "so", "索馬利文" },
            { "sq", "阿爾巴尼亞文" },
            { "sr", "塞爾維亞文" },
            { "ss", "斯瓦特文" },
            { "st", "塞索托文" },
            { "su", metaValue_su },
            { "sv", "瑞典文" },
            { "sw", "史瓦希里文" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "塔吉克文" },
            { "th", metaValue_th },
            { "ti", "提格利尼亞文" },
            { "tk", "土庫曼文" },
            { "tl", "塔加路族文" },
            { "tn", "塞茲瓦納文" },
            { "to", "東加文" },
            { "tr", "土耳其文" },
            { "ts", "特松加文" },
            { "tt", "韃靼文" },
            { "tw", "特威文" },
            { "ty", "大溪地文" },
            { "ug", "維吾爾文" },
            { "uk", "烏克蘭文" },
            { "ur", "烏都文" },
            { "uz", "烏茲別克文" },
            { "ve", "溫達文" },
            { "vi", "越南文" },
            { "vo", "沃拉普克文" },
            { "wa", "瓦隆文" },
            { "wo", "沃洛夫文" },
            { "xh", "科薩文" },
            { "yi", "意第緒文" },
            { "yo", "約魯巴文" },
            { "za", "壯文" },
            { "zh", "中文" },
            { "zu", "祖魯文" },
            { "ace", "亞齊文" },
            { "ach", "阿僑利文" },
            { "ada", "阿當莫文" },
            { "ady", "阿迪各文" },
            { "aeb", "突尼斯阿拉伯文" },
            { "afh", "阿弗里希利文" },
            { "agq", "亞罕文" },
            { "ain", "阿伊努文" },
            { "akk", "阿卡德文" },
            { "akz", "阿拉巴馬文" },
            { "ale", "阿留申文" },
            { "aln", "蓋格阿爾巴尼亞文" },
            { "alt", "南阿爾泰文" },
            { "ang", "古英文" },
            { "ann", "奧博洛語" },
            { "anp", "昂加文" },
            { "arc", "阿拉米文" },
            { "arn", "馬普切文" },
            { "aro", "阿拉奧納文" },
            { "arp", "阿拉帕霍文" },
            { "arq", "阿爾及利亞阿拉伯文" },
            { "ars", "納吉迪阿拉伯文" },
            { "arw", "阿拉瓦克文" },
            { "ary", "摩洛哥阿拉伯文" },
            { "arz", "埃及阿拉伯文" },
            { "asa", "阿蘇文" },
            { "ase", "美國手語" },
            { "ast", "阿斯圖里亞文" },
            { "atj", "阿提卡梅克語" },
            { "avk", "科塔瓦文" },
            { "awa", "阿瓦文" },
            { "bal", "俾路支文" },
            { "ban", metaValue_ban },
            { "bar", "巴伐利亞文" },
            { "bas", metaValue_bas },
            { "bax", metaValue_bax },
            { "bbc", "巴塔克托巴文" },
            { "bbj", "戈馬拉文" },
            { "bej", "貝扎文" },
            { "bem", "別姆巴文" },
            { "bew", "貝塔維文" },
            { "bez", "貝納文" },
            { "bfd", "富特文" },
            { "bfq", "巴達加文" },
            { "bgc", "哈里亞納文" },
            { "bgn", "西俾路支文" },
            { "bho", "博傑普爾文" },
            { "bik", "比科爾文" },
            { "bin", "比尼文" },
            { "bjn", "班亞爾文" },
            { "bkm", "康姆文" },
            { "bla", "錫克錫卡文" },
            { "blo", "阿尼文" },
            { "bpy", "比什奴普萊利亞文" },
            { "bqi", "巴赫蒂亞里文" },
            { "bra", "布拉杰文" },
            { "brh", "布拉維文" },
            { "brx", "博多文" },
            { "bss", "阿庫色文" },
            { "bua", "布里阿特文" },
            { "bug", metaValue_bug },
            { "bum", "布魯文" },
            { "byn", "比林文" },
            { "byv", "梅敦巴文" },
            { "cad", "卡多文" },
            { "car", "加勒比文" },
            { "cay", "卡尤加文" },
            { "cch", "阿燦文" },
            { "ccp", metaValue_ccp },
            { "ceb", "宿霧文" },
            { "cgg", "奇加文" },
            { "chb", "奇布查文" },
            { "chg", "查加文" },
            { "chk", "處奇斯文" },
            { "chm", "馬里文" },
            { "chn", "契奴克文" },
            { "cho", "喬克托文" },
            { "chp", "奇佩瓦揚文" },
            { "chr", metaValue_chr },
            { "chy", "沙伊安文" },
            { "cic", "契卡索文" },
            { "ckb", "中庫德文" },
            { "clc", "齊爾柯廷語" },
            { "cop", metaValue_cop },
            { "cps", "卡皮茲文" },
            { "crg", "米奇夫語" },
            { "crh", "克里米亞韃靼文" },
            { "crj", "東南克里語" },
            { "crk", "平原克里語" },
            { "crl", "北部東克里語" },
            { "crm", "穆斯克里文" },
            { "crr", "卡羅萊納阿爾岡昆語" },
            { "crs", "塞席爾克里奧爾法文" },
            { "csb", "卡舒布文" },
            { "csw", "沼澤克里文" },
            { "dak", "達科他文" },
            { "dar", "達爾格瓦文" },
            { "dav", "台塔文" },
            { "del", "德拉瓦文" },
            { "den", "斯拉夫" },
            { "dgr", "多格里布文" },
            { "din", "丁卡文" },
            { "dje", "扎爾馬文" },
            { "doi", "多格來文" },
            { "dsb", "下索布文" },
            { "dtp", "中部杜順文" },
            { "dua", "杜亞拉文" },
            { "dum", "中古荷蘭文" },
            { "dyo", "朱拉文" },
            { "dyu", "迪尤拉文" },
            { "dzg", "達薩文" },
            { "ebu", "恩布文" },
            { "efi", "埃菲克文" },
            { "egl", "埃米利安文" },
            { "egy", "古埃及文" },
            { "eka", "艾卡朱克文" },
            { "elx", "埃蘭文" },
            { "enm", "中古英文" },
            { "esu", "中尤皮克文" },
            { "ewo", "依汪都文" },
            { "ext", "埃斯特雷馬杜拉文" },
            { "fan", "芳族文" },
            { "fat", "芳蒂文" },
            { "fil", "菲律賓文" },
            { "fit", "托爾訥芬蘭文" },
            { "fon", "豐文" },
            { "frc", "卡真法文" },
            { "frm", "中古法文" },
            { "fro", "古法文" },
            { "frp", "法蘭克-普羅旺斯文" },
            { "frr", "北弗里西亞文" },
            { "frs", "東弗里西亞文" },
            { "fur", "弗留利文" },
            { "gaa", "加族文" },
            { "gag", "加告茲文" },
            { "gan", "贛語" },
            { "gay", "加約文" },
            { "gba", "葛巴亞文" },
            { "gbz", "索羅亞斯德教達里文" },
            { "gez", "吉茲文" },
            { "gil", "吉爾伯特群島文" },
            { "glk", "吉拉基文" },
            { "gmh", "中古高地德文" },
            { "goh", "古高地德文" },
            { "gon", metaValue_gon },
            { "gor", "科隆達羅文" },
            { "got", "哥德文" },
            { "grb", "格列博文" },
            { "grc", "古希臘文" },
            { "gsw", "德文（瑞士）" },
            { "guc", "瓦尤文" },
            { "gur", "弗拉弗拉文" },
            { "guz", "古西文" },
            { "gwi", "圭契文" },
            { "hai", "海達文" },
            { "hak", "客家話" },
            { "haw", "夏威夷文" },
            { "hax", "南海達語" },
            { "hif", "斐濟印地文" },
            { "hil", "希利蓋農文" },
            { "hit", "赫梯文" },
            { "hmn", "苗語" },
            { "hsb", "上索布文" },
            { "hsn", "湘語" },
            { "hup", "胡帕文" },
            { "hur", "哈爾魁梅林語" },
            { "iba", "伊班文" },
            { "ibb", "伊比比奧文" },
            { "ikt", "西加拿大因紐特語" },
            { "ilo", "伊洛闊文" },
            { "inh", "印古什文" },
            { "izh", "英格里亞文" },
            { "jam", "牙買加克里奧爾英文" },
            { "jbo", "邏輯文" },
            { "jgo", "恩格姆巴文" },
            { "jmc", "馬恰美文" },
            { "jpr", "猶太教-波斯文" },
            { "jrb", "猶太阿拉伯文" },
            { "jut", "日德蘭文" },
            { "kaa", "卡拉卡爾帕克文" },
            { "kab", "卡比爾文" },
            { "kac", "卡琴文" },
            { "kaj", "卡捷文" },
            { "kam", "卡姆巴文" },
            { "kaw", "卡威文" },
            { "kbd", "卡巴爾達文" },
            { "kbl", "卡念布文" },
            { "kcg", "卡塔布文" },
            { "kde", "馬孔德文" },
            { "kea", "卡布威爾第文" },
            { "ken", "肯揚文" },
            { "kfo", "科羅文" },
            { "kgp", "坎剛文" },
            { "kha", "卡西文" },
            { "kho", "和闐文" },
            { "khq", "西桑海文" },
            { "khw", "科瓦文" },
            { "kiu", "北紮紮其文" },
            { "kkj", "卡庫文" },
            { "kln", "卡倫金文" },
            { "kmb", "金邦杜文" },
            { "koi", "科米-彼爾米亞克文" },
            { "kok", "貢根文" },
            { "kos", "科斯雷恩文" },
            { "kpe", "克佩列文" },
            { "krc", "卡拉柴-包爾卡爾文" },
            { "kri", "塞拉利昂克裏奧爾文" },
            { "krj", "基那來阿文" },
            { "krl", "卡累利阿文" },
            { "kru", "庫魯科文" },
            { "ksb", "尚巴拉文" },
            { "ksf", "巴菲亞文" },
            { "ksh", "科隆文" },
            { "kum", "庫密克文" },
            { "kut", "庫特奈文" },
            { "kwk", "誇誇嘉誇語" },
            { "kxv", "庫維文" },
            { "lad", "拉迪諾文" },
            { "lag", "朗吉文" },
            { "lah", "拉亨達文" },
            { "lam", "蘭巴文" },
            { "lez", "列茲干文" },
            { "lfn", "新共同語言" },
            { "lij", "利古里亞文" },
            { "lil", "利洛威特文" },
            { "liv", "利伏尼亞文" },
            { "lkt", "拉科塔文" },
            { "lmo", "倫巴底文" },
            { "lol", "芒戈文" },
            { "lou", "路易斯安那克里奧爾文" },
            { "loz", "洛齊文" },
            { "lrc", "北盧爾文" },
            { "lsm", "薩米亞文" },
            { "ltg", "拉特加萊文" },
            { "lua", "魯巴魯魯亞文" },
            { "lui", "路易塞諾文" },
            { "lun", "盧恩達文" },
            { "luo", "盧奧文" },
            { "lus", "米佐文" },
            { "luy", "盧雅文" },
            { "lzh", "文言文" },
            { "lzz", "拉茲文" },
            { "mad", "馬都拉文" },
            { "maf", "馬法文" },
            { "mag", "摩揭陀文" },
            { "mai", metaValue_mai },
            { "mak", "望加錫文" },
            { "man", "曼丁哥文" },
            { "mas", "馬賽文" },
            { "mde", "馬巴文" },
            { "mdf", "莫克沙文" },
            { "mdr", "曼達文" },
            { "men", metaValue_men },
            { "mer", "梅魯文" },
            { "mfe", "克里奧文（模里西斯）" },
            { "mga", "中古愛爾蘭文" },
            { "mgh", "馬夸文" },
            { "mgo", "美塔文" },
            { "mic", "米克馬克文" },
            { "min", "米南卡堡文" },
            { "mnc", "滿族文" },
            { "mni", metaValue_mni },
            { "moe", "因紐艾蒙語" },
            { "moh", "莫霍克文" },
            { "mos", "莫西文" },
            { "mrj", "西馬里文" },
            { "mua", "蒙當文" },
            { "mul", "多種語言" },
            { "mus", "克里克文" },
            { "mwl", "米蘭德斯文" },
            { "mwr", "馬瓦里文" },
            { "mwv", "明打威文" },
            { "mye", "姆耶內文" },
            { "myv", "厄爾茲亞文" },
            { "mzn", "馬贊德蘭文" },
            { "nan", "閩南語" },
            { "nap", "拿波里文" },
            { "naq", "納馬文" },
            { "nds", "低地德文" },
            { "new", "尼瓦爾文" },
            { "nia", "尼亞斯文" },
            { "niu", "紐埃文" },
            { "njo", "阿沃那加文" },
            { "nmg", "夸西奧文" },
            { "nnh", "恩甘澎文" },
            { "nog", "諾蓋文" },
            { "non", "古諾爾斯文" },
            { "nov", "諾維亞文" },
            { "nqo", "曼德文字 (N’Ko)" },
            { "nso", "北索托文" },
            { "nus", "努埃爾文" },
            { "nwc", "古尼瓦爾文" },
            { "nym", "尼揚韋齊文" },
            { "nyn", "尼揚科萊文" },
            { "nyo", "尼奧囉文" },
            { "nzi", "尼茲馬文" },
            { "ojb", "西北奧吉布瓦語" },
            { "ojc", "中央奧吉布瓦語" },
            { "ojs", "奧吉克里語" },
            { "ojw", "西奧吉布瓦語" },
            { "oka", "奧卡諾根語" },
            { "osa", metaValue_osa },
            { "ota", "鄂圖曼土耳其文" },
            { "pag", "潘加辛文" },
            { "pal", "巴列維文" },
            { "pam", "潘帕嘉文" },
            { "pap", "帕皮阿門托文" },
            { "pau", "帛琉文" },
            { "pcd", "庇卡底文" },
            { "pcm", "奈及利亞皮欽文" },
            { "pdc", "賓夕法尼亞德文" },
            { "pdt", "門諾低地德文" },
            { "peo", metaValue_peo },
            { "pfl", "普法爾茨德文" },
            { "phn", metaValue_phn },
            { "pis", "皮金語" },
            { "pms", "皮埃蒙特文" },
            { "pnt", "旁狄希臘文" },
            { "pon", "波那貝文" },
            { "pqm", "馬里希特帕薩瑪奎迪文" },
            { "prg", "普魯士文" },
            { "pro", "古普羅旺斯文" },
            { "quc", "基切文" },
            { "qug", "欽博拉索海蘭蓋丘亞文" },
            { "raj", "拉賈斯坦諸文" },
            { "rap", "復活島文" },
            { "rar", "拉羅通加文" },
            { "rgn", "羅馬格諾里文" },
            { "rhg", "羅興亞文" },
            { "rif", "里菲亞諾文" },
            { "rof", "蘭博文" },
            { "rom", "吉普賽文" },
            { "rtm", "羅圖馬島文" },
            { "rue", "盧森尼亞文" },
            { "rug", "羅維阿納文" },
            { "rup", "羅馬尼亞語系" },
            { "rwk", "羅瓦文" },
            { "sad", "桑達韋文" },
            { "sah", "雅庫特文" },
            { "sam", "薩瑪利亞阿拉姆文" },
            { "saq", "薩布魯文" },
            { "sas", "撒撒克文" },
            { "sat", metaValue_sat },
            { "saz", metaValue_saz },
            { "sba", "甘拜文" },
            { "sbp", "桑古文" },
            { "scn", "西西里文" },
            { "sco", "蘇格蘭文" },
            { "sdc", "薩丁尼亞-薩薩里文" },
            { "sdh", "南庫德文" },
            { "see", "塞訥卡文" },
            { "seh", "賽納文" },
            { "sei", "瑟里文" },
            { "sel", "塞爾庫普文" },
            { "ses", "東桑海文" },
            { "sga", "古愛爾蘭文" },
            { "sgs", "薩莫吉希亞文" },
            { "shi", "希爾哈文" },
            { "shn", "撣文" },
            { "shu", "阿拉伯文（查德）" },
            { "sid", "希達摩文" },
            { "slh", "南盧紹錫德語" },
            { "sli", "下西利西亞文" },
            { "sly", "塞拉亞文" },
            { "sma", "南薩米文" },
            { "smj", "魯勒薩米文" },
            { "smn", "伊納里薩米文" },
            { "sms", "斯科特薩米文" },
            { "snk", "索尼基文" },
            { "sog", metaValue_sog },
            { "srn", "蘇拉南東墎文" },
            { "srr", "塞雷爾文" },
            { "ssy", metaValue_ssy },
            { "stq", "沙特菲士蘭文" },
            { "str", "海峽薩利希語" },
            { "suk", "蘇庫馬文" },
            { "sus", "蘇蘇文" },
            { "sux", "蘇美文" },
            { "swb", "葛摩文" },
            { "syc", "古敘利亞文" },
            { "syr", metaValue_syr },
            { "szl", "西利西亞文" },
            { "tce", "南塔穹語" },
            { "tcy", "圖盧文" },
            { "tem", "提姆文" },
            { "teo", "特索文" },
            { "ter", "泰雷諾文" },
            { "tet", "泰頓文" },
            { "tgx", "塔吉什語" },
            { "tht", "塔爾坦語" },
            { "tig", "蒂格雷文" },
            { "tiv", "提夫文" },
            { "tkl", "托克勞文" },
            { "tkr", "查庫爾文" },
            { "tlh", "克林貢文" },
            { "tli", "特林基特文" },
            { "tly", "塔里什文" },
            { "tmh", "塔馬奇克文" },
            { "tog", "東加文（尼亞薩）" },
            { "tok", "道本語" },
            { "tpi", "托比辛文" },
            { "tru", "圖羅尤文" },
            { "trv", "太魯閣文" },
            { "tsd", "特薩克尼恩文" },
            { "tsi", "欽西安文" },
            { "ttm", "北塔穹語" },
            { "ttt", "穆斯林塔特文" },
            { "tum", "圖姆布卡文" },
            { "tvl", "吐瓦魯文" },
            { "twq", "北桑海文" },
            { "tyv", "圖瓦文" },
            { "tzm", "中阿特拉斯塔馬塞特文" },
            { "udm", "烏德穆爾特文" },
            { "uga", metaValue_uga },
            { "umb", "姆本杜文" },
            { "und", "未知語言" },
            { "vai", "瓦伊文" },
            { "vec", "威尼斯文" },
            { "vep", "維普森文" },
            { "vls", "西佛蘭德文" },
            { "vmf", "美茵-法蘭克尼亞文" },
            { "vmw", "馬庫瓦文" },
            { "vot", "沃提克文" },
            { "vro", "佛羅文" },
            { "vun", "溫舊文" },
            { "wae", "瓦爾瑟文" },
            { "wal", "瓦拉莫文" },
            { "war", "瓦瑞文" },
            { "was", "瓦紹文" },
            { "wbp", "沃皮瑞文" },
            { "wuu", "吳語" },
            { "xal", "卡爾梅克文" },
            { "xmf", "明格列爾文" },
            { "xnr", "康格里" },
            { "xog", "索加文" },
            { "yao", "瑤文" },
            { "yap", "雅浦文" },
            { "yav", "洋卞文" },
            { "ybb", "耶姆巴文" },
            { "yrl", "奈恩加圖文" },
            { "yue", "粵語" },
            { "zap", "薩波特克文" },
            { "zbl", "布列斯符號" },
            { "zea", "西蘭文" },
            { "zen", "澤納加文" },
            { "zgh", "標準摩洛哥塔馬塞特文" },
            { "zun", "祖尼文" },
            { "zxx", "無語言內容" },
            { "zza", "扎扎文" },
            { "Adlm", metaValue_ff },
            { "Afak", "阿法卡文字" },
            { "Aghb", "高加索阿爾巴尼亞文" },
            { "Ahom", "阿洪姆文" },
            { "Arab", "阿拉伯字母" },
            { "Aran", "波斯體" },
            { "Armi", "皇室亞美尼亞文" },
            { "Armn", metaValue_hy },
            { "Avst", "阿維斯陀文" },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", metaValue_bas },
            { "Batk", "巴塔克文" },
            { "Beng", metaValue_bn },
            { "Bhks", metaValue_sa },
            { "Blis", "布列斯文" },
            { "Bopo", "注音符號" },
            { "Brah", "婆羅米文" },
            { "Brai", "盲人用點字" },
            { "Bugi", metaValue_bug },
            { "Buhd", "布希德文" },
            { "Cakm", metaValue_ccp },
            { "Cans", "加拿大原住民通用字符" },
            { "Cari", "卡里亞文" },
            { "Cham", "占文" },
            { "Cher", metaValue_chr },
            { "Cirt", "色斯文" },
            { "Copt", metaValue_cop },
            { "Cprt", "塞浦路斯文" },
            { "Cyrl", "西里爾文字" },
            { "Cyrs", "西里爾文（古教會斯拉夫文變體）" },
            { "Deva", "天城文" },
            { "Dsrt", "德瑟雷特文" },
            { "Dupl", "杜普洛伊速記" },
            { "Egyd", "古埃及世俗體" },
            { "Egyh", "古埃及僧侶體" },
            { "Egyp", "古埃及聖書體" },
            { "Elba", "愛爾巴桑文" },
            { "Ethi", "衣索比亞文" },
            { "Geok", "喬治亞語系（阿索他路里和努斯克胡里文）" },
            { "Geor", metaValue_ka },
            { "Glag", "格拉哥里文" },
            { "Gonm", metaValue_gon },
            { "Goth", "歌德文" },
            { "Gran", "格蘭他文字" },
            { "Grek", "希臘字母" },
            { "Gujr", metaValue_gu },
            { "Guru", "古魯穆奇文" },
            { "Hanb", "標上注音符號的漢字" },
            { "Hang", "諺文" },
            { "Hani", "漢字" },
            { "Hano", "哈努諾文" },
            { "Hans", "簡體" },
            { "Hant", "繁體" },
            { "Hatr", "哈特拉文" },
            { "Hebr", metaValue_he },
            { "Hira", "平假名" },
            { "Hluw", "安那托利亞象形文字" },
            { "Hmng", "楊松錄苗文" },
            { "Hrkt", "片假名或平假名" },
            { "Hung", "古匈牙利文" },
            { "Inds", "印度河流域（哈拉帕文）" },
            { "Ital", "古意大利文" },
            { "Jamo", "韓文字母" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "女真文字" },
            { "Kali", "克耶李文" },
            { "Kana", "片假名" },
            { "Khar", "卡羅須提文" },
            { "Khmr", metaValue_km },
            { "Khoj", "克吉奇文字" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "克培列文" },
            { "Kthi", "凱提文" },
            { "Lana", "藍拿文" },
            { "Laoo", metaValue_lo },
            { "Latf", "拉丁文（尖角體活字變體）" },
            { "Latg", "拉丁文（蓋爾語變體）" },
            { "Latn", "拉丁字母" },
            { "Lepc", "雷布查文" },
            { "Limb", "林佈文" },
            { "Lina", "線性文字（A）" },
            { "Linb", "線性文字（B）" },
            { "Lisu", "栗僳文" },
            { "Loma", "洛馬文" },
            { "Lyci", "呂西亞語" },
            { "Lydi", "里底亞語" },
            { "Mahj", metaValue_hi },
            { "Mand", "曼底安文" },
            { "Mani", "摩尼教文" },
            { "Marc", "瑪欽文" },
            { "Maya", "瑪雅象形文字" },
            { "Mend", metaValue_men },
            { "Merc", "麥羅埃文（曲線字體）" },
            { "Mero", "麥羅埃文" },
            { "Mlym", metaValue_ml },
            { "Modi", metaValue_mr },
            { "Mong", metaValue_mn },
            { "Moon", "蒙氏點字" },
            { "Mroo", "謬文" },
            { "Mtei", metaValue_mni },
            { "Mult", "木爾坦文" },
            { "Mymr", metaValue_my },
            { "Narb", "古北阿拉伯文" },
            { "Nbat", "納巴泰文字" },
            { "Newa", "Vote 尼瓦爾文" },
            { "Nkgb", "納西格巴文" },
            { "Nkoo", "西非書面語言 (N’Ko)" },
            { "Nshu", "女書" },
            { "Ogam", "歐甘文" },
            { "Olck", metaValue_sat },
            { "Orkh", "鄂爾渾文" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "歐斯曼亞文" },
            { "Palm", "帕米瑞拉文字" },
            { "Pauc", "鮑欽豪文" },
            { "Perm", "古彼爾姆諸文" },
            { "Phag", "八思巴文" },
            { "Phli", "巴列維文（碑銘體）" },
            { "Phlp", "巴列維文（聖詩體）" },
            { "Phlv", "巴列維文（書體）" },
            { "Phnx", metaValue_phn },
            { "Plrd", "柏格理拼音符" },
            { "Prti", "帕提亞文（碑銘體）" },
            { "Qaag", "佐基文" },
            { "Rjng", "拉讓文" },
            { "Rohg", "哈乃斐羅興亞文" },
            { "Roro", "朗格朗格象形文" },
            { "Runr", "古北歐文字" },
            { "Samr", "撒馬利亞文" },
            { "Sara", "沙拉堤文" },
            { "Sarb", "古南阿拉伯文" },
            { "Saur", metaValue_saz },
            { "Sgnw", "手語書寫符號" },
            { "Shaw", "簫柏納字符" },
            { "Shrd", "夏拉達文" },
            { "Sidd", "悉曇文字" },
            { "Sind", metaValue_sd },
            { "Sinh", "錫蘭文" },
            { "Sogd", metaValue_sog },
            { "Sogo", "古粟特文" },
            { "Sora", "索朗桑朋文字" },
            { "Soyo", "索永布文字" },
            { "Sund", metaValue_su },
            { "Sylo", "希洛弟納格里文" },
            { "Syrc", metaValue_syr },
            { "Syre", "敘利亞文（福音體文字變體）" },
            { "Syrj", "敘利亞文（西方文字變體）" },
            { "Syrn", "敘利亞文（東方文字變體）" },
            { "Tagb", "南島文" },
            { "Takr", "塔卡里文字" },
            { "Tale", "傣哪文" },
            { "Talu", "西雙版納新傣文" },
            { "Taml", metaValue_ta },
            { "Tang", "西夏文" },
            { "Tavt", "傣擔文" },
            { "Telu", metaValue_te },
            { "Teng", "談格瓦文" },
            { "Tfng", "提非納文" },
            { "Tglg", "塔加拉文" },
            { "Thaa", "塔安那文" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", metaValue_mai },
            { "Ugar", metaValue_uga },
            { "Vaii", "瓦依文" },
            { "Visp", "視覺語音文字" },
            { "Wara", "瓦郎奇蒂文字" },
            { "Wole", "沃雷艾文" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "蘇米魯亞甲文楔形文字" },
            { "Yiii", "彞文" },
            { "Zanb", "札那巴札爾文字" },
            { "Zinh", "繼承文字（Unicode）" },
            { "Zmth", "數學符號" },
            { "Zsye", metaValue_Zsye },
            { "Zsym", "符號" },
            { "Zxxx", "非書寫語言" },
            { "Zyyy", "一般文字" },
            { "Zzzz", "未知文字" },
            { "de_CH", "高地德文（瑞士）" },
            { "nl_BE", "法蘭德斯文" },
            { "ro_MD", "摩爾多瓦文" },
            { "sw_CD", "史瓦希里文（剛果）" },
            { "%%1901", "傳統德語拼字學" },
            { "%%1994", "標準雷西亞拼字" },
            { "%%1996", "1996 年的德語拼字學" },
            { "ar_001", "現代標準阿拉伯文" },
            { "key.ca", "曆法" },
            { "key.cf", "貨幣格式" },
            { "key.co", "排序" },
            { "key.cu", "貨幣" },
            { "key.hc", "時間週期（12 小時制與 24 小時制）" },
            { "key.lb", "換行樣式" },
            { "key.ms", "度量單位系統" },
            { "key.nu", metaValue_key_nu },
            { "key.tz", "時區" },
            { "key.va", "區域變異" },
            { "nds_NL", "低地薩克遜文" },
            { "%%ALUKU", "阿魯庫方言" },
            { "%%BARLA", "卡布佛得鲁向風群島方言" },
            { "%%BISKE", "聖喬治/比拉方言" },
            { "%%BOONT", "布恩特林方言" },
            { "%%JAUER", "米茲泰爾方言" },
            { "%%KKCOR", "通用康沃爾文拼字" },
            { "%%KSCOR", "標準拼寫" },
            { "%%LIPAW", "雷西亞利波瓦方言" },
            { "%%NEDIS", "那提松尼方言" },
            { "%%NJIVA", "雷西亞尼瓦方言" },
            { "%%NULIK", "現代沃拉普克文" },
            { "%%OSOJS", "雷西亞歐西亞柯方言" },
            { "%%POSIX", "電腦" },
            { "%%PUTER", "瑞士普特爾方言" },
            { "%%RIGIK", "古典沃拉普克文" },
            { "%%ROZAJ", "雷西亞方言" },
            { "%%RUMGR", "羅曼什文" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "雷西亞史托維薩方言" },
            { "%%SOTAV", "卡布佛得鲁背風群島方言" },
            { "%%UCCOR", "統一康沃爾文拼字" },
            { "hi_Latn", "印地語（拉丁文）" },
            { "zh_Hans", "簡體中文" },
            { "zh_Hant", "繁體中文" },
            { "%%AO1990", "1990 年葡語書寫協議的拼寫" },
            { "%%DAJNKO", "謙柯字母" },
            { "%%EKAVSK", "易卡發音塞爾維亞文" },
            { "%%FONIPA", "IPA 拼音" },
            { "%%FONUPA", "UPA 拼音" },
            { "%%NDYUKA", "蘇利南恩都卡方言" },
            { "%%PAMAKA", "蘇利南帕馬卡方言" },
            { "%%PINYIN", "漢語拼音" },
            { "%%SCOUSE", "利物浦方言" },
            { "%%TARASK", "白俄羅斯文傳統拼字" },
            { "%%UCRCOR", "統一康沃爾文修訂拼字" },
            { "%%ULSTER", "愛爾蘭阿爾斯特方言" },
            { "%%ABL1943", "1943 年拼字標準" },
            { "%%ALALC97", "美國國會圖書館標準方案羅馬化（1997年版）" },
            { "%%AREVELA", "亞美尼亞東部" },
            { "%%AREVMDA", "亞美尼亞西部" },
            { "%%BALANKA", "安尼巴朗卡方言" },
            { "%%BAUDDHA", "佛教混合梵文" },
            { "%%BOHORIC", "波赫力字母" },
            { "%%EMODENG", "早期現代英語" },
            { "%%HEPBURN", "平文式羅馬字" },
            { "%%ITIHASA", "史詩梵文" },
            { "%%LAUKIKA", "傳統梵文" },
            { "%%METELKO", "梅泰爾科字母" },
            { "%%MONOTON", "希臘文單調正字法" },
            { "%%POLYTON", "希臘文多調正字法" },
            { "%%REVISED", "已修訂的拼字學" },
            { "%%SURSILV", "瑞士蘇瑟瓦方言" },
            { "%%SUTSILV", "瑞士蘇希瓦方言" },
            { "%%VAIDIKA", "吠陀梵文" },
            { "%%1606NICT", "中世紀晚期法文（至1606年）" },
            { "%%1694ACAD", "早期現代法文" },
            { "%%1959ACAD", "白俄羅斯文（學術）" },
            { "%%BAKU1926", "統一土耳其拉丁字母" },
            { "%%BISCAYAN", "比斯開方言" },
            { "%%COLB1945", "1945 年巴西葡萄牙文拼字標準" },
            { "%%FONXSAMP", "X-SAMPA 音標" },
            { "%%HOGNORSK", "高地挪威文" },
            { "%%IJEKAVSK", "耶卡發音塞爾維亞文" },
            { "%%JYUTPING", "香港語言學學會粵語拼音" },
            { "%%LUNA1918", "俄羅斯文拼字（1917年後）" },
            { "%%OXENDICT", "牛津英文字典拼音" },
            { "%%PETR1708", "俄羅斯文拼字（1708 年）" },
            { "%%SCOTLAND", "蘇格蘭標準英文" },
            { "%%SURMIRAN", "瑞士蘇邁拉方言" },
            { "%%VALENCIA", "瓦倫西亞文" },
            { "%%VALLADER", "瑞士瓦勒德方言" },
            { "%%WADEGILE", "威妥瑪式拼音" },
            { "type.ca.roc", "國曆" },
            { "type.co.eor", "歐洲排序規則" },
            { "type.hc.h11", "12 小時制 (0–11)" },
            { "type.hc.h12", "12 小時制 (1–12)" },
            { "type.hc.h23", "24 小時制 (0–23)" },
            { "type.hc.h24", "24 小時制 (1–24)" },
            { "type.m0.bgn", "美國地名委員會" },
            { "type.nu.ahom", "阿洪姆數字" },
            { "type.nu.arab", "阿拉伯-印度數字" },
            { "type.nu.armn", "亞美尼亞數字" },
            { "type.nu.bali", "峇里文數字" },
            { "type.nu.beng", "孟加拉數字" },
            { "type.nu.brah", "婆羅米數字" },
            { "type.nu.cakm", "查克馬數字" },
            { "type.nu.cham", "占文數字" },
            { "type.nu.cyrl", "西里爾數字" },
            { "type.nu.deva", "梵文數字" },
            { "type.nu.ethi", "衣索比亞數字" },
            { "type.nu.geor", "喬治亞數字" },
            { "type.nu.gonm", "馬薩拉姆貢地數字" },
            { "type.nu.grek", "希臘數字" },
            { "type.nu.gujr", "古吉拉特數字" },
            { "type.nu.guru", "古爾穆奇數字" },
            { "type.nu.hans", "小寫簡體中文數字" },
            { "type.nu.hant", "小寫繁體中文數字" },
            { "type.nu.hebr", "希伯來數字" },
            { "type.nu.hmng", "帕哈苗數字" },
            { "type.nu.java", "爪哇文數字" },
            { "type.nu.jpan", "小寫日文數字" },
            { "type.nu.kali", "克耶數字" },
            { "type.nu.khmr", "高棉數字" },
            { "type.nu.knda", "坎那達數字" },
            { "type.nu.lana", "老傣文數字" },
            { "type.nu.laoo", "寮國數字" },
            { "type.nu.latn", "阿拉伯數字" },
            { "type.nu.lepc", "西納文數字" },
            { "type.nu.limb", "林布文數字" },
            { "type.nu.mlym", "馬來亞拉姆數字" },
            { "type.nu.modi", "莫笛數字" },
            { "type.nu.mong", "蒙古數字" },
            { "type.nu.mroo", "默文數字" },
            { "type.nu.mtei", "曼尼普爾數字" },
            { "type.nu.mymr", "緬甸數字" },
            { "type.nu.nkoo", "曼德數字" },
            { "type.nu.olck", "桑塔利文數字" },
            { "type.nu.orya", "歐迪亞數字" },
            { "type.nu.osma", "奧斯曼亞數字" },
            { "type.nu.saur", "索拉什特拉文數字" },
            { "type.nu.shrd", "夏拉達數字" },
            { "type.nu.sind", "信德數字" },
            { "type.nu.sinh", "僧伽羅數字" },
            { "type.nu.sora", "索朗桑朋數字" },
            { "type.nu.sund", "巽他數字" },
            { "type.nu.takr", "塔卡里數字" },
            { "type.nu.talu", "新傣仂文數字" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "type.nu.telu", "泰盧固數字" },
            { "type.nu.thai", "泰文數字" },
            { "type.nu.tibt", "藏文數字" },
            { "type.nu.tirh", "提爾胡塔數字" },
            { "type.nu.vaii", "瓦伊文數字" },
            { "type.nu.wara", "瓦蘭齊地數字" },
            { "type.ca.dangi", "檀紀曆" },
            { "type.co.ducet", "預設 Unicode 排序" },
            { "type.co.emoji", metaValue_Zsye },
            { "type.lb.loose", "寬鬆換行樣式" },
            { "type.nu.roman", "羅馬數字" },
            { "type.ca.coptic", "科普特曆" },
            { "type.ca.hebrew", "希伯來曆" },
            { "type.ca.indian", "印度國曆" },
            { "type.co.compat", "舊制排序" },
            { "type.co.pinyin", "拼音排序" },
            { "type.co.search", "一般用途搜尋" },
            { "type.co.stroke", "筆畫排序" },
            { "type.co.unihan", "部首筆畫排序" },
            { "type.co.zhuyin", "注音排序" },
            { "type.d0.fwidth", "全形" },
            { "type.d0.hwidth", "半形" },
            { "type.lb.normal", "一般換行樣式" },
            { "type.lb.strict", "強制換行樣式" },
            { "type.m0.ungegn", "聯合國地名專家組" },
            { "type.ms.metric", "公制" },
            { "type.nu.native", "原始數字" },
            { "type.ca.chinese", "農曆" },
            { "type.ca.islamic", "伊斯蘭曆" },
            { "type.ca.iso8601", "ISO 8601 國際曆法" },
            { "type.ca.persian", "波斯曆" },
            { "type.cf.account", "會計貨幣格式" },
            { "type.co.big5han", "繁體中文排序 - Big5" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "阿拉伯-印度擴充數字" },
            { "type.nu.armnlow", "小寫亞美尼亞數字" },
            { "type.nu.finance", "金融數字" },
            { "type.nu.greklow", "小寫希臘數字" },
            { "type.nu.hanidec", "中文十進位數字" },
            { "type.nu.hansfin", "大寫簡體中文數字" },
            { "type.nu.hantfin", "大寫繁體中文數字" },
            { "type.nu.jpanfin", "大寫日文數字" },
            { "type.nu.mathdbl", "數學雙重數字" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "type.ca.buddhist", "佛曆" },
            { "type.ca.ethiopic", "衣索比亞曆" },
            { "type.ca.japanese", "日本曆" },
            { "type.cf.standard", "標準貨幣格式" },
            { "type.co.phonetic", "發音排序" },
            { "type.co.searchjl", "依諺文聲母搜尋" },
            { "type.co.standard", "標準排序" },
            { "type.ms.uksystem", "英制度量單位系統" },
            { "type.ms.ussystem", "美制度量單位系統" },
            { "type.nu.fullwide", "全形數字" },
            { "type.nu.lanatham", "蘭納文數字" },
            { "type.nu.mathbold", "數學粗體數字" },
            { "type.nu.mathmono", "數學等寬數字" },
            { "type.nu.mathsanb", "數學無襯線粗體數字" },
            { "type.nu.mathsans", "數學無襯線數字" },
            { "type.nu.mymrshan", "緬甸撣文數字" },
            { "type.nu.mymrtlng", "緬甸傣族數字" },
            { "type.nu.romanlow", "小寫羅馬數字" },
            { "type.ca.gregorian", "公曆" },
            { "type.co.gb2312han", "簡體中文排序 - GB2312" },
            { "type.co.phonebook", "電話簿排序" },
            { "ListKeyTypePattern", "{0}：{1}" },
            { "type.co.dictionary", "字典排序" },
            { "type.co.traditional", "傳統排序" },
            { "type.nu.traditional", "傳統數字" },
            { "type.ca.islamic-rgsa", "伊斯蘭新月曆" },
            { "type.ca.islamic-tbla", "伊斯蘭天文曆" },
            { "type.ca.islamic-civil", "伊斯蘭民用曆" },
            { "ListCompositionPattern", "{0}，{1}" },
            { "type.ca.islamic-umalqura", "伊斯蘭曆（烏姆庫拉）" },
            { "type.ca.ethiopic-amete-alem", "衣索比亞曆 (Amete Alem)" },
        };
        return data;
    }
}
