/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ee extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich gaƒoƒo me",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia nutome gaƒoƒo me",
               "",
               "Apia kele gaƒoƒo me",
               "",
               "Apia gaƒoƒo me",
               "",
            };
        final String[] Cook = new String[] {
               "Cook Islands nutome gaƒoƒo me",
               "",
               "Cook Islands dzomeŋɔli gaƒoƒo me",
               "",
               "Cook Islands gaƒoƒo me",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba nutome gaƒoƒome",
               "CST",
               "Cuba kele gaƒoƒome",
               "CDT",
               "Cuba gaƒoƒome",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji nutome gaƒoƒo me",
               "",
               "Fiji dzomeŋɔli gaƒoƒo me",
               "",
               "Fiji gaƒoƒo me",
               "",
            };
        final String[] Gulf = new String[] {
               "Gulf nutome gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd nutome gaƒoƒo me",
               "",
               "Hovd dzomeŋɔli gaƒoƒo me",
               "",
               "Hovd gaƒoƒo me",
               "",
            };
        final String[] Iran = new String[] {
               "Iran nutome gaƒoƒo me",
               "",
               "Iran kele gaƒoƒo me",
               "",
               "Iran gaƒoƒo me",
               "",
            };
        final String[] Niue = new String[] {
               "Niue gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk nutome gaƒoƒo me",
               "",
               "Omsk dzomeŋɔli gaƒoƒo me",
               "",
               "Omsk gaƒoƒo me",
               "",
            };
        final String[] Peru = new String[] {
               "Peru nutome gaƒoƒo me",
               "",
               "Peru dzomeŋɔli gaƒoƒome",
               "",
               "Peru gaƒoƒo me",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Island gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chile nutome gaƒoƒo me",
               "",
               "Chile dzomeŋɔli gaƒoƒo me",
               "",
               "Chile gaƒoƒo me",
               "",
            };
        final String[] China = new String[] {
               "China nutome gaƒoƒo me",
               "CST",
               "China kele gaƒoƒo me",
               "CDT",
               "China gaƒoƒo me",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India gaƒoƒo me",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan nutome gaƒoƒo me",
               "JST",
               "Japan dzomeŋɔli gaƒoƒo me",
               "JDT",
               "Japan gaƒoƒo me",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea nutome gaƒoƒo me",
               "KST",
               "Korea dzomeŋɔli gaƒoƒo me",
               "KST",
               "Korea gaƒoƒo me",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa nutome gaƒoƒo me",
               "SST",
               "Samoa kele gaƒoƒo me",
               "SST",
               "Samoa gaƒoƒo me",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga nutome gaƒoƒo me",
               "",
               "Tonga dzomeŋɔli gaƒoƒo me",
               "",
               "Tonga gaƒoƒo me",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska nutome gaƒoƒo me",
               "AKST",
               "Alaska kele gaƒoƒo me",
               "AKDT",
               "Alaska gaƒoƒome",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon nutome gaƒoƒo me",
               "",
               "Amazon dzomeŋɔli gaƒoƒo me",
               "",
               "Amazon gaƒoƒome",
               "",
            };
        final String[] Azores = new String[] {
               "Azores nutome gaƒoƒo me",
               "",
               "Azores dzomeŋɔli gaƒoƒo me",
               "",
               "Azores gaƒoƒo me",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Easter Island nutome gaƒoƒo me",
               "",
               "Easter Island dzomeŋɔli gaƒoƒo me",
               "",
               "Easter Island gaƒoƒo me",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel nutome gaƒoƒo me",
               "IST",
               "Israel kele gaƒoƒo me",
               "IDT",
               "Israel gaƒoƒo me",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moscow nutome gaƒoƒo me",
               "MSK",
               "Moscow dzomeŋɔli gaƒoƒo me",
               "MSK",
               "Moscow gaƒoƒo me",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei nutome gaƒoƒo me",
               "CST",
               "Taipei kele gaƒoƒo me",
               "CDT",
               "Taipei gaƒoƒo me",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis & Futuna gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabia nutome gaƒoƒo me",
               "",
               "Arabia dzomeŋɔli gaƒoƒo me",
               "",
               "Arabia gaƒoƒo me",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia nutome gaƒoƒo me",
               "",
               "Armenia dzomeŋɔli gaƒoƒo me",
               "",
               "Armenia gaƒoƒo me",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham nutome gaƒoƒo me",
               "",
               "Chatham kele gaƒoƒo me",
               "",
               "Chatham gaƒoƒo me",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Xexeme gaƒoƒoɖoanyi me",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuador gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia nutome gaƒoƒo me",
               "",
               "Georgia dzomeŋɔli gaƒoƒo me",
               "",
               "Georgia gaƒoƒo me",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk nutome gaƒoƒo me",
               "",
               "Irkutsk dzomeŋɔli gaƒoƒo me",
               "",
               "Irkutsk gaƒoƒo me",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan nutome gaƒoƒo me",
               "",
               "Magadan dzomeŋɔli gaƒoƒo me",
               "",
               "Magadan gaƒoƒo me",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Island nutome gaƒoƒo me",
               "",
               "Norfolk Island dzomeŋɔli gaƒoƒo me",
               "",
               "Norfolk Island gaƒoƒo me",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha nutome gaƒoƒo me",
               "",
               "Fernando de Noronha dzomeŋɔli gaƒoƒo me",
               "",
               "Fernando de Noronha gaƒoƒo me",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunion gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Islands gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguay nutome gaƒoƒo me",
               "",
               "Uruguay dzomeŋɔli gaƒoƒo me",
               "",
               "Uruguay gaƒoƒo me",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu nutome gaƒoƒo me",
               "",
               "Vanuatu dzomeŋɔli gaƒoƒo me",
               "",
               "Vanuatu gaƒoƒo me",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk nutome gaƒoƒo me",
               "",
               "Yakutsk dzomeŋɔli gaƒoƒo me",
               "",
               "Yakutsk gaƒoƒo me",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic nutome gaƒoƒome",
               "AST",
               "Atlantic kele gaƒoƒome",
               "AST",
               "Atlantic gaƒoƒome",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia nutome gaƒoƒo me",
               "",
               "Brasilia dzomeŋɔli gaƒoƒo me",
               "",
               "Brasilia gaƒoƒo me",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro gaƒoƒo me",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombia nutome gaƒoƒo me",
               "",
               "Colombia dzomeŋɔli gaƒoƒo me",
               "",
               "Colombia gaƒoƒo me",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland Islands nutome gaƒoƒo me",
               "",
               "Falkland Islands dzomeŋɔli gaƒoƒo me",
               "",
               "Falkland Islands gaƒoƒo me",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysia gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator nutome gaƒoƒo me",
               "",
               "Ulan Bator dzomeŋɔli gaƒoƒo me",
               "",
               "Ulan Bator gaƒoƒo me",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan nutome gaƒoƒo me",
               "PKT",
               "Pakistan dzomeŋɔli gaƒoƒo me",
               "PKST",
               "Pakistan gaƒoƒo me",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay nutome gaƒoƒo me",
               "",
               "Paraguay dzomeŋɔli gaƒoƒo me",
               "",
               "Paraguay gaƒoƒo me",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin nutome gaƒoƒo me",
               "",
               "Sakhalin dzomeŋɔli gaƒoƒo me",
               "",
               "Sakhalin gaƒoƒo me",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname gaƒoƒome",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina nutome gaƒoƒo me",
               "",
               "Argentina dzomeŋɔli gaƒoƒo me",
               "",
               "Argentina gaƒoƒo me",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmas Island gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong nutome gaƒoƒo me",
               "HKT",
               "Hong Kong dzomeŋɔli gaƒoƒo me",
               "HKST",
               "Hong Kong gaƒoƒo me",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indonesia gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgystan gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe nutome gaƒoƒo me",
               "",
               "Lord Howe kele gaƒoƒo me",
               "",
               "Lord Howe gaƒoƒo me",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius nutome gaƒoƒo me",
               "",
               "Mauritius dzomeŋɔli gaƒoƒo me",
               "",
               "Mauritius gaƒoƒo me",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore nutome gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd nutome gaƒoƒo me",
               "MSK",
               "Vogograd dzomeŋɔli gaƒoƒo me",
               "MSK",
               "Volgograd gaƒoƒo me",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijan nutome gaƒoƒo me",
               "",
               "Azerbaijan dzomeŋɔli gaƒoƒo me",
               "",
               "Azerbaijan gaƒoƒo me",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh nutome gaƒoƒo me",
               "",
               "Bangladesh dzomeŋɔli gaƒoƒo me",
               "",
               "Bangladesh gaƒoƒo me",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde nutome gaƒoƒo me",
               "",
               "Cape Verde dzomeŋɔli gaƒoƒo me",
               "",
               "Cape Verde gaƒoƒo me",
               "",
            };
        final String[] East_Timor = new String[] {
               "East Timor gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tajikistan gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan nutome gaƒoƒo me",
               "",
               "Uzbekistan dzomeŋɔli gaƒoƒo me",
               "",
               "Uzbekistan gaƒoƒo me",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk nutome gaƒoƒo me",
               "",
               "Krasnoyarsk dzomeŋɔli gaƒoƒo me",
               "",
               "Krasnoyarsk gaƒoƒo me",
               "",
            };
        final String[] New_Zealand = new String[] {
               "New Zealand nutome gaƒoƒo me",
               "NZST",
               "New Zealand kele gaƒoƒo me",
               "NZDT",
               "New Zealand gaƒoƒo me",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk nutome gaƒoƒo me",
               "",
               "Novosibirsk dzomeŋɔli gaƒoƒo me",
               "",
               "Novosibirsk gaƒoƒo me",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippine nutome gaƒoƒo me",
               "PST",
               "Philippine dzomeŋɔli gaƒoƒo me",
               "PDT",
               "Philippine gaƒoƒo me",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok nutome gaƒoƒo me",
               "",
               "Vladivostok dzomeŋɔli gaƒoƒo me",
               "",
               "Vladivostok gaƒoƒo me",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indian Ocean gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line Islands gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland nutome gaƒoƒome",
               "NST",
               "Newfoundland kele gaƒoƒome",
               "NDT",
               "Newfoundland gaƒoƒome",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan nutome gaƒoƒo me",
               "",
               "Turkmenistan dzomeŋɔli gaƒoƒo me",
               "",
               "Turkmenistan gaƒoƒo me",
               "",
            };
        final String[] French_Guiana = new String[] {
               "French Guiana gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "New Caledonia nutome gaƒoƒo me",
               "",
               "New Caledonia dzomeŋɔli gaƒoƒo me",
               "",
               "New Caledonia gaƒoƒo me",
               "",
            };
        final String[] South_Georgia = new String[] {
               "South Georgia gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg nutome gaƒoƒo me",
               "",
               "Yekaterinburg dzomeŋɔli gaƒoƒo me",
               "",
               "Yekaterinburg gaƒoƒo me",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Central Africa gaƒoƒo me",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "East Africa gaƒoƒo me",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "West Africa nutome gaƒoƒo me",
               "WAT",
               "West Africa dzomeŋɔli gaƒoƒo me",
               "WAST",
               "West Africa game",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Central Europe nutome gaƒoƒo me",
               "CET",
               "Central Europe dzomeŋɔli gaƒoƒo me",
               "CEST",
               "Central Europe gaƒoƒo me",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ɣedzeƒe Europe gaƒoƒoɖoanyime",
               "EET",
               "Ɣedzeƒe Europe ŋkekeme gaƒoƒome",
               "EEST",
               "Ɣedzeƒe Europe gaƒoƒome",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Western Europe nutome gaƒoƒo me",
               "WET",
               "Western Europe dzomeŋɔli gaƒoƒo me",
               "WEST",
               "Western Europe gaƒoƒo me",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific nutome gaƒoƒo me",
               "MST",
               "Mexican Pacific kele gaƒoƒome",
               "MDT",
               "Mexican Pacific gaƒoƒo me",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa nutome gaƒoƒo me",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Titina America nutome gaƒoƒo me",
               "CST",
               "Titina America kele gaƒoƒo me",
               "CDT",
               "Titina America gaƒoƒome",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern America nutome gaƒoƒo me",
               "EST",
               "Eastern America kele gaƒoƒo me",
               "EST",
               "Eastern America gaƒoƒo me",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pacific nutome gaƒoƒo me",
               "PST",
               "Pacific kele gaƒoƒo me",
               "PDT",
               "Pacific gaƒoƒome",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "French Southern & Antarctic gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Islands gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutia nutome gaƒoƒo me",
               "HST",
               "Hawaii-Aleutia kele gaƒoƒo me",
               "HST",
               "Hawaii-Aleutia gaƒoƒo me",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Islands gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon nutome gaƒoƒome",
               "",
               "St. Pierre & Miquelon kele gaƒoƒome",
               "",
               "St. Pierre & Miquelon gaƒoƒome",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain nutome gaƒoƒo me",
               "MST",
               "Mountain kele gaƒoƒo me",
               "MST",
               "Mountain gaƒoƒo me",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Islands gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua New Guinea gaƒoƒo me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australian Central nutome gaƒoƒo me",
               "ACST",
               "Australian Central dzomeli gaƒoƒo me",
               "ACDT",
               "Central Australia gaƒoƒo me",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern nutome gaƒoƒo me",
               "AEST",
               "Australian Eastern kele gaƒoƒo me",
               "AEDT",
               "Eastern Australia gaƒoƒo me",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western nutome gaƒoƒo me",
               "AWST",
               "Australian Western kele gaƒoƒo me",
               "AWDT",
               "Western Australia gaƒoƒo me",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia gaƒoƒo me",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia gaƒoƒo me",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia gaƒoƒo me",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western nutome gaƒoƒo me",
               "",
               "Australian Central Western kele gaƒoƒo me",
               "",
               "Australian Central Australia ɣetoɖofe gaƒoƒo me",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Xexeme gaƒoƒoɖoanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "Ireland nutome gaƒoƒo me",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Xexeme gaƒoƒoɖoanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Xexeme gaƒoƒoɖoanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Xexeme gaƒoƒoɖoanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Xexeme gaƒoƒoɖoanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Xexeme gaƒoƒoɖoanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "Ireland nutome gaƒoƒo me",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich gaƒoƒo me",
                    "GMT",
                    "British dzomeŋɔli gaƒoƒo me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Du manya" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Katmandu", "Kathmandu nutomegaƒoƒome" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
        };
        return data;
    }
}
