/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ca extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "àrab";
        final String metaValue_hy = "armeni";
        final String metaValue_ae = "avèstic";
        final String metaValue_ban = "balinès";
        final String metaValue_bax = "bamum";
        final String metaValue_bn = "bengalí";
        final String metaValue_zbl = "símbols Bliss";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copte";
        final String metaValue_ka = "georgià";
        final String metaValue_got = "gòtic";
        final String metaValue_el = "grec";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreu";
        final String metaValue_jv = "javanès";
        final String metaValue_ja = "japonès";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreà";
        final String metaValue_kpe = "kpelle";
        final String metaValue_la = "llatí";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malaiàlam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmà";
        final String metaValue_nqo = "n’Ko";
        final String metaValue_sat = "santali";
        final String metaValue_or = "oriya";
        final String metaValue_osa = "osage";
        final String metaValue_pal = "pahlavi";
        final String metaValue_phn = "fenici";
        final String metaValue_si = "singalès";
        final String metaValue_syr = "siríac";
        final String metaValue_ta = "tàmil";
        final String metaValue_te = "telugu";
        final String metaValue_bo = "tibetà";
        final String metaValue_uga = "ugarític";
        final String metaValue_peo = "persa antic";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Món" },
            { "002", "Àfrica" },
            { "003", "Amèrica del Nord" },
            { "005", "Amèrica del Sud" },
            { "009", "Oceania" },
            { "011", "Àfrica occidental" },
            { "013", "Amèrica Central" },
            { "014", "Àfrica oriental" },
            { "015", "Àfrica septentrional" },
            { "017", "Àfrica central" },
            { "018", "Àfrica meridional" },
            { "019", "Amèrica" },
            { "021", "Amèrica septentrional" },
            { "029", "Carib" },
            { "030", "Àsia oriental" },
            { "034", "Àsia meridional" },
            { "035", "Àsia sud-oriental" },
            { "039", "Europa meridional" },
            { "053", "Australàsia" },
            { "054", "Melanèsia" },
            { "057", "Regió de la Micronèsia" },
            { "061", "Polinèsia" },
            { "142", "Àsia" },
            { "143", "Àsia central" },
            { "145", "Àsia occidental" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "155", "Europa occidental" },
            { "202", "Àfrica subsahariana" },
            { "419", "Amèrica Llatina" },
            { "AC", "Illa de l’Ascensió" },
            { "AD", "Andorra" },
            { "AE", "Emirats Àrabs Units" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albània" },
            { "AM", "Armènia" },
            { "AO", "Angola" },
            { "AQ", "Antàrtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Àustria" },
            { "AU", "Austràlia" },
            { "AW", "Aruba" },
            { "AX", "Illes Åland" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bòsnia i Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Bèlgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgària" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benín" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermudes" },
            { "BN", "Brunei" },
            { "BO", "Bolívia" },
            { "BQ", "Carib Neerlandès" },
            { "BR", "Brasil" },
            { "BS", "Bahames" },
            { "BT", "Bhutan" },
            { "BV", "Illa Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarús" },
            { "BZ", "Belize" },
            { "CA", "Canadà" },
            { "CC", "Illes Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "República Centreafricana" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Suïssa" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Illes Cook" },
            { "CL", "Xile" },
            { "CM", "Camerun" },
            { "CN", "Xina" },
            { "CO", "Colòmbia" },
            { "CP", "Illa Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap Verd" },
            { "CW", "Curaçao" },
            { "CX", "Illa Christmas" },
            { "CY", "Xipre" },
            { "CZ", "Txèquia" },
            { "DE", "Alemanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "República Dominicana" },
            { "DZ", "Algèria" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Equador" },
            { "EE", "Estònia" },
            { "EG", "Egipte" },
            { "EH", "Sàhara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espanya" },
            { "ET", "Etiòpia" },
            { "EU", "Unió Europea" },
            { "EZ", "zona euro" },
            { "FI", "Finlàndia" },
            { "FJ", "Fiji" },
            { "FK", "Illes Falkland" },
            { "FM", "Micronèsia" },
            { "FO", "Illes Fèroe" },
            { "FR", "França" },
            { "GA", "Gabon" },
            { "GB", "Regne Unit" },
            { "GD", "Grenada" },
            { "GE", "Geòrgia" },
            { "GF", "Guaiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlàndia" },
            { "GM", "Gàmbia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Equatorial" },
            { "GR", "Grècia" },
            { "GS", "Illes Geòrgia del Sud i Sandwich del Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong (RAE Xina)" },
            { "HM", "Illes Heard i McDonald" },
            { "HN", "Hondures" },
            { "HR", "Croàcia" },
            { "HT", "Haití" },
            { "HU", "Hongria" },
            { "IC", "Illes Canàries" },
            { "ID", "Indonèsia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Illa de Man" },
            { "IN", "Índia" },
            { "IO", "Territori Britànic de l’Oceà Índic" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islàndia" },
            { "IT", "Itàlia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordània" },
            { "JP", "Japó" },
            { "KE", "Kenya" },
            { "KG", "Kirguizstan" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint Kitts i Nevis" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "KW", "Kuwait" },
            { "KY", "Illes Caiman" },
            { "KZ", "Kazakhstan" },
            { "LA", "Lao" },
            { "LB", "Líban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libèria" },
            { "LS", "Lesotho" },
            { "LT", "Lituània" },
            { "LU", "Luxemburg" },
            { "LV", "Letònia" },
            { "LY", "Líbia" },
            { "MA", "Marroc" },
            { "MC", "Mònaco" },
            { "MD", "Moldàvia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Illes Marshall" },
            { "MK", "Macedònia del Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmània)" },
            { "MN", "Mongòlia" },
            { "MO", "Macau (RAE Xina)" },
            { "MP", "Illes Marianes del Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauritània" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurici" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mèxic" },
            { "MY", "Malàisia" },
            { "MZ", "Moçambic" },
            { "NA", "Namíbia" },
            { "NC", "Nova Caledònia" },
            { "NE", "Níger" },
            { "NF", "Illa Norfolk" },
            { "NG", "Nigèria" },
            { "NI", "Nicaragua" },
            { "NL", "Països Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelanda" },
            { "OM", "Oman" },
            { "PA", "Panamà" },
            { "PE", "Perú" },
            { "PF", "Polinèsia Francesa" },
            { "PG", "Papua Nova Guinea" },
            { "PH", "Filipines" },
            { "PK", "Pakistan" },
            { "PL", "Polònia" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Illes Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territoris palestins" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Qatar" },
            { "QO", "Territoris allunyats d’Oceania" },
            { "RE", "Illa de la Reunió" },
            { "RO", "Romania" },
            { "RS", "Sèrbia" },
            { "RU", "Rússia" },
            { "RW", "Ruanda" },
            { "SA", "Aràbia Saudí" },
            { "SB", "Illes Salomó" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Suècia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovènia" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "Eslovàquia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somàlia" },
            { "SR", "Surinam" },
            { "SS", "Sudan del Sud" },
            { "ST", "São Tomé i Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Síria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Illes Turks i Caicos" },
            { "TD", "Txad" },
            { "TF", "Terres Australs Antàrtiques Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailàndia" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunísia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzània" },
            { "UA", "Ucraïna" },
            { "UG", "Uganda" },
            { "UM", "Illes Menors Allunyades dels Estats Units" },
            { "UN", "Nacions Unides" },
            { "US", "Estats Units" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Ciutat del Vaticà" },
            { "VC", "Saint Vincent i les Grenadines" },
            { "VE", "Veneçuela" },
            { "VG", "Illes Verges Britàniques" },
            { "VI", "Illes Verges dels Estats Units" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudoaccents" },
            { "XB", "pseudobidi" },
            { "XK", "Kosovo" },
            { "YE", "Iemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud-àfrica" },
            { "ZM", "Zàmbia" },
            { "ZW", "Zimbàbue" },
            { "ZZ", "regió desconeguda" },
            { "aa", "àfar" },
            { "ab", "abkhaz" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "àkan" },
            { "am", "amhàric" },
            { "an", "aragonès" },
            { "ar", metaValue_ar },
            { "as", "assamès" },
            { "av", "àvar" },
            { "ay", "aimara" },
            { "az", "azerbaidjanès" },
            { "ba", "baixkir" },
            { "be", "belarús" },
            { "bg", "búlgar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretó" },
            { "bs", "bosnià" },
            { "ca", "català" },
            { "ce", "txetxè" },
            { "ch", "chamorro" },
            { "co", "cors" },
            { "cr", "cree" },
            { "cs", "txec" },
            { "cu", "eslau eclesiàstic" },
            { "cv", "txuvaix" },
            { "cy", "gal·lès" },
            { "da", "danès" },
            { "de", "alemany" },
            { "dv", "divehi" },
            { "dz", "dzongka" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "anglès" },
            { "eo", "esperanto" },
            { "es", "espanyol" },
            { "et", "estonià" },
            { "eu", "basc" },
            { "fa", "persa" },
            { "ff", "ful" },
            { "fi", "finès" },
            { "fj", "fijià" },
            { "fo", "feroès" },
            { "fr", "francès" },
            { "fy", "frisó occidental" },
            { "ga", "irlandès" },
            { "gd", "gaèlic escocès" },
            { "gl", "gallec" },
            { "gn", "guaraní" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "haussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croat" },
            { "ht", "crioll d’Haití" },
            { "hu", "hongarès" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesi" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi sichuan" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandès" },
            { "it", "italià" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuiu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandès" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "caixmiri" },
            { "ku", "kurd" },
            { "kv", "komi" },
            { "kw", "còrnic" },
            { "ky", "kirguís" },
            { "la", metaValue_la },
            { "lb", "luxemburguès" },
            { "lg", "ganda" },
            { "li", "limburguès" },
            { "ln", "lingala" },
            { "lo", "laosià" },
            { "lt", "lituà" },
            { "lu", "luba katanga" },
            { "lv", "letó" },
            { "mg", "malgaix" },
            { "mh", "marshallès" },
            { "mi", "maori" },
            { "mk", "macedoni" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malai" },
            { "mt", "maltès" },
            { "my", metaValue_my },
            { "na", "nauruà" },
            { "nb", "noruec bokmål" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepalès" },
            { "ng", "ndonga" },
            { "nl", "neerlandès" },
            { "nn", "noruec nynorsk" },
            { "no", "noruec" },
            { "nr", "ndebele meridional" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "occità" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osseta" },
            { "pa", "panjabi" },
            { "pi", "pali" },
            { "pl", "polonès" },
            { "ps", "paixtu" },
            { "pt", "portuguès" },
            { "qu", "quítxua" },
            { "rm", "retoromànic" },
            { "rn", "rundi" },
            { "ro", "romanès" },
            { "ru", "rus" },
            { "rw", "ruandès" },
            { "sa", "sànscrit" },
            { "sc", "sard" },
            { "sd", "sindi" },
            { "se", "sami septentrional" },
            { "sg", "sango" },
            { "sh", "serbocroat" },
            { "si", metaValue_si },
            { "sk", "eslovac" },
            { "sl", "eslovè" },
            { "sm", "samoà" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanès" },
            { "sr", "serbi" },
            { "ss", "swazi" },
            { "st", "sotho meridional" },
            { "su", "sondanès" },
            { "sv", "suec" },
            { "sw", "suahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjik" },
            { "th", "tai" },
            { "ti", "tigrinya" },
            { "tk", "turcman" },
            { "tl", "tagal" },
            { "tn", "setswana" },
            { "to", "tongalès" },
            { "tr", "turc" },
            { "ts", "tsonga" },
            { "tt", "tàtar" },
            { "tw", "twi" },
            { "ty", "tahitià" },
            { "ug", "uigur" },
            { "uk", "ucraïnès" },
            { "ur", "urdú" },
            { "uz", "uzbek" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapük" },
            { "wa", "való" },
            { "wo", "wòlof" },
            { "xh", "xosa" },
            { "yi", "ídix" },
            { "yo", "ioruba" },
            { "za", "zhuang" },
            { "zh", "xinès" },
            { "zu", "zulu" },
            { "ace", "atjeh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigué" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "accadi" },
            { "akz", "alabama" },
            { "ale", "aleuta" },
            { "aln", "albanès geg" },
            { "alt", "altaic meridional" },
            { "ang", "anglès antic" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameu" },
            { "arn", "mapudungu" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "ars", "àrab najdi" },
            { "arw", "arauac" },
            { "arz", "àrab egipci" },
            { "asa", "pare" },
            { "ase", "llengua de signes americana" },
            { "ast", "asturià" },
            { "atj", "atacama" },
            { "awa", "awadhi" },
            { "bal", "balutxi" },
            { "ban", metaValue_ban },
            { "bar", "bavarès" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "balutxi occidental" },
            { "bho", "bhojpuri" },
            { "bik", "bicol" },
            { "bin", "edo" },
            { "bkm", "kom" },
            { "bla", "blackfoot" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", "bugui" },
            { "bum", "bulu" },
            { "byn", "bilin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "carib" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuà" },
            { "cgg", "chiga" },
            { "chb", "txibtxa" },
            { "chg", "txagatai" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "pidgin chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "xeiene" },
            { "ckb", "kurd central" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "tàtar de Crimea" },
            { "crj", "cree sud-oriental" },
            { "crk", "cree de la plana" },
            { "crl", "cree nord-oriental" },
            { "crm", "moose cree" },
            { "crr", "algonquí de Carolina" },
            { "crs", "francès crioll de les Seychelles" },
            { "csb", "caixubi" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "darguà" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slavi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baix sòrab" },
            { "dua", "douala" },
            { "dum", "neerlandès mitjà" },
            { "dyo", "diola" },
            { "dyu", "jula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emilià" },
            { "egy", "egipci antic" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "anglès mitjà" },
            { "ewo", "ewondo" },
            { "ext", "extremeny" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipí" },
            { "fon", "fon" },
            { "frc", "francès cajun" },
            { "frm", "francès mitjà" },
            { "fro", "francès antic" },
            { "frr", "frisó septentrional" },
            { "frs", "frisó oriental" },
            { "fur", "friülà" },
            { "gaa", "ga" },
            { "gag", "gagaús" },
            { "gan", "xinès gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "gueez" },
            { "gil", "gilbertès" },
            { "glk", "gilaki" },
            { "gmh", "alt alemany mitjà" },
            { "goh", "alt alemany antic" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grec antic" },
            { "gsw", "alemany suís" },
            { "guc", "wayú" },
            { "guz", "gusí" },
            { "gwi", "gwich’in" },
            { "hai", "haida" },
            { "hak", "xinès hakka" },
            { "haw", "hawaià" },
            { "hax", "haida meridional" },
            { "hif", "hindi de Fiji" },
            { "hil", "híligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "alt sòrab" },
            { "hsn", "xinès xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut occidental canadenc" },
            { "ilo", "ilocano" },
            { "inh", "ingúix" },
            { "jam", "crioll anglès de Jamaica" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "judeopersa" },
            { "jrb", "judeoàrab" },
            { "kaa", "karakalpak" },
            { "kab", "cabilenc" },
            { "kac", "katxin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardí" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "crioll capverdià" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingà" },
            { "kha", "khasi" },
            { "kho", "khotanès" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiac" },
            { "kok", "concani" },
            { "kos", "kosraeà" },
            { "kpe", metaValue_kpe },
            { "krc", "karatxai-balkar" },
            { "kri", "krio" },
            { "krl", "carelià" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kúmik" },
            { "kut", "kutenai" },
            { "kwk", "kwak’wala" },
            { "kxv", "kuvi" },
            { "lad", "judeocastellà" },
            { "lag", "langi" },
            { "lah", "panjabi occidental" },
            { "lam", "lamba" },
            { "lez", "lesguià" },
            { "lij", "lígur" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "llombard" },
            { "lol", "mongo" },
            { "lou", "crioll francès de Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri septentrional" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luisenyo" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "lzh", "xinès clàssic" },
            { "lzz", "laz" },
            { "mad", "madurès" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassar" },
            { "man", "mandinga" },
            { "mas", "massai" },
            { "mde", "maba" },
            { "mdf", "mordovià moksa" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "mauricià" },
            { "mga", "gaèlic irlandès mitjà" },
            { "mgh", "makhuwa-metto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manxú" },
            { "mni", "manipurí" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moore" },
            { "mrj", "mari occidental" },
            { "mua", "mundang" },
            { "mul", "llengües vàries" },
            { "mus", "creek" },
            { "mwl", "mirandès" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "mordovià erza" },
            { "mzn", "mazanderani" },
            { "nan", "xinès min del sud" },
            { "nap", "napolità" },
            { "naq", "nama" },
            { "nds", "baix alemany" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueà" },
            { "nmg", "bissio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "nòrdic antic" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho septentrional" },
            { "nus", "nuer" },
            { "nwc", "newari clàssic" },
            { "nym", "nyamwesi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "ojb", "ojibwa septentrional" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa occidental" },
            { "oka", "okanagà" },
            { "osa", metaValue_osa },
            { "ota", "turc otomà" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "pam", "pampanga" },
            { "pap", "papiament" },
            { "pau", "palauà" },
            { "pcd", "picard" },
            { "pcm", "pidgin de Nigèria" },
            { "pdc", "alemany pennsilvanià" },
            { "peo", metaValue_peo },
            { "pfl", "alemany palatí" },
            { "phn", metaValue_phn },
            { "pis", "pidgin" },
            { "pms", "piemontès" },
            { "pnt", "pòntic" },
            { "pon", "ponapeà" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prussià" },
            { "pro", "provençal antic" },
            { "quc", "k’iche’" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongà" },
            { "rgn", "romanyès" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "romaní" },
            { "rup", "aromanès" },
            { "rwk", "rwo" },
            { "sad", "sandawe" },
            { "sah", "iacut" },
            { "sam", "arameu samarità" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", metaValue_sat },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilià" },
            { "sco", "escocès" },
            { "sdc", "sasserès" },
            { "sdh", "kurd meridional" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "songhai oriental" },
            { "sga", "irlandès antic" },
            { "shi", "taixelhit" },
            { "shn", "xan" },
            { "shu", "àrab txadià" },
            { "sid", "sidamo" },
            { "slh", "lushootseed meridional" },
            { "sma", "sami meridional" },
            { "smj", "sami lule" },
            { "smn", "sami d’Inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdià" },
            { "srn", "sranan" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "str", "straits salish" },
            { "suk", "sukuma" },
            { "sus", "susú" },
            { "sux", "sumeri" },
            { "swb", "comorià" },
            { "syc", "siríac clàssic" },
            { "syr", metaValue_syr },
            { "szl", "silesià" },
            { "tce", "tutxone meridional" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "terena" },
            { "tet", "tètum" },
            { "tgx", "tagish" },
            { "tht", "tahltà" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelauès" },
            { "tkr", "tsakhur" },
            { "tlh", "klingonià" },
            { "tli", "tlingit" },
            { "tly", "talix" },
            { "tmh", "amazic" },
            { "tog", "tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshià" },
            { "ttm", "tutxone septentrional" },
            { "ttt", "tat meridional" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluà" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinià" },
            { "tzm", "amazic del Marroc central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "idioma desconegut" },
            { "vec", "vènet" },
            { "vep", "vepse" },
            { "vls", "flamenc occidental" },
            { "vmw", "makua" },
            { "vot", "vòtic" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "xinès wu" },
            { "xal", "calmuc" },
            { "xmf", "mingrelià" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapeà" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatú" },
            { "yue", "cantonès" },
            { "zap", "zapoteca" },
            { "zbl", metaValue_zbl },
            { "zea", "zelandès" },
            { "zen", "zenaga" },
            { "zgh", "amazic estàndard marroquí" },
            { "zun", "zuni" },
            { "zxx", "sense contingut lingüístic" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Aghb", "albanès caucàsic" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nasta’liq" },
            { "Armi", "arameu imperial" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "buginès" },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "sil·labari aborigen canadenc unificat" },
            { "Cari", "carià" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "xipriota" },
            { "Cyrl", "ciríl·lic" },
            { "Cyrs", "ciríl·lic de l’antic eslau eclesiàstic" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Dupl", "taquigrafia Duployé" },
            { "Egyd", "demòtic egipci" },
            { "Egyh", "hieràtic egipci" },
            { "Egyp", "jeroglífic egipci" },
            { "Elba", "elbasan" },
            { "Ethi", "etiòpic" },
            { "Geok", "georgià hucuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolític" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han amb bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificat" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "jeroglífic anatoli" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "sil·labaris japonesos" },
            { "Hung", "hongarès antic" },
            { "Inds", "escriptura de la vall de l’Indus" },
            { "Ital", "cursiva antiga" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "jürchen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khoja" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "llatí fraktur" },
            { "Latg", "llatí gaèlic" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineal A" },
            { "Linb", "lineal B" },
            { "Lisu", "lisu" },
            { "Loma", "loma" },
            { "Lyci", "lici" },
            { "Lydi", "lidi" },
            { "Mahj", "mahajani" },
            { "Mand", "mandaic" },
            { "Mani", "maniqueu" },
            { "Maya", "jeroglífics maies" },
            { "Mend", metaValue_men },
            { "Merc", "cursiva meroítica" },
            { "Mero", "meroític" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mro" },
            { "Mtei", "manipuri" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Narb", "antic nord-aràbic" },
            { "Nbat", "nabateu" },
            { "Newa", "newar" },
            { "Nkgb", "geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nü shu" },
            { "Ogam", "ogham" },
            { "Olck", metaValue_sat },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmanya" },
            { "Palm", "palmirè" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "antic pèrmic" },
            { "Phag", "phagspa" },
            { "Phli", "pahlavi inscripcional" },
            { "Phlp", "psalter pahlavi" },
            { "Phlv", metaValue_pal },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollard miao" },
            { "Prti", "parthià inscripcional" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongo-rongo" },
            { "Runr", "rúnic" },
            { "Samr", "samarità" },
            { "Sara", "sarati" },
            { "Sarb", "sud-aràbic antic" },
            { "Saur", "saurashtra" },
            { "Sgnw", "escriptura de signes" },
            { "Shaw", "shavià" },
            { "Shrd", "shrada" },
            { "Sidd", "siddham" },
            { "Sind", "devangari" },
            { "Sinh", metaValue_si },
            { "Sora", "sora sompeng" },
            { "Sund", "sundanès" },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siríac estrangelo" },
            { "Syrj", "siríac occidental" },
            { "Syrn", "siríac oriental" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "nou tai lue" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinag" },
            { "Tglg", "tagàlog" },
            { "Thaa", "thaana" },
            { "Thai", "tailandès" },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhut" },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Visp", "llenguatge visible" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneïforme sumeri-accadi" },
            { "Yiii", "yi" },
            { "Zinh", "heretat" },
            { "Zmth", "notació matemàtica" },
            { "Zsye", "emoji" },
            { "Zsym", "símbols" },
            { "Zxxx", "sense escriptura" },
            { "Zyyy", "comú" },
            { "Zzzz", "escriptura desconeguda" },
            { "de_AT", "alemany austríac" },
            { "de_CH", "alemany estàndard suís" },
            { "en_AU", "anglès australià" },
            { "en_CA", "anglès canadenc" },
            { "en_GB", "anglès britànic" },
            { "en_US", "anglès americà" },
            { "es_ES", "espanyol europeu" },
            { "es_MX", "espanyol de Mèxic" },
            { "fa_AF", "dari" },
            { "fr_CA", "francès canadenc" },
            { "fr_CH", "francès suís" },
            { "nl_BE", "flamenc" },
            { "pt_BR", "portuguès del Brasil" },
            { "pt_PT", "portuguès de Portugal" },
            { "ro_MD", "moldau" },
            { "sw_CD", "suahili del Congo" },
            { "%%1901", "ortografia alemanya tradicional" },
            { "%%1994", "ortografia resiana estandarditzada" },
            { "%%1996", "ortografia alemanya de 1996" },
            { "ar_001", "àrab estàndard modern" },
            { "es_419", "espanyol llatinoamericà" },
            { "key.ca", "calendari" },
            { "key.cf", "format de moneda" },
            { "key.co", "ordre" },
            { "key.cu", "moneda" },
            { "key.hc", "sistema horari (12 h o 24 h)" },
            { "key.lb", "estil de salt de línia" },
            { "key.ms", "sistema de mesures" },
            { "key.nu", "xifres" },
            { "key.tz", "zona horària" },
            { "key.va", "variant local" },
            { "nds_NL", "baix saxó" },
            { "%%ALUKU", "dialecte aluku" },
            { "%%BISKE", "dialecte de San Giorgio/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%JAUER", "jauer" },
            { "%%KKCOR", "ortografia comuna" },
            { "%%LIPAW", "dialecte Lipovaz del resià" },
            { "%%NEDIS", "dialecte de Natisone" },
            { "%%NJIVA", "dialecte de Gniva/Njiva" },
            { "%%OSOJS", "dialecte d’Oseacco/Osojane" },
            { "%%POSIX", "ordinador" },
            { "%%PUTER", "alt engiadinès" },
            { "%%ROZAJ", "resià" },
            { "%%RUMGR", "interomanx" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialecte de Stolvizza/Solbica" },
            { "%%UCCOR", "ortografia unificada" },
            { "zh_Hans", "xinès simplificat" },
            { "zh_Hant", "xinès tradicional" },
            { "%%FONIPA", "alfabet fonètic internacional" },
            { "%%FONUPA", "sistema fonètic UPA" },
            { "%%NDYUKA", "dialecte ndyuka" },
            { "%%PAMAKA", "dialecte pamaka" },
            { "%%PINYIN", "romanització Pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortografia taraskievica" },
            { "%%UCRCOR", "ortografia revisada unificada" },
            { "%%ULSTER", "ulster" },
            { "%%ALALC97", "romanització ALA/LC, edició de 1997" },
            { "%%AREVELA", "armeni oriental" },
            { "%%AREVMDA", "armeni occidental" },
            { "%%BAUDDHA", "bauddha" },
            { "%%HEPBURN", "romanització Hepburn" },
            { "%%ITIHASA", "itihasa" },
            { "%%LAUKIKA", "laukika" },
            { "%%MONOTON", "monotònic" },
            { "%%POLYTON", "politònic" },
            { "%%REVISED", "ortografia revisada" },
            { "%%SURSILV", "sobreselvà" },
            { "%%SUTSILV", "sotaselvà" },
            { "%%VAIDIKA", "vèdic" },
            { "%%1606NICT", "francès mitjà tardà fins el 1606" },
            { "%%1694ACAD", "francès modern primerenc" },
            { "%%1959ACAD", "acadèmica" },
            { "%%BAKU1926", "alfabet llatí turc unificat" },
            { "%%BISCAYAN", "basc biscaí" },
            { "%%FONXSAMP", "sistema X-SAMPA" },
            { "%%HOGNORSK", "høgnorsk" },
            { "%%JYUTPING", "jyupting" },
            { "%%LUNA1918", "luna 1918" },
            { "%%PETR1708", "ortografia russa 1708–1917" },
            { "%%SCOTLAND", "anglès estàndard d’Escòcia" },
            { "%%SURMIRAN", "surmiran" },
            { "%%VALENCIA", "valencià" },
            { "%%VALLADER", "baix engiadinès" },
            { "%%WADEGILE", "romanització Wade-Giles" },
            { "type.ca.roc", "calendari de la República de Xina" },
            { "type.co.eor", "normes europees d’ordenació" },
            { "type.hc.h11", "sistema de 12 hores (0–11)" },
            { "type.hc.h12", "sistema de 12 hores (1–12)" },
            { "type.hc.h23", "sistema de 24 hores (0–23)" },
            { "type.hc.h24", "sistema de 24 hores (1–24)" },
            { "type.m0.bgn", "sistema de transliteració BGN" },
            { "type.nu.arab", "xifres indoaràbigues" },
            { "type.nu.armn", "nombres armenis" },
            { "type.nu.bali", "dígits balinesos" },
            { "type.nu.beng", "dígits bengalins" },
            { "type.nu.cakm", "dígits chakma" },
            { "type.nu.cham", "dígits txams" },
            { "type.nu.deva", "dígits devanagaris" },
            { "type.nu.ethi", "nombres etiòpics" },
            { "type.nu.geor", "nombres georgians" },
            { "type.nu.grek", "nombres grecs" },
            { "type.nu.gujr", "dígits gujarati" },
            { "type.nu.guru", "dígits gurmukhi" },
            { "type.nu.hans", "nombres xinesos simplificats" },
            { "type.nu.hant", "nombres xinesos tradicionals" },
            { "type.nu.hebr", "nombres hebreus" },
            { "type.nu.java", "dígits javanesos" },
            { "type.nu.jpan", "nombres japonesos" },
            { "type.nu.kali", "dígits kayah" },
            { "type.nu.khmr", "dígits khmer" },
            { "type.nu.knda", "dígits kannada" },
            { "type.nu.lana", "dígits tai tham hora" },
            { "type.nu.laoo", "dígits lao" },
            { "type.nu.latn", "dígits aràbics" },
            { "type.nu.lepc", "dígits lepcha" },
            { "type.nu.limb", "dígits limbu" },
            { "type.nu.mlym", "dígits malaiàlam" },
            { "type.nu.mong", "dígits mongols" },
            { "type.nu.mtei", "dígits meitei mayek" },
            { "type.nu.mymr", "dígits de Myanmar" },
            { "type.nu.nkoo", "dígits n’ko" },
            { "type.nu.olck", "dígits ol chiki" },
            { "type.nu.orya", "dígits oriya" },
            { "type.nu.saur", "dígits saurashtra" },
            { "type.nu.sund", "dígits sudanesos" },
            { "type.nu.talu", "dígits tai lue nous" },
            { "type.nu.taml", "nombres tamils tradicionals" },
            { "type.nu.telu", "dígits telugu" },
            { "type.nu.thai", "dígits tai" },
            { "type.nu.tibt", "dígits tibetans" },
            { "type.nu.vaii", "dígits vai" },
            { "type.ca.dangi", "calendari dangi" },
            { "type.co.ducet", "ordre Unicode predeterminat" },
            { "type.lb.loose", "salt de línia flexible" },
            { "type.nu.roman", "nombres romans" },
            { "type.ca.coptic", "calendari copte" },
            { "type.ca.hebrew", "calendari hebreu" },
            { "type.ca.indian", "calendari hindú" },
            { "type.co.compat", "ordre anterior, per a compatibilitat" },
            { "type.co.pinyin", "ordre pinyin" },
            { "type.co.search", "cerca de propòsit general" },
            { "type.co.stroke", "ordre dels traços" },
            { "type.co.unihan", "ordre de traços radicals" },
            { "type.co.zhuyin", "ordre zhuyin" },
            { "type.d0.fwidth", "amplada completa" },
            { "type.d0.hwidth", "amplada mitjana" },
            { "type.lb.normal", "salt de línia normal" },
            { "type.lb.strict", "salt de línia estricte" },
            { "type.m0.ungegn", "sistema de transliteració UNGEGN" },
            { "type.ms.metric", "sistema mètric" },
            { "type.nu.native", "dígits natius" },
            { "type.ca.chinese", "calendari xinès" },
            { "type.ca.islamic", "calendari islàmic" },
            { "type.ca.iso8601", "calendari ISO-8601" },
            { "type.ca.persian", "calendari persa" },
            { "type.cf.account", "format de moneda comptable" },
            { "type.co.big5han", "ordre del xinès tradicional - Big5" },
            { "type.d0.npinyin", "Numèric" },
            { "type.nu.arabext", "xifres indoaràbigues ampliades" },
            { "type.nu.armnlow", "nombres armenis en minúscula" },
            { "type.nu.finance", "Numerals financers" },
            { "type.nu.greklow", "nombres grecs en minúscula" },
            { "type.nu.hanidec", "nombres decimals xinesos" },
            { "type.nu.hansfin", "nombres financers xinesos simplificats" },
            { "type.nu.hantfin", "nombres financers xinesos tradicionals" },
            { "type.nu.jpanfin", "nombres financers japonesos" },
            { "type.nu.tamldec", "dígits tamils" },
            { "type.ca.buddhist", "calendari budista" },
            { "type.ca.ethiopic", "calendari etíop" },
            { "type.ca.japanese", "calendari japonès" },
            { "type.cf.standard", "format de moneda estàndard" },
            { "type.co.phonetic", "ordre fonètic" },
            { "type.co.searchjl", "cerca per consonant inicial del hangul" },
            { "type.co.standard", "ordre estàndard" },
            { "type.ms.uksystem", "sistema imperial d’unitats" },
            { "type.ms.ussystem", "sistema d’unitats dels EUA" },
            { "type.nu.fullwide", "dígits d’amplada completa" },
            { "type.nu.lanatham", "dígits tai tham tham" },
            { "type.nu.mymrshan", "dígits shan de Myanmar" },
            { "type.nu.romanlow", "nombres romans en minúscula" },
            { "type.ca.gregorian", "calendari gregorià" },
            { "type.co.gb2312han", "ordre del xinès simplificat - GB2312" },
            { "type.co.phonebook", "ordre de la guia telefònica" },
            { "type.co.dictionary", "ordre de diccionari" },
            { "type.co.traditional", "ordre tradicional" },
            { "type.nu.traditional", "Numerals tradicionals" },
            { "type.ca.islamic-civil", "calendari civil islàmic" },
            { "type.ca.islamic-umalqura", "calendari islàmic (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendari etíop amete-alem" },
        };
        return data;
    }
}
