/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ku extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Saeta Navînî ya Greenwichê",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Saeta Standard a Apiayê",
               "",
               "Saeta Havînê ya Apiayê",
               "",
               "Saeta Apiayê",
               "",
            };
        final String[] Cook = new String[] {
               "Saeta Standard a Giravên Cookê",
               "",
               "Saeta Nîvhavînê ya Giravên Cookê",
               "",
               "Saeta Giravên Cookê",
               "",
            };
        final String[] Cuba = new String[] {
               "Saeta Standard a Kubayê",
               "SSK",
               "Saeta Havînê ya Kubayê",
               "SHK",
               "Saeta Kubayê",
               "SK",
            };
        final String[] Fiji = new String[] {
               "Saeta Standard a Fîjîyê",
               "",
               "Saeta Havînê ya Fîjîyê",
               "",
               "Saeta Fîjîyê",
               "",
            };
        final String[] Gulf = new String[] {
               "Saeta Standard a Kendavê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Saeta Standard a Hovdê",
               "",
               "Saeta Havînê ya Hovdê",
               "",
               "Saeta Hovdê",
               "",
            };
        final String[] Iran = new String[] {
               "Saeta Standard a Îranê",
               "",
               "Saeta Havînê ya Îranê",
               "",
               "Saeta Îranê",
               "",
            };
        final String[] Niue = new String[] {
               "Saeta Niueyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Saeta Standard a Omskê",
               "",
               "Saeta Havînê ya Omskê",
               "",
               "Saeta Omskê",
               "",
            };
        final String[] Peru = new String[] {
               "Saeta Standard a Perûyê",
               "",
               "Saeta Havînê ya Perûyê",
               "",
               "Saeta Perûyê",
               "",
            };
        final String[] Truk = new String[] {
               "Saeta Chuukê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Saeta Girava Wakeyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Saeta Standard a Şîlîyê",
               "",
               "Saeta Havînê ya Şîlîyê",
               "",
               "Saeta Şîlîyê",
               "",
            };
        final String[] China = new String[] {
               "Saeta Standard a Çînê",
               "CST",
               "Saeta Havînê ya Çînê",
               "CDT",
               "Saeta Çînê",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Saeta Giravên Cocosê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Saeta Davîsê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Saeta Standard a Hindistanê",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Saeta Standard a Japonyayê",
               "JST",
               "Saeta Havşnê ya Japonyayê",
               "JDT",
               "Saeta Japonyayê",
               "JT",
            };
        final String[] Korea = new String[] {
               "Saeta Standard a Koreyê",
               "KST",
               "Saeta Havînê ya Koreyê",
               "KST",
               "Saeta Koreyê",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Saeta Naûrûyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Saeta Nepalê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Saeta Palauyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Saeta Standard a Samoayê",
               "SST",
               "Saeta Havînê ya Samoayê",
               "SST",
               "Saeta Samoayê",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Saeta Syowayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Saeta Standard a Tongayê",
               "",
               "Saeta Havînê ya Tongayê",
               "",
               "Saeta Tongayê",
               "",
            };
        final String[] Yukon = new String[] {
               "Saeta Yukonê",
               "SY",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Saeta Standard a Alaskayê",
               "SSAK",
               "Saeta Havînê ya Alaskayê",
               "SHAK",
               "Saeta Alaskayê",
               "SAK",
            };
        final String[] Amazon = new String[] {
               "Saeta Standard a Amazonê",
               "",
               "Saeta Havînê ya Amazonê",
               "",
               "Saeta Amazonê",
               "",
            };
        final String[] Azores = new String[] {
               "Saeta Standard a Azoran",
               "",
               "Saeta Havînê ya Azoran",
               "",
               "Saeta Azoran",
               "",
            };
        final String[] Bhutan = new String[] {
               "Saeta Bûtanê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Saeta Brûney Darusselamê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Saeta Standard a Girava Paskalyayê",
               "",
               "Saeta Havînê ya Girava Paskalyayê",
               "",
               "Saeta Girava Paskalyayê",
               "",
            };
        final String[] Guyana = new String[] {
               "Saeta Guyanayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Saeta Standard a Îsraîlê",
               "IST",
               "Saeta Havînê ya Îsraîlê",
               "IDT",
               "Saeta Îsraîlê",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Saeta Kosraeyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Saeta Mawsonê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Saeta Standard a Moskovayê",
               "MSK",
               "Saeta Havînê ya Moskovayê",
               "MSK",
               "Saeta Moskovayê",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Saeta Ponapeyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Saeta Tahîtîyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Saeta Standard a Taîpeîyê",
               "CST",
               "Saeta Havînê ya Taîpeîyê",
               "CDT",
               "Saeta Taîpeîyê",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Saeta Tûvalûyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Saeta Vostokê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Saeta Wallis û Futunayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Saeta Standard a Erebistanê",
               "",
               "Saeta Havînê ya Erebistanê",
               "",
               "Saeta Erebistanê",
               "",
            };
        final String[] Armenia = new String[] {
               "Saeta Standard a Ermenistanê",
               "",
               "Saeta Havînê ya Ermenistanê",
               "",
               "Saeta Ermenistanê",
               "",
            };
        final String[] Bolivia = new String[] {
               "Saeta Bolîvyayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Saeta Standard a Chathamê",
               "",
               "Saeta Havînê ya Chathamê",
               "",
               "Saeta Chathamê",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Saeta Gerdûnî ya Hevdemî",
               "SGH",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Saeta Ekwadorê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Saeta Gambierê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Saeta Standard a Gurcistanê",
               "",
               "Saeta Havînê ya Gurcistanê",
               "",
               "Saeta Gurcistanê",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Saeta Standard a Irkutskê",
               "",
               "Saeta Havînê ya Irkutskê",
               "",
               "Saeta Irkutskê",
               "",
            };
        final String[] Magadan = new String[] {
               "Saeta Standard a Magadanê",
               "",
               "Saeta Havînê ya Magadanê",
               "",
               "Saeta Magadanê",
               "",
            };
        final String[] Myanmar = new String[] {
               "Saeta Myanmarê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Saeta Standard a Girava Norfolkê",
               "",
               "Saeta Havînê ya Girava Norfolkê",
               "",
               "Saeta Girava Norfolkê",
               "",
            };
        final String[] Noronha = new String[] {
               "Saeta Standard a Fernando de Noronhayê",
               "",
               "Saeta Havînê ya Fernando de Noronhayê",
               "",
               "Saeta Fernando de Noronhayê",
               "",
            };
        final String[] Reunion = new String[] {
               "Saeta Réunionê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Saeta Rotherayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Saeta Giravên Solomonê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Saeta Tokelauyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Saeta Standard a Ûrûgûayê",
               "",
               "Saeta Havînê ya Ûrûgûayê",
               "",
               "Saeta Ûrûgûayê",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Saeta Standard a Vanûatûyê",
               "",
               "Saeta Havînê ya Vanûatûyê",
               "",
               "Saeta Vanûatûyê",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Saeta Standard a Yakutskê",
               "",
               "Saeta Havînê ya Yakutskê",
               "",
               "Saeta Yakutskê",
               "",
            };
        final String[] Atlantic = new String[] {
               "Saeta Standard a Atlantîkê",
               "SSA",
               "Saeta Havînê ya Atlantîkê",
               "SHA",
               "Saeta Atlantîkê",
               "SA",
            };
        final String[] Brasilia = new String[] {
               "Saeta Standard a Brasîlyayê",
               "",
               "Saeta Havînê ya Brasîlyayê",
               "",
               "Saeta Brasîlyayê",
               "",
            };
        final String[] Chamorro = new String[] {
               "Saeta Standard a Chamorroyê",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Saeta Standard a Kolombîyayê",
               "",
               "Saeta Havînê ya Kolombîyayê",
               "",
               "Saeta Kolombîyayê",
               "",
            };
        final String[] Falkland = new String[] {
               "Saeta Standard a Giravên Falklandê",
               "",
               "Saeta Havînê ya Giravên Falklandê",
               "",
               "Saeta Giravên Falklandê",
               "",
            };
        final String[] Malaysia = new String[] {
               "Saeta Malezyayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Saeta Maldîvan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Saeta Standard a Ûlanbatarê",
               "",
               "Saeta Havînê ya Ûlanbatarê",
               "",
               "Saeta Ûlanbatarê",
               "",
            };
        final String[] Pakistan = new String[] {
               "Saeta Standard a Pakistanê",
               "PKT",
               "Saeta Havînê ya Pakistanê",
               "PKST",
               "Saeta Pakistanê",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Saeta Standard a Paragûayê",
               "",
               "Saeta Havînê ya Paragûayê",
               "",
               "Saeta Paragûayê",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Saeta Pitcairnê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Saeta Standard a Saxalînê",
               "",
               "Saeta Havînê ya Saxalînê",
               "",
               "Saeta Saxalînê",
               "",
            };
        final String[] Suriname = new String[] {
               "Saeta Surînamê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Saeta Standard a Arjantînê",
               "",
               "Saeta Havînê ya Arjantînê",
               "",
               "Saeta Arjantînê",
               "",
            };
        final String[] Christmas = new String[] {
               "Saeta Girava Christmasê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Saeta Galapagosê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Saeta Standard a Hong Kongê",
               "HKT",
               "Saeta Havînê ya Hong Kongê",
               "HKST",
               "Saeta Hong Kongê",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Saeta Hindiçînê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Saeta Qirxizistanê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Saeta Standard a Lord Howeyê",
               "",
               "Saeta Havînê ya Lord Howeyê",
               "",
               "Saeta Lord Howeyê",
               "",
            };
        final String[] Marquesas = new String[] {
               "Saeta Marquesasê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Saeta Standard a Mauritiusê",
               "",
               "Saeta Havînê ya Mauritiusê",
               "",
               "Saeta Mauritiusê",
               "",
            };
        final String[] Singapore = new String[] {
               "Saeta Standard a Sîngapûrê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Saeta Venezûelayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Saeta Standard a Volgogradê",
               "MSK",
               "Saeta Havînê ya Volgogradê",
               "MSK",
               "Saeta Volgogradê",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Saeta Standard a Azerbeycanê",
               "",
               "Saeta Havînê ya Azerbeycanê",
               "",
               "Saeta Azerbeycanê",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Saeta Standard a Bengladeşê",
               "",
               "Saeta Havînê ya Bengladeşê",
               "",
               "Saeta Bengladeşê",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Saeta Standard a Cape Verdeyê",
               "",
               "Saeta Havînê ya Cape Verdeyê",
               "",
               "Saeta Cape Verdeyê",
               "",
            };
        final String[] East_Timor = new String[] {
               "Saeta Tîmûra Rojhilat",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Saeta Qazaxistanê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Saeta Seyşelerê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Saeta Tacikistanê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Saeta Standard a Ozbekistanê",
               "",
               "Saeta Havînê ya Ozbekistanê",
               "",
               "Saeta Ozbekistanê",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Saeta Efxanistanê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Saeta Standard a Krasnoyarskê",
               "",
               "Saeta Havînê ya Krasnoyarskê",
               "",
               "Saeta Krasnoyarskê",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Saeta Standard a Zelandaya Nû",
               "NZST",
               "Saeta Havînê ya Zelandaya Nû",
               "NZDT",
               "Saeta Zelandaya Nû",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Saeta Standard a Novosibirskê",
               "",
               "Saeta Havînê ya Novosibirskê",
               "",
               "Saeta Novosibirskê",
               "",
            };
        final String[] Philippines = new String[] {
               "Saeta Standard a Fîlîpînê",
               "PST",
               "Saeta Havînê ya Fîlîpînê",
               "PDT",
               "Saeta Fîlîpînê",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Saeta Standard a Vladivostokê",
               "",
               "Saeta Havînê ya Vladivostokê",
               "",
               "Saeta Vladivostokê",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Saeta Okyanûsa Hindê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Saeta Giravên Lîneyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Saeta Standard a Newfoundlandê",
               "SSNF",
               "Saeta Havînê ya Newfoundlandê",
               "SHNF",
               "Saeta Newfoundlandê",
               "SNF",
            };
        final String[] Turkmenistan = new String[] {
               "Saeta Standard a Tirkmenistanê",
               "",
               "Saeta Havînê ya Tirkmenistanê",
               "",
               "Saeta Tirkmenistanê",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Saeta Guiyanaya Fransî",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Saeta Standard a Kaledonyaya Nû",
               "",
               "Saeta Havînê ya Kaledonyaya Nû",
               "",
               "Saeta Kaledonyaya Nû",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Saeta Georgiaya Başûr",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Saeta Standard a Yekaterinburgê",
               "",
               "Saeta Havînê ya Yekaterinburgê",
               "",
               "Saeta Yekaterinburgê",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Saeta Afrîkaya Navîn",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Saeta Afrîkaya Rojhilat",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Saeta Standard a Afrîkaya Rojava",
               "WAT",
               "Saeta Havînê ya Afrîkaya Rojava",
               "WAT",
               "Saeta Afrîkaya Rojava",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Saeta Dumont-d’Urvilleyê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Saeta Standard a Ewropaya Navîn",
               "CET",
               "Saeta Havînê ya Ewropaya Navîn",
               "CEST",
               "Saeta Ewropaya Navîn",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Saeta Standard a Ewropaya Rojhilat",
               "EET",
               "Saeta Havînê ya Ewropaya Rojhilat",
               "EEST",
               "Saeta Ewropaya Rojhilat",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Saeta Standard a Ewropaya Rojava",
               "WET",
               "Saeta Havînê ya Ewropaya Rojava",
               "WEST",
               "Saeta Ewropaya Rojava",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Saeta Standard a Pasîfîka Meksîkayê",
               "MST",
               "Saeta Havînê ya Pasîfîka Meksîkayê",
               "MDT",
               "Saeta Pasîfîka Meksîkayê",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Saeta Standard a Afrîkaya Başûr",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Saeta Standard a Navendî ya Amerîkaya Bakur",
               "SSN",
               "Saeta Havînê ya Navendî ya Amerîkaya Bakur",
               "SHN",
               "Saeta Navendî ya Amerîkaya Bakur",
               "SN",
            };
        final String[] America_Eastern = new String[] {
               "Saeta Standard a Rojhilat ya Amerîkaya Bakur",
               "SSR",
               "Saeta Havînê ya Rojhilat ya Amerîkaya Bakur",
               "SHR",
               "Saeta Rojhilat a Amerîkaya Bakur",
               "SR",
            };
        final String[] America_Pacific = new String[] {
               "Saeta Standard a Pasîfîkê ya Amerîkaya Bakur",
               "SSP",
               "Saeta Havînê ya Pasîfîkê ya Amerîkaya Bakur",
               "SHP",
               "Saeta Pasîfîkê ya Amerîkaya Bakur",
               "SP",
            };
        final String[] French_Southern = new String[] {
               "Saeta Antarktîka û Başûrê Fransayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Saeta Giravên Gilbertê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Saeta Standard a Hawaii-Aleutianê",
               "SSHA",
               "Saeta Havînê ya Hawaii-Aleutianê",
               "SHHA",
               "Saeta Hawaii-Aleutianê",
               "SHAL",
            };
        final String[] Phoenix_Islands = new String[] {
               "Saeta Giravên Phoenîks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saeta Standard a Saint Pierre û Miquelonê",
               "",
               "Saeta Havînê ya Saint Pierre û Miquelonê",
               "",
               "Saeta Saint Pierre û Miquelonê",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Saeta Standard a Çîyayî ya Amerîkaya Bakur",
               "SSÇ",
               "Saeta Havînê ya Çîyayî ya Amerîkaya Bakur",
               "SHÇ",
               "Saeta Çîyayî ya Amerîkaya Bakur",
               "SÇ",
            };
        final String[] Marshall_Islands = new String[] {
               "Saeta Giravên Marşalê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Saeta Gîneya Nû ya Papûayê",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Saeta Standard a Awistralyaya Navîn",
               "ACST",
               "Saeta Havînê ya Awistralyaya Navîn",
               "ACDT",
               "Saeta Awistralyaya Navîn",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Saeta Standard a Awistralyaya Rojhilat",
               "AEST",
               "Saeta Havînê ya Awistralyaya Rojhilat",
               "AEDT",
               "Saeta Awistralyaya Rojhilat",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Saeta Standard a Awistralyaya Rojava",
               "AWST",
               "Saeta Havînê ya Awistralyaya Rojava",
               "AWDT",
               "Saeta Awistralyaya Rojava",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Saeta Endonezyaya Navîn",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Saeta Endonezyaya Rojhilat",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Saeta Endonezyaya Rojava",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Saeta Standard a Rojavaya Navîn a Awistralyayê",
               "",
               "Saeta Havînê ya Rojavaya Navîn a Awistralyayê",
               "",
               "Saeta Rojavaya Navîn a Awistralyayê",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Saeta Gerdûnî ya Hevdemî",
                    "SGH",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Standard a Îrlandayê",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Saeta Gerdûnî ya Hevdemî",
                    "SGH",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Saeta Gerdûnî ya Hevdemî",
                    "SGH",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Saeta Gerdûnî ya Hevdemî",
                    "SGH",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Saeta Gerdûnî ya Hevdemî",
                    "SGH",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Saeta Gerdûnî ya Hevdemî",
                    "SGH",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Standard a Îrlandayê",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Saeta Navînî ya Greenwichê",
                    "GMT",
                    "Saeta Havînê ya Brîtanyayê",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakû" },
            { "timezone.excity.Asia/Dili", "Dîlî" },
            { "timezone.excity.Asia/Gaza", "Xeze" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Eman" },
            { "timezone.excity.Asia/Aqtau", "Aqtaw" },
            { "timezone.excity.Asia/Chita", "Çîta" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dûbaî" },
            { "timezone.excity.Asia/Kabul", "Kabûl" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Qeter" },
            { "timezone.excity.Asia/Seoul", "Seûl" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Almatî" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Atyrau", "Atîrav" },
            { "timezone.excity.Asia/Beirut", "Beyrût" },
            { "timezone.excity.Asia/Brunei", "Brûney" },
            { "timezone.excity.Asia/Kuwait", "Kuweyt" },
            { "timezone.excity.Asia/Manila", "Manîla" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Bajarê Ho Chi Minhê" },
            { "timezone.excity.Asia/Taipei", "Taîpeî" },
            { "timezone.excity.Asia/Urumqi", "Ûrûmçî" },
            { "timezone.excity.Etc/Unknown", "Bajarê Nenas" },
            { "timezone.excity.Europe/Kiev", "Kîev" },
            { "timezone.excity.Europe/Riga", "Rîga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Qahîre" },
            { "timezone.excity.Africa/Ceuta", "Septe" },
            { "timezone.excity.Africa/Tunis", "Tûnis" },
            { "timezone.excity.Asia/Baghdad", "Bexda" },
            { "timezone.excity.Asia/Bahrain", "Behreyn" },
            { "timezone.excity.Asia/Bishkek", "Bîşkek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Jakarta", "Cakarta" },
            { "timezone.excity.Asia/Karachi", "Karaçî" },
            { "timezone.excity.Asia/Kuching", "Kûçîng" },
            { "timezone.excity.Asia/Nicosia", "Lefkoşe" },
            { "timezone.excity.Asia/Tbilisi", "Tiflîs" },
            { "timezone.excity.Asia/Yerevan", "Rewan" },
            { "timezone.excity.Europe/Kirov", "Kîrov" },
            { "timezone.excity.Europe/Minsk", "Mînsk" },
            { "timezone.excity.Europe/Paris", "Parîs" },
            { "timezone.excity.Europe/Sofia", "Sofya" },
            { "timezone.excity.Pacific/Fiji", "Fîjî" },
            { "timezone.excity.Africa/Kigali", "Kîgalî" },
            { "timezone.excity.Africa/Maseru", "Maserû" },
            { "timezone.excity.America/Aruba", "Arûba" },
            { "timezone.excity.Asia/Ashgabat", "Eşqabat" },
            { "timezone.excity.Asia/Damascus", "Şam" },
            { "timezone.excity.Asia/Dushanbe", "Duşenbe" },
            { "timezone.excity.Asia/Jayapura", "Cayapûra" },
            { "timezone.excity.Asia/Katmandu", "Katmandû" },
            { "timezone.excity.Asia/Khandyga", "Xandîga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Sakhalin", "Saxalîn" },
            { "timezone.excity.Asia/Shanghai", "Şanghay" },
            { "timezone.excity.Asia/Tashkent", "Taşkent" },
            { "timezone.excity.Asia/Ust-Nera", "Ûst-Nera" },
            { "timezone.excity.Europe/Athens", "Atîna" },
            { "timezone.excity.Europe/Berlin", "Berlîn" },
            { "timezone.excity.Europe/Dublin", "Dûblîn" },
            { "timezone.excity.Europe/Lisbon", "Lîzbon" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Madrid", "Madrîd" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskova" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Skopje", "Uskup" },
            { "timezone.excity.Europe/Tirane", "Tîran" },
            { "timezone.excity.Europe/Vienna", "Viyana" },
            { "timezone.excity.Europe/Warsaw", "Warşova" },
            { "timezone.excity.Europe/Zurich", "Zûrîh" },
            { "timezone.excity.Indian/Comoro", "Komor" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Cezayîr" },
            { "timezone.excity.Africa/Conakry", "Konakrî" },
            { "timezone.excity.Africa/Nairobi", "Naîrobî" },
            { "timezone.excity.Africa/Tripoli", "Trablûs" },
            { "timezone.excity.America/Belize", "Belîze" },
            { "timezone.excity.America/Cancun", "Cancûn" },
            { "timezone.excity.America/Merida", "Merîda" },
            { "timezone.excity.Asia/Jerusalem", "Quds" },
            { "timezone.excity.Asia/Kamchatka", "Kamçatka" },
            { "timezone.excity.Asia/Qyzylorda", "Qizilorda" },
            { "timezone.excity.Asia/Samarkand", "Semerkand" },
            { "timezone.excity.Asia/Singapore", "Sîngapûr" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Tallinn", "Talîn" },
            { "timezone.excity.Europe/Vatican", "Vatîkan" },
            { "timezone.excity.Europe/Vilnius", "Vîlnûs" },
            { "timezone.excity.Pacific/Tahiti", "Tahîtî" },
            { "timezone.excity.Africa/Djibouti", "Cibûtî" },
            { "timezone.excity.Africa/Khartoum", "Xartûm" },
            { "timezone.excity.Africa/Kinshasa", "Kînşasa" },
            { "timezone.excity.America/Jamaica", "Jamaîka" },
            { "timezone.excity.Atlantic/Azores", "Giravên Azorê" },
            { "timezone.excity.Atlantic/Canary", "Giravên Kanaryayê" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bruksel" },
            { "timezone.excity.Europe/Budapest", "Bûdapeşt" },
            { "timezone.excity.Europe/Busingen", "Bûsîngen" },
            { "timezone.excity.Europe/Chisinau", "Kişînew" },
            { "timezone.excity.Europe/Helsinki", "Helsînkî" },
            { "timezone.excity.Europe/Istanbul", "Stenbol" },
            { "timezone.excity.Europe/Sarajevo", "Saraybosna" },
            { "timezone.excity.Indian/Maldives", "Maldîv" },
            { "timezone.excity.Africa/Mogadishu", "Mogadîşû" },
            { "timezone.excity.America/Dominica", "Domînîka" },
            { "timezone.excity.Antarctica/Davis", "Davîs" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ûlanbatar" },
            { "timezone.excity.Atlantic/Bermuda", "Bermûda" },
            { "timezone.excity.Australia/Sydney", "Sîdney" },
            { "timezone.excity.Europe/Astrakhan", "Astraxan" },
            { "timezone.excity.Europe/Bucharest", "Bukreş" },
            { "timezone.excity.Europe/Gibraltar", "Cebelîtariq" },
            { "timezone.excity.Europe/Podgorica", "Podgorîka" },
            { "timezone.excity.Europe/Stockholm", "Stokholm" },
            { "timezone.excity.Africa/Casablanca", "Kazablanka" },
            { "timezone.excity.Africa/Libreville", "Lîbrevîl" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kûala Lûmpûr" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhag" },
            { "timezone.excity.Europe/Luxembourg", "Luksembûrg" },
            { "timezone.excity.Europe/San_Marino", "San Marîno" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rîka" },
            { "timezone.excity.Europe/Isle_of_Man", "Girava Manê" },
            { "timezone.excity.Europe/Kaliningrad", "Kalînîngrad" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rîko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daruselam" },
            { "timezone.excity.America/Ciudad_Juarez", "Ciûdad Juarez" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthelemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahîa Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgiaya Başûr" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beûlah, Dakotaya Bakur" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakotaya Bakur" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakotaya Bakur" },
        };
        return data;
    }
}
