/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Гринвичийн цаг",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Апиагийн стандарт цаг",
               "",
               "Апиагийн зуны цаг",
               "",
               "Апиагийн цаг",
               "",
            };
        final String[] Cook = new String[] {
               "Күүкийн арлуудын стандарт цаг",
               "",
               "Күүкийн арлуудын хагас зуны цаг",
               "",
               "Күүкийн арлуудын цаг",
               "",
            };
        final String[] Cuba = new String[] {
               "Кубын стандарт цаг",
               "CST",
               "Кубын зуны цаг",
               "CDT",
               "Кубын цаг",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фижигийн стандарт цаг",
               "",
               "Фижигийн зуны цаг",
               "",
               "Фижигийн цаг",
               "",
            };
        final String[] Gulf = new String[] {
               "Персийн булангийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховдын стандарт цаг",
               "",
               "Ховдын зуны цаг",
               "",
               "Ховдын цаг",
               "",
            };
        final String[] Iran = new String[] {
               "Ираны стандарт цаг",
               "",
               "Ираны зуны цаг",
               "",
               "Ираны цаг",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуэгийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омскийн стандарт цаг",
               "",
               "Омскийн зуны цаг",
               "",
               "Омскийн цаг",
               "",
            };
        final String[] Peru = new String[] {
               "Перугийн стандарт цаг",
               "",
               "Перугийн зуны цаг",
               "",
               "Перугийн цаг",
               "",
            };
        final String[] Truk = new String[] {
               "Чүүкийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Уэкийн арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чилийн стандарт цаг",
               "",
               "Чилийн зуны цаг",
               "",
               "Чилийн цаг",
               "",
            };
        final String[] China = new String[] {
               "Хятадын стандарт цаг",
               "CST",
               "Хятадын зуны цаг",
               "CDT",
               "Хятадын цаг",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокос арлын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дэвисийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Энэтхэгийн цаг",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Японы стандарт цаг",
               "JST",
               "Японы зуны цаг",
               "JDT",
               "Японы цаг",
               "JT",
            };
        final String[] Korea = new String[] {
               "Солонгосын стандарт цаг",
               "KST",
               "Солонгосын зуны цаг",
               "KST",
               "Солонгосын цаг",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науругийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Балбын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палаугийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоагийн стандарт цаг",
               "SST",
               "Самоагийн зуны цаг",
               "SST",
               "Самоагийн цаг",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Сёвагийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонгагийн стандарт цаг",
               "",
               "Тонгагийн зуны цаг",
               "",
               "Тонгагийн цаг",
               "",
            };
        final String[] Yukon = new String[] {
               "Юкон цагийн бүс",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Аляскийн стандарт цаг",
               "AKST",
               "Аляскийн зуны цаг",
               "AKDT",
               "Аляскийн цаг",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазоны стандарт цаг",
               "",
               "Амазоны зуны цаг",
               "",
               "Амазоны цаг",
               "",
            };
        final String[] Azores = new String[] {
               "Азорын стандарт цаг",
               "",
               "Азорын зуны цаг",
               "",
               "Азорын цаг",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутаны цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней Даруссаламын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Зүүн Исландын стандарт цаг",
               "",
               "Зүүн Исландын зуны цаг",
               "",
               "Зүүн Исландын цаг",
               "",
            };
        final String[] Guyana = new String[] {
               "Гайанагийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Израилийн стандарт цаг",
               "IST",
               "Израилийн зуны цаг",
               "IDT",
               "Израилийн цаг",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Косрэгийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моусоны цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москвагийн стандарт цаг",
               "MSK",
               "Москвагийн зуны цаг",
               "MSK",
               "Москвагийн цаг",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понапегийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таитигийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайпейн стандарт цаг",
               "CST",
               "Тайпейн зуны цаг",
               "CDT",
               "Тайпейн цаг",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалугийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Востокийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уоллис ба Футунагийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арабын стандарт цаг",
               "",
               "Арабын зуны цаг",
               "",
               "Арабын цаг",
               "",
            };
        final String[] Armenia = new String[] {
               "Арменийн стандарт цаг",
               "",
               "Арменийн зуны цаг",
               "",
               "Арменийн цаг",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатемын стандарт цаг",
               "",
               "Чатемын зуны цаг",
               "",
               "Чатемын цаг",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Олон улсын зохицуулалттай цаг",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Эквадорын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбьегийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Гүржийн стандарт цаг",
               "",
               "Гүржийн зуны цаг",
               "",
               "Гүржийн цаг",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Эрхүүгийн стандарт цаг",
               "",
               "Эрхүүгийн зуны цаг",
               "",
               "Эрхүүгийн цаг",
               "",
            };
        final String[] Magadan = new String[] {
               "Магаданы стандарт цаг",
               "",
               "Магаданы зуны цаг",
               "",
               "Магаданы цаг",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мьянмарын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк арлын стандарт цаг",
               "",
               "Норфолк арлын зуны цаг",
               "",
               "Норфолк арлын цаг",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернандо де Норонагийн стандарт цаг",
               "",
               "Фернандо де Норонагийн зуны цаг",
               "",
               "Фернандо де Норонагийн цаг",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюнионы цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротерагийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломоны арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелаугийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвайн стандарт цаг",
               "",
               "Уругвайн зуны цаг",
               "",
               "Уругвайн цаг",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануатугийн стандарт цаг",
               "",
               "Вануатугийн зуны цаг",
               "",
               "Вануатугийн цаг",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутын стандарт цаг",
               "",
               "Якутын зуны цаг",
               "",
               "Якутын цаг",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантын стандарт цаг",
               "AST",
               "Атлантын зуны цаг",
               "AST",
               "Атлантын цаг",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилийн стандарт цаг",
               "",
               "Бразилийн зуны цаг",
               "",
               "Бразилийн цаг",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморрогийн цаг",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбын стандарт цаг",
               "",
               "Колумбын зуны цаг",
               "",
               "Колумбын цаг",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолклендийн арлуудын стандарт цаг",
               "",
               "Фолклендийн арлуудын зуны цаг",
               "",
               "Фолклендийн арлуудын цаг",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Мальдивийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улаанбаатарын стандарт цаг",
               "",
               "Улаанбаатарын зуны цаг",
               "",
               "Улаанбаатарын цаг",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистаны стандарт цаг",
               "PKT",
               "Пакистаны зуны цаг",
               "PKST",
               "Пакистаны цаг",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвайн стандарт цаг",
               "",
               "Парагвайн зуны цаг",
               "",
               "Парагвайн цаг",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкернийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Сахалины стандарт цаг",
               "",
               "Сахалины зуны цаг",
               "",
               "Сахалины цаг",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринамын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентины стандарт цаг",
               "",
               "Аргентины зуны цаг",
               "",
               "Аргентины цаг",
               "",
            };
        final String[] Christmas = new String[] {
               "Крисмас арлын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагосын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Хонг Конгийн стандарт цаг",
               "HKT",
               "Хонг Конгийн зуны цаг",
               "HKST",
               "Хонг Конгийн цаг",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Энэтхэг-Хятадын хойгийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргизийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд Хоугийн стандарт цаг",
               "",
               "Лорд Хоугийн зуны цаг",
               "",
               "Лорд Хоугийн цаг",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркезын арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маврикийн стандарт цаг",
               "",
               "Маврикийн зуны цаг",
               "",
               "Маврикийн цаг",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапурын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэлийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Волгоградын стандарт цаг",
               "MSK",
               "Волгоградын зуны цаг",
               "MSK",
               "Волгоградын цаг",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Азербайжаны стандарт цаг",
               "",
               "Азербайжаны зуны цаг",
               "",
               "Азербайжаны цаг",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладешийн стандарт цаг",
               "",
               "Бангладешийн зуны цаг",
               "",
               "Бангладешийн цаг",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Кабо-Вердийн стандарт цаг",
               "",
               "Кабо-Вердийн зуны цаг",
               "",
               "Кабо-Вердийн цаг",
               "",
            };
        final String[] East_Timor = new String[] {
               "Зүүн Тиморын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казахстаны цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшелийн арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Тажикистаны цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистаны стандарт цаг",
               "",
               "Узбекистаны зуны цаг",
               "",
               "Узбекистаны цаг",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афганистаны цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярскийн стандарт цаг",
               "",
               "Красноярскийн зуны цаг",
               "",
               "Красноярскийн цаг",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Шинэ Зеландын стандарт цаг",
               "NZST",
               "Шинэ Зеландын зуны цаг",
               "NZDT",
               "Шинэ Зеландын цаг",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Новосибирскийн стандарт цаг",
               "",
               "Новосибирскийн зуны цаг",
               "",
               "Новосибирскийн цаг",
               "",
            };
        final String[] Philippines = new String[] {
               "Филиппиний стандарт цаг",
               "PST",
               "Филиппиний зуны цаг",
               "PDT",
               "Филиппиний цаг",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивостокийн стандарт цаг",
               "",
               "Владивостокийн зуны цаг",
               "",
               "Владивостокийн цаг",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Энэтхэгийн далайн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Лайн арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Нью-Фаундлендын стандарт цаг",
               "NST",
               "Нью-Фаундлендын зуны цаг",
               "NDT",
               "Нью-Фаундлендын цаг",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменистаны стандарт цаг",
               "",
               "Туркменистаны зуны цаг",
               "",
               "Туркменистаны цаг",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Францын Гвианагийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Шинэ Каледонийн стандарт цаг",
               "",
               "Шинэ Каледонийн зуны цаг",
               "",
               "Шинэ Каледонийн цаг",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Өмнөд Жоржиагийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбургийн стандарт цаг",
               "",
               "Екатеринбургийн зуны цаг",
               "",
               "Екатеринбургийн цаг",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Төв Африкийн цаг",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Зүүн Африкийн цаг",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Баруун Африкийн стандарт цаг",
               "WAT",
               "Баруун Африкийн зуны цаг",
               "WAT",
               "Баруун Африкийн цаг",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Дюмон д’Юрвилийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Төв Европын стандарт цаг",
               "CET",
               "Төв Европын зуны цаг",
               "CEST",
               "Төв Европын цаг",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Зүүн Европын стандарт цаг",
               "EET",
               "Зүүн Европын зуны цаг",
               "EEST",
               "Зүүн Европын цаг",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Баруун Европын стандарт цаг",
               "WET",
               "Баруун Европын зуны цаг",
               "WEST",
               "Баруун Европын цаг",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексик-Номхон далайн стандарт цаг",
               "MST",
               "Мексик-Номхон далайн зуны цаг",
               "MDT",
               "Мексик-Номхон далайн цаг",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Өмнөд Африкийн стандарт цаг",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Төв стандарт цаг",
               "CST",
               "Төв зуны цаг",
               "CDT",
               "Төв цаг",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Зүүн эргийн стандарт цаг",
               "EST",
               "Зүүн эргийн зуны цаг",
               "EST",
               "Зүүн эргийн цаг",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Номхон далайн стандарт цаг",
               "PST",
               "Номхон далайн зуны цаг",
               "PDT",
               "Номхон далайн цаг",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Францын Өмнөд ба Антарктидийн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гильбертийн арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Хавай-Алеутын стандарт цаг",
               "HST",
               "Хавай-Алеутын зуны цаг",
               "HST",
               "Хавай-Алеутын цаг",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс арлын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сент-Пьер ба Микелоны стандарт цаг",
               "",
               "Сент-Пьер ба Микелоны зуны цаг",
               "",
               "Сент-Пьер ба Микелоны цаг",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Уулын стандарт цаг",
               "MST",
               "Уулын зуны цаг",
               "MST",
               "Уулын цаг",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршаллын арлуудын цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа Шинэ Гвинейн цаг",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Төв Австралийн стандарт цаг",
               "ACST",
               "Төв Австралийн зуны цаг",
               "ACDT",
               "Төв Австралийн цаг",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Австралийн зүүн эргийн стандарт цаг",
               "AEST",
               "Австралийн зүүн эргийн зуны цаг",
               "AEDT",
               "Зүүн Австралийн цаг",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Австралийн баруун эргийн стандарт цаг",
               "AWST",
               "Австралийн баруун эргийн зуны цаг",
               "AWDT",
               "Баруун Австралийн цаг",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Төв Индонезийн цаг",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Зүүн Индонезийн цаг",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Баруун Индонезийн цаг",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Австралийн төв баруун эргийн стандарт цаг",
               "",
               "Австралийн төв баруун эргийн зуны цаг",
               "",
               "Австралийн төв баруун эргийн цаг",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Олон улсын зохицуулалттай цаг",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Ирландын стандарт цаг",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Олон улсын зохицуулалттай цаг",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Олон улсын зохицуулалттай цаг",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Олон улсын зохицуулалттай цаг",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Олон улсын зохицуулалттай цаг",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Олон улсын зохицуулалттай цаг",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Ирландын стандарт цаг",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Гринвичийн цаг",
                    "GMT",
                    "Британийн зуны цаг",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Орал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Амман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дака" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сөүл" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Жуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алматы" },
            { "timezone.excity.Asia/Anadyr", "Анадыр" },
            { "timezone.excity.Asia/Aqtobe", "Актөбе" },
            { "timezone.excity.Asia/Atyrau", "Атырау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеброн" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Мускат" },
            { "timezone.excity.Asia/Riyadh", "Рияд" },
            { "timezone.excity.Asia/Saigon", "Хо Ши Мин хот" },
            { "timezone.excity.Asia/Taipei", "Тайпей" },
            { "timezone.excity.Asia/Tehran", "Тегеран" },
            { "timezone.excity.Asia/Urumqi", "Үрүмчи" },
            { "timezone.excity.Etc/Unknown", "Үл мэдэгдэх хот" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Ром" },
            { "timezone.excity.Indian/Mahe", "Махе" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "Каир" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Эрхүү" },
            { "timezone.excity.Asia/Jakarta", "Жакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучин" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никосия" },
            { "timezone.excity.Asia/Rangoon", "Рангун" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тхимпху" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Парис" },
            { "timezone.excity.Europe/Sofia", "Софи" },
            { "timezone.excity.Europe/Vaduz", "Вадуз" },
            { "timezone.excity.Indian/Cocos", "Кокос" },
            { "timezone.excity.Pacific/Apia", "Апиа" },
            { "timezone.excity.Pacific/Fiji", "Фижи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуэ" },
            { "timezone.excity.Pacific/Truk", "Чүүк" },
            { "timezone.excity.Pacific/Wake", "Уэк" },
            { "timezone.excity.Africa/Asmera", "Асмара" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Бангуй" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Биссау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуто" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ниамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Байя" },
            { "timezone.excity.America/Belem", "Белем" },
            { "timezone.excity.America/Boise", "Боисе" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Калькутта" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Жайпур" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Кандыга" },
            { "timezone.excity.Asia/Makassar", "Макассар" },
            { "timezone.excity.Asia/Qostanay", "Костанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Уст-Нера" },
            { "timezone.excity.Europe/Athens", "Афин" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дублин" },
            { "timezone.excity.Europe/Jersey", "Жерси" },
            { "timezone.excity.Europe/Lisbon", "Лисбон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопье" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшав" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморо" },
            { "timezone.excity.Pacific/Efate", "Эфате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абижан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайман" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гайана" },
            { "timezone.excity.America/Havana", "Хавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Жуно" },
            { "timezone.excity.America/La_Paz", "Ла Паз" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Нассау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифи" },
            { "timezone.excity.America/Regina", "Регина" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Хонг Конг" },
            { "timezone.excity.Asia/Jerusalem", "Йерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пёньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кызылорд" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Вьентьян" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вильнюс" },
            { "timezone.excity.Indian/Mayotte", "Майотта" },
            { "timezone.excity.Indian/Reunion", "Реюнион" },
            { "timezone.excity.Pacific/Easter", "Истер" },
            { "timezone.excity.Pacific/Kanton", "Кантон" },
            { "timezone.excity.Pacific/Kosrae", "Косрэ" },
            { "timezone.excity.Pacific/Majuro", "Мажуро" },
            { "timezone.excity.Pacific/Midway", "Мидуэй" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понпей" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уоллис" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Жибути" },
            { "timezone.excity.Africa/El_Aaiun", "Эль-Аюн" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровиа" },
            { "timezone.excity.Africa/Ndjamena", "Нжамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайенна" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордова" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нүүк" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Халифакс" },
            { "timezone.excity.America/Iqaluit", "Икалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Маригот" },
            { "timezone.excity.America/Mendoza", "Мендоза" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норона" },
            { "timezone.excity.America/Ojinaga", "Ожинага" },
            { "timezone.excity.America/Phoenix", "Феникс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпень" },
            { "timezone.excity.Atlantic/Azores", "Азор" },
            { "timezone.excity.Atlantic/Canary", "Канари" },
            { "timezone.excity.Atlantic/Faeroe", "Фарер" },
            { "timezone.excity.Australia/Eucla", "Еукла" },
            { "timezone.excity.Australia/Perth", "Перс" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бусинген" },
            { "timezone.excity.Europe/Chisinau", "Кишинёв" },
            { "timezone.excity.Europe/Guernsey", "Гернси" },
            { "timezone.excity.Europe/Helsinki", "Хельсинк" },
            { "timezone.excity.Europe/Istanbul", "Истанбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Мальдив" },
            { "timezone.excity.Pacific/Chatham", "Чатем" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбьер" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишу" },
            { "timezone.excity.America/Anguilla", "Ангилья" },
            { "timezone.excity.America/Asuncion", "Асунсьон" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминик" },
            { "timezone.excity.America/Edmonton", "Эдмонтон" },
            { "timezone.excity.America/Eirunepe", "Эйрунепе" },
            { "timezone.excity.America/Mazatlan", "Мазатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Нью-Йорк" },
            { "timezone.excity.America/Resolute", "Резолют" },
            { "timezone.excity.America/Santarem", "Сантарем" },
            { "timezone.excity.America/Santiago", "Сантьяго" },
            { "timezone.excity.America/St_Johns", "Сент-Жонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Киттс" },
            { "timezone.excity.America/St_Lucia", "Сент Люсиа" },
            { "timezone.excity.America/Winnipeg", "Виннипег" },
            { "timezone.excity.Antarctica/Casey", "Кэсей" },
            { "timezone.excity.Antarctica/Davis", "Дэвис" },
            { "timezone.excity.Antarctica/Syowa", "Сёва" },
            { "timezone.excity.Antarctica/Troll", "Тролл" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улаанбаатар" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермуда" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стэнли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Марихамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокхолм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульяновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Крисмас" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маврики" },
            { "timezone.excity.Pacific/Auckland", "Оукленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Honolulu", "Хонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Питкэрн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Либревиль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкораж" },
            { "timezone.excity.America/Araguaina", "Арагуаяна" },
            { "timezone.excity.America/Boa_Vista", "Боа-Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чихуахуа" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глейс булан" },
            { "timezone.excity.America/Goose_Bay", "Гуус булан" },
            { "timezone.excity.America/Guatemala", "Гватемал" },
            { "timezone.excity.America/Guayaquil", "Гуаякиль" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтерей" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паулу" },
            { "timezone.excity.America/St_Thomas", "Сент Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моусон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецк" },
            { "timezone.excity.Europe/Bratislava", "Братислав" },
            { "timezone.excity.Europe/Copenhagen", "Копенхаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферополь" },
            { "timezone.excity.Pacific/Enderbury", "Эндербери" },
            { "timezone.excity.Pacific/Galapagos", "Галапагос" },
            { "timezone.excity.Pacific/Kwajalein", "Кважалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркез" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Aбеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавиль" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд Турк" },
            { "timezone.excity.America/Guadeloupe", "Гваделуп" },
            { "timezone.excity.America/Hermosillo", "Хермосилло" },
            { "timezone.excity.America/Kralendijk", "Кралендик" },
            { "timezone.excity.America/Louisville", "Луисвилл" },
            { "timezone.excity.America/Martinique", "Мартиник" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монтсеррат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Рио-Бранко" },
            { "timezone.excity.America/St_Vincent", "Сент Винсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорз" },
            { "timezone.excity.Antarctica/McMurdo", "Мак-Мөрдо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколымск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкьявик" },
            { "timezone.excity.Atlantic/St_Helena", "Сент Хелена" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Брисбен" },
            { "timezone.excity.Australia/Lindeman", "Линдемэн" },
            { "timezone.excity.Europe/Isle_of_Man", "Мэн Арал" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханнесбург" },
            { "timezone.excity.America/El_Salvador", "Эль Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нэльсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анжелес" },
            { "timezone.excity.America/Mexico_City", "Мехико" },
            { "timezone.excity.America/Porto_Velho", "Порто-Велью" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрто-Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгирбайен" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо-Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд Хоу" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариво" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-эс-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Блан-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампо-Гранде" },
            { "timezone.excity.America/Danmarkshavn", "Данмаркшавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон Крик" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Индиана" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта Арена" },
            { "timezone.excity.America/Rankin_Inlet", "Рэнкин Инлет" },
            { "timezone.excity.America/Scoresbysund", "Скорсбисунн" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуори" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвиль" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт-Морсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кэмбрижийн булан" },
            { "timezone.excity.America/Ciudad_Juarez", "Сьюдад Хуарес" },
            { "timezone.excity.America/Coral_Harbour", "Атикокан" },
            { "timezone.excity.America/Indiana/Vevay", "Вивей, Индиана" },
            { "timezone.excity.America/Lower_Princes", "Ловер Принсес Квартер" },
            { "timezone.excity.America/Port_of_Spain", "Испаний боомт" },
            { "timezone.excity.America/Santo_Domingo", "Санто Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сент-Бартельми" },
            { "timezone.excity.America/Swift_Current", "Свифт Каррент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен Хилл" },
            { "timezone.excity.America/Bahia_Banderas", "Бахья Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Принс" },
            { "timezone.excity.Atlantic/South_Georgia", "Өмнөд Жоржиа" },
            { "timezone.excity.America/Argentina/Salta", "Салта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Индиана" },
            { "timezone.excity.America/Indiana/Winamac", "Винамак, Индиана" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуайя" },
            { "timezone.excity.America/Indiana/Tell_City", "Тел Сити, Индиана" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсенес, Индиана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон д’Юрвиль" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан Луи" },
            { "timezone.excity.America/Indiana/Petersburg", "Питерсбург, Индиана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтичелло, Кентаки" },
            { "timezone.excity.America/North_Dakota/Beulah", "Била, Хойд Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Төв, Хойд Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио-Гальегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Салем, Хойд Дакота" },
        };
        return data;
    }
}
