/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Address;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.ContainerElementsOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.OrderLine;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.ProductCategory;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ValidateParametersTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ValidateParametersTest.webArchiveBuilder().withTestClass(ValidateParametersTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withClass(Address.class)).withClass(Item.class)).withClass(OrderLine.class)).withClass(User.class)).withClass(ContainerElementsOrder.class)).withClass(ProductCategory.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="a"), @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolation() throws Exception {
        String methodName = "setFirstName";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class);
        String arg0 = "B";
        Object[] parameterValues = new Object[]{arg0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("firstName", 0)));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getRootBean(), (Object)object);
        Assert.assertEquals((Object)violation.getRootBeanClass(), User.class);
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)object);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)arg0);
        Assert.assertEquals((Object[])violation.getExecutableParameters(), (Object[])parameterValues);
        Assert.assertNull((Object)violation.getExecutableReturnValue());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="j")})
    public void testOneViolationFromCrossParameterConstraint() throws Exception {
        String methodName = "setAddress";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)object);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)parameterValues);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testTwoViolations() throws Exception {
        String methodName = "setNames";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, CharSequence.class);
        Object[] parameterValues = new Object[]{null, "S"};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("firstName", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("lastName", 1)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testTwoViolationsOnSameParameter() throws Exception {
        String methodName = "setFirstNameStrict";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{"S", 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("firstName", 0)), ConstraintViolationAssert.violationOf(Pattern.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("firstName", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testTwoConstraintsOfSameType() throws Exception {
        String methodName = "setLastNameStrict";
        User object = new User();
        Method method = User.class.getMethod(methodName, CharSequence.class);
        Object[] parameterValues = new Object[]{"S"};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("lastName", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("lastName", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testCrossParameterConstraintGivenSeveralTimes() throws Exception {
        String methodName = "setAddress";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, String.class, String.class);
        Object[] parameterValues = new Object[]{null, null, null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testNoViolations() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setNames", String.class, CharSequence.class);
        Object[] parameterValues = new Object[]{"Bob", "Smith"};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testValidationWithGroup() throws Exception {
        String methodName = "setLastName";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, Long.TYPE);
        Object[] parameterValues = new Object[]{"S", 0L};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{User.Extended.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("lastName", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testCrossParameterConstraintValidationWithGroup() throws Exception {
        String methodName = "setAddressExtended";
        User object = new User();
        Method method = User.class.getMethod(methodName, CharSequence.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{User.Extended.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testValidationWithSeveralGroups() throws Exception {
        String methodName = "setAllData";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, String.class, Date.class);
        Object[] parameterValues = new Object[]{null, "S", null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{User.Basic.class, User.Extended.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("firstName", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("lastName", 1)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("dateOfBirth", 2)));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="a")
    public void testUnexpectedType() throws Exception {
        String methodName = "setName";
        Address object = new Address();
        Method method = Address.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{"S"};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForObjectCausesException() throws Exception {
        Object object = null;
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters(object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForMethodCausesException() throws Exception {
        User object = new User();
        Method method = null;
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForParameterValuesCausesException() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = null;
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForGroupsCausesException() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, (Class[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedAsSingleGroupCausesException() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolationForCascadedValidation() throws Exception {
        String methodName = "setItem";
        OrderLine object = new OrderLine(null);
        Item leaf = new Item("foo");
        Method method = OrderLine.class.getMethod(methodName, Item.class);
        Object[] parameterValues = new Object[]{leaf};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)leaf);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"foo");
        Assert.assertEquals((Object[])violation.getExecutableParameters(), (Object[])parameterValues);
        Assert.assertNull((Object)violation.getExecutableReturnValue());
    }

    @Test
    @SpecAssertion(section="validationapi-constraintviolation", id="f")
    public void testContainerElementLeafBean() throws NoSuchMethodException, SecurityException {
        Method method = ContainerElementsOrder.class.getMethod("replaceOrderLines", Map.class);
        ContainerElementsOrder order = new ContainerElementsOrder("order");
        Item invalidItem = new Item("s");
        HashMap<ProductCategory, List<OrderLine>> invalidLines = new HashMap<ProductCategory, List<OrderLine>>();
        invalidLines.put(null, Arrays.asList(new OrderLine(new Item("item name"))));
        invalidLines.put(ProductCategory.MUSIC, Arrays.asList(new OrderLine(invalidItem)));
        Object[] parameterValues = new Object[]{invalidLines};
        Set violations = this.getExecutableValidator().validateParameters((Object)order, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withLeafBean(order), ConstraintViolationAssert.violationOf(Size.class).withLeafBean(invalidItem));
    }
}

