/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class DiagramRenameParticipant
extends RenameParticipant {
    private URI roomURI;
    private List<IFile> diagramFiles = new ArrayList<IFile>();
    private static String[] diagramExtensions;
    private static String[] diagramEditorsIds;

    static {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.etrice.ui.common.base.refactoring.rename");
        diagramExtensions = new String[elements.length];
        diagramEditorsIds = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            DiagramRenameParticipant.diagramExtensions[i] = elements[i].getAttribute("diagram_extension");
            DiagramRenameParticipant.diagramEditorsIds[i] = elements[i].getAttribute("editor_id");
            ++i;
        }
    }

    protected boolean initialize(Object element) {
        IFile roomFile = (IFile)element;
        IFolder diagramFolder = roomFile.getParent().getFolder((IPath)new Path("diagrams"));
        if (!diagramFolder.exists()) {
            return false;
        }
        final ArrayList allDiagrams = new ArrayList();
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                String[] stringArray = diagramExtensions;
                int n = diagramExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (proxy.getName().endsWith(extension)) {
                        allDiagrams.add((IFile)proxy.requestResource());
                    }
                    ++n2;
                }
                return true;
            }
        };
        try {
            diagramFolder.accept(visitor, 1, 1);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.roomURI = URI.createPlatformResourceURI((String)roomFile.getFullPath().toString(), (boolean)false);
        ResourceSetImpl rs = new ResourceSetImpl();
        for (IFile diagramFile : allDiagrams) {
            URI boURI;
            Diagram diagram;
            URI diagramURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)false);
            Resource res = rs.getResource(diagramURI, true);
            EObject obj = (EObject)res.getContents().iterator().next();
            if (!(obj instanceof Diagram) || (diagram = (Diagram)obj).getLink().getBusinessObjects().isEmpty() || !this.roomURI.equals((boURI = EcoreUtil.getURI((EObject)((EObject)diagram.getLink().getBusinessObjects().iterator().next()))).trimFragment())) continue;
            this.diagramFiles.add(diagramFile);
        }
        return !this.diagramFiles.isEmpty();
    }

    public String getName() {
        return null;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = RefactoringStatus.create((IStatus)Status.OK_STATUS);
        final ArrayList toIgnore = new ArrayList();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                for (IFile diagramFile : DiagramRenameParticipant.this.diagramFiles) {
                    if (!DiagramRenameParticipant.this.isDiagramEditorOpen(diagramFile, page)) continue;
                    toIgnore.add(diagramFile);
                }
            }
        };
        Display.getDefault().syncExec(runnable);
        for (IFile diagramFile : toIgnore) {
            this.diagramFiles.remove(diagramFile);
            status.addWarning("Cannot update open diagram " + diagramFile.getName(), (RefactoringStatusContext)new FileStatusContext(diagramFile, null));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.diagramFiles.isEmpty()) {
            return new NullChange();
        }
        URI oldURI = this.roomURI;
        String newFileName = this.getArguments().getNewName();
        URI newURI = oldURI.trimSegments(1).appendSegment(newFileName);
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResource(oldURI, true);
        DiagramCompositeChange compositeChange = new DiagramCompositeChange(oldURI, newURI, (ResourceSet)rs);
        for (IFile diagramFile : this.diagramFiles) {
            URI diagramURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)false);
            Resource diagramRes = rs.getResource(diagramURI, true);
            compositeChange.add((Change)new DiagramUpdateChange(diagramRes));
        }
        return compositeChange;
    }

    private boolean isDiagramEditorOpen(IFile input, IWorkbenchPage page) {
        FileEditorInput editorInput = new FileEditorInput(input);
        String[] stringArray = diagramEditorsIds;
        int n = diagramEditorsIds.length;
        int n2 = 0;
        while (n2 < n) {
            String editorId = stringArray[n2];
            IEditorReference[] editorRefs = page.findEditors((IEditorInput)editorInput, editorId, 3);
            if (editorRefs.length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class DiagramCompositeChange
    extends CompositeChange {
        private URI oldURI;
        private URI newURI;
        private ResourceSet rs;

        public DiagramCompositeChange(URI oldURI, URI newURI, ResourceSet rs) {
            super("Update Diagrams");
            this.oldURI = oldURI;
            this.newURI = newURI;
            this.rs = rs;
        }

        public DiagramCompositeChange(URI oldURI, URI newURI, ResourceSet rs, Change[] childUndos) {
            super("Update Diagrams", childUndos);
            this.oldURI = oldURI;
            this.newURI = newURI;
            this.rs = rs;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Resource roomRes = (Resource)this.rs.getResources().get(0);
            EcoreUtil.resolveAll((ResourceSet)this.rs);
            roomRes.setURI(this.newURI);
            Change undoChange = super.perform(pm);
            return undoChange;
        }

        protected Change createUndoChange(Change[] childUndos) {
            return new DiagramCompositeChange(this.newURI, this.oldURI, this.rs, childUndos);
        }

        protected boolean internalContinueOnCancel() {
            return true;
        }
    }

    private class DiagramUpdateChange
    extends ResourceChange {
        Resource diagramRes;

        public DiagramUpdateChange(Resource diagramRes) {
            this.diagramRes = diagramRes;
            this.setValidationMethod(2);
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            final RefactoringStatus status = super.isValid(pm);
            if (status.hasFatalError()) {
                return status;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (DiagramRenameParticipant.this.isDiagramEditorOpen((IFile)DiagramUpdateChange.this.getModifiedResource(), page)) {
                        status.addFatalError("Diagram " + DiagramUpdateChange.this.diagramRes.getURI().lastSegment() + " is open");
                    }
                }
            };
            Display.getDefault().syncExec(runnable);
            if (!this.diagramRes.isLoaded()) {
                status.addFatalError("Expired");
            }
            return status;
        }

        protected IResource getModifiedResource() {
            Path path = new Path(this.diagramRes.getURI().toPlatformString(false));
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        }

        public String getName() {
            return "Update references";
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            try {
                this.diagramRes.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CoreException(Status.CANCEL_STATUS);
            }
            return new DiagramUpdateChange(this.diagramRes);
        }
    }
}

