/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.fsm.ast;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.etrice.dctools.fsm.ast.DCLanguage;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCBracketRule;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCIdentifierRule;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCKeywordRule;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCSpecialCharRule;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCWhitespaceDetector;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCTextToken;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCToken;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class DCScanner {
    private final RuleBasedScanner scanner = new RuleBasedScanner();
    private DCLanguage language;

    public DCScanner(DCLanguage language) {
        this.language = language;
        this.scanner.setRules(this.getRules());
    }

    public ArrayList<DCTextToken> scan(String text) {
        ArrayList result = CollectionLiterals.newArrayList();
        Document document = new Document(text);
        this.scanner.setRange((IDocument)document, 0, text.length());
        IToken lastToken = null;
        while (lastToken != Token.EOF) {
            Object object;
            int n;
            lastToken = this.scanner.nextToken();
            if (lastToken == null) continue;
            int begin = this.scanner.getTokenOffset();
            int n2 = this.scanner.getTokenLength();
            int end = begin + n2;
            if (begin < 0 || begin >= end) continue;
            if (lastToken instanceof DCToken) {
                n = this.scanner.getTokenLength();
                object = new DCTextToken(begin, n, (DCToken)lastToken);
                result.add(object);
                continue;
            }
            n = this.scanner.getTokenLength();
            object = new DCToken(DCToken.Kind.OTHER);
            DCTextToken dCTextToken = new DCTextToken(begin, n, (DCToken)object);
            result.add(dCTextToken);
        }
        return result;
    }

    private IRule[] getRules() {
        Object object;
        IRule[] iRuleArray = null;
        ArrayList rules = CollectionLiterals.newArrayList();
        DCToken dCToken = new DCToken(DCToken.Kind.COMMENT);
        EndOfLineRule endOfLineRule = new EndOfLineRule("//", (IToken)dCToken);
        rules.add(endOfLineRule);
        DCToken dCToken2 = new DCToken(DCToken.Kind.COMMENT);
        MultiLineRule multiLineRule = new MultiLineRule("/*", "*/", (IToken)dCToken2, '\u0000', true);
        rules.add(multiLineRule);
        DCToken dCToken3 = new DCToken(DCToken.Kind.STRING);
        SingleLineRule singleLineRule = new SingleLineRule("\"", "\"", (IToken)dCToken3, '\\');
        rules.add(singleLineRule);
        DCToken dCToken4 = new DCToken(DCToken.Kind.STRING);
        SingleLineRule singleLineRule2 = new SingleLineRule("'", "'", (IToken)dCToken4, '\\');
        rules.add(singleLineRule2);
        DCToken dCToken5 = new DCToken(DCToken.Kind.STRING);
        MultiLineRule multiLineRule2 = new MultiLineRule("\"", "\"", (IToken)dCToken5, '\\', true);
        rules.add(multiLineRule2);
        DCToken dCToken6 = new DCToken(DCToken.Kind.STRING);
        MultiLineRule multiLineRule3 = new MultiLineRule("'", "'", (IToken)dCToken6, '\\', true);
        rules.add(multiLineRule3);
        DCToken dCToken7 = new DCToken(DCToken.Kind.NUMBER);
        NumberRule numberRule = new NumberRule((IToken)dCToken7);
        rules.add(numberRule);
        if (this.language != DCLanguage.OTHER_LANGUAGE) {
            object = new DCKeywordRule(this.language);
            rules.add(object);
        }
        object = new DCIdentifierRule();
        rules.add(object);
        DCWhitespaceDetector dCWhitespaceDetector = new DCWhitespaceDetector();
        DCToken dCToken8 = new DCToken(DCToken.Kind.WHITESPACE);
        WhitespaceRule whitespaceRule = new WhitespaceRule((IWhitespaceDetector)dCWhitespaceDetector, (IToken)dCToken8);
        rules.add(whitespaceRule);
        DCBracketRule dCBracketRule = new DCBracketRule();
        rules.add(dCBracketRule);
        DCSpecialCharRule dCSpecialCharRule = new DCSpecialCharRule();
        rules.add(dCSpecialCharRule);
        iRuleArray = (IRule[])Iterables.toArray((Iterable)rules, IRule.class);
        return iRuleArray;
    }
}

