/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure;

import com.google.inject.Injector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.common.base.export.IBulkDiagramExporter;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.etrice.ui.structure.commands.UpdateDiagramCommand;
import org.eclipse.etrice.ui.structure.editor.StructureExporter;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class DiagramAccess
extends DiagramAccessBase {
    public String getDiagramName(EObject rootObject) {
        if (rootObject instanceof StructureClass) {
            StructureClass sc = (StructureClass)rootObject;
            return sc.getName() + " Structure";
        }
        return "unknown";
    }

    protected String getDiagramTypeId() {
        return "room.structure";
    }

    protected String getEditorId() {
        return "org.eclipse.etrice.ui.structure.editor.StructureEditor";
    }

    public String getDigramFileName(EObject rootObject) {
        if (rootObject instanceof StructureClass) {
            StructureClass sc = (StructureClass)rootObject;
            String modelName = ((RoomModel)sc.eContainer()).getName();
            return modelName + "." + sc.getName() + ".structure";
        }
        return "unknown";
    }

    protected Command getInitialCommand(EObject rootObject, Diagram diagram, TransactionalEditingDomain editingDomain) {
        if (rootObject instanceof StructureClass) {
            IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(diagram, "org.eclipse.etrice.ui.structure.diagramTypeProvider");
            IFeatureProvider featureProvider = dtp.getFeatureProvider();
            return new UpdateDiagramCommand(diagram, (StructureClass)rootObject, editingDomain, featureProvider);
        }
        return null;
    }

    protected Command getUpdateCommand(Diagram diagram, TransactionalEditingDomain editingDomain) {
        IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(diagram, "org.eclipse.etrice.ui.structure.diagramTypeProvider");
        IFeatureProvider featureProvider = dtp.getFeatureProvider();
        UpdateDiagramCommand cmd = new UpdateDiagramCommand(diagram, editingDomain, featureProvider);
        if (cmd.updateNeeded()) {
            return cmd;
        }
        return null;
    }

    protected void injectMembers() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    public IBulkDiagramExporter getDiagramExporter() {
        return new StructureExporter();
    }
}

