/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;

    public void doGenerate(Root root) {
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                String filepath = this.roomExt.getPath((RoomClass)ssi.getSubSystemClass());
                String string = this._cppExtensions.getCppClassName(nr, ssi);
                String string2 = filepath + string;
                String string3 = string2 + "Runner.h";
                this.fileIO.generateFile("generating SubSystemRunner declaration", string3, this.generateHeaderFile(root, ssi));
                String string4 = this._cppExtensions.getCppClassName(nr, ssi);
                String string5 = filepath + string4;
                String string6 = string5 + "Runner.cpp";
                this.fileIO.generateFile("generating SubSystemRunner implementation", string6, this.generateSourceFile(root, ssi));
            }
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance ssc) {
        StringConcatenation stringConcatenation = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._cppExtensions.getCppClassName(nr, ssc);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* this class contains the main function running component ");
        String string = ssc.getName();
        stringConcatenation2.append(string, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* it instantiates ");
        String string2 = ssc.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.append(" and starts and ends the lifecycle");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._cppExtensions.generateIncludeGuardBegin((RoomClass)cc, "Runner");
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        String string3 = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        stringConcatenation2.append(string3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/SubSystemRunnerBase.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        stringConcatenation2.append(clsname + "Runner");
        stringConcatenation2.append(" : public etRuntime::SubSystemRunnerBase {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string4 = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        stringConcatenation2.append(string4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this._cppExtensions.generateIncludeGuardEnd((RoomClass)cc, "Runner");
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssc) {
        Object object;
        StringConcatenation stringConcatenation = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._cppExtensions.getCppClassName(nr, ssc);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* this class contains the main function running component ");
        String string = ssc.getName();
        stringConcatenation2.append(string, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* it instantiates ");
        String string2 = ssc.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.append(" and starts and ends the lifecycle");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("Runner.h\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(".h\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("#include \"common/modelbase/RTSystem.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/containers/String.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/containers/Vector.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/containers/Set.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/containers/Map.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("using namespace etRuntime;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string3 = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        stringConcatenation2.append(string3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* ");
        String string4 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.append(" function");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* creates components and starts and stops the lifecycle");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.append("int ");
        String string5 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        stringConcatenation2.append(string5);
        stringConcatenation2.append("(int argc, char* argv[]) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// instantiate the main component");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("RTSystem* sys = ");
        Object object2 = ssc.eContainer();
        if (object2 instanceof SystemInstance) {
            stringConcatenation2.append("new RTSystem(\"");
            object = ssc.eContainer();
            String string6 = ((SystemInstance)object).getName();
            stringConcatenation2.append(string6, "\t");
            stringConcatenation2.append("\")");
        } else {
            stringConcatenation2.append("0");
        }
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("* main_component = new ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("(sys, \"");
        object2 = ssc.getName();
        stringConcatenation2.append((String)object2, "\t");
        stringConcatenation2.append("\");");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Runner::run(*main_component, argc, argv);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//delete sys;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("printf(\"String allocations %d and deallocations %d\\n\", etRuntime::String::getNAllocations(), etRuntime::String::getNDeallocations());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("printf(\"String creations %d and destructions %d\\n\", etRuntime::String::getNCreated(), etRuntime::String::getNDestroyed());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("printf(\"Vector allocations %d and deallocations %d\\n\", etRuntime::VectorStats::getNAllocations(), etRuntime::VectorStats::getNDeallocations());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("printf(\"Vector creations %d and destructions %d\\n\", etRuntime::VectorStats::getNCreated(), etRuntime::VectorStats::getNDestroyed());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("printf(\"Set creations %d and destructions %d\\n\", etRuntime::SetStats::getNCreated(), etRuntime::SetStats::getNDestroyed());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("printf(\"Map creations %d and destructions %d\\n\", etRuntime::MapStats::getNCreated(), etRuntime::MapStats::getNDestroyed());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("fflush(stdout);");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("return 0;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        object = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        stringConcatenation2.append((String)object);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

