/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;

public abstract class AbstractIntegerRendering
extends AbstractAsyncTableRendering {
    private int fDisplayEndianess = 2;

    public AbstractIntegerRendering(String renderingId) {
        super(renderingId);
    }

    @Override
    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        super.init(container, block);
        if (!(block instanceof IMemoryBlockExtension)) {
            this.fDisplayEndianess = 1;
        }
    }

    public int getDisplayEndianess() {
        return this.fDisplayEndianess;
    }

    public void setDisplayEndianess(int currentEndianess) {
        this.fDisplayEndianess = currentEndianess;
    }

    protected int getBytesEndianess(MemoryByte[] data) {
        int endianess = 2;
        if (!data[0].isEndianessKnown()) {
            return endianess;
        }
        endianess = data[0].isBigEndian() ? 1 : 0;
        int i = 1;
        while (i < data.length) {
            int byteEndianess;
            if (!data[i].isEndianessKnown()) {
                return 2;
            }
            int n = byteEndianess = data[i].isBigEndian() ? 1 : 0;
            if (byteEndianess != endianess) {
                endianess = 2;
                break;
            }
            ++i;
        }
        return endianess;
    }
}

