/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class UrgEdgesCodeGenerator {
    private UrgEdgesCodeGenerator() {
    }

    public static void gencodeUrgEdges(Specification spec, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("UrgEdges");
        CodeBox h = file.header;
        h.add("/** Urgent edges. */");
        h.add("public final class UrgEdges {");
        CodeBox c = file.body;
        c.add("public static boolean evalUrgEdges(State state) {");
        c.indent();
        c.add("boolean b; // temp var for pred eval rslts");
        List<ExprCodeGeneratorResult> exprResults = UrgEdgesCodeGenerator.gencodeUrgEdgesComponent((ComplexComponent)spec, ctxt, c);
        c.add();
        c.add("return false;");
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult exprResult : exprResults) {
            exprResult.addExtraMethods(c);
        }
    }

    private static List<ExprCodeGeneratorResult> gencodeUrgEdgesComponent(ComplexComponent comp, CifCompilerContext ctxt, CodeBox c) {
        List exprResults = Lists.list();
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.indent();
            EList locs = aut.getLocations();
            int locIdx = 0;
            while (locIdx < locs.size()) {
                Location loc = (Location)locs.get(locIdx);
                boolean caseAdded = false;
                String locTxt = CifTextUtils.getLocationText2((Location)loc);
                for (Edge edge : loc.getEdges()) {
                    if (!edge.isUrgent()) continue;
                    if (!caseAdded) {
                        caseAdded = true;
                        c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                        c.indent();
                    }
                    c.add("try {");
                    c.indent();
                    ExprCodeGeneratorResult result = ExprCodeGenerator.gencodePreds((List<Expression>)edge.getGuards(), ctxt, "state");
                    c.add("b = %s;", new Object[]{result});
                    exprResults.add(result);
                    c.dedent();
                    c.add("} catch (CifSimulatorException e) {");
                    c.indent();
                    c.add("throw new CifSimulatorException(\"Evaluation of guard(s) \\\"%s\\\" of an urgent edge of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprsToStr((List)edge.getGuards()), (int)1000)), StringEscapeUtils.escapeJava((String)locTxt)});
                    c.dedent();
                    c.add("}");
                    c.add("if (b) return true;");
                }
                if (caseAdded) {
                    c.add("break;");
                    c.dedent();
                }
                ++locIdx;
            }
            c.dedent();
            c.add("}");
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                exprResults.addAll(UrgEdgesCodeGenerator.gencodeUrgEdgesComponent((ComplexComponent)child, ctxt, c));
            }
        }
        return exprResults;
    }
}

