/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.test;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.ESEMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.ESMutateUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.ESPredicates;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.Annotations;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyRunner;
import org.eclipse.emf.emfstore.internal.common.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.modelmutator.ESCrossResourceReferencesModelMutator;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=ESFuzzyRunner.class)
@Annotations.DataProvider(value=ESEMFDataProvider.class)
public class CrossResourceReferencesMutatorTest {
    @Annotations.Data
    private Project project;
    @Annotations.Util
    private ESMutateUtil util;
    @Annotations.Mutator
    private ESCrossResourceReferencesModelMutator mutator;

    @Test
    public void createsCrossResourceReferences() {
        this.mutator.mutateUntil(ESPredicates.hasExternalReference());
        EList resources = this.mutator.getResourceSet().getResources();
        int allObjectsCount = CrossResourceReferencesMutatorTest.computeSize((TreeIterator<EObject>)this.project.eAllContents());
        Resource resource1 = (Resource)resources.get(0);
        Resource resource2 = (Resource)resources.get(1);
        int firstResourceContents = CrossResourceReferencesMutatorTest.computeSize((TreeIterator<EObject>)resource1.getAllContents());
        int secondResourceContents = CrossResourceReferencesMutatorTest.computeSize((TreeIterator<EObject>)resource2.getAllContents());
        System.out.println(String.valueOf(this.getConfig(this.project).getMinObjectsCount()) + " vs. " + allObjectsCount);
        Assert.assertTrue((secondResourceContents > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals((long)(allObjectsCount + 1), (long)firstResourceContents);
        Assert.assertTrue((boolean)ESPredicates.hasExternalReference().apply((Object)this.project));
    }

    @Test
    public void createsCrossResourceReferencesWithTwoResourceSets() {
        Project clonedProject = (Project)EcoreUtil.copy((EObject)this.project);
        ESCrossResourceReferencesModelMutator mutator = new ESCrossResourceReferencesModelMutator(this.getConfig(this.project));
        ESCrossResourceReferencesModelMutator secondMutator = new ESCrossResourceReferencesModelMutator(this.getConfig(clonedProject));
        mutator.mutateUntil(ESPredicates.hasExternalReference());
        secondMutator.mutateUntil(ESPredicates.hasExternalReference());
        EcoreUtil.equals((EObject)this.project, (EObject)clonedProject);
    }

    private static int computeSize(TreeIterator<EObject> allContents) {
        int allObjectsCount = 0;
        while (allContents.hasNext()) {
            allContents.next();
            ++allObjectsCount;
        }
        return allObjectsCount;
    }

    private ESModelMutatorConfiguration getConfig(Project root) {
        ESModelMutatorConfiguration mmc = new ESModelMutatorConfiguration(this.util.getEPackages(), (EObject)root, Long.valueOf(this.util.getSeed()));
        HashSet<EReference> eStructuralFeaturesToIgnore = new HashSet<EReference>();
        eStructuralFeaturesToIgnore.add(ModelPackage.Literals.PROJECT__CUT_ELEMENTS);
        mmc.seteStructuralFeaturesToIgnore(eStructuralFeaturesToIgnore);
        mmc.setMinObjectsCount(this.util.getMinObjectsCount());
        mmc.setDoNotGenerateRoot(true);
        return mmc;
    }
}

