/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.push.PushJob;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.egit.ui.internal.push.PushWizardDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PushOperationUI {
    private final Repository repository;
    private final boolean dryRun;
    private final String destinationString;
    private final RemoteConfig config;
    private PushOperationSpecification spec;
    private CredentialsProvider credentialsProvider;
    private PushOperation op;
    private final String remoteName;
    private final String branchName;
    private PushOperationResult expectedResult;
    private boolean showConfigureButton = true;
    @NonNull
    private PushMode pushMode = PushMode.UPSTREAM;
    private boolean force;

    public PushOperationUI(Repository repository, String remoteName, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = null;
        this.remoteName = remoteName;
        this.branchName = null;
        this.dryRun = dryRun;
        this.destinationString = MessageFormat.format("{0} - {1}", repository.getDirectory().getParentFile().getName(), remoteName);
    }

    public PushOperationUI(Repository repository, RemoteConfig config, boolean dryRun) {
        this(repository, null, config, dryRun);
    }

    public PushOperationUI(Repository repository, String branchName, RemoteConfig config, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = config;
        this.remoteName = null;
        this.branchName = branchName;
        this.dryRun = dryRun;
        this.destinationString = branchName != null ? MessageFormat.format("{0} {1} - {2}", repository.getDirectory().getParentFile().getName(), branchName, config.getName()) : MessageFormat.format("{0} - {1}", repository.getDirectory().getParentFile().getName(), config.getName());
    }

    public PushOperationUI(Repository repository, PushOperationSpecification spec, boolean dryRun) {
        this.repository = repository;
        this.spec = spec;
        this.config = null;
        this.remoteName = null;
        this.branchName = null;
        this.dryRun = dryRun;
        this.destinationString = spec.getURIsNumber() == 1 ? ((URIish)spec.getURIs().iterator().next()).toPrivateString() : MessageFormat.format(UIText.PushOperationUI_MultiRepositoriesDestinationString, spec.getURIsNumber());
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setExpectedResult(PushOperationResult expectedResult) {
        this.expectedResult = expectedResult;
    }

    public void setShowConfigureButton(boolean showConfigureButton) {
        this.showConfigureButton = showConfigureButton;
    }

    public PushOperationResult execute(IProgressMonitor monitor) throws CoreException {
        this.createPushOperation();
        if (this.credentialsProvider != null) {
            this.op.setCredentialsProvider(this.credentialsProvider);
        } else {
            this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        }
        try {
            this.op.run(monitor);
            return this.op.getOperationResult();
        }
        catch (InvocationTargetException e) {
            throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
        }
    }

    private void createPushOperation() throws CoreException {
        if (this.remoteName != null) {
            this.op = new PushOperation(this.repository, this.remoteName, this.dryRun, GitSettings.getRemoteConnectionTimeout());
            return;
        }
        if (this.spec == null) {
            ArrayList<RefSpec> pushRefSpecs = new ArrayList<RefSpec>();
            if (this.branchName == null) {
                pushRefSpecs.addAll(this.config.getPushRefSpecs());
            } else {
                StoredConfig repoConfig = this.repository.getConfig();
                String remoteBranchName = this.branchName;
                BranchConfig branchConfig = new BranchConfig((Config)repoConfig, Repository.shortenRefName((String)this.branchName));
                String trackingBranchName = branchConfig.getMerge();
                if (!branchConfig.isRemoteLocal() && trackingBranchName != null && trackingBranchName.startsWith("refs/heads/")) {
                    remoteBranchName = trackingBranchName;
                }
                pushRefSpecs.add(new RefSpec((this.force ? "+" : "") + this.branchName + ":" + remoteBranchName));
            }
            try {
                this.spec = PushOperationSpecification.create((Repository)this.repository, (RemoteConfig)this.config, pushRefSpecs);
            }
            catch (IOException e) {
                throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
            }
        }
        this.op = new PushOperation(this.repository, this.spec, this.dryRun, GitSettings.getRemoteConnectionTimeout());
    }

    public void start() {
        Repository repo = this.repository;
        if (repo == null) {
            return;
        }
        try {
            this.createPushOperation();
        }
        catch (CoreException e) {
            Activator.showErrorStatus(e.getLocalizedMessage(), e.getStatus());
            return;
        }
        if (this.credentialsProvider != null) {
            this.op.setCredentialsProvider(this.credentialsProvider);
        } else {
            this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        }
        PushJob job = new PushJob(MessageFormat.format(UIText.PushOperationUI_PushJobName, this.destinationString), repo, this.op, this.expectedResult, this.destinationString, this.showConfigureButton, this.pushMode);
        job.setUser(true);
        job.schedule();
    }

    public String getDestinationString() {
        return this.destinationString;
    }

    public void setPushMode(@NonNull PushMode mode) {
        this.pushMode = mode;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public static void pushToUpstream(Shell parent, @NonNull Repository repository) throws IOException {
        PushOperationUI op = PushOperationUI.doPushToUpstream(parent, repository);
        if (op != null) {
            op.start();
        }
    }

    private static PushOperationUI doPushToUpstream(Shell parent, @NonNull Repository repository) throws IOException {
        StoredConfig config;
        String fullBranch = repository.getFullBranch();
        if (ObjectId.isId((String)fullBranch)) {
            PushOperationUI.pushBranchDialog(parent, repository);
            return null;
        }
        String shortBranch = Repository.shortenRefName((String)fullBranch);
        RemoteConfig remoteCfg = PushOperation.getRemote((String)shortBranch, (Config)(config = repository.getConfig()));
        if (remoteCfg == null) {
            PushOperationUI.nothingToPush(parent);
            return null;
        }
        List refSpecs = remoteCfg.getPushRefSpecs();
        if (!refSpecs.isEmpty()) {
            RefSpec match = refSpecs.stream().filter(RefSpec::isMatching).findAny().orElse(null);
            if (match != null) {
                if (repository.getRefDatabase().getRefsByPrefix("refs/heads/").size() > 1 && !PushOperationUI.warnMatching(parent, RepositoryUtil.INSTANCE.getRepositoryName(repository), remoteCfg.getName(), MessageFormat.format(UIText.PushOperationUI_PushMatchingPushRefSpec, remoteCfg.getName(), match))) {
                    return null;
                }
            } else {
                List<String> allLocalNames;
                Collection updates = Transport.findRemoteRefUpdatesFor((Repository)repository, (Collection)refSpecs, (Collection)remoteCfg.getFetchRefSpecs());
                if (updates.isEmpty()) {
                    PushOperationUI.nothingToPush(parent);
                    return null;
                }
                if (updates.size() > 1 && !PushOperationUI.warnMultiple(parent, allLocalNames = updates.stream().map(RemoteRefUpdate::getSrcRef).collect(Collectors.toList()))) {
                    return null;
                }
            }
            return new PushOperationUI(repository, remoteCfg.getName(), false);
        }
        PushConfig.PushDefault pushDefault = ((PushConfig)config.get(PushConfig::new)).getPushDefault();
        switch (pushDefault) {
            case CURRENT: {
                return new PushOperationUI(repository, remoteCfg.getName(), false);
            }
            case MATCHING: {
                int numberOfBranches = repository.getRefDatabase().getRefsByPrefix("refs/heads/").size();
                if (numberOfBranches == 0) {
                    PushOperationUI.nothingToPush(parent);
                    return null;
                }
                if (numberOfBranches > 1 && !PushOperationUI.warnMatching(parent, RepositoryUtil.INSTANCE.getRepositoryName(repository), remoteCfg.getName(), "push.default=matching")) {
                    return null;
                }
                PushOperationSpecification spec = PushOperationSpecification.create((Repository)repository, (RemoteConfig)remoteCfg, Collections.singleton(new RefSpec(":")));
                return new PushOperationUI(repository, spec, false);
            }
            case NOTHING: {
                PushOperationUI.nothingToPush(parent);
                return null;
            }
            case UPSTREAM: 
            case SIMPLE: {
                boolean isTriangular;
                BranchConfig branchCfg = new BranchConfig((Config)config, shortBranch);
                String upstreamBranch = branchCfg.getMerge();
                if (upstreamBranch == null) {
                    PushOperationUI.pushBranchDialog(parent, repository);
                    return null;
                }
                String fetchRemote = branchCfg.getRemote();
                if (fetchRemote == null) {
                    fetchRemote = "origin";
                }
                boolean bl = isTriangular = !fetchRemote.equals(remoteCfg.getName());
                if (isTriangular) {
                    if (PushConfig.PushDefault.UPSTREAM.equals((Object)pushDefault)) {
                        PushOperationUI.pushBranchDialog(parent, repository);
                        return null;
                    }
                    return new PushOperationUI(repository, remoteCfg.getName(), false);
                }
                if (PushConfig.PushDefault.SIMPLE.equals((Object)pushDefault) && !upstreamBranch.equals(fullBranch)) {
                    PushOperationUI.pushBranchDialog(parent, repository);
                    return null;
                }
                return new PushOperationUI(repository, fullBranch, remoteCfg, false);
            }
        }
        throw new IllegalStateException("Unknown push.default: " + String.valueOf(pushDefault));
    }

    private static void nothingToPush(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)UIText.SimplePushActionHandler_NothingToPushDialogTitle, (String)UIText.SimplePushActionHandler_NothingToPushDialogMessage);
    }

    private static void pushBranchDialog(Shell shell, @NonNull Repository repo) throws IOException {
        Wizard wizard = PushMode.UPSTREAM.getWizard(repo, null, false);
        if (wizard != null) {
            PushWizardDialog dialog = new PushWizardDialog(shell, (IWizard)wizard);
            dialog.open();
        }
    }

    private static boolean warnMatching(Shell shell, String repository, String remote, String cause) {
        MessageDialog dialog = new MessageDialog(shell, UIText.PushOperationUI_PushMatchingTitle, null, MessageFormat.format(UIText.PushOperationUI_PushMatchingMessage, repository, remote, cause), 3, 0, new String[]{UIText.PushOperationUI_PushMultipleOkLabel, IDialogConstants.CANCEL_LABEL});
        return dialog.open() == 0;
    }

    private static boolean warnMultiple(Shell shell, List<String> refNames) {
        PushMultipleDialog dialog = new PushMultipleDialog(shell, refNames);
        return dialog.open() == 0;
    }

    private static class PushMultipleDialog
    extends MessageDialog {
        private final List<String> names;

        PushMultipleDialog(Shell parent, List<String> names) {
            super(parent, UIText.PushOperationUI_PushMultipleTitle, null, UIText.PushOperationUI_PushMultipleMessage, 2, 0, new String[]{UIText.PushOperationUI_PushMultipleOkLabel, IDialogConstants.CANCEL_LABEL});
            this.names = names;
        }

        protected Control createCustomArea(Composite parent) {
            LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
            parent.addDisposeListener(arg_0 -> PushMultipleDialog.lambda$0((ResourceManager)resources, arg_0));
            TableViewer table = new TableViewer(parent, 520);
            table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            table.setLabelProvider((IBaseLabelProvider)LabelProvider.createImageProvider(arg_0 -> PushMultipleDialog.lambda$1((ResourceManager)resources, arg_0)));
            table.setInput(this.names);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.heightHint = Math.min(20, this.names.size() + 1) * table.getTable().getItemHeight();
            table.getControl().setLayoutData((Object)layoutData);
            return table.getControl();
        }

        private static /* synthetic */ void lambda$0(ResourceManager resourceManager, DisposeEvent event) {
            resourceManager.dispose();
        }

        private static /* synthetic */ Image lambda$1(ResourceManager resourceManager, Object element) {
            if (element.toString().startsWith("refs/heads/")) {
                return UIIcons.getImage(resourceManager, UIIcons.BRANCH);
            }
            return UIIcons.getImage(resourceManager, UIIcons.COMMIT);
        }
    }
}

