/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class AboutDialog
extends AdminDialog {
    private static final long serialVersionUID = 3654269274511563780L;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public AboutDialog(Frame parent) {
        super(parent, "", 32);
        this.setTitle(acr.getString("A1126"));
    }

    @Override
    public JPanel createWorkPanel() {
        JPanel workPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        workPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPanel = this.makeLeftPanel();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        gridbag.setConstraints(leftPanel, c);
        workPanel.add(leftPanel);
        JPanel rightPanel = this.makeRightPanel();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 18;
        c.ipadx = 20;
        gridbag.setConstraints(rightPanel, c);
        workPanel.add(rightPanel);
        return workPanel;
    }

    private JPanel makeLeftPanel() {
        JPanel leftPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        leftPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        JLabel label1 = new JLabel(AGraphics.adminImages[37]);
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(label1, c);
        leftPanel.add(label1);
        return leftPanel;
    }

    private JPanel makeRightPanel() {
        LabelledComponent tmpLabelC;
        int gridy = 0;
        Version version = new Version(false);
        JPanel rightPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        rightPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(version.getProductName() + " " + version.getReleaseQID());
        c.gridx = 0;
        c.gridy = gridy++;
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        rightPanel.add(label);
        label = new JLabel(acr.getString("A1440", version.getBuildVersion()));
        c.gridx = 0;
        c.gridy = gridy++;
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        rightPanel.add(label);
        label = new JLabel(acr.getString("A1441", version.getBuildDate()));
        c.gridx = 0;
        c.gridy = gridy++;
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        rightPanel.add(label);
        JSeparator sep = new JSeparator();
        c.gridx = 0;
        c.gridy = gridy++;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        c.anchor = 17;
        gridbag.setConstraints(sep, c);
        rightPanel.add(sep);
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        label = new JLabel(acr.getString("A1443", version.getVersionPackageName()));
        c.gridx = 0;
        int n = ++gridy;
        ++gridy;
        c.gridy = n;
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        rightPanel.add(label);
        c.insets = new Insets(0, 0, 0, 0);
        String[] patchids = version.getPatchIds();
        LabelledComponent[] lvpItems = patchids == null || patchids.length < 1 ? new LabelledComponent[3] : new LabelledComponent[4];
        lvpItems[0] = tmpLabelC = new LabelledComponent(acr.getString("A1444"), new JLabel(version.getImplementationVersion()));
        lvpItems[1] = tmpLabelC = new LabelledComponent(acr.getString("A1445"), new JLabel(version.getProtocolVersion()));
        lvpItems[2] = tmpLabelC = new LabelledComponent(acr.getString("A1446"), new JLabel(version.getTargetJMSVersion()));
        if (patchids != null && patchids.length >= 1) {
            JPanel patchPanel = new JPanel();
            GridBagLayout gb = new GridBagLayout();
            patchPanel.setLayout(gb);
            GridBagConstraints c2 = new GridBagConstraints();
            for (int p = 0; p < patchids.length; ++p) {
                c2.gridx = 0;
                c2.gridy = p;
                c2.ipadx = 0;
                c2.ipady = 0;
                c2.anchor = 17;
                JLabel patchLabel = new JLabel(patchids[p]);
                gb.setConstraints(patchLabel, c2);
                patchPanel.add(patchLabel);
            }
            lvpItems[3] = tmpLabelC = new LabelledComponent(acr.getString("A1448"), (JComponent)patchPanel, 0);
        }
        LabelValuePanel lvp = new LabelValuePanel(lvpItems, 4, 0);
        c.gridx = 0;
        c.gridy = gridy++;
        c.anchor = 17;
        gridbag.setConstraints(lvp, c);
        rightPanel.add(lvp);
        label = new JLabel(acr.getString("A1438") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
        c.gridx = 0;
        c.gridy = gridy++;
        c.insets = new Insets(5, 0, 0, 0);
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        rightPanel.add(label);
        String classpathStr = System.getProperty("java.class.path");
        classpathStr = classpathStr.replace(File.pathSeparatorChar, '\n');
        JTextArea ta = new JTextArea(classpathStr);
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        Color bgColor = rightPanel.getBackground();
        ta.setBackground(bgColor);
        Color fgColor = label.getForeground();
        ta.setForeground(fgColor);
        ta.setFont(label.getFont());
        int width = label.getPreferredSize().width;
        ta.setSize(width, 1);
        tmpLabelC = new LabelledComponent(acr.getString("A1439"), (JComponent)ta, 0);
        c.gridx = 0;
        c.gridy = gridy++;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        gridbag.setConstraints(tmpLabelC, c);
        rightPanel.add(tmpLabelC);
        sep = new JSeparator();
        c.gridx = 0;
        c.gridy = gridy++;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        c.anchor = 17;
        gridbag.setConstraints(sep, c);
        rightPanel.add(sep);
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        ta = new JTextArea(version.getCopyright(1), 8, 0);
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        bgColor = rightPanel.getBackground();
        ta.setBackground(bgColor);
        fgColor = label.getForeground();
        ta.setForeground(fgColor);
        ta.setFont(label.getFont());
        width = rightPanel.getPreferredSize().width;
        ta.setSize(width, 1);
        JScrollPane sp = new JScrollPane(ta);
        c.gridx = 0;
        c.gridy = gridy++;
        c.anchor = 17;
        gridbag.setConstraints(sp, c);
        rightPanel.add(sp);
        label = new JLabel(acr.getString("A1447"));
        c.gridx = 0;
        c.gridy = gridy++;
        c.ipady = 10;
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        rightPanel.add(label);
        return rightPanel;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setDefaultButton(32);
        }
        super.setVisible(visible);
    }

    @Override
    public void doOK() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doClose() {
        this.setVisible(false);
    }

    @Override
    public void doClear() {
    }
}

