/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.invoke.MethodHandles;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class ProviderImplGenerator {
    private static final Logger logger = FlashlightLoggerInfo.getLogger();

    public String defineClass(FlashlightProbeProvider provider, Class providerClazz) {
        String generatedClassName = provider.getModuleProviderName() + "_Flashlight_" + provider.getModuleName() + "_Probe_" + (provider.getProbeProviderName() == null ? providerClazz.getName() : provider.getProbeProviderName());
        generatedClassName = providerClazz.getName() + "_" + generatedClassName;
        byte[] classData = this.generateClassData(provider, providerClazz, generatedClassName);
        try {
            MethodHandles.privateLookupIn(providerClazz, MethodHandles.lookup()).defineClass(classData);
            return generatedClassName;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateClassData(FlashlightProbeProvider provider, Class providerClazz, String generatedClassName) {
        Type classType = Type.getType((Class)providerClazz);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("** classType: " + String.valueOf(classType));
            logger.fine("** classDesc: " + Type.getDescriptor((Class)providerClazz));
            logger.fine("Generating for: " + generatedClassName);
        }
        generatedClassName = generatedClassName.replace('.', '/');
        int cwFlags = 3;
        ClassWriter cw = new ClassWriter(cwFlags);
        int access = 17;
        String[] interfaces = new String[]{providerClazz.getName().replace('.', '/')};
        cw.visit(61, access, generatedClassName, null, "java/lang/Object", interfaces);
        for (FlashlightProbe flashlightProbe : provider.getProbes()) {
            Type probeType = Type.getType(FlashlightProbe.class);
            int fieldAccess = 1;
            String fieldName = "_flashlight_" + flashlightProbe.getProbeName();
            cw.visitField(fieldAccess, fieldName, probeType.getDescriptor(), null, null);
        }
        Type probeType = Type.getType(FlashlightProbe.class);
        for (FlashlightProbe probe : provider.getProbes()) {
            StringBuilder methodDesc = new StringBuilder();
            methodDesc.append("void ").append(probe.getProviderJavaMethodName());
            methodDesc.append("(");
            String delim = "";
            for (Class paramType : probe.getParamTypes()) {
                methodDesc.append(delim).append(paramType.getName());
                delim = ", ";
            }
            methodDesc.append(")");
            Method m = Method.getMethod((String)methodDesc.toString());
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
            String fieldName = "_flashlight_" + probe.getProbeName();
            gen.loadThis();
            gen.visitFieldInsn(180, generatedClassName, fieldName, probeType.getDescriptor());
            int index = gen.newLocal(probeType);
            gen.storeLocal(index);
            gen.loadLocal(index);
            gen.invokeVirtual(probeType, Method.getMethod((String)"boolean isEnabled()"));
            gen.push(true);
            Label enabledLabel = new Label();
            Label notEnabledLabel = new Label();
            gen.ifCmp(Type.getType(Boolean.TYPE), 153, enabledLabel);
            gen.goTo(notEnabledLabel);
            gen.visitLabel(enabledLabel);
            gen.loadLocal(index);
            gen.loadArgArray();
            gen.invokeVirtual(probeType, Method.getMethod((String)"void fireProbe(Object[])"));
            gen.visitLabel(notEnabledLabel);
            gen.returnValue();
            gen.endMethod();
        }
        this.generateConstructor(cw, generatedClassName, provider);
        cw.visitEnd();
        byte[] byArray = cw.toByteArray();
        int index = generatedClassName.lastIndexOf(46);
        String clsName = generatedClassName.substring(index + 1);
        if (Boolean.parseBoolean(System.getenv("AS_DEBUG"))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Generated ClassDATA " + clsName);
            }
            clsName = clsName.replace('.', '/');
            index = (clsName = clsName.replace('\\', '/')).lastIndexOf("/");
            if (index >= 0) {
                clsName = clsName.substring(index + 1);
            }
            FileOutputStream fos = null;
            try {
                File file;
                String rootPath = System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()) + File.separator + "lib" + File.separator;
                String fileName = rootPath + clsName + ".class";
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ClassFile: " + fileName);
                }
                if (FileUtils.mkdirsMaybe((File)(file = new File(fileName)).getParentFile())) {
                    fos = new FileOutputStream(file);
                    fos.write(byArray);
                    fos.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    private void generateConstructor(ClassWriter cw, String generatedClassName, FlashlightProbeProvider provider) {
        Method m = Method.getMethod((String)"void <init> ()");
        GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        gen.loadThis();
        gen.invokeConstructor(Type.getType(Object.class), m);
        Type probeRegType = Type.getType(ProbeRegistry.class);
        Type probeType = Type.getType(FlashlightProbe.class);
        gen.loadThis();
        for (FlashlightProbe probe : provider.getProbes()) {
            gen.dup();
            String fieldName = "_flashlight_" + probe.getProbeName();
            gen.push(probe.getId());
            gen.invokeStatic(probeRegType, Method.getMethod((String)"org.glassfish.flashlight.provider.FlashlightProbe getProbeById(int)"));
            gen.visitFieldInsn(181, generatedClassName, fieldName, probeType.getDescriptor());
        }
        gen.pop();
        gen.returnValue();
        gen.endMethod();
    }
}

