/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.changebroker.internal.Strategy;
import org.eclipse.emf.ecp.changebroker.spi.ChangeObserver;

public class ContainingEClassStrategy
implements Strategy {
    private final Map<EClass, Set<ChangeObserver>> registry = new LinkedHashMap<EClass, Set<ChangeObserver>>();
    private final Map<ChangeObserver, Set<EClass>> observerToKey = new LinkedHashMap<ChangeObserver, Set<EClass>>();

    public void register(ChangeObserver observer, EClass eClass) {
        if (!this.registry.containsKey(eClass)) {
            this.registry.put(eClass, new LinkedHashSet());
        }
        this.registry.get(eClass).add(observer);
        if (!this.observerToKey.containsKey(observer)) {
            this.observerToKey.put(observer, new LinkedHashSet());
        }
        this.observerToKey.get(observer).add(eClass);
    }

    @Override
    public Set<ChangeObserver> getObservers(Notification notification) {
        LinkedHashSet<ChangeObserver> observers = new LinkedHashSet<ChangeObserver>();
        Set<EClass> allEClasses = this.getEClassFromNotification(notification);
        for (EClass eClass : allEClasses) {
            LinkedHashSet<EClass> eClassesToCheck = new LinkedHashSet<EClass>((Collection<EClass>)eClass.getESuperTypes());
            eClassesToCheck.add(eClass);
            for (EClass eClassToCheck : eClassesToCheck) {
                if (!this.registry.containsKey(eClassToCheck)) continue;
                observers.addAll((Collection<ChangeObserver>)this.registry.get(eClassToCheck));
            }
        }
        return observers;
    }

    private Set<EClass> getEClassFromNotification(Notification notification) {
        LinkedHashSet<EClass> allEClasses = new LinkedHashSet<EClass>();
        EObject notifier = (EObject)notification.getNotifier();
        while (notifier != null) {
            allEClasses.add(notifier.eClass());
            notifier = notifier.eContainer();
        }
        return allEClasses;
    }

    @Override
    public void deregister(ChangeObserver observer) {
        Set<EClass> keys = this.observerToKey.remove(observer);
        if (keys == null) {
            return;
        }
        for (EClass eClass : keys) {
            Set<ChangeObserver> set = this.registry.get(eClass);
            set.remove(observer);
            if (!set.isEmpty()) continue;
            this.registry.remove(eClass);
        }
    }

    @Override
    public Set<ChangeObserver> getAllObservers() {
        return new LinkedHashSet<ChangeObserver>(this.observerToKey.keySet());
    }
}

