/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.InputStream;
import java.util.List;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.application.ApplicationImpl;
import org.eclipse.rap.rwt.internal.resources.ContentBuffer;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.ui.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceRegisterer {
    private final Application application;
    private final ApplicationContextImpl applicationContext;
    private final ContentBuffer concatenatedScript;

    public ResourceRegisterer(Application application) {
        this.application = application;
        this.applicationContext = ((ApplicationImpl)application).getApplicationContext();
        this.concatenatedScript = new ContentBuffer();
    }

    public void registerResources(List<IResource> resources) {
        for (IResource resource : resources) {
            if (resource == null) continue;
            this.registerResource(resource);
        }
        if (this.concatenatedScript.getContent().length > 0) {
            this.registerConcatenatedScript();
        }
    }

    private void registerResource(IResource resource) {
        if (resource.isExternal()) {
            this.applicationContext.getStartupPage().addJsLibrary(resource.getLocation());
        } else if (resource.isJSLibrary()) {
            this.appendToConcatenatedScript(resource);
        } else {
            String location = resource.getLocation();
            this.application.addResource(location, (ResourceLoader)new WorkbenchResourceLoader(resource));
        }
    }

    private void appendToConcatenatedScript(IResource resource) {
        try {
            this.concatenatedScript.append(resource.getLoader().getResourceAsStream(resource.getLocation()));
        }
        catch (Exception exception) {
            String message = "Failed to load resource: " + resource.getLocation();
            throw new IllegalArgumentException(message, exception);
        }
    }

    private void registerConcatenatedScript() {
        this.application.addResource("resources.js", new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) {
                return ResourceRegisterer.this.concatenatedScript.getContentAsStream();
            }
        });
        this.applicationContext.getStartupPage().addJsLibrary("rwt-resources/resources.js");
    }

    private static class WorkbenchResourceLoader
    implements ResourceLoader {
        private final IResource resource;

        private WorkbenchResourceLoader(IResource resource) {
            this.resource = resource;
        }

        public InputStream getResourceAsStream(String resourceName) {
            return this.resource.getLoader().getResourceAsStream(this.resource.getLocation());
        }
    }
}

