/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc.details;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ua.core.toc.text.TocLink;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocFileValidator;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocTreeSection;
import org.eclipse.pde.internal.ua.ui.editor.toc.details.TocAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.toc.details.TocDetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TocLinkDetails
extends TocAbstractDetails {
    private TocLink fDataTOCLink = null;
    private FormEntry fTocPathEntry = null;

    public TocLinkDetails(TocTreeSection masterSection) {
        super(masterSection, "toc-context");
    }

    public void setData(TocLink object) {
        this.fDataTOCLink = object;
    }

    @Override
    protected TocObject getDataObject() {
        return this.fDataTOCLink;
    }

    @Override
    protected FormEntry getPathEntryField() {
        return this.fTocPathEntry;
    }

    @Override
    protected boolean isTocPath() {
        return true;
    }

    @Override
    public void createFields(Composite parent) {
        this.createTocPathWidget(parent);
    }

    private void createTocPathWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), TocDetailsMessages.TocLinkDetails_locationDesc);
        this.fTocPathEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), TocDetailsMessages.TocLinkDetails_locationText, TocDetailsMessages.TocLinkDetails_browse, this.isEditable());
    }

    @Override
    protected String getDetailsTitle() {
        return TocDetailsMessages.TocLinkDetails_title;
    }

    @Override
    protected String getDetailsDescription() {
        return null;
    }

    @Override
    public void hookListeners() {
        this.createTocPathEntryListeners();
    }

    private void createTocPathEntryListeners() {
        this.fTocPathEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (TocLinkDetails.this.fDataTOCLink != null) {
                    TocLinkDetails.this.fDataTOCLink.setFieldTocPath(TocLinkDetails.this.fTocPathEntry.getValue());
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                TocLinkDetails.this.handleBrowse();
            }

            public void linkActivated(HyperlinkEvent e) {
                TocLinkDetails.this.handleOpen();
            }
        });
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new TocFileValidator((IBaseModel)this.fDataTOCLink.getModel()));
        dialog.setAllowMultiple(false);
        dialog.setTitle(TocDetailsMessages.TocLinkDetails_dialogTitle);
        dialog.setMessage(TocDetailsMessages.TocLinkDetails_dialogMessage);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("xml"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            this.setPathEntry(file);
        }
    }

    @Override
    public void updateFields() {
        if (this.fDataTOCLink != null) {
            this.updateTocPathEntry(this.isEditableElement());
        }
    }

    private void updateTocPathEntry(boolean editable) {
        this.fTocPathEntry.setValue(this.fDataTOCLink.getFieldTocPath(), true);
        this.fTocPathEntry.setEditable(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fTocPathEntry.commit();
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object != null && object instanceof TocLink) {
            this.setData((TocLink)object);
            this.updateFields();
        }
    }
}

