/*******************************************************************************
 * Copyright (c) 2014, 2022 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Code 9 Corporation - on going enhancements and maintenance
 *     Brian de Alwis (MTI) - bug 429420
 *     Fabian Miehe - Bug 440420
 *     Martin Karpisek <martin.karpisek@gmail.com> - Bug 438509
 *     Axel Richard (Obeo) - Bug 41353 - Launch configurations prototypes
 *     Kit Lo (IBM) - Bug 244461 - Duplicating colon in error message
 *     Alexander Fedorov <alexander.fedorov@arsysop.ru> - Bug 547222
 *******************************************************************************/
package org.eclipse.pde.internal.ui;

import org.eclipse.osgi.util.NLS;

public class PDEUIMessages extends NLS {
	private static final String BUNDLE_NAME = "org.eclipse.pde.internal.ui.pderesources";//$NON-NLS-1$

	public static String AbstractLauncherToolbar_noProblems;

	public static String AbstractLauncherToolbar_noSelection;

	public static String AbstractLauncherToolbar_noSelection_plugins;

	public static String AbstractLauncherToolbar_noSelection_bundles;

	public static String AbstractSchemaDetails_descriptionLabel;

	public static String AbstractTargetPage_setTarget;

	public static String AbstractTargetPage_reloadTarget;

	public static String AddActivationHeaderResolution_label;

	public static String AddAutomaticModuleResolution_desc;

	public static String AddAutomaticModuleResolution_label;

	public static String AddLibraryDialog_nospaces;

	public static String BaseExtensionPointMainPage_errorMsgPluginNotFound;

	public static String BuildSiteJob_name;

	public static String BundleSourcePage_renameActionText;

	public static String BundlesTab_title;

	public static String CalculateUsesOperation_calculatingDirective;

	public static String ContentSection_0;

	public static String ContentSection_1;

	public static String ContentSection_2;

	public static String DefaultJUnitWorkspaceBlock_name;

	public static String DefinitionPage_0;

	public static String DefinitionPage_1;

	public static String DependenciesViewPage_showFragments;

	public static String DependenciesViewPage_showOptional;

	public static String DependencyPropertiesDialog_exportGroupText;
	public static String DependencyPropertiesDialog_closeButtonLabel;

	public static String ExtensionsPage_toggleExpandState;
	public static String ExternalizeStringsOperation_editNames_addComment;

	public static String ExternalizeStringsOperation_editNames_insertProperty;

	public static String ExternalizeStringsOperation_editNames_replaceText;

	public static String ExternalizeStringsOperation_pluginChangeName;

	public static String ExternalizeStringsProcessor_errorMessage;

	public static String FeatureBlock_AdditionalPluginsEntry;

	public static String FeatureBlock_AdditionalPluginsEntry_plugins;

	public static String FeatureBlock_AdditionalPluginsEntry_bundles;

	public static String FeatureBlock_AddPluginsLabel;

	public static String FeatureBlock_AddPluginsLabel_plugins;

	public static String FeatureBlock_AddPluginsLabel_bundles;

	public static String FeatureBlock_AllFeatureSelected;

	public static String FeatureBlock_RemovePluginsLabel;

	public static String FeatureBlock_RemovePluginsLabel_plugins;

	public static String FeatureBlock_RemovePluginsLabel_bundles;

	public static String FeatureBlock_addRequiredFeatues;

	public static String FeatureBlock_default;

	public static String FeatureBlock_defaultPluginResolution;

	public static String FeatureBlock_features;

	public static String FeatureBlock_pluginResolution;

	public static String FeatureBlock_externalBefore;

	public static String FeatureBlock_ExternalResolutionLabel;

	public static String FeatureBlock_SelectFeatures;

	public static String FeatureBlock_UseWorkspaceFeatures;

	public static String FeatureBlock_workspaceBefore;

	public static String FeatureBlock_WorkspaceResolutionLabel;

	public static String FeatureEditor_exportTooltip;

	public static String JavaArgumentsTab_addVMArgs;

	public static String OrganizeManifestsProcessor_invalidParam;

	public static String OrganizeManifestsProcessor_rootMessage;

	public static String PDECompilersConfigurationBlock_0;
	public static String PDECompilersConfigurationBlock_1;
	public static String PDECompilersConfigurationBlock_2;
	public static String PDECompilersConfigurationBlock_3;
	public static String PDECompilersConfigurationBlock_4;
	public static String PDECompilersConfigurationBlock_5;
	public static String PDECompilersConfigurationBlock_6;
	public static String PDECompilersConfigurationBlock_7;

	public static String PDECompilersConfigurationBlock_8;

	public static String PDECompilersConfigurationBlock_general;
	public static String PDECompilersConfigurationBlock_versioning;
	public static String PDECompilersConfigurationBlock_references;
	public static String PDECompilersConfigurationBlock_setting_changed_project;
	public static String PDECompilersConfigurationBlock_settings_changed;
	public static String PDECompilersConfigurationBlock_settings_changed_all;
	public static String PDECompilersConfigurationBlock_usage;
	public static String PDECompilersConfigurationBlock_build;
	public static String PDECompilersConfigurationBlock_buildButtonLabel;
	public static String PDECompilersConfigurationBlock_dontBuildButtonLabel;

	public static String PDEWizardNewFileCreationPage_errorMsgStartsWithDot;

	public static String CommandComposerPart_formTitle;

	public static String CommandCopyFilter_cheatsheet;

	public static String CommandCopyFilter_cheatsheetDesc;

	public static String CommandCopyFilter_help;

	public static String CommandCopyFilter_helpDesc;

	public static String CommandCopyFilter_intro;

	public static String CommandCopyFilter_introDesc;

	public static String CommandCopyFilter_noFilter;

	public static String CommandCopyFilter_noFilterDesc;

	public static String CommandDetails_clear;

	public static String CommandDetails_commandResult;

	public static String CommandDetails_copyToClipboard;

	public static String CommandDetails_copytooltip;

	public static String CommandDetails_execError;

	public static String CommandDetails_execute;

	public static String CommandDetails_executeText;

	public static String CommandDetails_groupName;

	public static String CommandDetails_id;

	public static String CommandDetails_includeMarkup;

	public static String CommandDetails_markupTooltip;

	public static String CommandDetails_noComSelected;

	public static String CommandDetails_noParameters;

	public static String CommandDetails_numParams;

	public static String CommandDetails_param;

	public static String CommandDetails_paramValueMessage;

	public static String CommandDetails_preview;

	public static String CommandList_clearTooltip;

	public static String CommandList_collapseAll0;

	public static String CommandList_groupName;

	public static String CommandSerializerPart_name;
	public static String CompilersConfigurationTab_incompatEnv;

	public static String ContainerRenameParticipant_renameFolders;
	public static String ContainerRenameParticipant_renameBundleId;

	public static String ControlValidationUtility_errorMsgFilterInvalidSyntax;
	public static String ControlValidationUtility_errorMsgKeyNotFound;
	public static String ControlValidationUtility_errorMsgNotOnClasspath;
	public static String ControlValidationUtility_errorMsgPluginUnresolved;
	public static String ControlValidationUtility_errorMsgValueMustBeSpecified;
	public static String ControlValidationUtility_errorMsgValueNotExternalized;

	public static String CalculateUsesAction_jobName;

	public static String ExportDestinationTab_InstallIntoCurrentPlatform;

	public static String ExportPackageSection_uses;

	public static String ExtensionElementBodyTextDetails_labelBodyText;

	public static String ExtensionElementBodyTextDetails_sectionDescElementGeneral;

	public static String ExtensionElementBodyTextDetails_sectionDescElementSpecific;

	public static String ExtensionPointsSection_sectionDescAllExtensionPoints;

	public static String ExtensionsSection_Remove;

	public static String ExtensionsSection_sectionDescExtensionsMaster;

	public static String JRESection_eeBoundJRE;

	public static String JRESection_eePreference;

	public static String JRESection_eeUnboundJRE;

	public static String JRESection_jrePreference;

	public static String LauncherUtils_workspaceLocked;

	public static String LauncherUtils_clearLogFile;

	public static String LauncherUtils_edit;

	public static String LauncherUtils_cancelLaunch;

	public static String LauncherUtils_generateConfigIni;

	public static String OrganizeManifestsWizardPage_calculateUses;

	public static String OverviewPage_contentDescription;

	public static String OverviewPage_contentTitle;

	public static String OverviewPage_environmentDescription;

	public static String OverviewPage_environmentTitle;

	public static String PackageFinder_taskName;

	public static String PluginContentMergeViewer_title;

	public static String PluginExportJob_name;

	public static String PluginExportWizard_Ant_errors_during_export_logs_generated;

	public static String PluginExportWizard_InstallJobName;

	public static String PluginEditor_exportTooltip;

	public static String PluginListPage_initializeFromLaunch;

	public static String PluginListPage_initializeFromPlugins;

	public static String PluginSection_includeOptional;

	public static String PluginsTab_allPlugins;

	public static String PluginsTab_customFeatureMode;

	public static String PluginsTab_launchWith;

	public static String PluginsTab_selectedPlugins;

	public static String PluginsTab_AttributeLabel_UseDefault;
	public static String PluginsTab_AttributeLabel_IncludeOptional;
	public static String PluginsTab_AttributeLabel_AutomaticAdd;
	public static String PluginsTab_AttributeLabel_UseCustomFeatures;
	public static String PluginsTab_AttributeLabel_DefaultAutoStart;
	public static String PluginsTab_AttributeLabel_DefaultStartLevel;
	public static String PluginsTab_AttributeLabel_DeselectedWorkspacePlugins;
	public static String PluginsTab_AttributeLabel_SelectedWorkspacePlugins;
	public static String PluginsTab_AttributeLabel_SelectedTargetPlugins;
	public static String PluginsTab_AttributeLabel_FeaturePluginResolution;
	public static String PluginsTab_AttributeLabel_FeatureDefaultLocation;
	public static String PluginsTab_AttributeLabel_AutomaticValidate;
	public static String PluginsTab_AttributeLabel_OnlyShowSelected;
	public static String PluginsTab_AttributeLabel_SelectedFeatures;
	public static String PluginsTab_AttributeLabel_AdditionalPlugins;

	public static String PluginsTabToolBar_auto_validate;

	public static String PluginsTabToolBar_auto_validate_plugins;

	public static String PluginsTabToolBar_auto_validate_bundles;

	public static String PluginsTabToolBar_validate;

	public static String PluginsTabToolBar_validate_plugins;

	public static String PluginsTabToolBar_validate_bundles;

	public static String PluginStructureCreator_name;

	public static String PointSelectionPage_cannotFindTemplate;

	public static String ProductExportJob_name;

	public static String ProductEditor_exportTooltip;

	public static String ProductEditor_launchFailed;

	public static String RemoveSplashHandlerBindingAction_msgProgressRemoveProductBindings;

	public static String RenamePluginAction_label;

	public static String RenamePluginProcessor_changeTitle;

	public static String RenamePluginProcessor_externalBundleError;

	public static String RenamePluginProcessor_noManifestError;

	public static String RenamePluginProcessor_processorName;

	public static String RenamePluginProcessor_renameProjectDesc;

	public static String RenamePluginWizardPage_idNotSet;

	public static String RenamePluginWizardPage_invalidId;

	public static String RenamePluginWizardPage_newId;

	public static String RenameExtensionPointProcessor_changeTitle;

	public static String RenameExtensionPointProcessor_processorName;

	public static String RenameExtensionPointWizard_pageTitle;

	public static String RenamePluginWizardPage_renameProject;

	public static String RenamePluginWizardPage_updateReferences;

	public static String RenameProjectChange_destinationExists;

	public static String RenameProjectChange_name;

	public static String RenameProjectChange_projectDoesNotExist;

	public static String RenameProjectChange_taskTitle;

	public static String RenameProvidePackageResolution_desc;

	public static String RenameProvidePackageResolution_label;

	public static String RequiresSection_sortAlpha;

	public static String SchemaDtdDetailsSection_title;

	public static String SchemaEditor_ElementSection_newChoice;

	public static String SchemaEditor_ElementSection_newSequence;

	public static String SchemaEditor_ElementSection_remove;

	public static String SchemaPreviewLauncher_msgEditorHasUnsavedChanges;

	public static String SchemaPreviewLauncher_msgSaveChanges;

	public static String EditorSourcePage_name;

	public static String SplashConfigurationSection_none;

	public static String SplashConfigurationSection_msgDecorationTemplateSupport;

	public static String SplashConfigurationSection_msgTooltipOffsetRelative;

	public static String SplashConfigurationSection_sectionDescCustomization;

	public static String SplashPage_splashName;

	public static String SplashProgressSection_progressName;

	public static String SplashProgressSection_progressSectionDesc;

	public static String SplashTemplatesSection_typeName;

	public static String StateViewPage_ChangeTargetPlatform;

	public static String StateViewPage_importedPackages;

	public static String StateViewPage_openItem;

	public static String StateViewPage_requiredBundles;

	public static String StateViewPage_showLeaves;

	public static String StateViewPage_showOnlyUnresolved_label;

	public static String StateViewPage_suppliedBy;

	public static String StateViewPage_suppliedByJRE;

	public static String TargetCreationPage_0;

	public static String TargetCreationPage_1;

	public static String TargetCreationPage_2;

	public static String TargetCreationPage_3;

	public static String TargetCreationPage_4;

	public static String TargetCreationPage_6;

	public static String UpdateActivationResolution_bundleActivationPolicy_desc;
	public static String UpdateActivationResolution_bundleActivationPolicy_label;

	public static String ExportOptionsTab_antReservedMessage;
	public static String ExportOptionsTab_allowBinaryCycles;

	public static String ExportOptionsTab_use_workspace_classfiles;

	public static String ExtensionsPage_sortAlpha;

	public static String FileRenameParticipant_renameFiles;

	public static String FormatManifestAction_actionText;

	public static String FormatManifestOperation_subtask;

	public static String FormatManifestOperation_task;

	public static String ImageBrowserView_FilterAllImages;

	public static String ImageBrowserView_FilterDisabled;

	public static String ImageBrowserView_FilterIcons;

	public static String ImageBrowserView_FilterTooltip;

	public static String ImageBrowserView_FilterWizards;

	public static String ImageBrowserView_Height;

	public static String ImageBrowserView_MaxImages;

	public static String ImageBrowserView_PrevPage;

	public static String ImageBrowserView_NextPage;

	public static String ImageBrowserView_Path;

	public static String ImageBrowserView_FilterText;

	public static String ImageBrowserView_Pixels;

	public static String ImageBrowserView_Plugin;

	public static String ImageBrowserView_Reference;

	public static String ImageBrowserView_SaveActionName;

	public static String ImageBrowserView_Show;

	public static String ImageBrowserView_Source;

	public static String ImageBrowserView_Width;

	public static String ImportActionGroup_binaryWithLinkedContent;

	public static String ImportActionGroup_cannot_import;

	public static String ImportActionGroup_importContributingPlugin;

	public static String ImportActionGroup_Repository_project;

	public static String InformationSection_0;

	public static String InputContext_errorMessageFileDoesNotExist;

	public static String InputContext_errorMessageLocationNotSet;

	public static String InputContextManager_errorMessageInputContextNotFound;

	public static String LibrarySection_addDialogButton;

	public static String MainPreferencePage_askFullRebuild;

	public static String MainPreferencePage_settingChanged;

	public static String MainPreferencePage_build;

	public static String MainPreferencePage_notNow;

	public static String MainPreferencePage_AddSwtNonDisposedToVMArguments;

	public static String MainPreferencePage_AddSwtNonDisposedToVMArgumentsToolTop;

	public static String MainPreferencePage_addToJavaSearch;
	public static String MainPreferencePage_BundlePoolPrefsCleanBtn;

	public static String MainPreferencePage_BundlePoolPrefsCleanDesc;

	public static String MainPreferencePage_BundlePoolPrefsError;

	public static String MainPreferencePage_BundlePoolPrefsErrorCleaning;

	public static String MainPreferencePage_BundlePoolPrefsGroup;

	public static String MainPreferencePage_junitWorkspace_asContainer;

	public static String MainPreferencePage_junitWorkspace_asLocation;

	public static String MainPreferencePage_junitWorkspace_fileSystem;

	public static String MainPreferencePage_junitWorkspace_variables;

	public static String MainPreferencePage_junitWorkspace_workspace;

	public static String MainPreferencePage_junitWorkspaceGroup;

	public static String MainPreferencePage_promptBeforeOverwrite;
	public static String MainPreferencePage_promtBeforeRemove;
	public static String MainPreferencePage_runtimeWorkspace_asContainer;

	public static String MainPreferencePage_runtimeWorkspace_asLocation;

	public static String MainPreferencePage_runtimeWorkspace_fileSystem;

	public static String MainPreferencePage_runtimeWorkspace_variables;

	public static String MainPreferencePage_runtimeWorkspace_workspace;

	public static String MainPreferencePage_runtimeWorkspaceGroup;
	public static String MainPreferencePage_showSourceBundles;

	public static String MainPreferencePage_ShowTargetStatus;

	public static String MainPreferencePage_WorkspacePluginsOverrideTarget;
	public static String MainPreferencePage_WorkspacePluginsOverrideTargetTooltip;
	public static String MainPreferencePage_DisableAPIAnalysisBuilder;
	public static String MainPreferencePage_RunAPIAnalysisBuilderAsJob;

	public static String MainPreferencePage_test_plugin_pattern_group;
	public static String MainPreferencePage_test_plugin_pattern_label;
	public static String MainPreferencePage_test_plugin_pattern_description;
	public static String MainPreferencePage_test_plugin_pattern_note;

	public static String MainPreferencePage_updateStale;

	public static String ManifestStructureCreator_errorMessage;

	public static String MissingResourcePage_missingResource;

	public static String MissingResourcePage_unableToOpen;

	public static String MissingResourcePage_unableToOpenFull;

	public static String NewLibraryPluginCreationPage_pdependencies;

	public static String OpenSchemaAction_errorMsgSchemaNotFound;

	public static String OpenSchemaAction_msgUnknown;

	public static String OpenSchemaAction_titleExtensionPointSchema;

	public static String OSGiFrameworkBlock_selectedBundles;

	public static String OSGiFrameworkPreferencePage_default;

	public static String OSGiFrameworkPreferencePage_installed;

	public static String OSGiFrameworkPreferencePage_installed_nolink;

	public static String PDEFormEditor_errorMessageSaveNotCompleted;

	public static String PDEFormEditor_errorTitleProblemSaveAs;

	public static String PDEFormPage_titleDetails;

	public static String PDEFormPage_titleMessage;

	public static String PDESourcePage_actionTextQuickOutline;

	public static String QuickOutlinePopupDialog_infoTextPressEscToExit;

	public static String RemoveUnknownExecEnvironments_label;

	public static String AddDefaultExecutionEnvironment_label;

	public static String RevertUnsupportSingletonResolution_desc;

	public static String AddLibraryDialog_emptyLibraries;

	public static String BaseWizardSelectionPage_noDesc;

	public static String ChooseClassXMLResolution_label;

	public static String ChooseManifestClassResolution_label;

	public static String CreateClassXMLResolution_label;

	public static String CreateManifestClassResolution_label;

	public static String CreateModuleInfoPDEAction_mod_info_not_in_sync;

	public static String CreateModuleInfoPDEAction_sync_issue;

	public static String ElementSection_missingRefElement;

	public static String ExternalizeResolution_attrib;

	public static String ExternalizeResolution_header;

	public static String ExternalizeResolution_text;

	public static String OpenManifestAction_noManifest;

	public static String ProjectNamesPage_duplicateNames;

	public static String RemoveNodeXMLResolution_attrLabel;

	public static String RemoveNodeXMLResolution_label;

	public static String RuntimeInfoSection_replace;

	public static String RuntimeInfoSection_replacedialog;

	public static String SchemaIncludesSection_missingWarningMessage;

	public static String SchemaIncludesSection_missingWarningTitle;

	public static String ShowDescriptionAction_schemaNotAvail;

	public static String TableSection_itemCount;

	public static String UpdateClasspathResolution_label;
	public static String UpdateExecutionEnvironment_label;

	//
	// PDE resource strings
	// Part 2.    (TRANSLATE Part 2)
	// These are the translable properties.
	//

	public static String UpdateManager_noUndo;
	public static String UpdateManager_noRedo;
	public static String UpdateManager_undo;
	public static String UpdateManager_redo;
	public static String UpdateManager_op_add;
	public static String UpdateManager_op_remove;
	public static String UpdateManager_op_change;

	//

	public static String PluginModelManager_outOfSync;

	// Status text #####################################
	public static String Errors_CreationError;
	public static String Errors_CreationError_NoWizard;

	public static String UpdateSplashHandlerInModelAction_msgAddingExtension;

	public static String UpdateSplashHandlerInModelAction_msgAddingExtensionPoint;

	public static String UpdateSplashHandlerInModelAction_msgModifyingExtension;

	public static String UpdateSplashHandlerInModelAction_nameApplicationFramework;

	public static String UpdateSplashHandlerInModelAction_nameEmbedded;

	public static String UpdateSplashHandlerInModelAction_nameEnterprise;

	public static String UpdateSplashHandlerInModelAction_nameLanguages;

	public static String UpdateSplashHandlerInModelAction_nameRCP;

	public static String UpdateSplashHandlerInModelAction_splashExtensionPointName;

	public static String UpdateSplashHandlerInModelAction_templateTypeBrowser;

	public static String UpdateSplashHandlerInModelAction_templateTypeExtensible;

	public static String UpdateSplashHandlerInModelAction_templateTypeInteractive;

	public static String UpdateSplashProgressAction_msgErrorCustomFileSaveFailed;

	public static String UpdateSplashProgressAction_msgErrorTextFileBuffer;

	public static String UpdateSplashProgressAction_msgErrorTextFileBufferManager;

	public static String UpdateSplashProgressAction_msgProgressCustomizingSplash;

	// Reusable Parts ################################
	public static String WizardCheckboxTablePart_selectAll;
	public static String WizardCheckboxTablePart_deselectAll;
	public static String WizardCheckboxTablePart_select;
	public static String WizardCheckboxTablePart_deselect;
	public static String WizardCheckboxTablePart_counter;

	// Outline #################################
	public static String ToggleLinkWithEditorAction_label;
	public static String ToggleLinkWithEditorAction_toolTip;
	public static String ToggleLinkWithEditorAction_description;
	public static String PDEMultiPageContentOutline_SortingAction_label;
	public static String PDEMultiPageContentOutline_SortingAction_tooltip;
	public static String PDEMultiPageContentOutline_SortingAction_description;

	// build.properties editor #####################
	public static String BuildEditor_BuildPage_title;
	public static String BuildEditor_AddLibraryDialog_label;

	public static String BuildEditor_RuntimeInfoSection_title;
	public static String BuildEditor_RuntimeInfoSection_desc;
	public static String BuildEditor_RuntimeInfoSection_duplicateLibrary;
	public static String BuildEditor_RuntimeInfoSection_duplicateFolder;
	public static String BuildEditor_RuntimeInfoSection_addLibrary;
	public static String BuildEditor_RuntimeInfoSection_popupAdd;
	public static String BuildEditor_RuntimeInfoSection_addFolder;
	public static String BuildEditor_RuntimeInfoSection_popupFolder;

	public static String BuildEditor_SrcSection_title;
	public static String BuildEditor_SrcSection_desc;
	public static String BuildEditor_BinSection_title;
	public static String BuildEditor_BinSection_desc;

	public static String BuildEditor_ClasspathSection_add;
	public static String BuildEditor_SourceFolderSelectionDialog_button;
	public static String BuildEditor_ClasspathSection_remove;
	public static String BuildEditor_ClasspathSection_title;
	public static String BuildEditor_ClasspathSection_desc;
	public static String BuildEditor_ClasspathSection_jarsTitle;
	public static String BuildEditor_ClasspathSection_jarsDesc;

	// Feature Manifest Editor ####################
	public static String FeatureEditor_BuildAction_label;
	public static String FeatureEditor_FeaturePage_title;
	public static String FeatureEditor_InfoPage_title;
	public static String FeatureEditor_InfoPage_heading;
	public static String FeatureEditor_ReferencePage_title;
	public static String FeatureEditor_ReferencePage_heading;
	public static String FeatureEditor_IncludesPage_title;
	public static String FeatureEditor_IncludesPage_heading;
	public static String FeatureEditor_DependenciesPage_heading;
	public static String FeatureEditor_DependenciesPage_title;

	public static String FeatureEditor_PortabilityChoicesDialog_title;
	public static String FeatureEditor_PortabilityChoicesDialog_choices;

	public static String FeatureEditor_SpecSection_title;
	public static String FeatureEditor_SpecSection_desc;
	public static String FeatureEditor_SpecSection_desc_patch;
	public static String FeatureEditor_SpecSection_id;
	public static String FeatureEditor_SpecSection_patchedId;
	public static String FeatureEditor_SpecSection_name;
	public static String FeatureEditor_SpecSection_version;
	public static String FeatureEditor_SpecSection_patchedVersion;
	public static String FeatureEditor_SpecSection_provider;
	public static String FeatureEditor_SpecSection_plugin;
	public static String FeatureEditor_SpecSection_updateUrlLabel;
	public static String FeatureEditor_SpecSection_updateUrl;
	public static String FeatureEditor_SpecSection_synchronize;
	public static String FeatureEditor_SpecSection_badVersionTitle;
	public static String FeatureEditor_SpecSection_badVersionMessage;
	public static String FeatureEditor_SpecSection_badUrlTitle;
	public static String FeatureEditor_SpecSection_badUrlMessage;
	public static String FeatureEditor_PortabilitySection_title;
	public static String FeatureEditor_PortabilitySection_desc;
	public static String FeatureEditor_PortabilitySection_os;
	public static String FeatureEditor_PortabilitySection_ws;
	public static String FeatureEditor_PortabilitySection_nl;
	public static String FeatureEditor_PortabilitySection_arch;
	public static String FeatureEditor_PortabilitySection_edit;

	public static String FeatureEditor_IncludedFeatures_title;
	public static String FeatureEditor_IncludedFeatures_desc;
	public static String FeatureEditor_IncludedFeatures_new;
	public static String FeatureEditor_IncludedFeatures_remove;
	public static String FeatureEditor_IncludedFeatures_up;
	public static String FeatureEditor_IncludedFeatures_down;
	public static String FeatureEditor_IncludedFeatures_sortAlpha;

	public static String SiteEditor_IncludedFeaturesDetailsSection_title;
	public static String SiteEditor_IncludedFeaturesDetailsSection_desc;
	public static String SiteEditor_IncludedFeaturesDetailsSection_featureLabel;
	public static String SiteEditor_IncludedFeaturesDetailsSection_optional;
	public static String SiteEditor_IncludedFeaturesDetailsSection_searchLocation;
	public static String SiteEditor_IncludedFeaturesDetailsSection_root;
	public static String SiteEditor_IncludedFeaturesDetailsSection_self;
	public static String SiteEditor_IncludedFeaturesDetailsSection_both;

	public static String FeatureEditor_IncludedFeaturePortabilitySection_title;
	public static String FeatureEditor_IncludedFeaturePortabilitySection_desc;

	public static String FeatureEditor_InfoSection_desc;

	public static String FeatureEditor_InfoSection_url;
	public static String FeatureEditor_InfoSection_text;
	public static String FeatureEditor_info_description;
	public static String FeatureEditor_info_license;
	public static String FeatureEditor_info_copyright;
	public static String FeatureEditor_info_discoveryUrls;

	public static String FeatureEditor_licenseFeatureSection_browse;
	public static String FeatureEditor_licenseFeatureSection_sharedButton;
	public static String FeatureEditor_licenseFeatureSection_featureID;
	public static String FeatureEditor_licenseFeatureSection_featureVersion;
	public static String FeatureEditor_licenseFeatureSection_localButton;

	public static String FeatureEditor_PluginSection_pluginTitle;
	public static String FeatureEditor_PluginSection_pluginDesc;
	public static String FeatureEditor_PluginSection_new;
	public static String FeatureEditor_PluginSection_remove;
	public static String FeatureEditor_PluginSection_sortAlpha;

	public static String FeatureEditor_PluginPortabilitySection_title;
	public static String FeatureEditor_PluginPortabilitySection_desc;

	public static String SiteEditor_PluginDetailsSection_title;
	public static String SiteEditor_PluginDetailsSection_desc;
	public static String SiteEditor_PluginDetailsSection_pluginLabel;
	public static String SiteEditor_PluginDetailsSection_downloadSize;
	public static String SiteEditor_PluginDetailsSection_installSize;
	public static String SiteEditor_PluginDetailsSection_unpack;

	public static String FeatureEditor_DataDetailsSection_title;
	public static String FeatureEditor_DataDetailsSection_desc;

	public static String FeatureExportJob_name;

	public static String FeatureEditor_RequiresSection_title;
	public static String FeatureEditor_RequiresSection_desc;
	public static String FeatureEditor_RequiresSection_sync;
	public static String FeatureEditor_RequiresSection_compute;
	public static String FeatureEditor_RequiresSection_plugin;
	public static String FeatureEditor_RequiresSection_feature;
	public static String FeatureEditor_RequiresSection_sortAlpha;
	public static String FeatureEditor_RequiresSection_remove;

	public static String FeatureEditor_URLSection_desc;
	public static String FeatureEditor_URLSection_new;
	public static String FeatureEditor_URLSection_newDiscoverySite;
	public static String FeatureEditor_URLSection_newURL;
	public static String FeatureEditor_URLDetailsSection_desc;
	public static String FeatureEditor_URLDetailsSection_updateUrlLabel;
	public static String FeatureEditor_URLDetailsSection_updateUrl;
	public static String FeatureEditor_URLDetailsSection_badUrlTitle;
	public static String FeatureEditor_URLDetailsSection_badUrlMessage;

	public static String FeatureEditor_InfoPage_ContentSection_title;
	public static String FeatureEditor_InfoPage_ContentSection_text;

	public static String FeatureEditor_InfoPage_PackagingSection_title;
	public static String FeatureEditor_InfoPage_PackagingSection_text;

	public static String FeatureOptionsTab_0;

	public static String FeatureOutlinePage_discoverUrls;

	// Plug-in Manifest Editor ########################

	public static String ManifestEditor_DetailExtensionPointSection_title;
	public static String ManifestEditor_DetailExtensionPointSection_new;
	public static String ManifestEditor_DetailExtensionPointSection_newExtensionPoint;

	public static String ManifestEditor_DetailExtension_title;
	public static String ManifestEditor_DetailExtension_new;
	public static String ManifestEditor_DetailExtension_remove;
	public static String ManifestEditor_DetailExtension_edit;
	public static String ManifestEditor_DetailExtension_up;
	public static String ManifestEditor_DetailExtension_down;
	public static String ManifestEditor_DetailExtension_missingExtPointSchema;

	public static String ManifestEditor_ExportSection_title;
	public static String ManifestEditor_ExportSection_desc;
	public static String ManifestEditor_ExportSection_fullExport;
	public static String ManifestEditor_ExportSection_selectedExport;
	public static String ManifestEditor_ExportSection_add;
	public static String ManifestEditor_ExportSection_remove;
	public static String PackageSelectionDialog_label;
	public static String PackageSelectionDialog_title;

	public static String ManifestEditor_ExtensionSection_title;
	public static String ManifestEditor_OverviewPage_title;

	public static String ManifestEditor_ExtensionPointDetails_validate_errorStatus;
	public static String ManifestEditor_ExtensionPointDetails_schemaLocation_title;
	public static String ManifestEditor_ExtensionPointDetails_schemaLocation_desc;

	public static String ManifestEditor_ContentSection_title;
	public static String ManifestEditor_ContentSection_ftitle;

	public static String ManifestEditor_DeployingSection_title;

	public static String ManifestSourcePage_dependencies;
	public static String ManifestEditor_JarsSection_dialogTitle;
	public static String ManifestEditor_JarsSection_dialogMessage;

	public static String ManifestEditor_LibrarySection_title;
	public static String ManifestEditor_LibrarySection_fdesc;
	public static String ManifestEditor_LibrarySection_desc;
	public static String ManifestEditor_LibrarySection_up;
	public static String ManifestEditor_LibrarySection_down;
	public static String ManifestEditor_LibrarySection_newLibrary;
	public static String ManifestEditor_LibrarySection_newLibraryEntry;
	public static String NewManifestEditor_LibrarySection_add;
	public static String NewManifestEditor_LibrarySection_new;
	public static String NewManifestEditor_LibrarySection_remove;
	public static String ManifestEditor_RuntimeLibraryDialog_label;
	public static String ManifestEditor_RuntimeLibraryDialog_default;
	public static String ManifestEditor_RuntimeLibraryDialog_validationError;

	public static String ManifestSourcePage_libraries;
	public static String ManifestSourcePage_extensions;

	public static String ManifestEditor_MatchSection_optional;
	public static String ManifestEditor_MatchSection_reexport;
	public static String ManifestEditor_MatchSection_version;
	public static String ManifestEditor_MatchSection_perfect;
	public static String ManifestEditor_MatchSection_equivalent;
	public static String ManifestEditor_MatchSection_compatible;
	public static String ManifestEditor_MatchSection_greater;

	public static String ManifestEditor_PluginSpecSection_title;
	public static String ManifestEditor_PluginSpecSection_desc;
	public static String ManifestEditor_PluginSpecSection_fdesc;

	public static String ManifestEditor_PluginSpecSection_versionMatch;

	public static String ResourceAttributeCellEditor_title;
	public static String ResourceAttributeCellEditor_message;

	public static String IdAttributeRow_title;
	public static String IdAttributeRow_message;
	public static String IdAttributeRow_emptyMessage;

	public static String ManifestEditor_RuntimeForm_title;
	public static String ManifestSourcePage_extensionPoints;

	public static String ManifestSourcePage_renameActionText;
	public static String ManifestEditor_addActionText;

	public static String ManifestEditor_TestingSection_title;

	// Schema Editor ##################################
	public static String SchemaEditorContributor_previewAction;
	public static String SchemaEditor_previewLink;

	public static String SchemaEditor_DocSection_desc;
	public static String SchemaEditor_topic_overview;
	public static String SchemaEditor_topic_since;
	public static String SchemaEditor_topic_examples;
	public static String SchemaEditor_topic_implementation;
	public static String SchemaEditor_topic_api;
	public static String SchemaEditor_topic_copyright;

	public static String SchemaEditor_SpecSection_title;
	public static String SchemaEditor_SpecSection_desc;
	public static String SchemaEditor_SpecSection_plugin;
	public static String SchemaEditor_SpecSection_point;
	public static String SchemaEditor_SpecSection_name;

	public static String SchemaEditor_ElementSection_title;
	public static String SchemaEditor_ElementSection_desc;
	public static String SchemaEditor_ElementSection_newElement;
	public static String SchemaEditor_ElementSection_newAttribute;

	public static String ReviewPage_noSampleFound;

	public static String SchemaEditor_NewAttribute_label;
	public static String SchemaEditor_NewAttribute_tooltip;
	public static String SchemaEditor_NewAttribute_initialName;

	public static String SchemaEditor_NewElement_label;
	public static String SchemaEditor_NewElement_tooltip;
	public static String SchemaEditor_NewElement_initialName;

	public static String SchemaEditor_NewCompositor_tooltip;

	public static String SchemaEditor_FormPage_title;
	public static String SchemaEditor_DocPage_title;

	// Launchers #######################################
	public static String MainTab_name;
	public static String MainTab_AttributeLabel_LauncherPDEVersion;
	public static String MainTab_AttributeLabel_AppendArgs;
	public static String MainTab_AttributeLabel_WorkspaceLocation;
	public static String MainTab_AttributeLabel_ClearWorkspace;
	public static String MainTab_AttributeLabel_ClearLogOnly;
	public static String MainTab_AttributeLabel_ClearAskForConfirmation;
	public static String MainTab_AttributeLabel_UseProduct;
	public static String MainTab_AttributeLabel_Product;
	public static String MainTab_AttributeLabel_Application;
	public static String MainTab_AttributeLabel_JavaExecutable;
	public static String MainTab_AttributeLabel_JREContainerPath;
	public static String MainTab_AttributeLabel_SourcePathProvider;
	public static String MainTab_AttributeLabel_BootstrapEntries;
	public static String WorkspaceDataBlock_workspace;
	public static String WorkspaceDataBlock_location;
	public static String WorkspaceDataBlock_clear;
	public static String WorkspaceDataBlock_askClear;
	public static String WorkspaceDataBlock_clearLog;
	public static String WorkspaceDataBlock_clearWorkspace;

	public static String WorkspaceDataBlock_configureDefaults;
	public static String BasicLauncherTab_javaExec;

	public static String BasicLauncherTab_unbound;
	public static String ProgramBlock_runProduct;

	public static String BasicLauncherTab_ee;
	public static String BasicLauncherTab_jre;

	public static String BasicLauncherTab_environments;
	public static String BasicLauncherTab_installedJREs;
	public static String ProgramBlock_productDecorationWarning0;

	public static String ProgramBlock_programToRun;
	public static String BasicLauncherTab_bootstrap;
	public static String BasicLauncherTab_javaExecDefault;
	public static String BasicLauncherTab_noJreForEeMessage;
	public static String ProgramBlock_runApplication;
	public static String JUnitProgramBlock_headless;

	public static String AdvancedLauncherTab_name;
	public static String AdvancedLauncherTab_workspacePlugins;
	public static String AdvancedLauncherTab_selectAll;
	public static String AdvancedLauncherTab_deselectAll;
	public static String AdvancedFeatureExportPage_noSite;
	public static String AdvancedPluginExportPage_signJar;
	public static String AdvancedPluginExportPage_noAlias;
	public static String AdvancedLauncherTab_subset;
	public static String AdvancedLauncherTab_subset_plugins;
	public static String AdvancedLauncherTab_subset_bundles;
	public static String AdvancedLauncherTab_autoIncludeRequirements_bundles;
	public static String AdvancedLauncherTab_autoIncludeRequirements_plugins;
	public static String AdvancedLauncherTab_autoIncludeRequirements_features_withBundles;
	public static String AdvancedLauncherTab_autoIncludeRequirements_features_withPlugins;
	public static String AdvancedLauncherTab_addNew;
	public static String AdvancedLauncherTab_addNew_plugins;
	public static String AdvancedLauncherTab_addNew_bundles;
	public static String AdvancedLauncherTab_defaults;
	public static String AdvancedLauncherTab_workingSet;
	public static String AdvancedLauncherTab_selectedBundles;
	public static String AdvancedFeatureExportPage_jnlp;
	public static String AdvancedPluginExportPage_alias;
	public static String JARSigningTab_keypass;
	public static String AdvancedLauncherTab_includeOptional;
	public static String AdvancedLauncherTab_includeOptional_plugins;
	public static String AdvancedLauncherTab_includeOptional_bundles;
	public static String AdvancedFeatureExportPage_siteURL;
	public static String AdvancedPluginExportPage_keystore;
	public static String AdvancedPluginExportPage_password;
	public static String AdvancedFeatureExportPage_noVersion;
	public static String AdvancedPluginExportPage_signButton;
	public static String AdvancedPluginExportPage_noKeystore;
	public static String AdvancedPluginExportPage_noPassword;
	public static String AdvancedFeatureExportPage_createJNLP;
	public static String AdvancedFeatureExportPage_jreVersion;
	public static String AdvancedPluginExportPage_qualifier;

	public static String TracingTab_AttributeLabel_Tracing;
	public static String TracingTab_AttributeLabel_TracingOptions;
	public static String TracingTab_AttributeLabel_TracingChecked;
	public static String TracingTab_AttributeLabel_TracingNone;

	public static String TracingBlock_restore_default;
	public static String TracingBlock_restore_default_selected;

	public static String TracingLauncherTab_name;
	public static String TracingLauncherTab_tracing;
	public static String TracingLauncherTab_enableAll;
	public static String TracinglauncherTab_disableAll;

	public static String ConfigurationTab_name;
	public static String ConfigurationTab_clearArea;
	public static String ConfigurationTab_configAreaGroup;
	public static String ConfigurationTab_useDefaultLoc;
	public static String ConfigurationTab_configLog;
	public static String ConfigurationSection_title;
	public static String ConfigurationSection_desc;
	public static String ConfigurationSection_file;
	public static String ConfigurationSection_existing;
	public static String ConfigurationTab_configLocMessage;
	public static String ConfigurationTab_configFileGroup;
	public static String ConfigurationTab_defaultConfigIni;
	public static String ConfigurationTab_existingConfigIni;
	public static String ConfigurationTab_templateLoc;
	public static String ConfigurationSection_default;
	public static String ConfigurationSection_browse;
	public static String ConfigurationSection_message;
	public static String ConfigurationTab_fileSelection;
	public static String ConfigurationSection_selection;
	public static String ConfigurationTab_fileDialogMessage;
	public static String ConfigurationTab_AttributeLabel_UseDefaultConfigArea;
	public static String ConfigurationTab_AttributeLabel_ConfigLocation;
	public static String ConfigurationTab_AttributeLabel_ConfigClearArea;
	public static String ConfigurationTab_AttributeLabel_ConfigGenerateDefault;
	public static String ConfigurationTab_AttributeLabel_ConfigTemplateLocation;
	public static String ConfigurationTab_AttributeLabel_GenerateProfile;

	public static String WorkbenchLauncherConfigurationDelegate_confirmDeleteWorkspace;
	public static String WorkbenchLauncherConfigurationDelegate_clearButtonLabel;
	public static String WorkbenchLauncherConfigurationDelegate_dontClearButtonLabel;

	public static String Launcher_error_title;
	public static String LauncherSection_desc;
	public static String LauncherSection_ico;
	public static String LauncherSection_file;
	public static String LauncherSection_icon;
	public static String Launcher_error_code13;
	public static String Launcher_error_displayInLogView;
	public static String Launcher_error_displayInSystemEditor;
	public static String LauncherSection_browse;
	public static String LauncherSection_title;
	public static String LauncherSection_label;
	public static String LauncherSection_bmpImages;
	public static String LauncherSection_Low16;
	public static String LauncherSection_High16;
	public static String LauncherSection_32Low;
	public static String LauncherSection_32High;
	public static String LauncherSection_48Low;
	public static String LauncherSection_48High;
	public static String LauncherSection_256High;
	public static String LauncherSection_linuxLabel;
	public static String LauncherSection_macLabel;
	public static String OSGiBundlesTab_frameworkLabel;

	// Preferences ####################################
	public static String Preferences_MainPage_Description;

	public static String Preferences_MainPage_showObjects;
	public static String Preferences_MainPage_useIds;
	public static String Preferences_MainPage_useFullNames;

	public static String Preferences_TargetEnvironmentPage_os;
	public static String Preferences_TargetEnvironmentPage_ws;
	public static String Preferences_TargetEnvironmentPage_nl;
	public static String Preferences_TargetEnvironmentPage_arch;

	public static String SourceBlock_add;
	public static String SourceBlock_remove;

	// Wizards #######################################
	public static String NewFragmentProjectWizard_title;
	public static String NewPluginProjectFromTemplateWizard_0;

	public static String NewPluginProjectFromTemplateWizard_1;

	public static String NewProjectWizard_MainPage_ftitle;
	public static String NewProductFileWizard_windowTitle;
	public static String NewProjectWizard_MainPage_fdesc;

	public static String NewProjectWizard_title;
	public static String NewProjectWizard_MainPage_title;
	public static String NewProjectWizard_MainPage_desc;

	public static String ProjectNamesPage_emptyName;
	public static String ProjectStructurePage_settings;
	public static String ProjectStructurePage_java;
	public static String ProjectStructurePage_source;
	public static String ProjectStructurePage_output;

	public static String ProjectNamesPage_projectName;
	public static String ProjectNamesPage_multiProjectName;
	public static String ProjectNamesPage_title;
	public static String ProjectNamesPage_desc;
	public static String ProjectNamesPage_noSampleFound;

	public static String ContentPage_0;

	public static String ContentPage_1;

	public static String ContentPage_title;
	public static String ContentPage_ftitle;
	public static String ContentPage_desc;
	public static String ContentPage_fdesc;
	public static String ContentPage_pGroup;
	public static String ContentPage_fGroup;
	public static String ContentPage_parentPluginGroup;
	public static String ContentPage_pClassGroup;
	public static String ContentPage_pid;
	public static String ContentPage_pversion;
	public static String ContentPage_pversion_message;
	public static String ContentPage_pname;
	public static String ContentPage_pprovider;
	public static String ContentPage_fid;
	public static String ContentPage_fversion;
	public static String ContentPage_fname;
	public static String ContentPage_fprovider;
	public static String ContentPage_generate;
	public static String ContentPage_classname;
	public static String ContentPage_uicontribution;
	public static String FragmentContentPage_pid;
	public static String FragmentContentPage_pversion;
	public static String ContentPage_browse;
	public static String ContentPage_matchRule;
	public static String ContentPage_noid;
	public static String ContentPage_invalidId;
	public static String ContentPage_badversion;
	public static String ContentPage_nopid;
	public static String ContentPage_pluginNotFound;
	public static String ContentPage_illegalCharactersInID;
	public static String WizardListSelectionPage_title;
	public static String WizardListSelectionPage_desc;
	public static String WizardListSelectionPage_label;
	public static String WizardListSelectionPage_templates;
	public static String OptionTemplateSection_mustBeSet;

	public static String NewLibraryPluginProjectWizard_title;
	public static String NewLibraryPluginCreationPage_title;
	public static String NewLibraryPluginCreationPage_desc;
	public static String NewLibraryPluginCreationPage_jarred;
	public static String NewLibraryPluginCreationPage_pGroup;
	public static String NewLibraryPluginCreationPage_pid;
	public static String NewLibraryPluginCreationPage_pversion;
	public static String NewLibraryPluginCreationPage_pname;
	public static String NewLibraryPluginCreationPage_pprovider;
	public static String NewLibraryPluginCreationPage_noid;
	public static String NewLibraryPluginCreationPage_invalidId;
	public static String NewLibraryPluginCreationPage_noversion;
	public static String NewLibraryPluginCreationPage_noname;
	public static String NewLibraryPluginCreationPage_UpdateReferences_button;
	public static String LibraryPluginJarsPage_title;
	public static String LibraryPluginJarsPage_desc;
	public static String LibraryPluginJarsPage_label;
	public static String LibraryPluginJarsPage_add;
	public static String LibraryPluginJarsPage_addExternal;
	public static String LibraryPluginJarsPage_remove;
	public static String LibraryPluginJarsPage_SelectionDialog_title;
	public static String LibraryPluginJarsPage_SelectionDialog_message;

	public static String NewProjectCreationOperation_creating;
	public static String NewProjectCreationOperation_project;
	public static String NewProjectCreationOperation_setClasspath;
	public static String NewProjectCreationOperation_manifestFile;
	public static String NewProjectCreationOperation_buildPropertiesFile;
	public static String NewProjectCreationOperation_copyingJar;
	public static String NewProjectCreationOperation_errorImportingJar;

	public static String AbstractTemplateSection_generating;

	public static String BuildAction_Validate;
	public static String BuildAction_Generate;
	public static String BuildAction_Update;
	public static String BuildPage_custom;
	public static String BuildPage_name;
	public static String BuildAction_ErrorDialog_Title;
	public static String BuildAction_ErrorDialog_Message;
	public static String BuildPluginAction_ErrorDialog_Title;
	public static String BuildPluginAction_ErrorDialog_Message;

	public static String BuildPluginAction_WarningCustomBuildExists;

	public static String NewFeatureWizard_wtitle;
	public static String NewFeatureWizard_MainPage_desc;
	public static String NewFeatureWizard_SpecPage_title;
	public static String NewFeatureWizard_SpecPage_desc;
	public static String NewFeatureWizard_SpecPage_id;
	public static String NewFeatureWizard_SpecPage_name;
	public static String NewFeatureWizard_SpecPage_version;
	public static String NewFeatureWizard_SpecPage_provider;
	public static String NewFeatureWizard_SpecPage_versionFormat;
	public static String NewFeatureWizard_sampleCopyrightDesc;
	public static String NewFeatureWizard_sampleLicenseDesc;
	public static String NewFeatureWizard_sampleDescriptionDesc;
	public static String NewSiteProjectCreationPage_webTitle;
	public static String NewFeatureWizard_SpecPage_missing;
	public static String NewFeatureWizard_SpecPage_pmissing;
	public static String NewFeatureWizard_SpecPage_invalidId;

	public static String NewFeatureWizard_PlugPage_title;
	public static String NewFeatureWizard_PlugPage_desc;

	public static String NewFeatureWizard_creatingProject;
	public static String NewFeatureWizard_creatingManifest;
	public static String NewFeatureWizard_overwriteFeature;
	public static String NewFeatureWizard_SpecPage_library;
	public static String NewFeatureWizard_SpecPage_patchProperties;

	public static String FeatureDetailsSection_title;
	public static String FeatureDetailsSection_desc;
	public static String FeatureDetailsSection_url;
	public static String FeatureDetailsSection_patch;
	public static String FeatureDetailsSection_requiredURL;
	public static String FeatureDetailsSection_requiredURL_title;

	public static String SiteEditor_PortabilitySection_title;
	public static String SiteEditor_PortabilitySection_desc;
	public static String SiteEditor_PortabilitySection_os;
	public static String SiteEditor_PortabilitySection_ws;
	public static String SiteEditor_PortabilitySection_nl;
	public static String SiteEditor_PortabilitySection_arch;
	public static String SiteEditor_PortabilitySection_edit;
	public static String SiteEditor_PortabilityChoicesDialog_title;

	public static String FeaturePatch_wtitle;
	public static String FeaturePatch_MainPage_desc;
	public static String PatchSpec_title;
	public static String NewFeaturePatch_SpecPage_id;
	public static String NewFeaturePatch_SpecPage_name;
	public static String NewFeaturePatch_SpecPage_provider;
	public static String NewFeaturePatch_SpecPage_notFound;
	public static String FeatureSelectionDialog_IdMatched;

	public static String FeatureSelectionDialog_title;
	public static String FeatureSelectionDialog_message;

	public static String FeatureSelectionDialog_PluginMatched;

	public static String VersionSyncWizard_wtitle;
	public static String VersionSyncWizard_title;
	public static String VersionSyncWizard_desc;
	public static String VersionSyncWizard_group;
	public static String VersionSyncWizard_useComponent;
	public static String VersionSyncWizard_usePlugins;
	public static String VersionSyncWizard_usePluginsAtBuild;
	public static String VersionSyncWizard_synchronizing;

	public static String JavaAttributeWizard_wtitle;

	public static String ExtensionsPage_collapseAll;
	public static String ExtensionPointDetails_title;
	public static String ExtensionPointDetails_desc;
	public static String ExtensionPointDetails_id;
	public static String ExtensionPointDetails_name;
	public static String ExtensionPointsPage_title;
	public static String ExtensionPointsPage_tabName;
	public static String ExtensionPointDetails_schema;
	public static String ExtensionPointDetails_schemaLinks;
	public static String ExtensionPointsSection_message1;

	public static String ExtensionPointsSection_rename_label;
	public static String ExtensionPointDetails_browse;
	public static String ExtensionPointsSection_title;
	public static String ExtensionPointDetails_noSchemaLinks;
	public static String ExtensionElementDetails_descNoAttributes;
	public static String ExtensionDetails_noPoint_title;
	public static String ExtensionDetails_extensionPointLinks;
	public static String ExtensionElementDetails_setDesc;
	public static String ExtensionElementDetails_setDescDepr;
	public static String ExtensionEditorSelectionPage_title;
	public static String ExtensionEditorSelectionPage_message;
	public static String ExtensionEditorSelectionPage_desc;
	public static String ShowDescriptionAction_noPoint_desc;
	public static String ExtensionElementDetails_title;

	public static String BaseExtensionPoint_pluginId;
	public static String BaseExtensionPoint_id;
	public static String BaseExtensionPoint_name;

	public static String BaseExtensionPoint_schema;
	public static String BaseExtensionPoint_schemaLocation;
	public static String BaseExtensionPoint_edit;
	public static String BaseExtensionPoint_shared;
	public static String BaseExtensionPoint_sections_overview;
	public static String BaseExtensionPoint_sections_since;
	public static String BaseExtensionPoint_sections_usage;
	public static String BaseExtensionPoint_sections_api;
	public static String BaseExtensionPoint_sections_supplied;
	public static String BaseExportWizard_confirmReplace_desc;
	public static String BaseExportWizardPage_packageJARs;
	public static String BaseExportWizard_wtitle;
	public static String BaseExportWizardPage_fPackageJARs;
	public static String BaseFeatureSpecPage_patchGroup_title;
	public static String BaseFeatureSpecPage_featurePropertiesGroup_title;
	public static String BaseFeatureSpecPage_browse;
	public static String BaseExportWizard_confirmReplace_title;
	public static String BaseExtensionPoint_generating;
	public static String GeneralInfoSection_IdWarning;

	public static String GeneralInfoSection_version;
	public static String GeneralInfoSection_provider;
	public static String GeneralInfoSection_pluginId;
	public static String GeneralInfoSection_pluginVersion;
	public static String GeneralInfoSection_hostMinVersionRange;
	public static String GeneralInfoSection_hostMaxVersionRange;

	public static String NewWizard_wtitle;
	public static String NewExtensionWizard_wtitle;
	public static String NewElementAction_generic;
	public static String NewExtensionWizard_PointSelectionPage_title;
	public static String NewExtensionWizard_PointSelectionPage_desc;
	public static String NewExtensionRegistryReader_missingProperty;
	public static String NewExtensionTemplateWizard_generating;
	public static String NewExtensionWizard_PointSelectionPage_filterCheck;
	public static String NewExtensionWizard_PointSelectionPage_dependencyTitle;
	public static String NewExtensionWizard_PointSelectionPage_dependencyMessage;
	public static String NewExtensionWizard_PointSelectionPage_availExtPoints_label;
	public static String NewExtensionWizard_PointSelectionPage_contributedTemplates_title;
	public static String NewExtensionWizard_PointSelectionPage_contributedTemplates_label;
	public static String NewExtensionWizard_PointSelectionPage_templateDescription;
	public static String NewExtensionWizard_PointSelectionPage_pluginDescription;
	public static String NewExtensionWizard_PointSelectionPage_pluginDescription_deprecated;
	public static String NewExtensionWizard_PointSelectionPage_extPointDescription;

	public static String ExtensionEditorWizard_wtitle;

	public static String NewExtensionPointWizard_wtitle;
	public static String NewExtensionPointWizard_title;
	public static String NewExtensionPointWizard_desc;

	public static String NewSchemaFileWizard_wtitle;
	public static String NewSchemaFileWizard_title;
	public static String NewSchemaFileWizard_desc;

	public static String BaseExtensionPointMainPage_missingExtensionPointID;
	public static String BaseExtensionPointMainPage_invalidCompositeID;
	public static String BaseExtensionPointMainPage_invalidSimpleID;
	public static String BaseExtensionPointMainPage_missingExtensionPointName;
	public static String BaseExtensionPointMainPage_missingExtensionPointSchema;

	public static String NewSchemaFileMainPage_missingPluginID;
	public static String NewSchemaFileMainPage_nonExistingPluginID;
	public static String NewSchemaFileMainPage_externalPluginID;
	public static String NewSchemaFileMainPage_missingContainer;
	public static String NewSchemaFileMainPage_invalidContainer;
	public static String NewSchemaFileMainPage_nonExistingContainer;

	public static String ConvertedProjectsPage_DeselectAll;
	public static String ConvertedProjectsPage_SelectAll;
	public static String ConvertedProjectWizard_title;
	public static String ConvertedProjectWizard_desc;
	public static String ConvertedProjectWizard_projectList;
	public static String ConvertedProjectWizard_converting;
	public static String ConvertProjectsAction_find;
	public static String ConvertProjectsAction_none;

	public static String PluginCodeGeneratorWizard_title;

	public static String NewProductFileWizard_title;

	public static String PointSelectionPage_tab1;
	public static String PointSelectionPage_tab2;
	public static String PointSelectionPage_categories;
	public static String ProductDefinitonWizardPage_productGroup;
	public static String ProductDefinitonWizardPage_productExists;
	public static String ProductDefinitonWizardPage_application;
	public static String ProductDefinitonWizardPage_noProductID;
	public static String ProductFileWizadPage_existingProduct;
	public static String ProductFileWizadPage_existingLaunchConfig;
	public static String ProductDefinitonWizardPage_productDefinition;
	public static String ProductDefinitonWizardPage_applicationGroup;
	public static String ProductDefinitonWizardPage_notInWorkspace;
	public static String ProductDefinitionOperation_readOnly;

	public static String TemplateSelectionPage_title;
	public static String TemplateSelectionPage_desc;
	public static String TemplateSelectionPage_table;
	public static String TemplateSelectionPage_column_name;
	public static String TemplateSelectionPage_column_point;

	public static String PluginSelectionDialog_title;
	public static String PluginSelectionDialog_message;

	public static String PluginImportOperation_could_not_delete_project;

	public static String PluginContentPage_appQuestion;

	public static String PluginContentPage_enable_api_analysis;

	public static String ImportWizard_title;
	public static String ImportWizard_FirstPage_title;
	public static String ImportWizard_FirstPage_desc;
	public static String ImportWizard_FirstPage_importGroup;
	public static String ImportWizard_FirstPage_importPrereqs;
	public static String ImportWizard_FirstPage_scanAll;
	public static String ImportWizard_FirstPage_importAs;
	public static String ImportWizard_FirstPage_binary;
	public static String ImportWizard_FirstPage_binaryLinks;
	public static String ImportWizard_FirstPage_source;
	public static String ImportWizard_FirstPage_importFrom;
	public static String ImportWizard_FirstPage_target;
	public static String ImportWizard_FirstPage_goToTarget;
	public static String ImportWizard_FirstPage_otherFolder;
	public static String ImportWizard_FirstPage_browse;
	public static String ImportWizard_SecondPage_addFragments;

	public static String ImportWizard_messages_folder_title;
	public static String ImportWizard_messages_folder_message;

	public static String ImportWizard_errors_locationMissing;
	public static String ImportWizard_errors_buildFolderInvalid;
	public static String ImportWizard_errors_buildFolderMissing;

	public static String ImportWizard_expressPage_title;
	public static String ImportWizard_expressPage_desc;
	public static String ImportWizard_expressPage_nonBinary;
	public static String ImportWizard_expressPage_total;

	public static String ImportWizard_DetailedPage_title;
	public static String ImportWizard_DetailedPage_desc;
	public static String ImportWizard_DetailedPage_availableList;
	public static String ImportWizard_DetailedPage_importList;
	public static String ImportWizard_DetailedPage_add;
	public static String ImportWizard_DetailedPage_addAll;
	public static String ImportWizard_DetailedPage_remove;
	public static String ImportWizard_DetailedPage_removeAll;
	public static String ImportWizard_DetailedPage_swap;
	public static String ImportWizard_DetailedPage_existing;
	public static String ImportWizard_DetailedPage_existingUnshared;
	public static String ImportWizard_DetailedPage_addRequired;
	public static String ImportWizard_DetailedPage_count;
	public static String ImportWizard_DetailedPage_filter;

	public static String ImportWizard_DetailedPage_filterDesc;
	public static String ImportWizard_DetailedPage_search;

	public static String ImportWizard_operation_multiProblem;
	public static String ImportWizard_operation_importingSource;

	public static String FeatureImportWizard_FirstPage_title;
	public static String FeatureImportWizard_FirstPage_desc;
	public static String FeatureImportWizard_FirstPage_runtimeLocation;
	public static String FeatureImportWizard_FirstPage_otherFolder;
	public static String FeatureImportWizard_FirstPage_binaryImport;
	public static String FeatureImportWizard_FirstPage_browse;
	public static String FeatureImportWizard_messages_folder_title;
	public static String FeatureImportWizard_messages_folder_message;
	public static String FeatureImportWizard_errors_locationMissing;
	public static String FeatureImportWizard_errors_buildFolderInvalid;
	public static String FeatureImportWizard_errors_buildFolderMissing;
	public static String FeatureImportWizard_messages_updating;
	public static String FeatureImportWizard_title;

	public static String FeatureImportWizard_noToAll;
	public static String FeatureImportWizard_messages_noFeatures;
	public static String FeatureImportWizard_messages_title;
	public static String FeatureImportWizard_messages_exists;

	public static String FeatureImportWizard_operation_creating;
	public static String FeatureImportWizard_operation_multiProblem;
	public static String FeatureImportWizard_operation_creating2;

	public static String ForbiddenAccessProposal_quickfixMessage;

	public static String UpdateBuildpathWizard_wtitle;
	public static String UpdateBuildpathWizard_title;
	public static String UpdateBuildpathWizard_desc;
	public static String UpdateBuildpathWizard_availablePlugins;

	// Actions ########################################
	public static String EditorActions_save;
	public static String EditorActions_cut;
	public static String EditorActions_copy;
	public static String EditorActions_paste;
	public static String EditorActions_selectall;
	public static String EditorActions_revert;
	public static String Actions_open_label;
	public static String Actions_delete_label;
	public static String Actions_filter_relatedPluginElements;
	public static String Actions_synchronizeVersions_label;

	public static String Menus_new_label;

	public static String Actions_Feature_OpenProjectWizardAction;
	public static String Actions_Site_OpenProjectWizardAction;

	public static String UnresolvedImportFixProcessor_0;
	public static String UnresolvedImportFixProcessor_1;
	public static String UnresolvedImportFixProcessor_2;
	public static String UnresolvedImportFixProcessor_3;
	public static String UnresolvedImportFixProcessor_4;
	public static String UnresolvedImportFixProcessor_5;

	public static String UpdateClasspathJob_error_title;
	public static String UpdateClasspathJob_error_message;
	public static String UpdateClasspathJob_task;
	public static String UpdateClasspathJob_title;

	public static String RuntimeWorkbenchShortcut_title;
	public static String RuntimeWorkbenchShortcut_select_debug;
	public static String RuntimeWorkbenchShortcut_select_run;
	public static String RuntimeInfoSection_addEntry;
	public static String RuntimeInfoSection_rename;
	public static String RuntimeInstallJob_Creating_installable_unit;

	public static String RuntimeInstallJob_ErrorCouldNotFindUnitInRepo;

	public static String RuntimeInstallJob_ErrorCouldNotGetIdOrVersion;

	public static String RuntimeInstallJob_ErrorCouldntOpenProfile;

	public static String RuntimeInstallJob_installPatchDescription;
	public static String RuntimeInstallJob_installPatchName;

	public static String RuntimeInstallJob_Job_name_installing;

	public static String BaseExtensionPointMainPage_pluginId_tooltip;
	public static String BaseExtensionPointMainPage_schemaLocation_tooltip;
	public static String BaseExtensionPointMainPage_pluginBrowse;
	public static String BaseExtensionPointMainPage_findBrowse;
	public static String BaseProductCreationOperation_taskName;
	public static String BaseExtensionPointMainPage_since;
	public static String BaseExtensionPointMainPage_schemaLocation_title;
	public static String BaseExtensionPointMainPage_schemaLocation_desc;
	public static String EditorPreferencePage_colorSettings;
	public static String EditorPreferencePage_text;
	public static String EditorPreferencePage_proc;
	public static String EditorPreferencePage_string;
	public static String EditorPreferencePage_tag;
	public static String EditorPreferencePage_comment;
	public static String PluginContentPage_yes;

	//Search Page###############################
	public static String SearchPage_searchString;
	public static String SearchPage_caseSensitive;
	public static String SearchPage_searchFor;
	public static String SearchResult_matches;
	public static String SearchPage_limitTo;
	public static String SearchPage_externalScope;
	public static String SearchPage_plugin;
	public static String SearchPage_fragment;
	public static String SelectionPage_title;
	public static String SearchPage_extPt;
	public static String SearchPage_declarations;
	public static String SearchPage_references;
	public static String SearchPage_allOccurrences;
	public static String SearchPage_all;
	public static String SearchPage_enabledOnly;
	public static String SearchPage_none;
	public static String SearchResult_match;
	public static String SelectionPage_desc;
	public static String SearchAction_references;
	public static String SearchAction_Declaration;
	public static String ShowDescriptionAction_label;
	public static String ShowDescriptionAction_title;
	public static String ShowAllExtensionsAction_label;
	public static String ShowSampleAction_installing;
	public static String ShowSampleAction_title;
	public static String ShowSampleAction_msgDesc;
	public static String ShowSampleAction_msgTitle;

	public static String ShowSampleAction_NoSamplesFound;
	public static String DependencyExtent_singular;
	public static String DependencyExtent_plural;
	public static String DetailsBlock_horizontal;
	public static String DependencyExtent_found;
	public static String DependencyExtentAction_label;
	public static String DependencyExtentQuery_label;
	public static String UnusedDependencies_title;
	public static String UnusedDependencies_action;
	public static String UnusedDependencies_notFound;
	public static String UnusedDependenciesJob_viewResults;
	public static String UnusedDependenciesAction_jobName;
	public static String UnusedDependencies_remove;
	public static String UnusedDependencies_analyze;
	public static String UnusedDependencies_unused;
	public static String RemoveExportPkgs_label;
	public static String RemoveExportPkgs_description;

	public static String DependenciesView_open;
	public static String DependenciesView_ShowCalleesAction_label;
	public static String DependenciesView_ShowCalleesAction_description;
	public static String DependenciesView_ShowCalleesAction_tooltip;
	public static String DependenciesView_ShowCallersAction_label;
	public static String DependenciesView_ShowCallersAction_description;
	public static String DependenciesView_ShowCallersAction_tooltip;
	public static String DependenciesView_ShowListAction_label;
	public static String DependenciesView_ShowListAction_description;
	public static String DependenciesView_ShowListAction_tooltip;
	public static String DependenciesView_ShowTreeAction_label;
	public static String DependenciesView_ShowTreeAction_description;
	public static String DependenciesView_ShowTreeAction_tooltip;
	public static String DependenciesView_ShowLoopsAction_label;
	public static String DependenciesView_ShowLoopsAction_description;
	public static String DependenciesView_ShowLoopsAction_tooltip;
	public static String DependenciesView_callees_tree_title;
	public static String DependenciesView_callees_list_title;
	public static String DependenciesView_callers_tree_title;
	public static String DependenciesView_callers_list_title;
	public static String DependenciesView_cycles_title;
	public static String DependenciesViewTreePage_CollapseAllAction_label;
	public static String DependenciesViewTreePage_CollapseAllAction_description;
	public static String DependenciesViewTreePage_CollapseAllAction_tooltip;
	public static String DependenciesPage_title;
	public static String DependenciesPage_tabName;
	public static String DetailsBlock_vertical;
	public static String DependenciesViewPage_focusOn;
	public static String DependenciesViewPage_focusOnSelection;
	public static String DependencyAnalysisSection_title;
	public static String DependencyAnalysisSection_loops;
	public static String DependencyAnalysisSection_noCycles;
	public static String DependencyExtentOperation_searching;
	public static String DependencyExtentOperation_inspecting;
	public static String DependencyExtentSearchResult_dependency;
	public static String DependencyExtentSearchResult_dependencies;
	public static String DependencyAnalysisSection_fragment_editable;
	public static String DependencyAnalysisSection_fragment_notEditable;
	public static String DependencyAnalysisSection_plugin_editable;
	public static String DependencyAnalysisSection_plugin_notEditable;

	public static String FeaturesView_CollapseAllAction_description;
	public static String FeaturesView_CollapseAllAction_tooltip;
	public static String FeaturesView_FeatureAndPluginCopyAction_label;
	public static String FeaturesView_FilterFeatureChildAction_description;
	public static String FeaturesView_FilterFeatureChildAction_tooltip;
	public static String FeaturesView_ShowCalleesContentProviderAction_description;
	public static String FeaturesView_ShowCalleesContentProviderAction_tooltip;
	public static String FeaturesView_ShowCallersContentProviderAction_description;
	public static String FeaturesView_ShowCallersContentProviderAction_tooltip;
	public static String FeaturesView_ShowPluginsAction_description;
	public static String FeaturesView_ShowPluginsAction_tooltip;
	public static String FeaturesView_ShowProductsAction_description;
	public static String FeaturesView_ShowProductsAction_tooltip;
	public static String FeaturesView_OpenAction_label;
	public static String FeaturesView_loadingDescription;
	public static String FeaturesView_searchPlaceholder;

	public static String HistoryAction_description;
	public static String HistoryAction_tooltip;
	public static String HistoryDropDownAction_tooltip;
	public static String HistoryListAction_label;
	public static String HistoryListDialog_label;
	public static String HistoryListDialog_title;
	public static String HistoryListDialog_remove_button;

	public static String PluginsView_open;
	public static String PluginsView_openDependencies;
	public static String PluginsView_asBinaryProject;
	public static String PluginsView_asSourceProject;
	public static String PluginsView_showDisabled;
	public static String PluginsView_showEnabled;
	public static String PluginsView_showWorkspace;
	public static String PluginsView_textEditor;
	public static String PluginWorkingSet_title;
	public static String PluginsView_systemEditor;
	public static String PluginsView_manifestEditor;
	public static String PluginContentPage_rcpGroup;
	public static String PluginWorkingSet_emptyName;
	public static String PluginWorkingSet_nameInUse;
	public static String PluginsView_schemaEditor;
	public static String PluginsView_copy;
	public static String PluginsView_deferredLabel0;

	public static String PluginsView_dependentPlugins;
	public static String PluginsView_pluginsInJavaSearch;
	public static String PluginsView_addToJavaSearch;
	public static String PluginsView_removeFromJavaSearch;
	public static String PluginWorkingSet_setContent;
	public static String PluginWorkingSet_selectAll_label;
	public static String PluginWorkingSet_selectAll_toolTip;
	public static String PluginWorkingSet_deselectAll_label;
	public static String PluginWorkingSet_deselectAll_toolTip;
	public static String PluginWorkingSet_noPluginsChecked;
	public static String PluginStatusDialog_pluginValidation;
	public static String PluginsView_openWith;
	public static String PluginsView_import;
	public static String PluginsView_select;
	public static String PluginsView_showIn;
	public static String PluginsView_CollapseAllAction_label;
	public static String PluginsView_CollapseAllAction_description;
	public static String PluginsView_CollapseAllAction_tooltip;
	public static String PluginsView_SelectAllAction_label;
	public static String PluginsView_TotalPlugins_unknown;

	public static String PluginSection_open;
	public static String PluginsView_unableToOpen;
	public static String PluginWorkingSet_setName;
	public static String PluginStatusDialog_label;
	public static String PluginStatusDialog_continueButtonLabel;
	public static String PluginSection_removeAll;
	public static String PluginsView_disabled;
	public static String PluginContentPage_no;
	public static String PluginContentPage_noEE;
	public static String PluginSection_remove;
	public static String RequiredPluginsContainerPage_title;
	public static String RequiredPluginsContainerPage_desc;
	public static String RequiredPluginsContainerPage_label;

	public static String NewSiteWizard_wtitle;
	public static String NewSiteWizard_MainPage_title;
	public static String NewSiteWizard_creatingProject;
	public static String NewSiteWizard_creatingManifest;
	public static String NewSiteWizard_MainPage_desc;

	//
	public static String SiteHTML_checkLabel;
	public static String SiteHTML_webLabel;
	public static String SiteHTML_webError;
	public static String SiteHTML_loadError;

	//
	public static String CompilersConfigurationBlock_plugins;
	public static String CompilersConfigurationBlock_schemas;
	public static String CompilersConfigurationBlock_features;
	public static String CompilersConfigurationBlock_label;
	public static String CompilersConfigurationBlock_altlabel;

	public static String CompilersPreferencePage_configure_project_specific_settings;

	public static String CompilersPreferencePage_title;

	public static String CompilersPropertyPage_useworkspacesettings_change;
	public static String CompilersPropertyPage_useprojectsettings_label;

	public static String compilers_p_unresolved_import;
	public static String compilers_p_unresolved_ex_points;
	public static String compilers_p_unknown_element;
	public static String compilers_p_unknown_attribute;
	public static String compilers_p_unknown_class;
	public static String compilers_p_discouraged_class;
	public static String compilers_p_unknown_resource;
	public static String compilers_p_unknown_identifier;
	public static String compilers_p_no_required_att;
	public static String compilers_p_not_externalized_att;
	public static String compilers_p_service_component_without_lazy_act;
	public static String compilers_p_no_automatic_module_name;
	public static String compilers_p_deprecated;
	public static String compilers_p_internal;
	public static String compilers_p_missing_imp_pkg;
	public static String compilers_p_missing_exp_pkg;
	public static String compilers_p_missing_require_bundle;
	public static String compilers_s_create_docs;
	public static String compilers_s_doc_folder;
	public static String compilers_s_open_tags;
	public static String compilers_p_exec_env_too_low;

	public static String compilers_p_exported_pkgs;

	public static String compilers_f_unresolved_plugins;
	public static String compilers_f_unresolved_features;

	public static String CompilersConfigurationBlock_building;

	public static String ExportWizard_Plugin_pageTitle;
	public static String ExportWizard_Feature_pageTitle;
	public static String ExportWizard_Plugin_pageBlock;
	public static String ExportWizard_Feature_pageBlock;
	public static String ExportWizard_Plugin_description;
	public static String ExportWizard_archive;
	public static String ExportWizard_includeSource;
	public static String ExportWizard_includeSourceInBinaryBundles;
	public static String ExportWizard_generateAssociatedSourceBundles;
	public static String ExportWizard_includesMetadata;
	public static String ExportWizard_generateCategories;
	public static String ExportWizard_multi_platform;
	public static String ExportWizard_destination;
	public static String ExportWizard_options;
	public static String ExportWizard_directory;
	public static String ExportWizard_workingSet;
	public static String ExportWizard_browse;
	public static String ExportWizard_antCheck;
	public static String ExportWizard_dialog_title;
	public static String ExportWizard_dialog_message;
	public static String ExportWizard_status_noselection;
	public static String ExportWizard_status_nodirectory;
	public static String ExportWizard_status_invaliddirectory;
	public static String ExportWizard_status_nofile;
	public static String ExportWizard_status_noantfile;
	public static String ExtensionsPage_title;
	public static String ExtensionsPage_tabName;
	public static String ExtensionDetails_title;
	public static String ExtensionDetails_desc;
	public static String ExtensionDetails_id;
	public static String ExtensionDetails_name;

	public static String FeatureImportWizard_DetailedPage_problemsLoading;
	public static String NewArchiveDialog_alreadyExists;
	public static String UpdateClasspathAction_find;
	public static String UpdateClasspathAction_none;
	public static String RenameDialog_label;
	public static String RenameDialog_validationError;
	public static String ReferenceAttributeRow_browse;
	public static String EditableTablePart_renameAction;
	public static String EditableTablePart_renameTitle;

	// Category Editor ######################################
	public static String CategoryPage_header;
	public static String CategoryDefinitionWizardPage_title;
	public static String CategoryDefinitionWizardPage_description;
	public static String NewCategoryDefinitionWizard_creatingManifest;
	public static String NewCategoryDefinitionWizard_title;
	public static String CategoryDefinitionCategorySection_title;
	public static String CategoryDefinitionCategorySection_new;
	public static String CategoryDefinitionCategorySection_desc;
	public static String RepositoryPage_title;
	public static String RepositorySection_title;
	public static String RepositorySection_description;
	public static String RepositorySection_add;
	public static String RepositorySection_edit;
	public static String RepositorySection_remove;
	public static String RepositorySection_removeAll;
	public static String StatsSection_title;
	public static String StatsSection_description;
	public static String StatsSection_url;
	public static String StatsSection_addFeature;
	public static String StatsSection_addBundle;
	public static String StatsSection_remove;
	public static String StatsSection_removeAll;

	// Site Editor #########################################
	public static String CategorySection_title;
	public static String CategorySection_new;
	public static String CategorySection_desc;
	public static String CategorySection_add;
	public static String CategorySection_addBundle;
	public static String CategorySection_remove;
	public static String CategorySection_environment;
	public static String CategorySection_buildAll;
	public static String CategorySection_build;
	public static String CategorySection_newCategoryName;
	public static String CategorySection_newCategoryLabel;

	// Target Export ########################################
	public static String ExportActiveTargetDefinition;
	public static String ExportActiveTargetDefinition_message;
	public static String ExportTargetError_ChooseDestination;
	public static String ExportTargetError_validPath;
	public static String ExportTargetCurrentTarget;
	public static String ExportTargetChooseFolder;
	public static String ExportTargetBrowse;
	public static String ExportTargetSelectDestination;
	public static String ExportTargetSpecifyDestination;
	public static String ExportTargetClearDestination;

	public static String CategoryDetails_title;
	public static String CategoryDetails_sectionDescription;
	public static String CategoryDetails_name;
	public static String CategoryDetails_label;
	public static String CategoryDetails_desc;
	public static String CategoryDetails_alreadyExists;
	public static String CategoryDetails_alreadyExists_title;

	public static String FeatureDetails_title;
	public static String FeatureDetails_sectionDescription;
	public static String SiteContentDetails_id;
	public static String SiteContentDetails_version;
	public static String FeatureDetails_url;
	public static String FeatureDetails_include_url;

	public static String BundleDetails_title;
	public static String BundleDetails_sectionDescription;

	public static String FeaturesPage_title;
	public static String FeaturesPage_header;

	public static String SiteEditor_add;
	public static String SiteEditor_edit;
	public static String SiteEditor_remove;
	public static String SiteEditor_NewArchiveDialog_path;
	public static String SiteEditor_NewArchiveDialog_url;
	public static String SiteEditor_NewArchiveDialog_title;
	public static String SiteEditor_NewArchiveDialog_error;
	public static String SiteEditor_ArchiveSection_header;
	public static String SiteEditor_ArchiveSection_instruction;
	public static String SiteEditor_ArchiveSection_col1;
	public static String SiteEditor_ArchiveSection_col2;
	public static String SiteEditor_DescriptionSection_header;
	public static String SiteEditor_DescriptionSection_desc;
	public static String SiteEditor_DescriptionSection_descLabel;
	public static String SiteEditor_DescriptionSection_urlLabel;
	public static String SiteEditor_MirrorsSection_header;
	public static String SiteEditor_MirrorsSection_desc;
	public static String SiteEditor_MirrorsSection_urlLabel;

	public static String SynchronizePropertiesAction_label;
	public static String SynchronizePropertiesWizard_wtitle;
	public static String SynchronizePropertiesWizardPage_title;
	public static String SynchronizePropertiesWizardPage_desc;
	public static String SynchronizePropertiesWizardPage_group;
	public static String SynchronizationOperation_externalPlugin;
	public static String SynchronizePropertiesWizardPage_selectedFeatures;
	public static String SynchronizationOperation_noDefiningPlugin;
	public static String SynchronizePropertiesWizardPage_allFeatures;
	public static String SynchronizePropertiesWizardPage_synchronizing;

	public static String PDEFormPage_help;
	public static String GeneralInfoSection_id;
	public static String GeneralInfoSection_name;
	public static String GeneralInfoSection_class;
	public static String GeneralInfoSection_browse;
	public static String GeneralInfoSection_platformFilter;
	public static String GeneralInfoSection_selectionTitle;
	public static String RequiresSection_title;
	public static String RequiresSection_fDesc;
	public static String RequiresSection_desc;
	public static String RequiresSection_down;
	public static String RequiresSection_add;
	public static String RequiresSection_up;
	public static String RequiresSection_open;
	public static String RequiresSection_delete;

	public static String RequiresSection_nullLog;
	public static String LoopDialog_title;
	public static String MatchSection_title;
	public static String MatchSection_desc;
	public static String ClasspathSection_jarsMessage;
	public static String OverviewPage_exportingTitle;
	public static String OverviewPage_content;
	public static String OverviewPage_testing;
	public static String OverviewPage_OSGiTesting;
	public static String OverviewPage_tabName;
	public static String OverviewPage_title;
	public static String OverviewPage_deploying;
	public static String OverviewPage_NoPluginConverterFragment;
	public static String OverviewPage_NoPluginConverterPlugin;
	public static String OverviewPage_error;
	public static String OverviewPage_fContent;
	public static String OverviewPage_fTesting;
	public static String OverviewPage_fDeploying;
	public static String ClassAttributeRow_dialogTitle;
	public static String ArchivePage_title;
	public static String ArchivePage_name;

	public static String SampleWizard_title;
	public static String SampleEditor_desc;
	public static String SampleWizard_overwrite;
	public static String SampleEditor_content;
	public static String SampleOperation_creating;
	public static String SampleStandbyContent_content;
	public static String SampleStandbyContent_desc;
	public static String SaveToWorkspace_ConfirmOverwrite;

	public static String SaveToWorkspace_ConfirmOverwriteText;

	public static String SaveToWorkspace_SaveImageToWorkspace;

	public static String ReviewPage_title;
	public static String ReviewPage_desc;
	public static String ReviewPage_descContent;
	public static String ReviewPage_content;
	public static String SelfHostingPropertyPage_label;
	public static String SelfHostingPropertyPage_viewerLabel;
	public static String RuntimePage_tabName;
	public static String ApplicationSelectionDialog_debug;
	public static String ApplicationSelectionDialog_run;
	public static String ApplicationSelectionDialog_dtitle;
	public static String ApplicationSelectionDialog_rtitle;

	public static String EnvironmentBlock_targetEnv;

	//Product Editor#####################
	public static String Product_overview_configuration;
	public static String Product_PluginSection_working;
	public static String ProductInfoSection_version;
	public static String Product_PluginSection_required;
	public static String ProductExportWizardPage_title;
	public static String ProductExportWizardPage_config;
	public static String ProductExportWizardPage_browse;
	public static String Product_PluginSection_removeAll;
	public static String Product_PluginSection_newPlugin;
	public static String Product_PluginSection_recommended;
	public static String Product_PluginSection_RecommendedBundles_title;
	public static String Product_PluginSection_RecommendedBundles_message;
	public static String Product_PluginSection_NoRecommendedBundles_message;
	public static String Product_FeatureSection_properties;
	public static String Product_DependenciesPage_title;
	public static String ProductFileWizadPage_groupTitle;
	public static String Product_PluginSection_newFragment;
	public static String ProductValidateAction_validate;
	public static String Product_overview_testing;
	public static String ProductInfoSection_title;
	public static String GeneralInfoSection_title;
	public static String Product_PluginSection_add;
	public static String Product_PluginSection_autoIncludeRequirements;
	public static String Product_PluginSection_title;
	public static String Product_FeatureSection_desc;
	public static String ProductExportWizardPage_desc;
	public static String ProductExportWizardPage_root;
	public static String ProductExportWizardPage_sync;
	public static String ProductExportWizard_error;
	public static String ProductExportWizard_corrupt;
	public static String ProductDefinitionWizard_title;
	public static String ProductDefinitionWizard_error;
	public static String ProductDefinitonWizardPage_title;
	public static String ProductDefinitonWizardPage_desc;
	public static String ProductDefinitonWizardPage_descNoName;
	public static String ProductDefinitonWizardPage_plugin;
	public static String ProductDefinitonWizardPage_browse;
	public static String ProductDefinitonWizardPage_productId;
	public static String ProductDefinitonWizardPage_productName;
	public static String ProductDefinitonWizardPage_noPluginId;
	public static String ProductDefinitonWizardPage_noPlugin;
	public static String ProductDefinitonWizardPage_invalidId;
	public static String Product_FeatureSection_title;
	public static String Product_FeatureSection_newFeature;
	public static String ProductExportWizardPage_productGroup;
	public static String ProductExportWizardPage_productNotExists;
	public static String ProductExportWizardPage_wrongExtension;
	public static String ProductExportWizardPage_fileSelection;
	public static String ProductExportWizardPage_productSelection;
	public static String ProductExportWizardPage_syncText;
	public static String ProductExportWizardPage_syncButton;
	public static String ProductExportWizardPage_noProduct;
	public static String Product_OverviewPage_testing;
	public static String Product_PluginSection_desc;
	public static String Product_FeatureSection_add;
	public static String Product_FeatureSection_autoIncludeRequirements;
	public static String ProductFileWizadPage_title;
	public static String ProductFileWizadPage_basic;
	public static String Product_overview_exporting;
	public static String GeneralInfoSection_desc;
	public static String ProductInfoSection_desc;
	public static String ProductInfoSection_id;
	public static String ProductInfoSection_product;
	public static String ProductInfoSection_productTooltip;
	public static String ProductInfoSection_new;
	public static String ProductInfoSection_app;
	public static String ProductInfoSection_appTooltip;
	public static String ProductInfoSection_launchers;
	public static String SplashSection_title;
	public static String SplashSection_desc;
	public static String SplashSection_plugin;
	public static String SplashSection_browse;
	public static String SplashSection_selection;
	public static String SplashSection_message;
	public static String BrandingPage_title;
	public static String WindowImagesSection_title;
	public static String WindowImagesSection_desc;
	public static String WindowImagesSection_browse;
	public static String WindowImagesSection_open;
	public static String WindowImagesSection_warning;
	public static String WindowImagesSection_emptyPath;
	public static String WindowImagesSection_dialogTitle;
	public static String WindowImagesSection_dialogMessage;
	public static String AboutSection_title;
	public static String AboutSection_desc;
	public static String AboutSection_image;
	public static String AboutSection_browse;
	public static String AboutSection_text;
	public static String AboutSection_open;
	public static String AboutSection_warning;
	public static String AboutSection_imgTitle;
	public static String AboutSection_imgMessage;
	public static String LauncherSection_launcherName;
	public static String LauncherSection_dialogTitle;
	public static String LauncherSection_dialogMessage;
	public static String ProductDefinitonWizardPage_applicationDefinition;
	public static String ArgumentsSection_0;

	public static String ArgumentsSection_1;

	public static String ArgumentsSection_title;
	public static String ArgumentsSection_desc;
	public static String ArgumentsSection_program;
	public static String ArgumentsSection_vm;

	public static String ProductJRESection_title;
	public static String ProductJRESection_desc;
	public static String ProductJRESection_eeName;
	public static String ProductJRESection_browseEEs;
	public static String ProdctJRESection_bundleJRE;

	public static String Product_FeatureSection_remove;
	public static String Product_FeatureSection_open;
	public static String Product_FeatureSection_up;
	public static String Product_FeatureSection_down;
	public static String Product_FeatureSection_sortAlpha;
	public static String FeatureSection_addRequired;
	public static String FeatureSection_toggleRoot;
	public static String FeatureSection_removeAll;

	public static String ImportPackageSection_desc;
	public static String ImportPackageSection_descFragment;
	public static String ExportPackageSection_desc;
	public static String ExportPackageSection_descFragment;

	static {
		// load message values from bundle file
		NLS.initializeMessages(BUNDLE_NAME, PDEUIMessages.class);
	}

	public static String ExportPackageVisibilitySection_title;

	public static String ExportPackageVisibilitySection_default;

	public static String ExportPackageVisibilitySection_hideAll;

	public static String ExportPackageSection_add;

	public static String ExportPackageSection_remove;

	public static String ExportPackageSection_properties;

	public static String ExportPackageSection_title;

	public static String ExportPackageSection_propertyAction;

	public static String ExportPackageSection_dialogButtonLabel;

	public static String DependenciesPage_properties;

	public static String ImportPackageSection_add;

	public static String ImportPackageSection_remove;

	public static String ImportPackageSection_properties;

	public static String ImportPackageSection_required;

	public static String ImportPackageSection_exported;

	public static String ImportPackageSection_selection;

	public static String ImportPackageSection_propertyAction;

	public static String DependencyPropertiesDialog_properties;

	public static String DependencyPropertiesDialog_optional;

	public static String DependencyPropertiesDialog_reexport;

	public static String DependencyPropertiesDialog_version;

	public static String DependencyPropertiesDialog_invalidFormat;

	public static String RequiresSection_properties;

	public static String ClasspathSection_fragment;

	public static String ClasspathSection_plugin;

	public static String EnvironmentBlock_jreTitle;

	public static String DependencyExtentSearchResultPage_referencesInPlugin;

	public static String CrossPlatformExportPage_available;

	public static String CrossPlatformExportPage_title;

	public static String CrossPlatformExportPage_desc;

	public static String BaseImportWizardSecondPage_0;

	public static String BaseImportWizardSecondPage_autobuild;

	public static String ExportPackageVisibilitySection_unconditional;

	public static String ExportPackageSection_props;

	public static String OverviewPage_buildTitle;

	public static String OverviewPage_buildQuestion;

	public static String OverviewPage_ErrorOccurred;

	public static String PluginWorkingSet_message;

	public static String ProductDefinitonWizardPage_noProductName;

	public static String DependencyPropertiesDialog_groupText;

	public static String DependencyPropertiesDialog_comboInclusive;

	public static String DependencyPropertiesDialog_comboExclusive;

	public static String DependencyPropertiesDialog_minimumVersion;

	public static String DependencyPropertiesDialog_maximumVersion;

	public static String DependencyPropertiesDialog_versionRangeError;

	public static String NewProjectCreationPage_pDependsOnRuntime;

	public static String NewProjectCreationPage_pPureOSGi;

	public static String IntroSection_sectionText;

	public static String IntroSection_sectionDescription;

	public static String IntroSection_introLabel;

	public static String IntroSection_introInput;

	public static String IntroSection_new;

	public static String IntroSection_undefinedProductId;

	public static String IntroSection_undefinedProductIdMessage;

	public static String ProductIntroWizard_title;

	public static String ProductIntroWizardPage_title;

	public static String ProductIntroWizardPage_description;

	public static String ProductIntroWizardPage_groupText;

	public static String ProductIntroWizardPage_formText;

	public static String ProductIntroWizardPage_targetLabel;

	public static String ProductIntroWizardPage_browse;

	public static String ProductIntroWizardPage_introLabel;

	public static String ProductIntroWizardPage_targetNotSet;

	public static String ProductIntroWizardPage_introNotSet;

	public static String ProductIntroWizardPage_invalidIntroId;

	public static String ProductIntroWizardPage_introIdExists;

	public static String ManifestTypeRenameParticipant_composite;

	public static String LauncherPage_title;

	public static String WindowImagesSection_16;

	public static String WindowImagesSection_32;

	public static String WindowImagesSection_48;

	public static String WindowImagesSection_64;

	public static String WindowImagesSection_128;

	public static String WindowImagesSection_256;

	public static String ManifestPackageRenameParticipant_packageRename;

	public static String NewProjectCreationPage_standard;

	public static String PluginDevelopmentPage_presentation;

	public static String PluginDevelopmentPage_extensions;

	public static String PluginDevelopmentPage_equinox;

	public static String MainTab_jreSection;

	public static String PluginsTab_target;

	public static String BaseBlock_workspace;

	public static String BaseBlock_filesystem;

	public static String BaseBlock_variables;

	public static String BaseBlock_workspaceS;

	public static String BaseBlock_filesystemS;

	public static String BaseBlock_variablesS;

	public static String BaseBlock_relative;

	public static String OverviewPage_extensionContent;

	public static String OverviewPage_extensionPageMessageTitle;

	public static String OverviewPage_extensionPageMessageBody;

	public static String OverviewPage_fExtensionContent;

	public static String OverviewPage_InstallNewSoftwareCouldNotBeOpened;

	public static String OverviewPage_ManifestWarning;
	public static String OverviewPage_WarnAboutMissingManifest;
	public static String OverviewPage_WarnAboutMissingManifestFragment;

	public static String OverwriteProjectsSelectionDialog_0;

	public static String BaseBlock_dirSelection;

	public static String BaseBlock_dirChoose;

	public static String BaseBlock_errorMessage;

	public static String BaseBlock_fileTitle;

	public static String BaseBlock_fileNotFoundMessage;

	public static String BaseBlock_fileErrorMessage;

	public static String BaseBlock_directoryTitle;

	public static String BaseBlock_directoryNotFoundMessage;

	public static String BaseBlock_directoryErrorMessage;

	public static String BaseBuildAction_NoValidManifest;

	public static String ConfigurationTemplateBlock_name;

	public static String WorkspaceDataBlock_name;

	public static String WorkspaceDataBlock_WorkspaceDataLocationCannotContainPound;

	public static String ConfigurationAreaBlock_name;
	public static String ConfigurationPageMock_pageTitle;
	public static String ConfigurationPageMock_sectionTitle;
	public static String ConfigurationPageMock_sectionDesc;
	public static String PluginConfigurationSection_tablePluginTitle;

	public static String AbstractPluginBlock_counter;

	public static String AbstractRepository_ErrorLoadingImageFromJar;

	public static String AbstractRepository_ScanForUI;

	public static String EquinoxPluginBlock_levelColumn;

	public static String EquinoxPluginBlock_defaultLevelColumn;

	public static String EquinoxPluginBlock_autoColumn;

	public static String EquinoxPluginsTab_defaultStart;

	public static String EquinoxPluginsTab_defaultAuto;

	public static String EquinoxSettingsTab_name;

	public static String ModelChangeLabelProvider_instance;

	public static String ModelChangeLabelProvider_instances;

	public static String MoveTargetDefinitionPage_0;

	public static String MoveTargetDefinitionPage_1;

	public static String MoveTargetDefinitionWizard_0;

	public static String GetNonExternalizedStringsOperation_taskMessage;

	public static String ExternalizeStringsWizard_title;

	public static String GetNonExternalizedStringsAction_allExternalizedTitle;

	public static String GetNonExternalizedStringsAction_allExternalizedMessage;

	public static String ExternalizeStringsWizardPage_pageTitle;

	public static String ExternalizeStringsWizardPage_pageDescription;

	public static String ExternalizeStringsWizardPage_badLocalizationError;

	public static String ExternalizeStringsWizardPage_resourcelabel;

	public static String ExternalizeStringsWizardPage_selectAllButton;

	public static String ExternalizeStringsWizardPage_deselectAllButton;

	public static String ExternalizeStringsWizardPage_projectLabel;

	public static String ExternalizeStringsWizardPage_noUnderlyingResource;

	public static String ExternalizeStringsWizardPage_localizationLabel;

	public static String ExternalizeStringsWizardPage_propertiesLabel;

	public static String ExternalizeStringsWizardPage_sourceLabel;

	public static String ExternalizeStringsWizardPage_keyEmptyError;

	public static String ExternalizeStringsWizardPage_keyCommentError;

	public static String ExternalizeStringsWizardPage_keyError;

	public static String ExternalizeStringsWizardPage_keyDuplicateError;

	public static String ExternalizeStringsWizardPage_keySuggested;

	public static String InternationalizeAction_internationalizeTitle;

	public static String InternationalizeAction_internationalizeMessage;

	public static String InternationalizeWizard_title;

	public static String InternationalizeWizard_PluginPage_internationalizeList;

	public static String InternationalizeWizard_PluginPage_availableList;

	public static String InternationalizeWizard_PluginPage_filter;

	public static String InternationalizeWizard_PluginPage_templateLabel;

	public static String InternationalizeWizard_PluginPage_pageTitle;

	public static String InternationalizeWizard_PluginPage_pageDescription;

	public static String InternationalizeWizard_PluginPage_overwriteWithoutAsking;
	public static String InternationalizeWizard_PluginPage_templateError;
	public static String InternationalizeWizard_PluginPage_selectionError;
	public static String InternationalizeWizard_PluginPage_individualFragments;

	public static String InternationalizeWizard_LocalePage_pageTitle;

	public static String InternationalizeWizard_LocalePage_pageDescription;

	public static String InternationalizeWizard_LocalePage_internationalizeList;

	public static String InternationalizeWizard_LocalePage_availableList;
	public static String InternationalizeWizard_LocalePage_selectionError;

	public static String InternationalizeWizard_LocalePage_filter;

	public static String InternationalizeWizard_NLSFragmentGenerator_overwriteTitle;

	public static String InternationalizeWizard_NLSFragmentGenerator_overwriteMessage;
	public static String InternationalizeWizard_NLSFragmentGenerator_errorMessage;

	public static String NewProjectCreationPage_target;

	public static String NewProjectCreationPage_ftarget;

	public static String NewProjectCreationPage_ptarget;

	public static String NewProjectCreationPage_executionEnvironments_label;

	public static String NewProjectCreationPage_environmentsButton;

	public static String RequiredExecutionEnvironmentSection_title;

	public static String PluginGeneralInfoSection_lazyStart;

	public static String PluginGeneralInfoSection_singleton;

	public static String FragmentGeneralInfoSection_singleton;

	public static String ClassSearchParticipant_taskMessage;

	public static String CreateJREBundleHeaderResolution_desc;

	public static String CreateJREBundleHeaderResolution_label;

	public static String UpdateActivationResolution_lazyStart_desc;

	public static String UpdateActivationResolution_lazyStart_label;

	public static String UpdateActivationResolution_bundleActivationPolicyAdd_desc;

	public static String UpdateActivationResolution_bundleActivationPolicyAdd_label;

	public static String AddSingleon_dir_label;

	public static String AddSingleon_att_label;

	public static String AddSingleon_dir_desc;

	public static String AddSingleon_att_desc;

	public static String RemoveBuildOrderEntries_desc;

	public static String RemoveBuildOrderEntries_label;

	public static String PointSelectionPage_extPointDesc;

	public static String PointSelectionPage_noDescAvailable;

	public static String RemoveRequireBundleResolution_description;
	public static String RemoveRequireBundleResolution_label;
	public static String RemoveUselessPluginFile_description;
	public static String AddNewExtensionResolution_description;
	public static String AddNewExtensionPointResolution_description;

	public static String OptionalRequireBundleResolution_description;

	public static String OptionalRequireBundleResolution_label;

	public static String ConfigureProblemSeverityForPDECompiler_0;

	public static String ConfigureProblemSeverityForPDECompiler_1;

	public static String ConfigureProblemSeverityForPDECompiler_2;

	public static String ConfigureProblemSeverityForPDECompiler_3;

	public static String ConfigureProblemSeverityForPDECompiler_4;

	public static String ConfigureProblemSeverityForPDECompiler_5;

	public static String ConfigureProblemSeverityForPDECompiler_6;

	public static String ConfigureTargetPlatformResolution_label;
	public static String ConfigureTargetPlatformResolution_description;

	public static String OrganizeManifestJob_taskName;

	public static String RemoveImportPkgResolution_description;

	public static String RemoveImportPkgResolution_label;

	public static String NoLineTerminationResolutionCreate_description;

	public static String NoLineTerminationResolutionCreate_label;

	public static String NoLineTerminationResolutionRemove_description;

	public static String NoLineTerminationResolutionRemove_label;

	public static String OptionalImportPkgResolution_description;

	public static String OptionalImportPkgResolution_label;

	public static String PluginImportOperation_Importing_plugin;

	public static String PluginImportOperation_OverwritePluginProjects;

	public static String PluginImportOperation_Set_up_classpaths;

	public static String PluginImportOperation_WarningDialogJob;

	public static String PluginImportOperation_WarningDialogMessageSingular;

	public static String PluginImportOperation_WarningDialogMessagePlural;

	public static String PluginImportWizard_runningConfigDesc;

	public static String PluginImportWizard_runningConfigsDesc;

	public static String PluginImportWizard_runningConfigsTitle;

	public static String PluginImportWizardFirstPage_0;

	public static String PluginImportWizardFirstPage_1;

	public static String PluginImportWizardFirstPage_2;

	public static String PluginImportWizardFirstPage_3;

	public static String LauncherUtils_title;

	public static String RemoveLazyLoadingDirectiveResolution_remove;

	public static String RemoveAutomaticModuleResolution_remove;

	public static String EditorPreferencePage_link;

	public static String ManifestSyntaxColorTab_keys;

	public static String ManifestSyntaxColorTab_assignment;

	public static String ManifestSyntaxColorTab_values;

	public static String SyntaxColorTab_elements;

	public static String SyntaxColorTab_color;

	public static String SyntaxColorTab_bold;

	public static String SyntaxColorTab_italic;

	public static String SyntaxColorTab_preview;

	public static String EditorPreferencePage_xml;

	public static String EditorPreferencePage_manifest;

	public static String ManifestSyntaxColorTab_reservedOSGi;

	public static String ManifestSyntaxColorTab_attributes;

	public static String AbstractSchemaDetails_minOccurLabel;

	public static String AbstractSchemaDetails_maxOccurLabel;

	public static String AbstractSchemaDetails_unboundedButton;

	public static String NewRestrictionDialog_title;

	public static String NewRestrictionDialog_message;

	public static String SchemaIncludesSection_addButton;

	public static String SchemaIncludesSection_removeButton;

	public static String SchemaIncludesSection_title;

	public static String SchemaIncludesSection_description;

	public static String SchemaIncludesSection_dialogMessage;

	public static String SchemaDetails_translatable;

	public static String SchemaElementDetails_title;

	public static String SchemaElementDetails_rootTitle;

	public static String SchemaElementDetails_description;

	public static String SchemaCompositorDetails_description;

	public static String SchemaElementReferenceDetails_description;

	public static String SchemaCompositorDetails_type;

	public static String SchemaCompositorDetails_title;

	public static String SchemaElementReferenceDetails_reference;

	public static String SchemaElementReferenceDetails_title;

	public static String DocSection_text;

	public static String SchemaDetails_deprecated;
	public static String SchemaDetails_internal;

	public static String SchemaAttributeDetails_use;
	public static String SchemaAttributeDetails_type;
	public static String SchemaAttributeDetails_restrictions;
	public static String SchemaAttributeDetails_addRestButton;
	public static String SchemaAttributeDetails_removeRestButton;
	public static String SchemaAttributeDetails_extends;
	public static String SchemaAttributeDetails_browseButton;
	public static String SchemaAttributeDetails_implements;
	public static String SchemaAttributeDetails_title;
	public static String SchemaAttributeDetails_description;
	public static String SchemaAttributeDetails_defaultDefaultValue;

	public static String SchemaStringAttributeDetails_reference;
	public static String SchemaIdentifierAttributeDetails_additionalRestrictions;

	public static String SchemaDetails_name;

	public static String SchemaRootElementDetails_replacement;

	public static String SecondaryBundlesSection_title;

	public static String SecondaryBundlesSection_desc;

	public static String SecondaryBundlesSection_resolve;

	public static String ArgumentsSection_allPlatforms;

	public static String ArgumentsSection_allArch;

	public static String ArgumentsSection_architecture;

	public static String ArgumentsSection_preview;

	public static String JavaArgumentsTab_progamArgsGroup;

	public static String JavaArgumentsTab_programVariables;

	public static String JavaArgumentsTab_vmArgsGroup;

	public static String JavaArgumentsTab_vmVariables;

	public static String NewTargetDefnitionFileWizardPage_0;

	public static String NewTargetProfileWizard_title;

	public static String TargetProfileWizardPage_description;

	public static String JavaArgumentsTab_description;

	public static String JavaSearchActionGroup_RemoveJavaSearchMessage;

	public static String JavaSearchActionGroup_RemoveJavaSearchTitle;

	public static String TargetProfileWizardPage_title;

	public static String ProductInfoSection_productname;

	public static String ManifestStructureCreator_name;

	public static String ManifestContentMergeViewer_title;

	public static String GenericEditorTab_title;

	public static String EnvironmentPage_title;

	public static String JRESection_description;

	public static String JRESection_defaultJRE;

	public static String JRESection_JREName;

	public static String JRESection_ExecutionEnv;

	public static String EnvironmentSection_description;

	public static String EnvironmentSection_operationSystem;

	public static String EnvironmentSection_windowingSystem;

	public static String EnvironmentSection_architecture;

	public static String EnvironmentSection_locale;

	public static String ArgumentsSection_programTabLabel;

	public static String ArgumentsSection_vmTabLabel;

	public static String ArgumentsSection_editorTitle;

	public static String ArgumentsSection_description;

	public static String ArgumentsSection_variableButtonTitle;

	public static String ArgumentsSection_argumentsButtonTitle;

	public static String TargetDefinitionContentPage_0;

	public static String TargetDefinitionContentPage_1;

	public static String TargetDefinitionContentPage_2;

	public static String TargetDefinitionContentPage_4;

	public static String TargetDefinitionContentPage_6;

	public static String TargetDefinitionContentPage_7;

	public static String TargetDefinitionContentPage_8;

	public static String TargetDefinitionContentPage_LocationDescription;

	public static String TargetDefinitionEnvironmentPage_3;

	public static String TargetDefinitionEnvironmentPage_4;

	public static String TargetDefinitionEnvironmentPage_5;

	public static String FilteredIUSelectionDialog_title;
	public static String FilteredIUSelectionDialog_message;
	public static String FilteredIUSelectionDialog_showLatestVersionOnly;

	public static String EditorUtilities_noImageData;

	public static String EditorUtilities_pathNotValidImage;

	public static String EditorUtilities_invalidFilePath;

	public static String EditorUtilities_icoError;

	public static String EditorUtilities_incorrectSize;

	public static String EditorUtilities_imageTooLarge;

	public static String EditorUtilities_imageTooLargeInfo;

	public static String EditorUtilities_missingIcoNote;

	public static String RequiredExecutionEnvironmentSection_add;

	public static String RequiredExecutionEnvironmentSection_remove;

	public static String RequiredExecutionEnvironmentSection_up;

	public static String RequiredExecutionEnvironmentSection_down;

	public static String RequiredExecutionEnvironmentSection_fragmentDesc;

	public static String RequiredExecutionEnvironmentSection_pluginDesc;

	public static String RequiredExecutionEnvironmentSection_dialog_title;

	public static String RequiredExecutionEnvironmentSection_dialogMessage;

	public static String BuildExecutionEnvironmentSection_configure;

	public static String BuildJob_buildingProjects;

	public static String BuildJob_buildingProject;

	public static String BuildJob_building;

	public static String ExecutionEnvironmentSection_updateClasspath;

	public static String EditorUtilities_incorrectImageDepth;

	public static String ImplicitDependenciesSection_0;

	public static String ImplicitDependenicesSection_Add;

	public static String ImplicitDependenicesSection_Remove;

	public static String ImplicitDependenicesSection_RemoveAll;

	public static String ImplicitDependenicesSection_Title;

	public static String TargetImplicitPluginsTab_desc;

	public static String TargetImplicitPluginsTab_removeAll3;

	public static String ProductExportWizard_syncTitle;

	public static String ProductExportWizardPage_exportOptionsGroup;

	public static String CompilersConfigurationTab_buildPropertiesErrors;

	public static String PluginsView_description;

	public static String LocationSection_0;

	public static String PointSelectionPage_newDepFound;

	public static String PointSelectionPage_newDepMessage;

	public static String OrganizeManifestsWizard_title;

	public static String OrganizeManifestsOperation_export;

	public static String OrganizeManifestsOperation_filterInternal;

	public static String OrganizeManifestsOperation_removeUnresolved;

	public static String OrganizeManifestsOperation_markOptionalUnresolved;

	public static String OrganizeManifestsOperation_unusedDeps;

	public static String OrganizeManifestsOperation_lazyStart;

	public static String OrganizeManifestsOperation_uselessPluginFile;

	public static String OrganizeManifestsOperation_nlIconPath;

	public static String OrganizeManifestsOperation_unusedKeys;

	public static String OrganizeManifestsWizardPage_title;

	public static String OrganizeManifestsWizardPage_description;

	public static String OrganizeManifestsWizardPage_errorMsg;

	public static String OrganizeManifestsWizardPage_exportedGroup;

	public static String OrganizeManifestsWizardPage_addMissing;

	public static String OrganizeManifestsWizardPage_markInternal;

	public static String OrganizeManifestsWizardPage_packageFilter;

	public static String OrganizeManifestsWizardPage_removeUnresolved;

	public static String OrganizeManifestsWizardPage_dependenciesGroup;

	public static String OrganizeManifestsWizardPage_unresolvedDependencies;

	public static String OrganizeManifestsWizardPage_remove;

	public static String OrganizeManifestsWizardPage_markOptional;

	public static String OrganizeManifestsWizardPage_removeUnused;

	public static String OrganizeManifestsWizardPage_generalGroup;

	public static String OrganizeManifestsWizardPage_lazyStart;

	public static String OrganizeManifestsWizardPage_uselessPluginFile;

	public static String OrganizeManifestsWizardPage_internationalizationGroup;

	public static String OrganizeManifestsWizardPage_prefixNL;

	public static String OrganizeManifestsWizardPage_removeUnusedKeys;

	public static String TargetPlatformPreferencePage_LoadDefaultTarget;

	public static String TargetPlatformPreferencePage2_0;

	public static String TargetPlatformPreferencePage2_1;

	public static String TargetPlatformPreferencePage2_10;

	public static String TargetPlatformPreferencePage2_11;

	public static String TargetPlatformPreferencePage2_12;

	public static String TargetPlatformPreferencePage2_13;

	public static String TargetPlatformPreferencePage2_14;

	public static String TargetPlatformPreferencePage2_15;

	public static String TargetPlatformPreferencePage2_16;

	public static String TargetPlatformPreferencePage2_17;

	public static String TargetPlatformPreferencePage2_18;

	public static String TargetPlatformPreferencePage2_19;

	public static String TargetPlatformPreferencePage2_2;

	public static String TargetPlatformPreferencePage2_20;

	public static String TargetPlatformPreferencePage2_21;

	public static String TargetPlatformPreferencePage2_22;

	public static String TargetPlatformPreferencePage2_23;

	public static String TargetPlatformPreferencePage2_25;

	public static String TargetPlatformPreferencePage2_26;

	public static String TargetPlatformPreferencePage2_27;

	public static String TargetPlatformPreferencePage2_28;

	public static String TargetPlatformPreferencePage2_3;

	public static String TargetPlatformPreferencePage2_4;

	public static String TargetPlatformPreferencePage2_5;

	public static String TargetPlatformPreferencePage2_6;

	public static String TargetPlatformPreferencePage2_7;

	public static String TargetPlatformPreferencePage2_8;

	public static String TargetPlatformRepository_CouldNotFindTargetPlatformService;

	public static String TargetPlatformRepository_RunningPlatform;

	public static String TargetPlatformRepository_TargetPlatformLabel;

	public static String ManifestEditorContributor_externStringsActionName;

	public static String MultiFixResolution_JavaFixAll;

	public static String MultiFixResolution_FixAll;

	public static String SplashSection_progressBar;
	public static String SplashSection_progressX;
	public static String SplashSection_progressWidth;
	public static String SplashSection_progressY;
	public static String SplashSection_progressHeight;
	public static String SplashSection_progressMessage;
	public static String SplashSection_messageX;
	public static String SplashSection_messageWidth;
	public static String SplashSection_messageColor;
	public static String SplashSection_messageY;
	public static String SplashSection_messageHeight;

	public static String LicensingPage_title;

	public static String LicenseSection_title;
	public static String LicenseSection_description;
	public static String LicenseSection_url;
	public static String LicenseSection_text;

	public static String UpdatesPage_title;
	public static String UpdatesSection_title;
	public static String UpdatesSection_add;
	public static String UpdatesSection_edit;
	public static String UpdatesSection_remove;
	public static String UpdatesSection_removeAll;
	public static String UpdatesSection_description;
	public static String UpdatesSection_RepositoryDialogTitle;
	public static String UpdatesSection_Location;
	public static String UpdatesSection_ErrorLocationNoName;
	public static String UpdatesSection_ErrorInvalidURL;
	public static String UpdatesSection_LocationColumn;

	public static String UpdatesSection_LocationMessage;
	public static String UpdatesSection_EnabledColumn;

	public static String CustomizationPage_title;

	public static String PreferencesSection_title;
	public static String PreferencesSection_description;
	public static String PreferencesSection_errorNoDefiningPlugin;
	public static String PreferencesSection_errorNoDefiningPluginTitle;
	public static String PreferencesSection_errorReading;
	public static String PreferencesSection_generate_overwrite1;
	public static String PreferencesSection_generate_overwrite2;
	public static String PreferencesSection_generate_overwrite3;
	public static String PreferencesSection_generate_overwrite4;
	public static String PreferencesSection_generate_merge1;
	public static String PreferencesSection_generate_merge2;
	public static String PreferencesSection_generate_merge3;
	public static String PreferencesSection_generate_merge4;

	public static String ConvertPreferencesWizardPage_title;
	public static String ConvertPreferencesWizardPage_description;
	public static String ConvertPreferencesWizardPage_source_file;
	public static String ConvertPreferencesWizardPage_source_browse;
	public static String ConvertPreferencesWizardPage_target_file;
	public static String ConvertPreferencesWizardPage_target_browse;
	public static String ConvertPreferencesWizardPage_merge;
	public static String ConvertPreferencesWizardPage_overwrite;
	public static String ConvertPreferencesWizardPage_fileTitle;
	public static String ConvertPreferencesWizardPage_fileMessage;
	public static String ConvertPreferencesWizardPage_sourceFileGroup;
	public static String ConvertPreferencesWizardPage_targetFileGroup;
	public static String ConvertPreferencesWizardPage_customFileTitle;
	public static String ConvertPreferencesWizardPage_customFileMessage;
	public static String ConvertPreferencesWizardPage_options;

	public static String ConvertPreferencesWizard_title;
	public static String ConvertPreferencesWizard_errorNoFileSpecified;
	public static String ConvertPreferencesWizard_errorTitle;
	public static String ConvertPreferencesWizard_errorFile;
	public static String ConvertPreferencesWizard_errorFileNotFound;
	public static String ConvertPreferencesWizard_errorNoPrefs;
	public static String ConvertPreferencesWizard_skippedInvalidLine;
	public static String ConvertPreferencesWizard_progress;

	public static String CSSSection_title;
	public static String CSSSection_description;
	public static String CSSSection_file;
	public static String CSSSection_fileTitle;
	public static String CSSSection_fileMessage;
	public static String CSSSection_browse;
	public static String CSSSection_synchronize;
	public static String CSSSection_errorNoDefiningPlugin;
	public static String CSSSection_errorNoDefiningPluginTitle;

	public static String TargetEditor_0;

	public static String TargetEditor_1;

	public static String TargetEditor_2;

	public static String TargetEditor_3;

	public static String TargetEditor_4;

	public static String TargetEditor_5;

	public static String TargetEditor_6;

	public static String FeatureImportWizardPage_importHasInvalid;

	public static String ProductInfoSection_plugins;

	public static String ProductInfoSection_features;

	public static String ProfileBlock_0;

	public static String ProfileBlock_1;

	public static String ImportPackageSection_goToPackage;

	public static String ExportPackageSection_findReferences;

	public static String RemoveBuildEntryResolution_removeEntry;

	public static String RemoveBuildEntryResolution_removeToken;

	public static String ReplaceBuildEntryResolution_replaceToken;

	public static String AddBuildEntryResolution_add;

	public static String AppendSeperatorBuildEntryResolution_label;

	public static String AddSourceBuildEntryResolution_label;

	public static String RemoveSeperatorBuildEntryResolution_label;

	public static String ExternalizeStringsResolution_desc;

	public static String ExternalizeStringsResolution_label;

	public static String DependencyManagementSection_jobName;

	public static String DescriptionSection_nameLabel;

	public static String DuplicatePluginResolutionDialog_deselectAll;

	public static String DuplicatePluginResolutionDialog_message;

	public static String DuplicatePluginResolutionDialog_messageSingular;

	public static String DuplicatePluginResolutionDialog_selectAll;

	public static String OrganizeManifestsOperation_additionalDeps;

	public static String OrganizeManifestsWizardPage_addDependencies;

	public static String OrganizeManifestsWizardPage_ProjectsUsingCustomBuildWarning;

	public static String OrganizeManifestsWizardPage_ProjectsUsingCustomBuildWarningPlural;

	public static String AddNewDependenciesAction_title;

	public static String AddNewDependenciesAction_notFound;

	public static String AddNewDependenciesOperation_mainTask;

	public static String AddNewDependenciesOperation_searchProject;

	public static String AddNewDependenciesOperation_searchForDependency;

	public static String OpenManifestsAction_cannotFind;

	public static String OpenManifestsAction_cannotOpen;
	public static String OpenManifestsAction_cannotOpenThisFile;

	public static String OpenManifestsAction_title;
	public static String OpenPluginManifestsAction_title;

	public static String NewProjectCreationPage_invalidProjectName;
	public static String NewProjectCreationPage_invalidLocationPath;
	public static String NewProjectCreationPage_invalidEE;

	public static String RemoveInternalDirective_label;

	public static String RemoveInternalDirective_desc;

	public static String ImportPackageSection_dialogButtonLabel;

	public static String EditorPreferencePage_folding;

	public static String EditTargetNode_0;

	public static String ExternalizeStringsWizardPage_subKey;

	public static String ExternalizeStringsWizardPage_value;

	public static String RemoveImportExportServices_label;
	public static String RemoveImportExportServices_description;

	// HyperlinkAction.java
	public static String HyperlinkActionOpenType;
	public static String HyperlinkActionOpenDescription;
	public static String HyperlinkActionOpenBundle;
	public static String HyperlinkActionOpenPackage;

	public static String HyperlinkActionOpenResource;
	public static String HyperlinkActionOpenSchema;
	public static String HyperlinkActionOpenTranslation;
	public static String HyperlinkActionNoLinksAvailable;

	// XMLCompletionProposal
	public static String XMLCompletionProposal_ErrorCycle;
	public static String XMLCompletionProposal_InfoElement;

	public static String XMLContentAssistProcessor_extensionPoints;

	public static String XMLContentAssistProcessor_extensions;

	public static String XMLContentAssistProcessor_extId;

	public static String XMLContentAssistProcessor_extName;

	public static String XMLContentAssistProcessor_extPoint;

	public static String XMLContentAssistProcessor_extPointId;

	public static String XMLContentAssistProcessor_extPointName;

	public static String XMLSyntaxColorTab_externalizedStrings;

	public static String XMLContentAssistProcessor_schemaLocation;

	public static String PDEJavaHelper_msgContentAssistAvailable;
	public static String PDEJavaHelper_msgContentAssistAvailableWithKeyBinding;

	public static String AddExportPackageResolution_Label;
	public static String AddExportPackageInternalDirectiveResolution_Label;
	public static String AddBundleClassPathResolution_add;

	public static String AddBundleManifestVersionResolution_description;
	public static String AddBundleManifestVersionResolution_label;

	public static String AddToJavaSearchJob_0;

	public static String AnnotationHover_version_change;

	public static String AntGeneratingExportWizard_0;
	public static String AntGeneratingExportWizard_1;
	public static String AntGeneratingExportWizard_2;

	public static String PluginVersionPart_groupTitle;
	public static String PluginVersionPart_buttonTitle;

	public static String FilteredPluginArtifactsSelectionDialog_title;
	public static String FilteredPluginArtifactsSelectionDialog_message;
	public static String FilteredPluginArtifactsSelectionDialog_searching;
	public static String FilteredPluginArtifactsSelectionDialog_showExtensions;
	public static String FilteredPluginArtifactsSelectionDialog_showExtensionPoints;
	public static String FilteredPluginArtifactsSelectionDialog_showExportedPackages;
	public static String FilteredPluginArtifactsSelectionDialog_showFeatures;

	public static String FilteredSchemaAttributeSelectionDialog_title;
	public static String FilteredSchemaAttributeSelectionDialog_message;
	public static String FilteredSchemaAttributeSelectionDialog_searching;
	public static String FilteredSchemaAttributeSelectionDialog_showOptionalAttributes;

	public static String FilterRelatedExtensionsAction_tooltip;

	public static String ProjectSelectionDialog_title;
	public static String ProjectSelectionDialog_message;
	public static String ProjectSelectionDialog_settingsTitle;

	public static String PropertiesSection_Add;
	public static String PropertiesSection_Edit;
	public static String PropertiesSection_ErrorPropertyExists;
	public static String PropertiesSection_ErrorPropertyNoName;
	public static String PropertiesSection_Name;
	public static String PropertiesSection_NameColumn;
	public static String PropertiesSection_PropertiesSectionDescription;
	public static String PropertiesSection_PropertiesSectionTitle;
	public static String PropertiesSection_PropertyDialogTitle;
	public static String PropertiesSection_Remove;
	public static String PropertiesSection_Value;
	public static String PropertiesSection_ValueColumn;
	public static String PropertiesSection_OS;
	public static String PropertiesSection_OSColumn;
	public static String PropertiesSection_Arch;
	public static String PropertiesSection_ArchColumn;
	public static String PropertiesSection_All;

	public static String PDECompilersConfigurationBlock_error;
	public static String PDECompilersConfigurationBlock_warning;
	public static String PDECompilersConfigurationBlock_info;
	public static String PDECompilersConfigurationBlock_ignore;

	public static String PDEJUnitLaunchConfigurationTab_Run_Tests_In_UI_Thread;

	public static String VersionDialog_text;
	public static String VersionDialog_title;

	public static String FeatureProps_rootFeature;
	public static String FeatureProps_title;

	public static String SearchRepositoriesForIUProposal_message;
	public static String SearchRepositoriesForIUProposal_description;

	public static String OSGiConsole_name;
	public static String OSGiConsoleFactory_title;

	public static String NewElement_deprecated;
	public static String ElementIsDeprecated;

	public static String ExtensionAttributeRow_AttrDepr;
	public static String ExtensionAttributeRow_AttrReq;
	public static String ExtensionAttributeRow_AttrReqDepr;
	public static String ExtensionAttributeRow_AttrFilter;
	public static String ExtensionAttributeRow_AttrLabel;
	public static String ExtensionAttributeRow_AttrLabelDepr;
	public static String ExtensionAttributeRow_AttrLabelReq;
	public static String ExtensionAttributeRow_AttrLabelReqDepr;
}
