/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.diagram.helpers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.diagram.helpers.Messages;

public class DiagramHelper {
    private static DiagramHelper instance;

    protected DiagramHelper() {
    }

    public static DiagramHelper getService() {
        if (instance == null) {
            instance = new DiagramHelper();
        }
        return instance;
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        return DialectManager.INSTANCE.getDescription(representation);
    }

    public static String getElementDescription(EObject object) {
        if (object instanceof CapellaElement) {
            return ((CapellaElement)object).getDescription();
        }
        if (object instanceof DRepresentationDescriptor) {
            return ((DRepresentationDescriptor)object).getDocumentation();
        }
        return null;
    }

    public static void setElementDescription(EObject object, String description) {
        if (object instanceof CapellaElement) {
            ((CapellaElement)object).setDescription(description);
        }
        if (object instanceof DRepresentationDescriptor) {
            ((DRepresentationDescriptor)object).setDocumentation(description);
        }
    }

    public boolean isA(DRepresentation diagram, String descriptionId) {
        if (diagram != null) {
            RepresentationDescription description = this.getDescription(diagram);
            return this.isA(description, descriptionId);
        }
        return false;
    }

    public boolean isA(RepresentationDescription description, String diagramDescriptionId) {
        if (description != null) {
            if (diagramDescriptionId == null) {
                return true;
            }
            return diagramDescriptionId.equals(description.getName());
        }
        return false;
    }

    public boolean isArchitectureBlank(DRepresentation diagram) {
        return this.hasKind(diagram, "Architecture Blank") || this.hasKind(diagram, "Entity Blank");
    }

    public boolean isBreakdown(DRepresentation diagram) {
        return this.hasKind(diagram, "Breakdown");
    }

    public boolean hasKind(DRepresentation diagram, String diagramDescriptionId) {
        if (diagram != null) {
            RepresentationDescription description = this.getDescription(diagram);
            return this.hasKind(description, diagramDescriptionId);
        }
        return false;
    }

    public boolean hasKind(RepresentationDescription description, String diagramDescriptionId) {
        if (description != null) {
            if (diagramDescriptionId == null) {
                return true;
            }
            return description.getName().contains(diagramDescriptionId);
        }
        return false;
    }

    public DDiagram getDiagramContainer(EObject current) {
        if (current instanceof DDiagram) {
            return (DDiagram)current;
        }
        return (DDiagram)EcoreUtil2.getFirstContainer((EObject)current, (EClass)DiagramPackage.Literals.DDIAGRAM);
    }

    public RepresentationDescription getDescription(Session session, String descriptionId) {
        Collection viewpoints = session.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : viewpoints) {
            for (RepresentationDescription description : viewpoint.getOwnedRepresentations()) {
                if (!descriptionId.equals(description.getName())) continue;
                return description;
            }
        }
        return null;
    }

    public Session getSession(DRepresentation diagram) {
        if (diagram instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)diagram).getTarget();
            if (target == null) {
                return null;
            }
            return SessionManager.INSTANCE.getSession(target);
        }
        return null;
    }

    public DRepresentation createDRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        return DialectManager.INSTANCE.createRepresentation(name, semantic, description, session, monitor);
    }

    public DRepresentation getRepresentation(DSemanticDecorator decorator) {
        if (decorator instanceof DRepresentation) {
            return (DRepresentation)decorator;
        }
        return (DRepresentation)EcoreUtil2.getFirstContainer((EObject)decorator, (EClass)ViewpointPackage.Literals.DREPRESENTATION);
    }

    public String getPackageName(DRepresentationDescriptor descriptor) {
        String name = null;
        DAnnotation annot = DAnnotationHelper.getAnnotation("https://www.polarsys.org/capella/dannotation/package", (DModelElement)descriptor, false);
        if (annot != null) {
            name = (String)annot.getDetails().get((Object)"name");
        }
        return name;
    }

    public Command createSetPackageNameCommand(TransactionalEditingDomain domain, final DRepresentationDescriptor descriptor, final String name) {
        RecordingCommand command = null;
        final DAnnotation annot = DAnnotationHelper.getAnnotation("https://www.polarsys.org/capella/dannotation/package", (DModelElement)descriptor, false);
        if (name != null) {
            String currentValue = null;
            if (annot != null) {
                currentValue = (String)annot.getDetails().get((Object)"name");
            }
            if (currentValue == null || !currentValue.equals(name)) {
                command = new RecordingCommand(domain){

                    public void doExecute() {
                        if (annot != null) {
                            SiriusUtil.delete((EObject)annot);
                        }
                        DAnnotation annot2 = DAnnotationHelper.getAnnotation("https://www.polarsys.org/capella/dannotation/package", (DModelElement)descriptor, true);
                        annot2.getDetails().put((Object)"name", (Object)name);
                    }
                };
                command.setLabel(Messages.DiagramHelper_0);
            }
        } else if (annot != null) {
            command = new RecordingCommand(domain){

                protected void doExecute() {
                    SiriusUtil.delete((EObject)annot);
                }
            };
            command.setLabel(Messages.DiagramHelper_1);
        }
        return command;
    }

    public static void collapseContainer(TransactionalEditingDomain ted, final DNodeContainer container) {
        if (container != null && ted != null) {
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
                    for (Object subNode : gmfNode.getChildren()) {
                        if (!(subNode instanceof Node)) continue;
                        for (Object style : ((Node)subNode).getStyles()) {
                            if (!(style instanceof DrawerStyle)) continue;
                            ((DrawerStyle)style).setCollapsed(true);
                        }
                    }
                }
            });
        }
    }

    public static void unCollapseContainer(TransactionalEditingDomain ted, final DNodeContainer container) {
        if (container != null && ted != null) {
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
                    for (Object subNode : gmfNode.getChildren()) {
                        if (!(subNode instanceof Node)) continue;
                        for (Object style : ((Node)subNode).getStyles()) {
                            if (!(style instanceof DrawerStyle)) continue;
                            ((DrawerStyle)style).setCollapsed(false);
                        }
                    }
                }
            });
        }
    }

    public void offScreenDiagramCopyPasteLayout(DSemanticDiagram sourceDiagram, DSemanticDiagram targetDiagram, Shell shell) {
        Collection sourceViews = new EObjectQuery((EObject)sourceDiagram).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
        Collection targetViews = new EObjectQuery((EObject)targetDiagram).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
        Optional<Diagram> sourceDiagramOptional = sourceViews.stream().filter(Diagram.class::isInstance).map(Diagram.class::cast).findFirst();
        Optional<Diagram> targetDiagramOptional = targetViews.stream().filter(Diagram.class::isInstance).map(Diagram.class::cast).findFirst();
        if (sourceDiagramOptional.isPresent() && targetDiagramOptional.isPresent()) {
            Diagram sourceGmfDiagram = sourceDiagramOptional.get();
            Diagram targetGmfDiagram = targetDiagramOptional.get();
            CanonicalSynchronizer targetDiagramSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(targetGmfDiagram);
            targetDiagramSynchronizer.synchronize();
            DiagramEditPart sourceEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(sourceGmfDiagram, shell);
            DiagramEditPart targetEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(targetGmfDiagram, shell);
            List diagramFormatDataManagers = FormatDataManagerRegistry.getSiriusFormatDataManagers((DDiagram)sourceDiagram);
            diagramFormatDataManagers.stream().forEach(formatDataManager -> formatDataManager.storeFormatData((IGraphicalEditPart)sourceEditPart));
            diagramFormatDataManagers.stream().forEach(formatDataManager -> formatDataManager.applyLayout((IGraphicalEditPart)targetEditPart));
            diagramFormatDataManagers.stream().forEach(SiriusFormatDataManager::clearFormatData);
        }
    }

    public void offScreenDiagramCopyLayout(DSemanticDiagram diagram, Shell shell) {
        Collection views = new EObjectQuery((EObject)diagram).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
        Optional<Diagram> diagramOptional = views.stream().filter(Diagram.class::isInstance).map(Diagram.class::cast).findFirst();
        if (diagramOptional.isPresent()) {
            Diagram gmfDiagram = diagramOptional.get();
            DiagramEditPart sourceEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(gmfDiagram, shell);
            List diagramFormatDataManagers = FormatDataManagerRegistry.getSiriusFormatDataManagers((DDiagram)diagram);
            diagramFormatDataManagers.stream().forEach(formatDataManager -> formatDataManager.storeFormatData((IGraphicalEditPart)sourceEditPart));
        }
    }

    public void offScreenDiagramPasteLayout(DSemanticDiagram diagram, Shell shell) {
        Collection views = new EObjectQuery((EObject)diagram).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
        Optional<Diagram> diagramOptional = views.stream().filter(Diagram.class::isInstance).map(Diagram.class::cast).findFirst();
        if (diagramOptional.isPresent()) {
            Diagram gmfDiagram = diagramOptional.get();
            DiagramEditPart targetEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(gmfDiagram, shell);
            List diagramFormatDataManagers = FormatDataManagerRegistry.getSiriusFormatDataManagers((DDiagram)diagram);
            diagramFormatDataManagers.stream().forEach(formatDataManager -> formatDataManager.applyLayout((IGraphicalEditPart)targetEditPart));
            diagramFormatDataManagers.stream().forEach(SiriusFormatDataManager::clearFormatData);
        }
    }

    public static void setPosition(AbstractDNode node, Point location) {
        SiriusLayoutDataManager.INSTANCE.addData((AbstractLayoutData)new RootLayoutData((Object)node, location, null));
    }

    public static Point getRelativePositionToNode(AbstractDNode node, EObject container, int deltaX, int deltaY) {
        Point newLocation = new Point();
        Point nodeLocation = DiagramHelper.getAbsolutePositionOfNode(node);
        int nodeWidth = 0;
        int nodeHeight = 0;
        ShapeEditPart nodeEditPart = DiagramHelper.getShapeEditPart((DDiagramElement)node);
        if (nodeEditPart != null) {
            nodeWidth = nodeEditPart.getSize().width;
            nodeHeight = nodeEditPart.getSize().height;
        }
        newLocation.translate(nodeLocation);
        if (deltaX == 0) {
            newLocation.translate(nodeWidth / 2, 0);
        } else if (deltaX > 0) {
            newLocation.translate(nodeWidth + deltaX, 0);
        } else if (deltaX < 0) {
            newLocation.translate(deltaX, 0);
        }
        if (deltaY == 0) {
            newLocation.translate(0, nodeHeight / 2);
        } else if (deltaY < 0) {
            newLocation.translate(0, deltaY);
        } else if (deltaY > 0) {
            newLocation.translate(0, nodeHeight + deltaY);
        }
        DiagramHelper.tranformAbsolutePositionInRelativePositionToTheContainer(newLocation, container);
        return newLocation;
    }

    public static Point getPositionAtMiddleOfEdge(DEdge edge, EObject container, int deltaX, int deltaY) {
        Point newLocation = new Point();
        EdgeTarget sourceEdge = edge.getSourceNode();
        EdgeTarget targetEdge = edge.getTargetNode();
        if (sourceEdge instanceof AbstractDNode && targetEdge instanceof AbstractDNode) {
            AbstractDNode source = (AbstractDNode)sourceEdge;
            AbstractDNode target = (AbstractDNode)targetEdge;
            Point sourceLocation = DiagramHelper.getAbsolutePositionOfNode(source);
            Point targetLocation = DiagramHelper.getAbsolutePositionOfNode(target);
            newLocation.translate(sourceLocation);
            ShapeEditPart sourceEditPart = DiagramHelper.getShapeEditPart((DDiagramElement)source);
            ShapeEditPart targetEditPart = DiagramHelper.getShapeEditPart((DDiagramElement)target);
            if (sourceEditPart != null && targetEditPart != null) {
                sourceLocation.translate(sourceEditPart.getSize().width / 2, sourceEditPart.getSize().height / 2);
                targetLocation.translate(targetEditPart.getSize().height / 2, targetEditPart.getSize().height / 2);
            }
            newLocation.translate((targetLocation.x - sourceLocation.x) / 2, (targetLocation.y - sourceLocation.y) / 2);
        }
        newLocation.translate(deltaX, deltaY);
        DiagramHelper.tranformAbsolutePositionInRelativePositionToTheContainer(newLocation, container);
        return newLocation;
    }

    public static void tranformAbsolutePositionInRelativePositionToTheContainer(Point position, EObject container) {
        Point containerlocation = new Point();
        if (container instanceof AbstractDNode) {
            containerlocation = DiagramHelper.getAbsolutePositionOfNode((AbstractDNode)container);
        }
        position.translate(-containerlocation.x, -containerlocation.y);
    }

    public static Point getAbsolutePositionOfNode(AbstractDNode node) {
        Point position = new Point();
        DiagramHelper.getAbsolutePositionOfNode(node, position);
        return position;
    }

    private static void getAbsolutePositionOfNode(AbstractDNode node, Point position) {
        ShapeEditPart shapeEditPart = DiagramHelper.getShapeEditPart((DDiagramElement)node);
        if (shapeEditPart != null) {
            position.translate(shapeEditPart.getLocation());
            EObject container = node.eContainer();
            if (!(container instanceof DDiagram) && container instanceof AbstractDNode) {
                DiagramHelper.getAbsolutePositionOfNode((AbstractDNode)container, position);
            }
        }
    }

    public static ShapeEditPart getShapeEditPart(DDiagramElement diagramElement) {
        Map editPartRegistry;
        Object editPart;
        Session session;
        View gmfView;
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (editor instanceof DiagramEditor && (gmfView = SiriusGMFHelper.getGmfView((DDiagramElement)diagramElement, (Session)(session = new EObjectQuery((EObject)diagramElement).getSession()))) != null && editor instanceof DiagramEditor && (editPart = (editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(gmfView)) instanceof ShapeEditPart) {
            return (ShapeEditPart)editPart;
        }
        return null;
    }
}

