/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.application.appstart.AbstractApplication;

public class CapellaApplication
extends AbstractApplication
implements IExecutableExtension {
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final Integer EXIT_RELAUNCH = 24;
    public static final String PLUGIN_ID = "org.eclipse.ui.ide.application";

    public Object start(IApplicationContext appContext) throws Exception {
        Display display = this.createDisplay();
        try {
            Shell shell = new Shell(display, 16384);
            try {
                if (!this.checkInstanceLocation(shell)) {
                    appContext.applicationRunning();
                    Integer n = EXIT_OK;
                    return n;
                }
            }
            finally {
                shell.dispose();
            }
            {
            }
        }
        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return false;
        }
        if (instanceLoc.isSet()) {
            block14: {
                if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                    return false;
                }
                if (!instanceLoc.lock()) break block14;
                CapellaApplication.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    String message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockMessage, (Object)workspaceDirectory.getAbsolutePath());
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockTitle, (String)message);
                } else {
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                }
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Could not obtain lock for workspace location", (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)e.getMessage());
            }
            return false;
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = false;
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) != null) {
            force = true;
            try {
                if (instanceLoc.set(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    CapellaApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IllegalStateException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                return false;
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
            }
            String message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage, (Object)workspaceUrl.getFile());
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInUseTitle, (String)message);
            launchData.writePersistedData();
        }
        return false;
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean inputForce) {
        boolean force = inputForce;
        URL url = null;
        do {
            new ChooseWorkspaceDialog(null, launchData, false, true).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        if (url == null) {
            return false;
        }
        String version = CapellaApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ideVersion = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspaceVersion = Integer.parseInt(version);
        if (workspaceVersion == ideVersion) {
            return true;
        }
        String title = IDEWorkbenchMessages.IDEApplication_versionTitle_olderWorkspace;
        String message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_olderWorkspace, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = CapellaApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = CapellaApplication.loadProperties(versionFile);
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)"Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static Properties loadProperties(File versionFile) throws IOException {
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(versionFile);){
            try {
                props.load(is);
            }
            catch (Exception exception) {
                is.close();
            }
        }
        return props;
    }

    private static void writeWorkspaceVersion() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || instanceLoc.isReadOnly()) {
            return;
        }
        File versionFile = CapellaApplication.getVersionFile(instanceLoc.getURL(), true);
        if (versionFile == null) {
            return;
        }
        OutputStream output = null;
        try {
            try {
                String versionLine = "org.eclipse.core.runtime=1";
                output = new FileOutputStream(versionFile);
                output.write(versionLine.getBytes("UTF-8"));
                output.close();
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    public void stop() {
        ReportManagerRegistry.getInstance().saveConfiguration();
        super.stop();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

