/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.SessionResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.MultiTagResourceVariantTree;

public class CVSCompareSubscriber
extends CVSSyncTreeSubscriber
implements ISubscriberChangeListener {
    public static final String ID = "org.eclipse.team.cvs.ui.compare-participant";
    public static final String ID_MODAL = "org.eclipse.team.cvs.ui.compare-participant-modal";
    public static final String QUALIFIED_NAME = "org.eclipse.team.cvs.core.compare";
    private static final String UNIQUE_ID_PREFIX = "compare-";
    private IResource[] resources;
    private CVSResourceVariantTree tree;

    public CVSCompareSubscriber(IResource[] resources, CVSTag tag) {
        super(CVSCompareSubscriber.getUniqueId(), NLS.bind((String)CVSMessages.CVSCompareSubscriber_2, (Object[])new String[]{tag.getName()}));
        this.resources = resources;
        this.tree = new CVSResourceVariantTree((ResourceVariantByteStore)new SessionResourceVariantByteStore(), tag, this.getCacheFileContentsHint());
        this.initialize();
    }

    public CVSCompareSubscriber(IResource[] resources, CVSTag[] tags, String name) {
        super(CVSCompareSubscriber.getUniqueId(), NLS.bind((String)CVSMessages.CVSCompareSubscriber_2, (Object[])new String[]{name}));
        this.resetRoots(resources, tags);
        this.initialize();
    }

    public void resetRoots(IResource[] resources, CVSTag[] tags) {
        if (this.resources != null) {
            ArrayList<SubscriberChangeEvent> removed = new ArrayList<SubscriberChangeEvent>();
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                removed.add(new SubscriberChangeEvent((Subscriber)this, 4, resource));
                ++n2;
            }
            this.resources = new IResource[0];
            this.fireTeamResourceChange(removed.toArray(new ISubscriberChangeEvent[removed.size()]));
            if (this.tree != null) {
                this.tree.dispose();
                this.tree = null;
            }
        }
        this.resources = resources;
        MultiTagResourceVariantTree multiTree = new MultiTagResourceVariantTree((ResourceVariantByteStore)new SessionResourceVariantByteStore(), this.getCacheFileContentsHint());
        int i = 0;
        while (i < tags.length) {
            multiTree.addResource(resources[i], tags[i]);
            ++i;
        }
        this.tree = multiTree;
    }

    private void initialize() {
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().addListener(this);
    }

    public void dispose() {
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().removeListener(this);
        this.tree.dispose();
    }

    private static QualifiedName getUniqueId() {
        String uniqueId = Long.toString(System.currentTimeMillis());
        return new QualifiedName(QUALIFIED_NAME, UNIQUE_ID_PREFIX + uniqueId);
    }

    protected IResourceVariantTree getBaseTree() {
        return null;
    }

    protected IResourceVariantTree getRemoteTree() {
        return this.tree;
    }

    @Override
    public boolean isThreeWay() {
        return false;
    }

    public IResource[] roots() {
        return this.resources;
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        ArrayList<SubscriberChangeEvent> outgoingDeltas = new ArrayList<SubscriberChangeEvent>(deltas.length);
        ISubscriberChangeEvent[] iSubscriberChangeEventArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            ISubscriberChangeEvent delta = iSubscriberChangeEventArray[n2];
            if ((delta.getFlags() & 4) != 0) {
                resource = delta.getResource();
                outgoingDeltas.addAll(Arrays.asList(this.handleRemovedRoot(resource)));
            } else if ((delta.getFlags() & 1) != 0) {
                resource = delta.getResource();
                try {
                    if (this.isSupervised(resource)) {
                        outgoingDeltas.add(new SubscriberChangeEvent((Subscriber)this, delta.getFlags(), resource));
                    }
                }
                catch (TeamException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
            ++n2;
        }
        this.fireTeamResourceChange((ISubscriberChangeEvent[])outgoingDeltas.toArray(new SubscriberChangeEvent[outgoingDeltas.size()]));
    }

    private SubscriberChangeEvent[] handleRemovedRoot(IResource removedRoot) {
        ArrayList<IResource> removals = new ArrayList<IResource>(this.resources.length);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (removedRoot.getFullPath().isPrefixOf(root.getFullPath())) {
                removals.add(root);
                try {
                    this.tree.flushVariants(root, 2);
                }
                catch (TeamException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
            ++n2;
        }
        if (removals.isEmpty()) {
            return new SubscriberChangeEvent[0];
        }
        ArrayList<IResource> newRoots = new ArrayList<IResource>(this.resources.length);
        newRoots.addAll(Arrays.asList(this.resources));
        newRoots.removeAll(removals);
        this.resources = newRoots.toArray(new IResource[newRoots.size()]);
        SubscriberChangeEvent[] deltas = new SubscriberChangeEvent[removals.size()];
        int i = 0;
        while (i < deltas.length) {
            deltas[i] = new SubscriberChangeEvent((Subscriber)this, 4, (IResource)removals.get(i));
            ++i;
        }
        return deltas;
    }

    @Override
    public boolean isSupervised(IResource resource) throws TeamException {
        if (super.isSupervised(resource)) {
            if (!resource.exists() && !this.getRemoteTree().hasResourceVariant(resource)) {
                return false;
            }
            if (this.resources != null) {
                IResource[] iResourceArray = this.resources;
                int n = this.resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource root = iResourceArray[n2];
                    if (root.getFullPath().isPrefixOf(resource.getFullPath())) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean getCacheFileContentsHint() {
        return true;
    }

    public CVSTag getTag() {
        return this.tree.getTag((IResource)ResourcesPlugin.getWorkspace().getRoot());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CVSCompareSubscriber)) {
            return false;
        }
        CVSCompareSubscriber s = (CVSCompareSubscriber)((Object)other);
        CVSResourceVariantTree tree1 = (CVSResourceVariantTree)this.getRemoteTree();
        CVSResourceVariantTree tree2 = (CVSResourceVariantTree)s.getRemoteTree();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        CVSTag tag1 = tree1.getTag((IResource)root);
        CVSTag tag2 = tree2.getTag((IResource)root);
        if (tag1 == null || tag2 == null) {
            return false;
        }
        return tag1.equals(tag2) && this.rootsEqual((Subscriber)s);
    }

    public void primeRemoteTree() throws CVSException {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            cvsResource.accept(new ICVSResourceVisitor(){

                @Override
                public void visitFile(ICVSFile file) throws CVSException {
                    byte[] bytes = file.getSyncBytes();
                    if (bytes != null) {
                        try {
                            CVSCompareSubscriber.this.tree.getByteStore().setBytes(file.getIResource(), bytes);
                        }
                        catch (TeamException e) {
                            throw CVSException.wrapException((CoreException)((Object)e));
                        }
                    }
                }

                @Override
                public void visitFolder(ICVSFolder folder) throws CVSException {
                    folder.acceptChildren(this);
                }
            });
            ++n2;
        }
    }

    public CVSTag getTag(IResource root) {
        return this.tree.getTag(root);
    }

    public boolean isMultipleTagComparison() {
        return this.getTag() == null;
    }
}

