/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag;

import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.bag.UnsortedBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;

public interface MutableBag<T>
extends UnsortedBag<T>,
MutableBagIterable<T> {
    @Override
    public MutableMap<T, Integer> toMapOfItemToCount();

    @Override
    public MutableBag<T> selectByOccurrences(IntPredicate var1);

    @Override
    default public MutableBag<T> selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    @Override
    default public MutableSet<T> selectUnique() {
        MutableSet result = Sets.mutable.empty();
        this.forEachWithOccurrences((each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result;
    }

    @Override
    default public MutableBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    default public MutableBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    default public MutableBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    default public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public MutableBag<T> newEmpty();

    @Override
    public MutableBag<T> asUnmodifiable();

    @Override
    public MutableBag<T> asSynchronized();

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect((Function)function);
    }

    @Override
    default public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    default public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect((Function)function);
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex();

    @Override
    public MutableBag<T> tap(Procedure<? super T> var1);

    @Override
    public MutableBag<T> select(Predicate<? super T> var1);

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public MutableBag<T> reject(Predicate<? super T> var1);

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public MutableByteBag collectByte(ByteFunction<? super T> var1);

    @Override
    public MutableCharBag collectChar(CharFunction<? super T> var1);

    @Override
    public MutableIntBag collectInt(IntFunction<? super T> var1);

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super T> var1);

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super T> var1);

    @Override
    public MutableLongBag collectLong(LongFunction<? super T> var1);

    @Override
    public MutableShortBag collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> var1);

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> MutableBag<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public ImmutableBag<T> toImmutable();

    @Override
    default public ImmutableBag<T> toImmutableBag() {
        return this.toImmutable();
    }
}

