/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.template;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.CommonTemplateProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.template.TemplateInterceptor;

public class VpdiagramTemplateProposalProvider
extends CommonTemplateProposalProvider {
    private static final TemplateInterceptor interceptor = new TemplateInterceptor();

    @Inject
    public VpdiagramTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.templateStore = templateStore;
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Template template;
        Template[] templates;
        TemplateContextType contextType = templateContext.getContextType();
        Template[] templateArray = templates = this.templateStore.getTemplates(contextType.getId());
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            template = templateArray[n2];
            if (template.getDescription().equals("Generate Diagrams for all classes")) {
                interceptor.setTemplate(template);
                this.fillInterceptorWithDataClasses(context);
            }
            ++n2;
        }
        templateArray = templates;
        n = templates.length;
        n2 = 0;
        while (n2 < n) {
            template = templateArray[n2];
            if (!acceptor.canAcceptMoreTemplates()) {
                return;
            }
            if (this.validate(template, templateContext)) {
                TemplateProposal proposal = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
                acceptor.accept(proposal);
            }
            ++n2;
        }
    }

    public static synchronized TemplateInterceptor getInterceptor() {
        return interceptor;
    }

    private void fillInterceptorWithDataClasses(ContentAssistContext context) {
        EObject current = context.getCurrentModel();
        interceptor.setModel(current);
        ResourceSet resourceSet = current.eResource().getResourceSet();
        String projectName = ResourceHelper.getProjectName((EObject)current);
        List dataResourceURIs = ResourceHelper.getSecondaryResourceURIsByExtension((String)"data.vptext", (String)projectName);
        if (dataResourceURIs == null || dataResourceURIs.isEmpty()) {
            throw new RuntimeException("could not locate data resource in the project: " + projectName);
        }
        interceptor.getClasses().clear();
        for (URI uri : dataResourceURIs) {
            List dataRoots = ResourceHelper.loadDataResource((URI)uri, (ResourceSet)resourceSet);
            for (EObject eObject : dataRoots) {
                if (!(eObject instanceof Data)) continue;
                EList classes = ((Data)eObject).getVP_Classes();
                interceptor.addAll((Collection<Class>)classes);
            }
        }
    }
}

