/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.NumericTypeKind;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.util.PropertyNamingHelper;
import org.polarsys.capella.core.data.information.validation.property.AbstractCardinalityRule;

public class PropertyMinimumCardinalityIsNaturalOrZero
extends AbstractCardinalityRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        if (this.isValidType(eObj) && eObj.eContainer() instanceof NamedElement) {
            NamedElement container = (NamedElement)eObj.eContainer();
            Property property = (Property)eObj;
            if (!property.isIsAbstract() && !this.isNaturalOrZero(property.getOwnedMinCard())) {
                return ctx.createFailureStatus(new Object[]{container.getName(), property.getName()});
            }
        } else if (eObj instanceof ExchangeItemElement && eObj.eContainer() instanceof NamedElement) {
            NamedElement container = (NamedElement)eObj.eContainer();
            ExchangeItemElement exchangeItemElement = (ExchangeItemElement)eObj;
            if (!this.isNaturalOrZero(exchangeItemElement.getOwnedMinCard())) {
                return ctx.createFailureStatus(new Object[]{container.getName(), exchangeItemElement.getName()});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean isNaturalOrZero(NumericValue value) {
        NumericType type;
        if (value != null && ((type = value.getNumericType()) == null || type.getKind() == NumericTypeKind.INTEGER)) {
            try {
                int integer = Integer.parseInt(PropertyNamingHelper.getCardValue((NumericValue)value));
                return integer >= 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

