/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Cfg;
import org.eclipse.xtext.util.formallang.CfgUtil;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.ProductionUtil;
import org.eclipse.xtext.util.formallang.Traverser;

public class PdaUtil {
    @Inject
    protected NfaUtil nfaUtil = new NfaUtil();
    public final long UNREACHABLE = Long.MAX_VALUE;

    public <S, P> boolean canReach(Pda<S, P> pda, S state, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        return this.distanceTo(pda, Collections.singleton(state), stack, matches, canPass) != Long.MAX_VALUE;
    }

    public <S, P, T, D extends Pda<S, P>> D expand(Pda<S, P> pda, Function<S, Pda<S, P>> expand, Function<S, T> tokens, PdaFactory<D, S, P, T> fact) {
        Pda result = (Pda)fact.create(tokens.apply(pda.getStart()), tokens.apply(pda.getStop()));
        Identity<S> identity = new Identity<S>();
        IdentityHashMap idstates = Maps.newIdentityHashMap();
        LinkedHashMultimap followers = LinkedHashMultimap.create();
        for (Object s : this.nfaUtil.collect(pda)) {
            Object s_new = idstates.get(s);
            if (s_new != null) continue;
            Pda sub = (Pda)expand.apply(s);
            if (sub != null) {
                Object s_start = identity.get(fact.createPush(result, tokens.apply(s)));
                Object s_stop = identity.get(fact.createPop(result, tokens.apply(s)));
                idstates.put(s, s_start);
                idstates.put(sub.getStart(), s_start);
                idstates.put(sub.getStop(), s_stop);
                followers.putAll(s_start, sub.getFollowers(sub.getStart()));
                followers.putAll(s_stop, pda.getFollowers(s));
                for (Object f_old : this.nfaUtil.collect(sub)) {
                    Object f_new;
                    if (f_old == sub.getStart() || f_old == sub.getStop() || (f_new = idstates.get(f_old)) != null) continue;
                    f_new = this.clone(f_old, sub, result, tokens, fact, identity);
                    idstates.put(f_old, f_new);
                    followers.putAll(f_new, pda.getFollowers(f_old));
                }
                continue;
            }
            s_new = this.clone(s, pda, result, tokens, fact, identity);
            idstates.put(s, s_new);
            followers.putAll(s_new, pda.getFollowers(s));
        }
        for (Map.Entry entry : followers.asMap().entrySet()) {
            LinkedHashSet f = Sets.newLinkedHashSet();
            for (Object s : (Collection)entry.getValue()) {
                f.add(idstates.get(s));
            }
            fact.setFollowers(result, entry.getKey(), f);
        }
        return (D)result;
    }

    protected <S, P, T, D extends Pda<S, P>> S clone(S state, Pda<S, P> src, D target, Function<S, T> tokens, PdaFactory<D, S, P, T> fact, Identity<S> identity) {
        if (state == src.getStart()) {
            return (S)target.getStart();
        }
        if (state == src.getStop()) {
            return (S)target.getStop();
        }
        P push = src.getPush(state);
        if (push != null) {
            return identity.get(fact.createPush(target, tokens.apply(state)));
        }
        P pop = src.getPop(state);
        if (pop != null) {
            return identity.get(fact.createPop(target, tokens.apply(state)));
        }
        return identity.get(fact.createState(target, tokens.apply(state)));
    }

    public <S, P, E, T, D extends Pda<S, P>> D create(Cfg<E, T> cfg, FollowerFunction<E> ff, PdaFactory<D, S, P, ? super E> fact) {
        return this.create(cfg, ff, Functions.identity(), fact);
    }

    protected <S, P, E, T1, T2, D extends Pda<S, P>> void create(Cfg<E, T1> cfg, D pda, S state, E ele, Iterable<E> followerElements, FollowerFunction<E> ff, Function<E, T2> tokens, PdaFactory<D, S, P, ? super T2> fact, Map<E, S> states, Map<E, S> stops, Multimap<E, E> callers) {
        ArrayList followerStates = Lists.newArrayList();
        for (E fol : followerElements) {
            Object s;
            if (fol == null) {
                E root = new ProductionUtil().getRoot(cfg, ele);
                if (root == cfg.getRoot()) {
                    followerStates.add(pda.getStop());
                }
                for (Object c : callers.get(root)) {
                    S s2 = stops.get(c);
                    if (s2 == null) {
                        s2 = fact.createPop(pda, tokens.apply(c));
                        stops.put(c, s2);
                        this.create(cfg, pda, s2, c, ff.getFollowers(c), ff, tokens, fact, states, stops, callers);
                    }
                    followerStates.add(s2);
                }
                continue;
            }
            E e = cfg.getCall(fol);
            if (e != null) {
                s = states.get(fol);
                if (s == null) {
                    s = fact.createPush(pda, tokens.apply(fol));
                    states.put(fol, s);
                    this.create(cfg, pda, s, e, ff.getStarts(e), ff, tokens, fact, states, stops, callers);
                }
                followerStates.add(s);
                continue;
            }
            s = states.get(fol);
            if (s == null) {
                s = fact.createState(pda, tokens.apply(fol));
                states.put(fol, s);
                this.create(cfg, pda, s, fol, ff.getFollowers(fol), ff, tokens, fact, states, stops, callers);
            }
            followerStates.add(s);
        }
        fact.setFollowers(pda, state, followerStates);
    }

    public <S, P, E, T1, T2, D extends Pda<S, P>> D create(Cfg<E, T1> cfg, FollowerFunction<E> ff, Function<E, T2> element2token, PdaFactory<D, S, P, ? super T2> fact) {
        Pda pda = (Pda)fact.create(null, null);
        LinkedHashMap states = Maps.newLinkedHashMap();
        LinkedHashMap stops = Maps.newLinkedHashMap();
        Multimap<E, E> callers = new CfgUtil().getCallers(cfg);
        this.create(cfg, pda, pda.getStart(), cfg.getRoot(), ff.getStarts(cfg.getRoot()), ff, element2token, fact, states, stops, callers);
        return (D)pda;
    }

    protected <T> StackItem<T> createStack(Iterator<T> stack) {
        StackItem<Object> result = new StackItem<Object>(null, null);
        ArrayList list = Lists.newArrayList(stack);
        for (int i = list.size() - 1; i >= 0; --i) {
            result = new StackItem<Object>(result, list.get(i));
        }
        return result;
    }

    public <S, P> long distanceTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.size();
        }
        return Long.MAX_VALUE;
    }

    public <S, P, R, D extends Pda<S, P>> D filterEdges(Pda<S, P> pda, Traverser<? super Pda<S, P>, S, R> traverser, PdaFactory<D, S, P, S> factory) {
        Map distances = new NfaUtil().distanceToFinalStateMap(pda);
        return this.filterEdges(pda, traverser, distances, factory);
    }

    public <S, P, R, D extends Pda<S, P>> D filterEdges(Pda<S, P> pda, Traverser<? super Pda<S, P>, S, R> traverser, Map<S, Integer> distances, PdaFactory<D, S, P, S> factory) {
        HashStack<TraversalItem<S, Object>> trace = new HashStack<TraversalItem<S, Object>>();
        R previous = traverser.enter(pda, pda.getStart(), null);
        if (previous == null) {
            return (D)(factory == null ? null : (Pda)factory.create(pda.getStart(), pda.getStop()));
        }
        NfaUtil.MappedComparator<S, Integer> distanceComp = new NfaUtil.MappedComparator<S, Integer>(distances);
        trace.push(this.newItem(pda, distanceComp, distances, pda.getStart(), previous));
        LinkedHashMultimap edges = LinkedHashMultimap.create();
        LinkedHashSet states = Sets.newLinkedHashSet();
        LinkedHashSet success = Sets.newLinkedHashSet();
        states.add(pda.getStart());
        states.add(pda.getStop());
        block0: while (!trace.isEmpty()) {
            TraversalItem current = (TraversalItem)trace.peek();
            while (current.followers.hasNext()) {
                Object next = current.followers.next();
                Object item = traverser.enter(pda, next, current.data);
                if (item == null) continue;
                if (next == pda.getStop() && traverser.isSolution(item) || success.contains(Tuples.create(next, item))) {
                    Object s = null;
                    for (TraversalItem traversalItem : trace) {
                        if (s != null) {
                            edges.put(s, traversalItem.state);
                        }
                        states.add(traversalItem.state);
                        success.add(Tuples.create(traversalItem.state, traversalItem.data));
                        s = traversalItem.state;
                    }
                    edges.put(s, next);
                    continue;
                }
                if (!trace.push(this.newItem(pda, distanceComp, distances, next, item))) continue;
                continue block0;
            }
            trace.pop();
        }
        if (factory == null) {
            return null;
        }
        Pda result = (Pda)factory.create(pda.getStart(), pda.getStop());
        LinkedHashMap old2new = Maps.newLinkedHashMap();
        old2new.put(pda.getStart(), result.getStart());
        old2new.put(pda.getStop(), result.getStop());
        for (Object old : states) {
            if (old == pda.getStart() || old == pda.getStop()) continue;
            if (pda.getPop(old) != null) {
                old2new.put(old, factory.createPop(result, old));
                continue;
            }
            if (pda.getPush(old) != null) {
                old2new.put(old, factory.createPush(result, old));
                continue;
            }
            old2new.put(old, factory.createState(result, old));
        }
        for (Object old : states) {
            ArrayList followers = Lists.newArrayList();
            for (Object f : edges.get(old)) {
                followers.add(old2new.get(f));
            }
            factory.setFollowers(result, old2new.get(old), followers);
        }
        return (D)result;
    }

    public <S, P> Nfa<S> filterUnambiguousPaths(Pda<S, P> pda) {
        LinkedHashMap followers = Maps.newLinkedHashMap();
        Map distanceMap = this.nfaUtil.distanceToFinalStateMap(pda);
        this.filterUnambiguousPaths(pda, pda.getStart(), distanceMap, followers);
        return new NfaUtil.NFAImpl(pda.getStart(), pda.getStop(), followers);
    }

    protected <S, P> void filterUnambiguousPaths(Pda<S, P> pda, S state, Map<S, Integer> dist, Map<S, List<S>> followers) {
        if (followers.containsKey(state)) {
            return;
        }
        ArrayList f = Lists.newArrayList(pda.getFollowers(state));
        if (f.size() <= 1) {
            followers.put(state, f);
            if (f.size() == 1) {
                this.filterUnambiguousPaths(pda, f.get(0), dist, followers);
            }
            return;
        }
        int closestDist = dist.get(f.get(0));
        Object closest = f.get(0);
        for (int i = 1; i < f.size(); ++i) {
            int d = dist.get(f.get(i));
            if (d >= closestDist) continue;
            closestDist = d;
            closest = f.get(i);
        }
        IsPop<S, P> isPop = new IsPop<S, P>(pda);
        Set closestPops = this.nfaUtil.findFirst(pda, Collections.singleton(closest), isPop);
        Iterator it = f.iterator();
        while (it.hasNext()) {
            Set nextPops;
            Object next = it.next();
            if (next == closest || closestPops.equals(nextPops = this.nfaUtil.findFirst(pda, Collections.singleton(next), isPop))) continue;
            it.remove();
        }
        followers.put(state, f);
        for (Object follower : f) {
            this.filterUnambiguousPaths(pda, follower, dist, followers);
        }
    }

    protected <S, R, P> TraversalItem<S, R> newItem(Pda<S, P> pda, NfaUtil.MappedComparator<S, Integer> comp, Map<S, Integer> distances, S next, R item) {
        ArrayList followers = Lists.newArrayList();
        for (S f : pda.getFollowers(next)) {
            if (!distances.containsKey(f)) continue;
            followers.add(f);
        }
        Collections.sort(followers, comp);
        return new TraversalItem<S, R>(next, followers, item);
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches) {
        return this.shortestPathTo(pda, pda.getStart(), stack, matches, Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        return this.shortestPathTo(pda, pda.getStart(), stack, matches, canPass);
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, S match) {
        return this.shortestPathTo(pda, pda.getStart(), stack, Predicates.equalTo(match), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, S start, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, Collections.singleton(start), stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestPathToFinalState(Pda<S, P> pda, Iterator<P> stack) {
        return this.shortestPathTo(pda, pda.getStart(), stack, Predicates.equalTo(pda.getStop()), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.traceToWithPruningStack(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStart(), stack, matches, Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterator<P> stack, S matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStart(), stack, Predicates.equalTo(matches), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, S start, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.traceToWithPruningStack(pda, Collections.singleton(start), stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P, R> List<R> collectReachable(Pda<S, P> pda, final Function<S, R> function) {
        final ArrayList result = Lists.newArrayList();
        Iterator stack = Collections.emptyList().iterator();
        Predicate matches = Predicates.alwaysFalse();
        Predicate canPass = new Predicate<S>(){

            public boolean apply(S input) {
                Object r = function.apply(input);
                if (r != null) {
                    result.add(r);
                    return false;
                }
                return true;
            }
        };
        this.trace(pda, Collections.singleton(pda.getStart()), stack, matches, canPass);
        return result;
    }

    protected <S, P> TraceItem<S, P> trace(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        StackItem<P> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        LinkedHashSet visited = Sets.newLinkedHashSet(starts);
        for (S start : starts) {
            current.add(new TraceItem<S, P>(null, start, stackItem));
        }
        for (int counter = stackItem.size() * -1; current.size() > 0 && counter < visited.size(); ++counter) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        return new TraceItem(trace, follower, trace.stackitem);
                    }
                    if (!canPass.apply(follower)) continue;
                    P push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    P pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
        }
        return null;
    }

    protected <S, P> TraceItem<S, P> traceToWithPruningStack(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        StackItem<P> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        LinkedHashSet visited = Sets.newLinkedHashSet(starts);
        TraceItem result = null;
        for (S start : starts) {
            TraceItem<S, P> item = new TraceItem<S, P>(null, start, stackItem);
            current.add(item);
        }
        for (int counter = stackItem.size() * -1; current.size() > 0 && counter < visited.size(); ++counter) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        TraceItem found = new TraceItem(trace, follower, trace.stackitem);
                        if (found.stackitem == null) {
                            return found;
                        }
                        if (result == null || result.stackitem.size() > found.stackitem.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        } else if (result.stackitem.size() == found.stackitem.size() && result.size() > found.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        }
                    }
                    if (!canPass.apply(follower)) continue;
                    P push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    P pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
        }
        return result;
    }

    public <S, P, D extends Pda<S, P>> D filterOrphans(Pda<S, P> pda, PdaFactory<D, S, P, S> factory) {
        CyclicStackTraverser traverser = new CyclicStackTraverser();
        return this.filterEdges(pda, traverser, factory);
    }

    public <S, P, D extends Pda<S, P>> Map<P, Pair<S, S>> collectPopsAndPushs(Pda<S, P> pda) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object s : this.nfaUtil.collect(pda)) {
            P pop;
            P push = pda.getPush(s);
            if (push != null) {
                Pair o = (Pair)result.get(push);
                Pair n = Tuples.create(s, o == null ? null : (Object)o.getSecond());
                result.put(push, n);
            }
            if ((pop = pda.getPop(s)) == null) continue;
            Pair o = (Pair)result.get(pop);
            Pair n = Tuples.create(o == null ? null : (Object)o.getFirst(), s);
            result.put(pop, n);
        }
        return result;
    }

    public <S, P, D extends Pda<S, P>> Map<S, S> mapPopAndPush(Pda<S, P> pda) {
        Map<P, Pair<S, S>> popsAndPushs = this.collectPopsAndPushs(pda);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Pair<S, S> p : popsAndPushs.values()) {
            S push = p.getFirst();
            S pop = p.getSecond();
            if (push == null || pop == null) continue;
            result.put(push, pop);
            result.put(pop, push);
        }
        return result;
    }

    public <S, P, D extends Pda<S, P>> D filter(Pda<S, P> pda, Predicate<S> filter, PdaFactory<D, S, P, ? super S> fact) {
        Pda result = (Pda)fact.create(pda.getStart(), pda.getStop());
        LinkedHashMap orig2copy = Maps.newLinkedHashMap();
        Object start = pda.getStart();
        Object stop = pda.getStop();
        orig2copy.put(start, result.getStart());
        orig2copy.put(stop, result.getStop());
        for (Object s : new NfaUtil().collect(pda)) {
            if (s == start || s == stop || !filter.apply(s)) continue;
            if (pda.getPop(s) != null) {
                orig2copy.put(s, fact.createPop(result, s));
                continue;
            }
            if (pda.getPush(s) != null) {
                orig2copy.put(s, fact.createPush(result, s));
                continue;
            }
            orig2copy.put(s, fact.createState(result, s));
        }
        for (Map.Entry entry : orig2copy.entrySet()) {
            Object orig = entry.getKey();
            Object copy = entry.getValue();
            LinkedList todo = Lists.newLinkedList();
            todo.add(orig);
            HashSet visited = Sets.newHashSet();
            LinkedHashSet followers = Sets.newLinkedHashSet();
            while (!todo.isEmpty()) {
                Object o = todo.pop();
                if (!visited.add(o)) continue;
                for (Object s : pda.getFollowers(o)) {
                    Object f = orig2copy.get(s);
                    if (f != null) {
                        followers.add(f);
                        continue;
                    }
                    todo.add(s);
                }
            }
            fact.setFollowers(result, copy, followers);
        }
        return (D)result;
    }

    protected static class Identity<T> {
        protected Map<T, T> cache = Maps.newHashMap();

        protected Identity() {
        }

        public T get(T t) {
            T r = this.cache.get(t);
            if (r != null) {
                return r;
            }
            this.cache.put(t, t);
            return t;
        }
    }

    protected static class TraversalItem<S, R> {
        protected R data;
        protected Iterator<S> followers;
        protected S state;

        public TraversalItem(S state, Iterable<S> followers, R previous) {
            this.state = state;
            this.followers = followers.iterator();
            this.data = previous;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TraversalItem other = (TraversalItem)obj;
            return this.data.equals(other.data) && this.state.equals(other.state);
        }

        public int hashCode() {
            return this.data.hashCode() + this.state.hashCode() * 7;
        }

        public String toString() {
            return this.state.toString();
        }
    }

    protected class TraceItem<S, P> {
        protected TraceItem<S, P> parent;
        protected StackItem<P> stackitem;
        protected S state;

        public TraceItem(TraceItem<S, P> parent, S state, StackItem<P> stackitem) {
            this.parent = parent;
            this.state = state;
            this.stackitem = stackitem;
        }

        public List<S> asList() {
            ArrayList result = Lists.newArrayList();
            TraceItem<S, P> current = this;
            while (current != null) {
                result.add(current.state);
                current = current.parent;
            }
            Collections.reverse(result);
            return result;
        }

        public int size() {
            int result = 0;
            TraceItem<S, P> current = this;
            while (current != null) {
                ++result;
                current = current.parent;
            }
            return result;
        }

        public String toString() {
            return "States: " + this.asList() + " Stack: " + this.stackitem;
        }
    }

    protected class StackItem<T> {
        protected StackItem<T> parent;
        protected T value;

        public StackItem(StackItem<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }

        public T peek() {
            return this.value;
        }

        public StackItem<T> pop() {
            if (this.parent != null) {
                return this.parent;
            }
            return null;
        }

        public StackItem<T> push(T value) {
            return new StackItem<T>(this, value);
        }

        public int size() {
            int result = 0;
            for (StackItem<T> current = this; current != null; current = current.pop()) {
                ++result;
            }
            return result;
        }

        public String toString() {
            ArrayList result = Lists.newArrayList();
            for (StackItem<T> current = this; current != null; current = current.pop()) {
                if (current.value == null) continue;
                result.add(current.value.toString());
            }
            return Joiner.on((String)", ").join((Iterable)result);
        }
    }

    public static class CyclicStackTraverser<S, P>
    implements Traverser<Pda<S, P>, S, CyclicStackItem<P>> {
        @Override
        public CyclicStackItem<P> enter(Pda<S, P> pda, S state, CyclicStackItem<P> previous) {
            P item = pda.getPush(state);
            if (item != null) {
                return previous.push(item);
            }
            item = pda.getPop(state);
            if (item != null) {
                return previous.pop(item);
            }
            if (previous == null) {
                return new CyclicStackItem();
            }
            return previous;
        }

        @Override
        public boolean isSolution(CyclicStackItem<P> result) {
            return result.parent == null;
        }
    }

    public static class CyclicStackItem<T> {
        protected CyclicStackItem<T> parent;
        protected T item;

        public CyclicStackItem() {
            this.parent = null;
        }

        public CyclicStackItem(CyclicStackItem<T> parent, T item) {
            this.parent = parent;
            this.item = item;
        }

        public CyclicStackItem<T> push(T item) {
            int count = 0;
            CyclicStackItem<T> current = this;
            while (current != null) {
                if (current.item == item) {
                    ++count;
                }
                current = current.parent;
            }
            if (count >= 2) {
                return null;
            }
            return new CyclicStackItem<T>(this, item);
        }

        public CyclicStackItem<T> pop(T item) {
            if (this.parent == null || this.item != item) {
                return null;
            }
            return this.parent;
        }
    }

    protected static class IsPop<S, P>
    implements Predicate<S> {
        private final Pda<S, P> pda;

        private IsPop(Pda<S, P> pda) {
            this.pda = pda;
        }

        public boolean apply(S input) {
            return this.pda.getPop(input) != null;
        }
    }

    public static class HashStack<T>
    implements Iterable<T> {
        protected LinkedList<T> list = Lists.newLinkedList();
        protected Set<T> set = Sets.newLinkedHashSet();

        public boolean contains(Object value) {
            return this.set.contains(value);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        public T peek() {
            return this.list.getLast();
        }

        public T pop() {
            T result = this.list.getLast();
            this.list.removeLast();
            this.set.remove(result);
            return result;
        }

        public boolean push(T value) {
            boolean result = this.set.add(value);
            if (result) {
                this.list.addLast(value);
            }
            return result;
        }

        public String toString() {
            return this.list.toString();
        }
    }
}

