/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.plugins;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.osgi.framework.Bundle;

public class AcceleoMetamodelProvider {
    private static AcceleoMetamodelProvider instance;
    private Map file2plugin = new HashMap();

    public static AcceleoMetamodelProvider getDefault() {
        if (instance == null) {
            instance = new AcceleoMetamodelProvider();
        }
        return instance;
    }

    public String getPluginId(File file) {
        return (String)this.file2plugin.get(file);
    }

    public File getFile(IPath fullPath) {
        if (fullPath != null && fullPath.segmentCount() > 0) {
            IFile file = Resources.findFile(fullPath);
            if (file != null) {
                return file.getLocation().toFile();
            }
            String pluginId = fullPath.segment(0);
            return this.getFile(pluginId, fullPath.removeFirstSegments(1));
        }
        return null;
    }

    public File getFile(String pluginId, IPath relativePath) {
        return this.getFile(pluginId, relativePath, true);
    }

    private File getFile(String pluginId, IPath relativePath, boolean requiredSearch) {
        if (pluginId.indexOf("org.eclipse.") > -1) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            String requiredBundles;
            File file;
            URL url = bundle.getEntry(relativePath.toString());
            if (url != null && (file = new File(Resources.transformToAbsolutePath(url))).exists()) {
                if (!this.file2plugin.containsKey(file)) {
                    this.file2plugin.put(file, pluginId);
                    Enumeration all = bundle.findEntries(relativePath.removeLastSegments(1).toString(), "*", false);
                    while (all != null && all.hasMoreElements()) {
                        File ecoreFile;
                        URL fileURL = (URL)all.nextElement();
                        if (fileURL == null || !(ecoreFile = new File(Resources.transformToAbsolutePath(fileURL))).exists()) continue;
                        this.file2plugin.put(ecoreFile, pluginId);
                    }
                }
                return file;
            }
            if (requiredSearch && (requiredBundles = (String)bundle.getHeaders().get("Require-Bundle")) != null) {
                StringTokenizer st = new StringTokenizer(requiredBundles, ",");
                while (st.hasMoreTokens()) {
                    File scriptFile;
                    String id = st.nextToken().trim();
                    int iDot = id.indexOf(59);
                    if (iDot > -1) {
                        id = id.substring(0, iDot).trim();
                    }
                    if (id.length() <= 0 || (scriptFile = this.getFile(id, relativePath, false)) == null) continue;
                    return scriptFile;
                }
            }
        }
        return null;
    }
}

