/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateNotExpression
extends TemplateExpression {
    protected TemplateExpression expression;

    public TemplateNotExpression(TemplateExpression expression, IScript script) {
        super(script);
        this.expression = expression;
        this.expression.setParent(this);
    }

    public TemplateExpression getExpression() {
        return this.expression;
    }

    @Override
    public ENode evaluate(ENode current, IScript script, LaunchManager mode) throws ENodeException, FactoryException {
        ENode result;
        ENode test = this.expression.evaluate(current, script, mode);
        try {
            boolean value = test.getBoolean();
            result = new ENode(!value, current);
        }
        catch (ENodeCastException eNodeCastException) {
            try {
                Object boolValue = test.getAdapterValue(Boolean.TYPE);
                if (!(boolValue instanceof Boolean)) {
                    throw new ENodeException(AcceleoGenMessages.getString("ENodeError.BooleanRequired", new Object[]{test.getType()}), this.expression.getPos(), script, current, true);
                }
                result = new ENode((Boolean)boolValue == false, current);
            }
            catch (ENodeCastException e2) {
                throw new ENodeException(e2.getMessage(), this.expression.getPos(), script, current, true);
            }
        }
        return result;
    }

    public String toString() {
        return String.valueOf(TemplateConstants.NOT) + this.expression.toString();
    }

    public static TemplateExpression fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Int2 trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
        }
        limits = trim;
        String text = buffer.substring(limits.b(), limits.e());
        if (text.startsWith(TemplateConstants.NOT)) {
            TemplateExpression expression = TemplateExpression.fromString(buffer, new Int2(limits.b() + TemplateConstants.NOT.length(), limits.e()), script);
            TemplateNotExpression notExpression = new TemplateNotExpression(expression, script);
            notExpression.setPos(limits);
            return notExpression;
        }
        return null;
    }
}

