/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.tools.resources.FileContentMap;

public class EObjectServices {
    private FileContentMap load = new FileContentMap();
    private EPackage eRootPackage;
    private Map<String, List<String>> eClass2containments = new HashMap<String, List<String>>();
    private Map<EClass, List<EClass>> eClass2subTypes;

    public EObject eContainer(EObject current) {
        return current.eContainer();
    }

    public EObject eContainer(EObject root, String type) throws FactoryException {
        EObject current = root;
        while (current != null) {
            if (EFactory.eInstanceOf(current, type)) {
                return current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    public EObject eClass(EObject current) {
        return current.eClass();
    }

    public EList<EObject> eContents(EObject current) {
        return current.eContents();
    }

    public ENodeList eAllContents(ENode current) {
        ENodeList result = new ENodeList();
        try {
            if (current.isList()) {
                ENodeIterator it = current.getList().iterator();
                while (it.hasNext()) {
                    result.addAll(this.eAllContents(it.next()));
                }
            } else if (current.isEObject()) {
                TreeIterator it = current.getEObject().eAllContents();
                while (it.hasNext()) {
                    result.add(ENode.createTry(it.next(), current));
                }
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        return result;
    }

    public ENodeList eAllContents(ENode current, String type) throws FactoryException {
        ENodeList result = new ENodeList();
        try {
            if (current.isList()) {
                ENodeIterator it = current.getList().iterator();
                while (it.hasNext()) {
                    result.addAll(this.eAllContents(it.next(), type));
                }
            } else if (current.isEObject()) {
                int i = type.lastIndexOf(".");
                String typeName = i > -1 ? type.substring(i + 1) : type;
                List<EObject> children = this.eAllContents(current.getEObject(), type, typeName);
                Iterator<EObject> it = children.iterator();
                while (it.hasNext()) {
                    result.add(ENode.createTry(it.next(), current));
                }
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        return result;
    }

    private List<EObject> eAllContents(EObject object, String type, String typeName) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List<String> containmentTypeNames = this.getContainmentNames(object);
        if (containmentTypeNames.contains(typeName)) {
            for (EObject eContent : object.eContents()) {
                if (EFactory.eInstanceOf(eContent, type)) {
                    result.add(eContent);
                }
                result.addAll(this.eAllContents(eContent, type, typeName));
            }
        }
        return result;
    }

    private List<String> getContainmentNames(EObject object) {
        String eClassName;
        List<String> containmentNames;
        EClass eClass = object.eClass();
        EPackage ePackage = (EPackage)this.getRootContainer((EObject)eClass);
        if (ePackage != this.eRootPackage) {
            this.eRootPackage = ePackage;
            this.eClass2containments.clear();
            this.eClass2subTypes = null;
        }
        if ((containmentNames = this.eClass2containments.get(eClassName = eClass.getName())) == null) {
            containmentNames = new ArrayList<String>();
            this.computeContainments(new ArrayList<EClassifier>(), containmentNames, ePackage, (Iterable<EReference>)eClass.getEAllReferences());
            this.eClass2containments.put(eClassName, containmentNames);
        }
        return containmentNames;
    }

    private void computeContainments(List<EClassifier> containmentTypes, List<String> containmentNames, EPackage ePackage, Iterable<EReference> eReferences) {
        for (EReference eReference : eReferences) {
            if (!eReference.isContainment()) continue;
            ArrayList<Object> types = new ArrayList<Object>();
            types.add(eReference.getEType());
            if (eReference.getEType() instanceof EClass) {
                types.addAll((Collection<Object>)((EClass)eReference.getEType()).getEAllSuperTypes());
            }
            types.addAll(this.eClass2subTypes(ePackage, eReference.getEType()));
            for (EClassifier eClassifier : types) {
                if (!(eClassifier instanceof EClass)) continue;
                String name = eClassifier.getName();
                if (containmentTypes.contains(eClassifier)) continue;
                containmentTypes.add(eClassifier);
                containmentNames.add(name);
                this.computeContainments(containmentTypes, containmentNames, ePackage, this.getEReferences((EClass)eClassifier));
            }
        }
    }

    private Iterable<EReference> getEReferences(EClass type) {
        return Iterables.filter((Iterable)type.getEStructuralFeatures(), EReference.class);
    }

    private List<EClass> eClass2subTypes(EPackage ePackage, EClassifier eClass) {
        List<EClass> types;
        if (this.eClass2subTypes == null) {
            this.eClass2subTypes = Maps.newHashMap();
            for (Object next : ETools.computeAllClassifiersList(ePackage, false)) {
                if (!(next instanceof EClass)) continue;
                EClass c = (EClass)next;
                for (EClass superType : c.getEAllSuperTypes()) {
                    List<EClass> subTypes = this.eClass2subTypes.get(superType);
                    if (subTypes == null) {
                        subTypes = new ArrayList<EClass>();
                        this.eClass2subTypes.put(superType, subTypes);
                    }
                    if (subTypes.contains(c)) continue;
                    subTypes.add(c);
                }
            }
        }
        if ((types = this.eClass2subTypes.get(eClass)) == null) {
            types = new ArrayList<EClass>();
        }
        return types;
    }

    public EStructuralFeature eContainingFeature(EObject current) {
        return current.eContainingFeature();
    }

    public EReference eContainmentFeature(EObject current) {
        return current.eContainmentFeature();
    }

    public List<EObject> eCrossReferences(EObject current) {
        return current.eCrossReferences();
    }

    public String eResource(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().path();
        }
        return null;
    }

    public String eResourceName(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().lastSegment();
        }
        return null;
    }

    public EObject load(ENode node, String rootpath) {
        IFile file;
        String path = rootpath;
        if (path.startsWith("/resource")) {
            path = path.substring("/resource".length());
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))).exists()) {
            EObject result = (EObject)this.load.get(file);
            if (result == null) {
                result = ETools.loadXMI(path);
                this.load.put(file, (Object)result);
            }
            return result;
        }
        return ETools.loadXMI(path);
    }
}

