/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.AbstractFixCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class PortRealizationPropagationCommand
extends AbstractFixCommand {
    public String getName() {
        return Messages.PropagatePortRealizations;
    }

    public PortRealizationPropagationCommand(Collection<ModelElement> selection) {
        this(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public PortRealizationPropagationCommand(Collection<ModelElement> selection, IProgressMonitor progressMonitor) {
        super(selection, progressMonitor);
    }

    @Override
    protected Collection<ModelElement> retrieveModelElements(ModelElement modelElement) {
        if (modelElement instanceof BlockArchitecture) {
            EList result = FunctionalExt.getAllFunctionalExchanges((BlockArchitecture)((BlockArchitecture)modelElement));
            return result;
        }
        if (modelElement instanceof FunctionalExchange) {
            return Collections.singleton(modelElement);
        }
        if (modelElement instanceof AbstractFunction) {
            Collection result = FunctionExt.getAllOwnedFunctionalExchanges((AbstractFunction)((AbstractFunction)modelElement));
            return result;
        }
        if (modelElement instanceof ComponentExchange) {
            return Collections.singleton(modelElement);
        }
        if (modelElement instanceof Component) {
            Collection result = ComponentExt.getAllOwnedComponentExchanges((Component)((Component)modelElement));
            return result;
        }
        if (modelElement instanceof Part) {
            return this.retrieveModelElements((ModelElement)((Part)modelElement).getAbstractType());
        }
        return Collections.singleton(modelElement);
    }

    @Override
    protected boolean process(ModelElement element) {
        boolean attachementAdded = false;
        if (element instanceof FunctionalExchange) {
            ActivityNode targetCurrent;
            FunctionalExchange fe = (FunctionalExchange)element;
            List previousPhaseElements = RefinementLinkExt.getRelatedTargetElements((CapellaElement)fe, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE);
            ActivityNode sourceCurrent = fe.getSource();
            if (sourceCurrent instanceof Port) {
                for (CapellaElement previous : previousPhaseElements) {
                    FunctionalExchange previousExchange = (FunctionalExchange)previous;
                    ActivityNode sourcePrevious = previousExchange.getSource();
                    attachementAdded |= this.attachIfNeeded((Port)sourceCurrent, (EObject)sourcePrevious);
                }
                this.detachIfUnused((Port)sourceCurrent);
            }
            if ((targetCurrent = fe.getTarget()) instanceof Port) {
                for (CapellaElement previous : previousPhaseElements) {
                    FunctionalExchange previousExchange = (FunctionalExchange)previous;
                    ActivityNode targetPrevious = previousExchange.getTarget();
                    attachementAdded |= this.attachIfNeeded((Port)targetCurrent, (EObject)targetPrevious);
                }
                this.detachIfUnused((Port)targetCurrent);
            }
        } else if (element instanceof ComponentExchange) {
            Port targetCurrent;
            ComponentExchange ce = (ComponentExchange)element;
            List previousPhaseElements = RefinementLinkExt.getRelatedTargetElements((CapellaElement)ce, (EClass)FaPackage.Literals.COMPONENT_EXCHANGE);
            Port sourceCurrent = ComponentExchangeExt.getSourcePort((ComponentExchange)ce);
            if (sourceCurrent instanceof Port) {
                for (CapellaElement previous : previousPhaseElements) {
                    ComponentExchange previousExchange = (ComponentExchange)previous;
                    Port sourcePrevious = ComponentExchangeExt.getSourcePort((ComponentExchange)previousExchange);
                    attachementAdded |= this.attachIfNeeded(sourceCurrent, (EObject)sourcePrevious);
                }
                this.detachIfUnused(sourceCurrent);
            }
            if ((targetCurrent = ComponentExchangeExt.getTargetPort((ComponentExchange)ce)) instanceof Port) {
                for (CapellaElement previous : previousPhaseElements) {
                    ComponentExchange previousExchange = (ComponentExchange)previous;
                    Port targetPrevious = ComponentExchangeExt.getTargetPort((ComponentExchange)previousExchange);
                    attachementAdded |= this.attachIfNeeded(targetCurrent, (EObject)targetPrevious);
                }
                this.detachIfUnused(targetCurrent);
            }
        }
        return attachementAdded;
    }

    private boolean attachIfNeeded(Port current, EObject previous) {
        if (previous instanceof Port && !RefinementLinkExt.isLinkedTo((TraceableElement)current, (TraceableElement)((TraceableElement)previous))) {
            this.attach(current, (TraceableElement)previous);
            return true;
        }
        return false;
    }

    private void attach(Port current, TraceableElement previous) {
        PortRealization realization = InformationFactory.eINSTANCE.createPortRealization();
        realization.setSourceElement((TraceableElement)current);
        realization.setTargetElement(previous);
        current.getOwnedPortRealizations().add((Object)realization);
        String message = "Port realization " + realization.getLabel() + " has been propagated from source element " + current.getLabel() + " to target element " + previous.getLabel();
        EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), Arrays.asList(realization, current, previous));
        logger.info((Object)eMessage);
    }

    private void detachIfUnused(Port current) {
        if (current != null) {
            ArrayList realizedExch = new ArrayList();
            if (current instanceof FunctionOutputPort) {
                for (ActivityEdge edge : ((FunctionOutputPort)current).getOutgoing()) {
                    realizedExch.addAll(RefinementLinkExt.getRelatedTargetElements((CapellaElement)((CapellaElement)edge), (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE));
                }
            } else if (current instanceof FunctionInputPort) {
                for (ActivityEdge edge : ((FunctionInputPort)current).getIncoming()) {
                    realizedExch.addAll(RefinementLinkExt.getRelatedTargetElements((CapellaElement)((CapellaElement)edge), (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE));
                }
            } else if (current instanceof ComponentPort) {
                for (ComponentExchange exch : ((ComponentPort)current).getComponentExchanges()) {
                    realizedExch.addAll(RefinementLinkExt.getRelatedTargetElements((CapellaElement)exch, (EClass)FaPackage.Literals.COMPONENT_EXCHANGE));
                }
            }
            for (PortRealization rlz : current.getOutgoingPortRealizations()) {
                Port port = rlz.getRealizedPort();
                boolean detachMe = true;
                if (port instanceof FunctionOutputPort) {
                    for (ActivityEdge edge : ((FunctionOutputPort)port).getOutgoing()) {
                        if (!realizedExch.contains(edge)) continue;
                        detachMe = false;
                    }
                } else if (port instanceof FunctionInputPort) {
                    for (ActivityEdge edge : ((FunctionInputPort)port).getIncoming()) {
                        if (!realizedExch.contains(edge)) continue;
                        detachMe = false;
                    }
                } else if (port instanceof ComponentPort) {
                    for (ComponentExchange exch : ((ComponentPort)port).getComponentExchanges()) {
                        if (!realizedExch.contains(exch)) continue;
                        detachMe = false;
                    }
                }
                if (!detachMe) continue;
                this.detach(current, port);
            }
        }
    }

    private void detach(Port currentPort, Port realizedPort) {
        if (currentPort != null && realizedPort != null) {
            PortRealization rlzToDelete = null;
            for (PortRealization rlz : currentPort.getOutgoingPortRealizations()) {
                if (!realizedPort.equals(rlz.getRealizedPort())) continue;
                rlzToDelete = rlz;
            }
            if (rlzToDelete != null) {
                currentPort.getOwnedPortRealizations().remove(rlzToDelete);
            }
        }
    }
}

